/*
 * Decompiled with CFR 0.152.
 */
package bluej.utility.javafx;

import bluej.BlueJTheme;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Scene;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.Swing)
public abstract class EmbeddableJFXPanel
extends JFXPanel {
    private final JFrame window;
    private @OnThread(value=Tag.FX) boolean initialised = false;
    private EmbeddableJFXPanel parentToDisable;
    private Runnable afterClose;

    protected EmbeddableJFXPanel(String windowTitle) {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("Cannot construct EmbeddableJFXPanel outside Swing thread");
        }
        this.window = new JFrame();
        this.window.setTitle(windowTitle);
        this.window.add((Component)((Object)this));
        this.window.addWindowListener(new WindowAdapter(){

            @Override
            @OnThread(value=Tag.Swing)
            public void windowOpened(WindowEvent e) {
                if (EmbeddableJFXPanel.this.parentToDisable != null) {
                    final Scene scene = EmbeddableJFXPanel.this.parentToDisable.getScene();
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            scene.getRoot().setDisable(true);
                        }
                    });
                }
            }

            @Override
            @OnThread(value=Tag.Swing)
            public void windowClosing(WindowEvent e) {
                if (EmbeddableJFXPanel.this.parentToDisable != null) {
                    final Scene scene = EmbeddableJFXPanel.this.parentToDisable.getScene();
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            scene.getRoot().setDisable(false);
                        }
                    });
                }
                if (EmbeddableJFXPanel.this.afterClose != null) {
                    Platform.runLater((Runnable)EmbeddableJFXPanel.this.afterClose);
                }
            }
        });
        Image icon = BlueJTheme.getIconImage();
        if (icon != null) {
            this.window.setIconImage(icon);
        }
    }

    @OnThread(value=Tag.FX, ignoreParent=true)
    public abstract void initialiseFX();

    @OnThread(value=Tag.FX, ignoreParent=true)
    public abstract void afterShow();

    @OnThread(value=Tag.Swing)
    public void showInWindow(EmbeddableJFXPanel parentToDisable, Runnable afterOpen, Runnable afterClose) {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("Cannot show EmbeddableJFXPanel outside Swing thread");
        }
        if (this.window.isVisible()) {
            if (afterOpen != null) {
                Platform.runLater((Runnable)afterOpen);
            }
            return;
        }
        this.parentToDisable = parentToDisable;
        this.afterClose = afterClose;
        Platform.runLater(() -> {
            if (!this.initialised) {
                this.initialiseFX();
                this.initialised = true;
            }
            SwingUtilities.invokeLater(() -> {
                this.window.setSize(this.getPreferredSize());
                this.window.setLocationRelativeTo(null);
                this.window.setVisible(true);
                Platform.runLater(() -> {
                    this.afterShow();
                    if (afterOpen != null) {
                        afterOpen.run();
                    }
                });
            });
        });
    }

    @OnThread(value=Tag.Any, ignoreParent=true)
    public void setWindowVisible(boolean vis, Runnable runAfterwards) {
        if (vis) {
            EventQueue.invokeLater(() -> this.showInWindow(null, runAfterwards, null));
        } else {
            EventQueue.invokeLater(() -> {
                this.window.setVisible(false);
                new Thread(runAfterwards).start();
            });
        }
    }

    public boolean isWindowVisible() {
        return this.window.isVisible();
    }

    public Rectangle getWindowBounds() {
        return this.window.getBounds();
    }

    public JFrame getWindow() {
        return this.window;
    }
}

