/*
 * Decompiled with CFR 0.152.
 */
package bluej.utility;

import bluej.Config;
import bluej.utility.DamerauLevenshteinAlgorithm;
import bluej.utility.Debug;
import bluej.utility.DialogManager;
import bluej.utility.javafx.FXPlatformSupplier;
import com.apple.eawt.Application;
import java.awt.Color;
import java.awt.Desktop;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Shape;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipInputStream;
import javafx.application.Platform;
import javafx.stage.Stage;
import javafx.stage.Window;
import javax.swing.AbstractButton;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.border.Border;
import javax.swing.text.TabExpander;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Serializer;
import threadchecker.OnThread;
import threadchecker.Tag;

public class Utility {
    private static final DamerauLevenshteinAlgorithm dla = new DamerauLevenshteinAlgorithm(1, 1, 1, 1);
    private static final ScheduledExecutorService background = Executors.newScheduledThreadPool(8);
    private static Set<String> occurredEvents = new HashSet<String>();

    public static void drawThickRect(Graphics g, int x, int y, int width, int height, int thickness) {
        for (int i = 0; i < thickness; ++i) {
            g.drawRect(x + i, y + i, width - 2 * i, height - 2 * i);
        }
    }

    public static void drawThickRoundRect(Graphics g, int x, int y, int width, int height, int arc, int thickness) {
        for (int i = 0; i < thickness; ++i) {
            g.drawRoundRect(x + i, y + i, width - 2 * i, height - 2 * i, arc, arc);
        }
    }

    public static void stripeRect(Graphics g, int x, int y, int width, int height, int separation, int thickness, Color color) {
        Color prev = g.getColor();
        g.setColor(color);
        for (int offset = 0; offset < width + height; offset += separation) {
            int i = 0;
            while (i < thickness) {
                int y2;
                int x2;
                int y1;
                int x1;
                if (offset < height) {
                    x1 = x;
                    y1 = y + offset;
                } else {
                    x1 = x + offset - height;
                    y1 = y + height;
                }
                if (offset < width) {
                    x2 = x + offset;
                    y2 = y;
                } else {
                    x2 = x + width;
                    y2 = y + offset - width;
                }
                g.drawLine(x1, y1, x2, y2);
                ++i;
                ++offset;
            }
        }
        g.setColor(prev);
    }

    public static void drawCentredText(Graphics g, String str, int x, int y, int width, int height) {
        FontMetrics fm = g.getFontMetrics();
        Shape oldClip = g.getClip();
        g.clipRect(x, y, width, height);
        int xOffset = (width - fm.stringWidth(str)) / 2;
        if (xOffset < 0) {
            xOffset = 0;
        }
        int yOffset = fm.getAscent() + (height - fm.getAscent() - fm.getDescent()) / 2;
        g.drawString(str, x + xOffset, y + yOffset);
        g.setClip(oldClip);
    }

    public static void drawRightText(Graphics g, String str, int x, int y, int width, int height) {
        FontMetrics fm = g.getFontMetrics();
        Shape oldClip = g.getClip();
        g.clipRect(x, y, width, height);
        g.drawString(str, x + width - fm.stringWidth(str), y + (height + fm.getAscent()) / 2);
        g.setClip(oldClip);
    }

    public static String[] split(String str, String delimiter) {
        ArrayList<String> strings = new ArrayList<String>();
        int start = 0;
        int len = str.length();
        int dlen = delimiter.length();
        int offset = str.lastIndexOf(delimiter);
        if (dlen < 1) {
            return null;
        }
        if (offset < 0) {
            String[] result = new String[]{str};
            return result;
        }
        if (len > offset + dlen) {
            str = str + delimiter;
            len += dlen;
        }
        do {
            offset = str.indexOf(delimiter, start);
            strings.add(str.substring(start, offset));
        } while ((start = offset + dlen) < len && offset != -1);
        String[] result = new String[strings.size()];
        strings.toArray(result);
        return result;
    }

    public static String[] splitLines(String str) {
        return str == null ? null : Utility.split(str, "\n");
    }

    public static String quoteString(String src) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < src.length(); ++i) {
            char c = src.charAt(i);
            if (c == '\n') {
                buf.append("\\n");
                continue;
            }
            if (c == '\r') {
                buf.append("\\r");
                continue;
            }
            if (c == '\t') {
                buf.append("\\g");
                continue;
            }
            if (c < ' ' || c > '\u0080') {
                String n = Integer.toHexString(c);
                n = "0000".substring(n.length()) + n;
                buf.append("\\u");
                buf.append(n);
                continue;
            }
            if (c == '\\' || c == '\"' || c == '\'') {
                buf.append('\\');
            }
            buf.append(src.charAt(i));
        }
        return buf.toString();
    }

    public static String getDocURL(String classname, String suffix) {
        int lastSlash;
        classname = classname.replace('.', '/');
        String docURL = Config.getPropString("bluej.url.javaStdLib");
        if (docURL.endsWith(".html") && (lastSlash = docURL.lastIndexOf(47)) != -1) {
            docURL = docURL.substring(0, lastSlash + 1);
        }
        String finalURL = docURL + classname + ".html" + suffix;
        return finalURL;
    }

    public static boolean openWebBrowser(String url) {
        if (Config.isWinOS()) {
            String cmd = Config.osname.startsWith("Windows 9") || Config.osname.equals("Windows Me") ? "command.com" : "cmd.exe";
            try {
                if (Config.osname.startsWith("Windows 98") || Config.osname.equals("Windows Me")) {
                    Runtime.getRuntime().exec(new String[]{cmd, "/c", "start", '\"' + url + '\"'});
                }
                Runtime.getRuntime().exec(new String[]{cmd, "/c", "start", "\"\"", '\"' + url + '\"'});
            }
            catch (IOException e) {
                Debug.reportError("could not start web browser. exc: " + e);
                return false;
            }
        } else {
            try {
                return Utility.openWebBrowser(new URL(url));
            }
            catch (MalformedURLException mfue) {
                return Utility.openWebBrowser(new File(url));
            }
        }
        return true;
    }

    public static boolean openWebBrowser(URL url) {
        if (Config.isWinOS()) {
            return Utility.openWebBrowser(url.toString());
        }
        Exception exception = null;
        if (Desktop.isDesktopSupported()) {
            try {
                Desktop.getDesktop().browse(url.toURI());
            }
            catch (IOException ioe) {
                exception = ioe;
            }
            catch (URISyntaxException use) {
                exception = use;
            }
            if (exception == null) {
                return true;
            }
        }
        if (Config.isMacOS()) {
            Debug.reportError("could not start web browser. exc: " + exception);
            return false;
        }
        String cmd = Utility.mergeStrings(Config.getPropString("browserCmd1"), url.toString());
        String cmd2 = Utility.mergeStrings(Config.getPropString("browserCmd2"), url.toString());
        String cmd3 = Utility.mergeStrings("xdg-open $", url.toString());
        Process p = null;
        try {
            p = Runtime.getRuntime().exec(cmd);
        }
        catch (IOException e) {
            try {
                p = Runtime.getRuntime().exec(cmd2);
                cmd2 = null;
            }
            catch (IOException e2) {
                try {
                    p = Runtime.getRuntime().exec(cmd3);
                    cmd3 = null;
                }
                catch (IOException e3) {
                    Debug.reportError("could not start web browser.  exc: " + e);
                    return false;
                }
            }
        }
        final String command2 = cmd2;
        final Process process = p;
        new Thread(){

            @Override
            public void run() {
                Utility.runUnixWebBrowser(process, command2);
            }
        }.start();
        return true;
    }

    private static void runUnixWebBrowser(Process p, String cmd2) {
        try {
            int exitCode = p.waitFor();
            if (exitCode != 0 && cmd2 != null && cmd2.length() > 0) {
                p = Runtime.getRuntime().exec(cmd2);
            }
        }
        catch (InterruptedException ie) {
            Debug.reportError("cannot start web browser:");
            Debug.reportError("caught exc " + ie);
        }
        catch (IOException ioe) {
            Debug.reportError("cannot start web browser:");
            Debug.reportError("caught exc " + ioe);
        }
    }

    public static boolean openWebBrowser(File file) {
        if (Config.isWinOS()) {
            return Utility.openWebBrowser(file.toString());
        }
        try {
            return Utility.openWebBrowser(file.toURI().toURL());
        }
        catch (MalformedURLException mfue) {
            return false;
        }
    }

    private static File calculateBluejLibDir() {
        File bluejDir = null;
        String bootFullName = Utility.class.getResource("Utility.class").toString();
        try {
            if (!bootFullName.startsWith("jar:")) {
                File startingDir;
                for (startingDir = new File(new URI(bootFullName)).getParentFile(); startingDir != null && !new File(startingDir.getParentFile(), "lib").isDirectory(); startingDir = startingDir.getParentFile()) {
                }
                if (startingDir != null) {
                    bluejDir = new File(startingDir.getParentFile(), "lib");
                }
            } else {
                int classIndex = bootFullName.indexOf("!");
                String bootName = bootFullName.substring(4, classIndex);
                File finalFile = new File(new URI(bootName));
                bluejDir = finalFile.getParentFile();
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return bluejDir;
    }

    @OnThread(value=Tag.Swing)
    public static void bringToFront(java.awt.Window window) {
        if (window != null) {
            if (!window.isShowing() || !window.getFocusableWindowState()) {
                return;
            }
            window.toFront();
        }
        Utility.appToFront();
    }

    @OnThread(value=Tag.FX)
    public static void bringToFrontFX(Stage window) {
        if (window != null) {
            if (!window.isShowing()) {
                return;
            }
            window.toFront();
        }
        Utility.appToFront();
    }

    private static void appToFront() {
        if (Config.isMacOS()) {
            Application.getApplication().requestForeground(false);
            return;
        }
        String pid = Utility.getProcessId();
        boolean isWindows = Config.isWinOS();
        if (isWindows) {
            File libdir = Utility.calculateBluejLibDir();
            String[] command = new String[]{"cscript", "\"" + libdir.getAbsolutePath() + "\\windowtofront.js\"", pid};
            StringBuffer commandAsStr = new StringBuffer();
            for (int i = 0; i < command.length; ++i) {
                commandAsStr.append(command[i] + " ");
            }
            try {
                Process p = Runtime.getRuntime().exec(command);
                new ExternalProcessLogger(command[0], commandAsStr.toString(), p).start();
                if (isWindows) {
                    if (Platform.isFxApplicationThread()) {
                        new ProcessWaiter(p);
                    } else {
                        new ProcessWaiter(p).waitForProcess(500L);
                    }
                }
            }
            catch (IOException e) {
                Debug.reportError("While trying to launch \"" + command[0] + "\", got this IOException:", e);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public static <T extends Comparable<T>> Comparator<List<T>> listComparator() {
        return Comparator.comparingInt(List::size).thenComparing((a, b) -> {
            for (int i = 0; i < a.size(); ++i) {
                int cmp;
                int n = a.get(i) == null ? (b.get(i) == null ? -1 : 0) : (cmp = ((Comparable)a.get(i)).compareTo(b.get(i)));
                if (cmp == 0) continue;
                return cmp;
            }
            return 0;
        });
    }

    public static <T> Comparator<List<T>> listComparator(Comparator<T> itemComparator) {
        return Comparator.comparingInt(List::size).thenComparing((a, b) -> {
            for (int i = 0; i < a.size(); ++i) {
                int cmp = itemComparator.compare(a.get(i), b.get(i));
                if (cmp == 0) continue;
                return cmp;
            }
            return 0;
        });
    }

    public static String getProcessId() {
        String pid = ManagementFactory.getRuntimeMXBean().getName();
        int atIndex = pid.indexOf("@");
        if (atIndex != -1) {
            pid = pid.substring(0, atIndex);
        }
        return pid;
    }

    public static String mergeStrings(String s1, String s2) {
        int pos = s1.indexOf(36);
        if (pos == -1) {
            return s1;
        }
        return s1.substring(0, pos) + s2 + s1.substring(pos + 1);
    }

    public static String mergeStrings(String s1, String[] s2) {
        for (int current = 0; current < s2.length; ++current) {
            s1 = Utility.mergeStrings(s1, s2[current]);
        }
        return s1;
    }

    public static String convertTabsToSpaces(String originalString, int tabSize) {
        if (originalString.indexOf(9) != -1) {
            StringBuffer buffer = new StringBuffer(originalString);
            for (int i = 0; i < buffer.length(); ++i) {
                if (buffer.charAt(i) != '\t') continue;
                buffer.deleteCharAt(i);
                int numberOfSpaces = tabSize - i % tabSize;
                for (int j = 0; j < numberOfSpaces; ++j) {
                    buffer.insert(i, ' ');
                }
            }
            return buffer.toString();
        }
        return originalString;
    }

    public static int[] calculateTabSpaces(String line, int tabSize) {
        int[] tabSpaces = new int[line.length()];
        int curPos = 0;
        for (int i = 0; i < line.length(); ++i) {
            if (line.charAt(i) == '\t') {
                int numberOfSpaces;
                tabSpaces[i] = numberOfSpaces = tabSize - curPos % tabSize;
                curPos += numberOfSpaces;
                continue;
            }
            ++curPos;
        }
        return tabSpaces;
    }

    public static TabExpander makeTabExpander(String line, int tabSize, final FontMetrics fontMetrics) {
        final int[] tabSpaces = Utility.calculateTabSpaces(line, tabSize);
        return new TabExpander(){

            @Override
            public float nextTabStop(float x, int tabOffset) {
                return x + (float)(tabSpaces[tabOffset] * fontMetrics.charWidth(' '));
            }
        };
    }

    public static int advanceChars(String line, int[] tabSpaces, int index, int advanceBy) {
        while (advanceBy > 0 && index < line.length()) {
            int width = line.charAt(index) == '\t' ? tabSpaces[index] : 1;
            advanceBy -= width;
            ++index;
        }
        return index;
    }

    public static boolean firstTimeThisRun(String context) {
        if (occurredEvents.contains(context)) {
            return false;
        }
        occurredEvents.add(context);
        return true;
    }

    public static boolean firstTimeEver(String context) {
        boolean occurred = Config.getPropBoolean(context);
        if (occurred) {
            return false;
        }
        Config.putPropBoolean(context, true);
        return true;
    }

    @OnThread(value=Tag.Swing)
    public static void changeToMacButton(AbstractButton button) {
        if (!Config.isMacOS()) {
            return;
        }
        Border oldBorder = button.getBorder();
        button.putClientProperty("JButton.buttonType", "square");
        if (oldBorder == button.getBorder()) {
            button.putClientProperty("JButton.buttonType", "toolbar");
        } else {
            button.setMargin(new Insets(3, 1, 3, 1));
        }
    }

    public static String getArchivePrefixFolder(File arName) throws FileNotFoundException, IOException {
        ZipInputStream jarInStream = null;
        FileInputStream is = null;
        String prefixFolder = null;
        try {
            is = new FileInputStream(arName);
            jarInStream = new JarInputStream(is);
            JarEntry je = ((JarInputStream)jarInStream).getNextJarEntry();
            while (je != null) {
                String entryName = je.getName();
                int slashIndex = entryName.indexOf(47);
                if (slashIndex == -1) {
                    prefixFolder = null;
                    break;
                }
                String prefix = entryName.substring(0, slashIndex);
                if (prefixFolder == null) {
                    prefixFolder = prefix;
                } else if (!prefixFolder.equals(prefix)) {
                    prefixFolder = null;
                    break;
                }
                je = ((JarInputStream)jarInStream).getNextJarEntry();
            }
        }
        catch (FileNotFoundException fnfe) {
            throw fnfe;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        finally {
            if (jarInStream != null) {
                jarInStream.close();
            }
            if (is != null) {
                is.close();
            }
        }
        return prefixFolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @OnThread(value=Tag.Swing)
    public static File maybeExtractArchive(File archive, FXPlatformSupplier<Window> parent) {
        ZipInputStream jarInStream = null;
        File oPath = archive.getParentFile();
        try {
            String prefixFolder = Utility.getArchivePrefixFolder(archive);
            if (prefixFolder == null) {
                String archiveName = archive.getName();
                int dotIndex = archiveName.lastIndexOf(46);
                String strippedName = null;
                strippedName = dotIndex != -1 ? archiveName.substring(0, dotIndex) : archiveName;
                if ((oPath = new File(oPath, strippedName)).exists()) {
                    File oPathFinal = oPath;
                    Platform.runLater(() -> DialogManager.showErrorWithTextFX((Window)parent.get(), "jar-output-dir-exists", oPathFinal.toString()));
                    File file = null;
                    return file;
                }
                if (!oPath.mkdir()) {
                    Platform.runLater(() -> DialogManager.showErrorWithTextFX((Window)parent.get(), "jar-output-no-write", archive.toString()));
                    File oPathFinal = null;
                    return oPathFinal;
                }
            } else {
                File prefixFolderFile = new File(oPath, prefixFolder);
                if (prefixFolderFile.exists()) {
                    Platform.runLater(() -> DialogManager.showErrorWithTextFX((Window)parent.get(), "jar-output-dir-exists", prefixFolderFile.toString()));
                    File dotIndex = null;
                    return dotIndex;
                }
                if (!prefixFolderFile.mkdir()) {
                    Platform.runLater(() -> DialogManager.showErrorWithTextFX((Window)parent.get(), "jar-output-no-write", archive.toString()));
                    File dotIndex = null;
                    return dotIndex;
                }
            }
            FileInputStream is = new FileInputStream(archive);
            jarInStream = new JarInputStream(is);
            JarEntry je = ((JarInputStream)jarInStream).getNextJarEntry();
            while (je != null) {
                File outFile = new File(oPath, je.getName());
                if (je.getName().endsWith("/")) {
                    outFile.mkdirs();
                } else {
                    outFile.getParentFile().mkdirs();
                    FileOutputStream os = new FileOutputStream(outFile);
                    byte[] buffer = new byte[8192];
                    int rlength = jarInStream.read(buffer);
                    while (rlength != -1) {
                        ((OutputStream)os).write(buffer, 0, rlength);
                        rlength = jarInStream.read(buffer);
                    }
                    jarInStream.closeEntry();
                    ((OutputStream)os).close();
                }
                je = ((JarInputStream)jarInStream).getNextJarEntry();
            }
            if (prefixFolder == null) return oPath;
            oPath = new File(oPath, prefixFolder);
            return oPath;
        }
        catch (Exception e) {
            e.printStackTrace();
            Platform.runLater(() -> DialogManager.showErrorFX((Window)parent.get(), "jar-extraction-error"));
            File file = null;
            return file;
        }
        finally {
            try {
                if (jarInStream != null) {
                    jarInStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static final String toClasspathString(File[] files) {
        if (files == null || files.length < 1) {
            return "";
        }
        boolean addSeparator = false;
        StringBuffer buf = new StringBuffer();
        for (int index = 0; index < files.length; ++index) {
            File file = files[index];
            if (file == null) continue;
            if (addSeparator) {
                buf.append(File.pathSeparatorChar);
            }
            buf.append(file.toString());
            addSeparator = true;
        }
        return buf.toString();
    }

    public static final File[] urlsToFiles(URL[] urls) {
        if (urls == null || urls.length < 1) {
            return new File[0];
        }
        ArrayList<File> rlist = new ArrayList<File>();
        for (int index = 0; index < urls.length; ++index) {
            URL url = urls[index];
            if (!"file".equals(url.getProtocol())) continue;
            URI uri = URI.create(url.toString());
            rlist.add(new File(uri));
        }
        return rlist.toArray(new File[rlist.size()]);
    }

    public static List<String> dequoteCommandLine(String str) {
        ArrayList<String> strings = new ArrayList<String>();
        int i = 0;
        while (i < str.length()) {
            while (i < str.length() && Character.isWhitespace(str.charAt(i))) {
                ++i;
            }
            StringBuffer arg = new StringBuffer();
            while (i < str.length()) {
                char c;
                if ((c = str.charAt(i++)) == '\\') {
                    if (i >= str.length()) continue;
                    arg.append(str.charAt(i++));
                    continue;
                }
                if (c == '\"') {
                    while (i < str.length() && (c = str.charAt(i++)) != '\"') {
                        if (c == '\\') {
                            if (i >= str.length()) continue;
                            arg.append(str.charAt(i++));
                            continue;
                        }
                        arg.append(c);
                    }
                    continue;
                }
                if (Character.isWhitespace(c)) break;
                arg.append(c);
            }
            strings.add(arg.toString());
        }
        return strings;
    }

    @OnThread(value=Tag.Swing)
    public static void setJEditorPaneBackground(JEditorPane jEditorPane, Color color) {
        Color bgColor = new Color(250, 246, 229);
        UIDefaults defaults = new UIDefaults();
        defaults.put("EditorPane[Enabled].backgroundPainter", bgColor);
        jEditorPane.putClientProperty("Nimbus.Overrides", defaults);
        jEditorPane.putClientProperty("Nimbus.Overrides.InheritDefaults", true);
        jEditorPane.setBackground(bgColor);
    }

    public static int editDistance(String s, String t) {
        return dla.execute(s, t);
    }

    public static String escapeAngleBrackets(String sig) {
        return sig.replace("<", "&lt;").replace(">", "&gt;");
    }

    public static <SRC, DEST> List<DEST> mapList(Collection<SRC> original, Function<SRC, DEST> func) {
        return original.stream().map(func).collect(Collectors.toList());
    }

    @SafeVarargs
    public static <T3> Stream<T3> concat(Stream<? extends T3> ... streams) {
        List<Stream<T3>> l = Arrays.asList(streams);
        return l.stream().filter(t -> t != null).flatMap(Function.identity());
    }

    @SafeVarargs
    public static <T4> List<T4> concat(List<T4> ... lists) {
        List<List<T4>> l = Arrays.asList(lists);
        return l.stream().filter(new Predicate<List<T4>>(){

            @Override
            public boolean test(List<T4> t) {
                return t != null;
            }
        }).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public static <T5, R> R orNull(T5 t, Function<T5, R> f) {
        return t == null ? null : (R)f.apply(t);
    }

    public static <T5B> void ifNotNull(T5B t, Consumer<T5B> f) {
        if (t != null) {
            f.accept(t);
        }
    }

    public static <T7> Collector<T7, ArrayList<T7>, ArrayList<T7>> intersperse(final Supplier<T7> makeInbetween) {
        return Collector.of(ArrayList::new, new BiConsumer<ArrayList<T7>, T7>(){

            @Override
            public void accept(ArrayList<T7> l, T7 x) {
                if (!l.isEmpty()) {
                    l.add(makeInbetween.get());
                }
                l.add(x);
            }
        }, new BinaryOperator<ArrayList<T7>>(){

            @Override
            public ArrayList<T7> apply(ArrayList<T7> a, ArrayList<T7> b) {
                a.addAll(b);
                return a;
            }
        }, new Collector.Characteristics[0]);
    }

    public static <T8> Collector<T8, ArrayList<T8>, ArrayList<T8>> intersperse(final T8 inbetween) {
        return Utility.intersperse(new Supplier<T8>(){

            @Override
            public T8 get() {
                return inbetween;
            }
        });
    }

    public static <T9> Stream<T9> interleave(Stream<T9> a, Stream<T9> b) {
        List ar = a.collect(Collectors.toList());
        List br = b.collect(Collectors.toList());
        ArrayList r = new ArrayList(ar.size() + br.size());
        for (int i = 0; i < Math.max(ar.size(), br.size()); ++i) {
            if (i < ar.size()) {
                r.add(ar.get(i));
            }
            if (i >= br.size()) continue;
            r.add(br.get(i));
        }
        return r.stream();
    }

    public static <T> CompletableFuture<T> swingFuture(SwingSupplier<T> func) {
        CompletableFuture f = new CompletableFuture();
        SwingUtilities.invokeLater(() -> f.complete(func.get()));
        return f;
    }

    public static <T> Optional<T> findLast(Stream<T> s) {
        return Optional.ofNullable(s.reduce(null, (p, c) -> c));
    }

    public static <K, V> Map<K, V> mergeMaps(Map<K, V> a, Map<K, V> b, BiFunction<V, V, V> mergeFunction) {
        HashMap<K, V> r = new HashMap<K, V>(a);
        for (Map.Entry<K, V> e : b.entrySet()) {
            r.merge(e.getKey(), e.getValue(), mergeFunction);
        }
        return r;
    }

    public static <T> Iterable<T> iterableStream(Stream<T> s) {
        return s::iterator;
    }

    public static <T> List<T> nonNulls(List<T> orig) {
        return orig.stream().filter(x -> x != null).collect(Collectors.toList());
    }

    public static File getGreenfootDir() throws IOException {
        File libDir = Config.getBlueJLibDir();
        File greenfootDir = libDir.getParentFile();
        if (greenfootDir == null || !greenfootDir.isDirectory() || !greenfootDir.canRead()) {
            throw new IOException("Could not read from greenfoot directory: " + greenfootDir);
        }
        return greenfootDir;
    }

    public static String getGreenfootApiDocURL(String page) throws IOException, MalformedURLException {
        String customUrl = Config.getPropString("greenfoot.url.javadoc", null);
        if (customUrl != null) {
            if (!customUrl.endsWith("/")) {
                customUrl = customUrl + "/";
            }
            customUrl = customUrl + page;
        } else {
            File greenfootDir = Utility.getGreenfootDir();
            File location = new File(greenfootDir, "/doc/API/" + page);
            if (location.canRead()) {
                customUrl = location.toURI().toURL().toString();
            }
        }
        return customUrl;
    }

    public static <T> Iterable<T> backwards(final List<T> src) {
        return new Iterable<T>(){
            private final ListIterator<T> listIterator;
            {
                this.listIterator = src.listIterator(src.size());
            }

            @Override
            public Iterator<T> iterator() {
                return new Iterator<T>(){

                    @Override
                    public boolean hasNext() {
                        return listIterator.hasPrevious();
                    }

                    @Override
                    public T next() {
                        return listIterator.previous();
                    }

                    @Override
                    public void remove() {
                        listIterator.remove();
                    }
                };
            }
        };
    }

    public static <T> List<T> filterList(Collection<T> src, Predicate<T> keep) {
        return src.stream().filter(keep).collect(Collectors.toList());
    }

    public static double roundHalf(double x) {
        return 0.5 + (double)Math.round(x - 0.5);
    }

    @OnThread(value=Tag.Any)
    public static void runBackground(BackgroundRunnable r) {
        long queue = System.currentTimeMillis();
        background.execute(() -> {
            long started = System.currentTimeMillis();
            r.run();
            long ended = System.currentTimeMillis();
        });
    }

    public static <T> Stream<T> streamOptional(Optional<T> optional) {
        return optional.isPresent() ? Stream.of(optional.get()) : Stream.empty();
    }

    public static <T> int findIndex(List<T> list, Predicate<T> criteria) {
        for (int i = 0; i < list.size(); ++i) {
            if (!criteria.test(list.get(i))) continue;
            return i;
        }
        return -1;
    }

    @OnThread(value=Tag.Any)
    public static String serialiseCodeToString(Element xml) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Utility.serialiseCodeTo(xml, baos);
        return baos.toString("UTF-8");
    }

    @OnThread(value=Tag.Any)
    public static void serialiseCodeTo(Element xml, OutputStream os) throws IOException {
        Serializer s = new Serializer(os);
        s.setLineSeparator("\n");
        s.setIndent(4);
        xml.addNamespaceDeclaration("xml", "http://www.w3.org/XML/1998/namespace");
        s.write(new Document(xml));
        s.flush();
    }

    private static class ProcessWaiter {
        boolean complete = false;

        public ProcessWaiter(final Process p) {
            new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        p.waitFor();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    ProcessWaiter processWaiter = this;
                    synchronized (processWaiter) {
                        complete = true;
                        this.notify();
                    }
                }
            }.start();
        }

        public synchronized void waitForProcess(long timeout) throws InterruptedException {
            while (!this.complete) {
                this.wait(timeout);
            }
        }
    }

    private static class ExternalProcessLogger
    extends Thread {
        String commandAsStr;
        String processName;
        Process p;

        public ExternalProcessLogger(String processName, String command, Process process) {
            this.processName = processName;
            this.commandAsStr = command;
            this.p = process;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            BufferedReader br = new BufferedReader(new InputStreamReader(this.p.getErrorStream()));
            StringBuffer extra = new StringBuffer();
            try {
                int len;
                char[] buf = new char[1024];
                Thread.sleep(1000L);
                if (br.ready() && (len = br.read(buf)) != -1) {
                    extra.append(buf, 0, len);
                }
                if (extra.length() != 0) {
                    Debug.message("When trying to launch " + this.processName + ":" + this.commandAsStr);
                    Debug.message(" This error was recieved: " + extra);
                }
            }
            catch (InterruptedException interruptedException) {
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @FunctionalInterface
    public static interface SwingSupplier<T> {
        @OnThread(value=Tag.Swing)
        public T get();
    }

    @FunctionalInterface
    public static interface BackgroundRunnable {
        @OnThread(value=Tag.Worker)
        public void run();
    }
}

