/*
 * Decompiled with CFR 0.152.
 */
package bluej.testmgr;

import bluej.BlueJTheme;
import bluej.Config;
import bluej.debugger.DebuggerTestResult;
import bluej.debugger.SourceLocation;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.Project;
import bluej.utility.JavaNames;
import bluej.utility.javafx.JavaFXUtil;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.Styleable;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TextArea;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.stage.Window;
import javax.swing.SwingUtilities;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public class TestDisplayFrame {
    private static @OnThread(value=Tag.Any, requireSynchronized=true) TestDisplayFrame singleton = null;
    private final Image failureIcon = Config.getFixedImageAsFXImage("failure.gif");
    private final Image errorIcon = Config.getFixedImageAsFXImage("error.gif");
    private final Image okIcon = Config.getFixedImageAsFXImage("ok.gif");
    private Stage frame;
    private ObservableList<DebuggerTestResult> testEntries;
    private ListView<DebuggerTestResult> testNames;
    private ProgressBar progressBar;
    private final SimpleIntegerProperty errorCount;
    private final SimpleIntegerProperty failureCount;
    private final SimpleIntegerProperty totalTimeMs;
    private final SimpleIntegerProperty testTotal;
    private boolean doingMultiple = false;
    private BooleanBinding hasErrors;
    private BooleanBinding hasFailures;
    private BooleanBinding hasFailuresOrErrors;
    private TextArea exceptionMessageField;
    private Button showSourceButton;
    private Project project;
    private final @OnThread(value=Tag.Any) AtomicBoolean frameShowing = new AtomicBoolean(false);

    @OnThread(value=Tag.FXPlatform)
    public static synchronized TestDisplayFrame getTestDisplay() {
        if (singleton == null) {
            singleton = new TestDisplayFrame();
        }
        return singleton;
    }

    @OnThread(value=Tag.Any)
    public static synchronized boolean isFrameShown() {
        if (singleton == null) {
            return false;
        }
        return singleton.isShown();
    }

    public TestDisplayFrame() {
        this.testTotal = new SimpleIntegerProperty(0);
        this.errorCount = new SimpleIntegerProperty(0);
        this.failureCount = new SimpleIntegerProperty(0);
        this.totalTimeMs = new SimpleIntegerProperty(0);
        this.createUI();
    }

    public void showTestDisplay(boolean doShow) {
        if (doShow) {
            if (!this.frame.isShowing()) {
                this.frame.show();
            }
            this.frame.toFront();
        } else {
            this.frame.hide();
        }
    }

    @OnThread(value=Tag.Any)
    public boolean isShown() {
        return this.frameShowing.get();
    }

    protected void createUI() {
        this.frame = new Stage();
        this.frame.setTitle(Config.getString("testdisplay.title"));
        this.frame.setOnShown(e -> this.frameShowing.set(true));
        this.frame.setOnHidden(e -> this.frameShowing.set(false));
        BlueJTheme.setWindowIconFX(this.frame);
        Config.rememberPosition((Window)this.frame, "bluej.testdisplay");
        VBox content = new VBox();
        this.testEntries = FXCollections.observableArrayList();
        this.testNames = new ListView();
        this.testNames.setEditable(false);
        this.testNames.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
        JavaFXUtil.addChangeListener(this.testNames.getSelectionModel().selectedItemProperty(), this::selected);
        this.testNames.setDisable(false);
        JavaFXUtil.addStyleClass(this.testNames, new String[]{"test-names"});
        this.testNames.setItems(this.testEntries);
        this.testNames.setCellFactory(col -> new TestResultCell());
        content.getChildren().add(this.testNames);
        this.progressBar = new ProgressBar();
        JavaFXUtil.addStyleClass((Styleable)this.progressBar, "test-progress-bar");
        this.progressBar.progressProperty().bind((ObservableValue)Bindings.add((double)0.0, (ObservableNumberValue)Bindings.size(this.testEntries)).divide((ObservableNumberValue)Bindings.max((int)1, (ObservableNumberValue)this.testTotal)));
        this.hasFailuresOrErrors = Bindings.greaterThan((ObservableNumberValue)this.failureCount.add((ObservableNumberValue)this.errorCount), (int)0);
        JavaFXUtil.bindPseudoclass((Node)this.progressBar, "bj-error", (BooleanExpression)this.hasFailuresOrErrors);
        content.getChildren().add((Object)this.progressBar);
        HBox counterPanel = new HBox();
        JavaFXUtil.addStyleClass((Styleable)counterPanel, "counter-panel");
        Label fNumberOfErrors = new Label();
        Label fNumberOfFailures = new Label();
        Label fNumberOfRuns = new Label();
        Label fTotalTime = new Label();
        HBox.setHgrow((Node)fNumberOfRuns, (Priority)Priority.ALWAYS);
        HBox.setHgrow((Node)fTotalTime, (Priority)Priority.ALWAYS);
        fNumberOfErrors.textProperty().bind((ObservableValue)this.errorCount.asString());
        fNumberOfFailures.textProperty().bind((ObservableValue)this.failureCount.asString());
        fNumberOfRuns.textProperty().bind((ObservableValue)Bindings.size(this.testEntries).asString().concat((Object)"/").concat((Object)this.testTotal.asString()));
        fTotalTime.textProperty().bind((ObservableValue)this.totalTimeMs.asString().concat((Object)"ms"));
        HBox errorPanel = new HBox(new Node[]{new ImageView(this.errorIcon), new Label(Config.getString("testdisplay.counter.errors")), fNumberOfErrors});
        JavaFXUtil.addStyleClass((Styleable)errorPanel, "error-panel");
        this.hasErrors = Bindings.greaterThan((ObservableNumberValue)this.errorCount, (int)0);
        JavaFXUtil.bindPseudoclass((Node)errorPanel, "bj-non-zero", (BooleanExpression)this.hasErrors);
        HBox.setHgrow((Node)errorPanel, (Priority)Priority.ALWAYS);
        HBox failurePanel = new HBox(new Node[]{new ImageView(this.failureIcon), new Label(Config.getString("testdisplay.counter.failures")), fNumberOfFailures});
        JavaFXUtil.addStyleClass((Styleable)failurePanel, "error-panel");
        this.hasFailures = Bindings.greaterThan((ObservableNumberValue)this.failureCount, (int)0);
        JavaFXUtil.bindPseudoclass((Node)failurePanel, "bj-non-zero", (BooleanExpression)this.hasFailures);
        HBox.setHgrow((Node)failurePanel, (Priority)Priority.ALWAYS);
        counterPanel.getChildren().addAll((Object[])new Node[]{new Label(Config.getString("testdisplay.counter.runs")), fNumberOfRuns, errorPanel, failurePanel, new Label(Config.getString("testdisplay.counter.totalTime")), fTotalTime});
        content.getChildren().add((Object)counterPanel);
        this.exceptionMessageField = new TextArea("");
        JavaFXUtil.addStyleClass((Styleable)this.exceptionMessageField, "test-output");
        VBox.setVgrow((Node)this.exceptionMessageField, (Priority)Priority.ALWAYS);
        this.exceptionMessageField.setEditable(false);
        this.exceptionMessageField.setFocusTraversable(false);
        content.getChildren().add((Object)this.exceptionMessageField);
        this.showSourceButton = new Button(Config.getString("testdisplay.showsource"));
        this.showSourceButton.setOnAction(e -> this.showSource((DebuggerTestResult)this.testNames.getSelectionModel().getSelectedItem()));
        this.showSourceButton.setDisable(true);
        Button closeButton = new Button(Config.getString("close"));
        closeButton.setOnAction(e -> this.frame.hide());
        BorderPane buttonPanel = new BorderPane();
        buttonPanel.setLeft((Node)this.showSourceButton);
        buttonPanel.setRight((Node)closeButton);
        content.getChildren().add((Object)buttonPanel);
        JavaFXUtil.addStyleClass((Styleable)content, "test-results");
        this.frame.setScene(new Scene((Parent)content));
        Config.addTestsStylesheets(this.frame.getScene());
    }

    protected void reset() {
        this.testEntries.clear();
        this.errorCount.set(0);
        this.failureCount.set(0);
        this.totalTimeMs.set(0);
        this.testTotal.set(0);
        this.exceptionMessageField.setText("");
        this.showSourceButton.setDisable(true);
    }

    public void startMultipleTests(Project proj, int num) {
        this.project = proj;
        this.doingMultiple = true;
        this.reset();
        this.testTotal.set(num);
        this.showTestDisplay(true);
    }

    public void endMultipleTests() {
        this.doingMultiple = false;
    }

    public void startTest(Project proj, int num) {
        this.project = proj;
        if (!this.doingMultiple) {
            this.reset();
            this.testTotal.set(num);
        }
    }

    public void addResult(DebuggerTestResult dtr, boolean quiet) {
        this.addResultQuietly(dtr);
        if (!quiet) {
            this.showTestDisplay(true);
        }
    }

    public void addResultQuietly(DebuggerTestResult dtr) {
        if (!dtr.isSuccess()) {
            if (dtr.isFailure()) {
                this.failureCount.set(this.failureCount.get() + 1);
            } else {
                this.errorCount.set(this.errorCount.get() + 1);
            }
        }
        this.totalTimeMs.set(this.totalTimeMs.get() + dtr.getRunTimeMs());
        this.testEntries.add((Object)dtr);
    }

    private void selected(DebuggerTestResult dtr) {
        if (dtr != null && (dtr.isError() || dtr.isFailure())) {
            this.exceptionMessageField.setText(dtr.getExceptionMessage() + "\n---\n" + dtr.getTrace());
            this.exceptionMessageField.positionCaret(0);
            this.showSourceButton.setDisable(dtr.getExceptionLocation() == null);
        } else {
            this.exceptionMessageField.setText("");
            this.showSourceButton.setDisable(true);
        }
    }

    private void showSource(DebuggerTestResult dtr) {
        if (dtr != null && (dtr.isError() || dtr.isFailure())) {
            Project projFinal = this.project;
            SwingUtilities.invokeLater(() -> {
                SourceLocation exceptionLocation = dtr.getExceptionLocation();
                if (exceptionLocation == null) {
                    return;
                }
                String packageName = JavaNames.getPrefix(exceptionLocation.getClassName());
                Package spackage = projFinal.getPackage(packageName);
                if (spackage == null) {
                    return;
                }
                String sourceName = exceptionLocation.getFileName();
                int lineno = exceptionLocation.getLineNumber();
                spackage.showSource(sourceName, lineno);
            });
        }
    }

    @OnThread(value=Tag.FX)
    private class TestResultCell
    extends ListCell<DebuggerTestResult> {
        private final ImageView imageView;

        public TestResultCell() {
            this.setEditable(false);
            this.setText("");
            this.imageView = new ImageView();
            this.imageView.setMouseTransparent(true);
            this.setGraphic((Node)this.imageView);
            this.setOnMouseClicked(e -> {
                if (e.getClickCount() == 2 && e.getButton() == MouseButton.PRIMARY) {
                    TestDisplayFrame.this.showSource((DebuggerTestResult)this.getItem());
                }
            });
        }

        public void updateItem(DebuggerTestResult item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (item == null || empty) {
                this.imageView.setImage(null);
                this.setText("");
            } else {
                if (item.isSuccess()) {
                    this.imageView.setImage(TestDisplayFrame.this.okIcon);
                } else if (item.isFailure()) {
                    this.imageView.setImage(TestDisplayFrame.this.failureIcon);
                } else {
                    this.imageView.setImage(TestDisplayFrame.this.errorIcon);
                }
                this.setText(item.getName() + " (" + item.getRunTimeMs() + "ms)");
            }
        }
    }
}

