/*
 * Decompiled with CFR 0.152.
 */
package bluej.terminal;

import bluej.BlueJEvent;
import bluej.BlueJEventListener;
import bluej.BlueJTheme;
import bluej.Config;
import bluej.collect.DataCollector;
import bluej.debugger.DebuggerField;
import bluej.debugger.DebuggerObject;
import bluej.debugger.DebuggerTerminal;
import bluej.debugmgr.ExecutionEvent;
import bluej.pkgmgr.Project;
import bluej.prefmgr.PrefMgr;
import bluej.terminal.InputBuffer;
import bluej.terminal.TermTextArea;
import bluej.terminal.TerminalPrinter;
import bluej.testmgr.record.InvokerRecord;
import bluej.utility.Debug;
import bluej.utility.DialogManager;
import bluej.utility.FileUtility;
import bluej.utility.javafx.FXPlatformSupplier;
import bluej.utility.javafx.JavaFXUtil;
import bluej.utility.javafx.SwingNodeFixed;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.MenuBar;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.stage.Window;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.InputMap;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import threadchecker.OnThread;
import threadchecker.Tag;

public final class Terminal
implements KeyListener,
BlueJEventListener,
DebuggerTerminal {
    private static final String WINDOWTITLE = Config.getApplicationName() + ": " + Config.getString("terminal.title");
    private static final int SHORTCUT_MASK = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    private static final String TERMINALFONTPROPNAME = "bluej.terminal.font";
    private static final String TERMINALFONTSIZEPROPNAME = "bluej.editor.fontsize";
    private static final String RECORDMETHODCALLSPROPNAME = "bluej.terminal.recordcalls";
    private static final String CLEARONMETHODCALLSPROPNAME = "bluej.terminal.clearscreen";
    private static final String UNLIMITEDBUFFERINGCALLPROPNAME = "bluej.terminal.buffering";
    private static int terminalFontSize = Config.getPropInteger("bluej.editor.fontsize", PrefMgr.getEditorFontSize());
    private static boolean isMacOs = Config.isMacOS();
    private final String title;
    private final Project project;
    private TermTextArea text;
    private TermTextArea errorText;
    private JScrollPane errorScrollPane;
    private JScrollPane scrollPane;
    private JSplitPane splitPane;
    private boolean isActive = false;
    private static boolean recordMethodCalls = Config.getPropBoolean("bluej.terminal.recordcalls");
    private static boolean clearOnMethodCall = Config.getPropBoolean("bluej.terminal.clearscreen");
    private static boolean unlimitedBufferingCall = Config.getPropBoolean("bluej.terminal.buffering");
    private boolean newMethodCall = true;
    private boolean errorShown = false;
    private InputBuffer buffer;
    private JCheckBoxMenuItem autoClear;
    private JCheckBoxMenuItem recordCalls;
    private JCheckBoxMenuItem unlimitedBuffering;
    private final @OnThread(value=Tag.Any) Reader in = new TerminalReader();
    private final @OnThread(value=Tag.Any) Writer out = new TerminalWriter(false);
    private final @OnThread(value=Tag.Any) Writer err = new TerminalWriter(true);
    private boolean initialised = false;
    private @OnThread(value=Tag.FX) Stage window;
    private JPanel mainPanel;
    private boolean isShowing;

    @OnThread(value=Tag.Swing)
    public Terminal(Project project) {
        this.title = WINDOWTITLE + " - " + project.getProjectName();
        this.project = project;
        this.initialise();
        BlueJEvent.addListener(this);
    }

    private static Font getTerminalFont() {
        terminalFontSize = Config.getPropInteger(TERMINALFONTSIZEPROPNAME, PrefMgr.getEditorFontSize());
        return Config.getFont(TERMINALFONTPROPNAME, "Monospaced", terminalFontSize);
    }

    public static void setTerminalFontSize(int size) {
        if (size <= 6) {
            return;
        }
        terminalFontSize = size;
        Config.putPropInteger(TERMINALFONTSIZEPROPNAME, terminalFontSize);
    }

    private synchronized void initialise() {
        if (!this.initialised) {
            this.buffer = new InputBuffer(256);
            int width = Config.isGreenfoot() ? 80 : Config.getPropInteger("bluej.terminal.width", 80);
            int height = Config.isGreenfoot() ? 10 : Config.getPropInteger("bluej.terminal.height", 22);
            this.makeWindow(width, height);
            this.initialised = true;
            this.text.setUnlimitedBuffering(unlimitedBufferingCall);
        }
    }

    public void showHide(boolean show) {
        DataCollector.showHideTerminal(this.project, show);
        this.isShowing = show;
        Platform.runLater(() -> {
            if (show) {
                this.window.show();
            } else {
                this.window.hide();
            }
            if (show) {
                SwingUtilities.invokeLater(() -> this.text.requestFocus());
            }
        });
    }

    public void dispose() {
        this.showHide(false);
        Platform.runLater(() -> {
            this.window = null;
        });
    }

    public boolean isShown() {
        return this.isShowing;
    }

    public void activate(boolean active) {
        if (active != this.isActive) {
            this.text.setEditable(active);
            if (!active) {
                this.text.getCaret().setVisible(false);
            }
            this.isActive = active;
        }
    }

    public boolean checkActive() {
        return this.isActive;
    }

    public void resetFont() {
        Font terminalFont = Terminal.getTerminalFont();
        this.text.setFont(terminalFont);
        if (this.errorText != null) {
            this.errorText.setFont(terminalFont);
        }
    }

    public void clear() {
        this.text.setText("");
        if (this.errorText != null) {
            this.errorText.setText("");
        }
        this.hideErrorPane();
    }

    public void save() {
        Platform.runLater(() -> {
            File fileName = FileUtility.getSaveFileFX((Window)this.window, Config.getString("terminal.save.title"), null, false);
            if (fileName != null) {
                if (fileName.exists() && DialogManager.askQuestionFX((Window)this.window, "error-file-exists") != 0) {
                    return;
                }
                SwingUtilities.invokeLater(() -> {
                    try {
                        FileWriter writer = new FileWriter(fileName);
                        this.text.write(writer);
                        writer.close();
                    }
                    catch (IOException ex) {
                        Platform.runLater(() -> DialogManager.showErrorFX((Window)this.window, "error-save-file"));
                    }
                });
            }
        });
    }

    public void print() {
        PrinterJob job = PrinterJob.getPrinterJob();
        int printFontSize = Config.getPropInteger("bluej.fontsize.printText", 10);
        Font font = new Font("Monospaced", 0, printFontSize);
        if (job.printDialog()) {
            TerminalPrinter.printTerminal(job, this.text, job.defaultPage(), font);
        }
    }

    private void writeToPane(boolean stdout, String s) {
        int n;
        this.prepare();
        if (!stdout) {
            this.showErrorPane();
        }
        if ((n = s.lastIndexOf(12)) != -1) {
            this.clear();
            s = s.substring(n + 1);
        }
        TermTextArea tta = stdout ? this.text : this.errorText;
        tta.append(s);
        tta.setCaretPosition(tta.getDocument().getLength());
    }

    public void writeToTerminal(String s) {
        this.writeToPane(true, s);
    }

    private void prepare() {
        if (this.newMethodCall) {
            this.showHide(true);
            this.newMethodCall = false;
        } else if (Config.isGreenfoot() && !this.isShowing) {
            this.showHide(true);
        }
    }

    private void methodCall(String callString) {
        this.newMethodCall = false;
        if (clearOnMethodCall) {
            this.clear();
        }
        if (recordMethodCalls) {
            this.text.appendMethodCall(callString + "\n");
        }
        this.newMethodCall = true;
    }

    private void constructorCall(InvokerRecord ir) {
        this.newMethodCall = false;
        if (clearOnMethodCall) {
            this.clear();
        }
        if (recordMethodCalls) {
            String callString = ir.getResultTypeString() + " " + ir.getResultName() + " = " + ir.toExpression() + ";";
            this.text.appendMethodCall(callString + "\n");
        }
        this.newMethodCall = true;
    }

    private void methodResult(ExecutionEvent event) {
        if (recordMethodCalls) {
            String result = null;
            String resultType = event.getResult();
            if (resultType == "Normal exit") {
                DebuggerObject object = event.getResultObject();
                if (object != null) {
                    if (event.getClassName() != null && event.getMethodName() == null) {
                        return;
                    }
                    if (object.isNullObject()) {
                        return;
                    }
                    DebuggerField resultField = object.getField(0);
                    result = "    returned " + resultField.getType().toString(true) + " ";
                    result = result + resultField.getValueString();
                }
            } else if (resultType == "An exception occurred") {
                result = "    Exception occurred.";
            } else if (resultType == "User terminated") {
                result = "    VM terminated.";
            }
            if (result != null) {
                this.text.appendMethodCall(result + "\n");
            }
        }
    }

    @Override
    @OnThread(value=Tag.Any, ignoreParent=true)
    public @OnThread(value=Tag.Any, ignoreParent=true) Reader getReader() {
        return this.in;
    }

    @Override
    @OnThread(value=Tag.Any, ignoreParent=true)
    public @OnThread(value=Tag.Any, ignoreParent=true) Writer getWriter() {
        return this.out;
    }

    @Override
    @OnThread(value=Tag.Any, ignoreParent=true)
    public @OnThread(value=Tag.Any, ignoreParent=true) Writer getErrorWriter() {
        return this.err;
    }

    @Override
    public void keyPressed(KeyEvent event) {
        this.handleFontsizeKeys(event, event.getKeyCode());
    }

    @Override
    public void keyReleased(KeyEvent event) {
    }

    private boolean handleFontsizeKeys(KeyEvent event, int ch) {
        boolean handled = false;
        switch (ch) {
            case 61: 
            case 521: {
                if (event.getModifiers() == SHORTCUT_MASK) {
                    PrefMgr.setEditorFontSize(terminalFontSize + 1);
                    event.consume();
                    handled = true;
                    break;
                }
            }
            case 45: {
                if (event.getModifiers() != SHORTCUT_MASK) break;
                PrefMgr.setEditorFontSize(terminalFontSize - 1);
                event.consume();
                handled = true;
            }
        }
        return handled;
    }

    @Override
    public void keyTyped(KeyEvent event) {
        char ch = event.getKeyChar();
        if ((event.getModifiers() & 4) != 0) {
            return;
        }
        if (this.isActive) {
            switch (ch) {
                case '\u0004': 
                case '\u001a': {
                    this.buffer.signalEOF();
                    this.writeToTerminal("\n");
                    event.consume();
                    break;
                }
                case '\b': {
                    if (this.buffer.backSpace()) {
                        try {
                            int length = this.text.getDocument().getLength();
                            this.text.replaceRange("", length - 1, length);
                        }
                        catch (Exception exc) {
                            Debug.reportError("bad location " + exc);
                        }
                    }
                    event.consume();
                    break;
                }
                case '\n': 
                case '\r': {
                    if (this.buffer.putChar('\n')) {
                        this.writeToTerminal(String.valueOf(ch));
                        this.buffer.notifyReaders();
                    }
                    event.consume();
                    break;
                }
                default: {
                    if (ch < ' ') break;
                    if (this.buffer.putChar(ch)) {
                        this.writeToTerminal(String.valueOf(ch));
                    }
                    event.consume();
                }
            }
        }
    }

    @Override
    public void blueJEvent(int eventId, Object arg) {
        if (eventId == 3) {
            InvokerRecord ir = (InvokerRecord)arg;
            if (ir.getResultName() != null) {
                this.constructorCall(ir);
            } else {
                boolean isVoid = ir.hasVoidResult();
                if (isVoid) {
                    this.methodCall(ir.toStatement());
                } else {
                    this.methodCall(ir.toExpression());
                }
            }
        } else if (eventId == 5) {
            this.methodResult((ExecutionEvent)arg);
        }
    }

    private void makeWindow(int columns, int rows) {
        this.text = new TermTextArea(rows, columns, this.buffer, this.project, this, false);
        final InputMap origInputMap = this.text.getInputMap();
        this.text.setInputMap(0, new InputMap(){
            {
                this.setParent(origInputMap);
            }

            @Override
            public Object get(KeyStroke keyStroke) {
                Object actionName = super.get(keyStroke);
                if (actionName == null) {
                    return null;
                }
                char keyChar = keyStroke.getKeyChar();
                if (keyChar == '\uffff' || keyChar < ' ') {
                    if ("copy-to-clipboard".equals(actionName)) {
                        return actionName;
                    }
                    if ("paste-from-clipboard".equals(actionName)) {
                        return actionName;
                    }
                    return PrefMgr.getFlag("bluej.accessibility.support") ? actionName : null;
                }
                return actionName;
            }
        });
        this.scrollPane = new JScrollPane(this.text);
        this.text.setFont(Terminal.getTerminalFont());
        this.text.setEditable(false);
        this.text.setMargin(new Insets(6, 6, 6, 6));
        this.text.addKeyListener(this);
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BorderLayout());
        this.mainPanel.add((Component)this.scrollPane, "Center");
        SwingNodeFixed swingNode = new SwingNodeFixed();
        swingNode.setContent(this.mainPanel);
        FXPlatformSupplier<MenuBar> makeFXMenuBar = JavaFXUtil.swingMenuBarToFX(this.makeMenuBar(), (Object)this.mainPanel);
        Platform.runLater(() -> {
            this.window = new Stage();
            BlueJTheme.setWindowIconFX(this.window);
            this.window.setTitle(this.title);
            MenuBar fxMenuBar = (MenuBar)makeFXMenuBar.get();
            fxMenuBar.setUseSystemMenuBar(true);
            this.window.setScene(new Scene((Parent)new VBox(new Node[]{fxMenuBar, swingNode})));
            this.window.setOnCloseRequest(e -> {
                e.consume();
                SwingUtilities.invokeLater(() -> {
                    if (this.project != null && this.project.getDebugger().getStatus() == 3) {
                        return;
                    }
                    this.showHide(false);
                });
            });
            Config.rememberPosition((Window)this.window, "bluej.terminal");
        });
    }

    private void createErrorPane() {
        this.errorText = new TermTextArea(Config.isGreenfoot() ? 20 : 5, 80, null, this.project, this, true);
        this.errorScrollPane = new JScrollPane(this.errorText);
        this.errorText.setFont(Terminal.getTerminalFont());
        this.errorText.setEditable(false);
        this.errorText.setMargin(new Insets(6, 6, 6, 6));
        this.errorText.setUnlimitedBuffering(true);
        this.splitPane = new JSplitPane(0, this.scrollPane, this.errorScrollPane);
    }

    private void showErrorPane() {
        if (this.errorShown) {
            return;
        }
        boolean isFirstShow = false;
        if (this.errorText == null) {
            isFirstShow = true;
            this.createErrorPane();
        }
        this.mainPanel.remove(this.scrollPane);
        if (!isFirstShow) {
            this.splitPane.setTopComponent(this.scrollPane);
        }
        this.mainPanel.add((Component)this.splitPane, "Center");
        this.splitPane.resetToPreferredSizes();
        this.mainPanel.validate();
        this.errorShown = true;
    }

    private void hideErrorPane() {
        if (!this.errorShown) {
            return;
        }
        this.mainPanel.remove(this.splitPane);
        this.mainPanel.add((Component)this.scrollPane, "Center");
        this.errorShown = false;
        this.mainPanel.validate();
    }

    private JMenuBar makeMenuBar() {
        JMenuBar menubar = new JMenuBar();
        JMenu menu = new JMenu(Config.getString("terminal.options"));
        JMenuItem item = menu.add(new ClearAction());
        item.setAccelerator(KeyStroke.getKeyStroke(75, SHORTCUT_MASK));
        item = menu.add(this.getCopyAction());
        item.setText(Config.getString("terminal.copy"));
        item.setAccelerator(KeyStroke.getKeyStroke(67, SHORTCUT_MASK));
        item = menu.add(new SaveAction());
        item.setAccelerator(KeyStroke.getKeyStroke(83, SHORTCUT_MASK));
        menu.add(new PrintAction());
        menu.add(new JSeparator());
        this.autoClear = new JCheckBoxMenuItem(new AutoClearAction());
        this.autoClear.setSelected(clearOnMethodCall);
        menu.add(this.autoClear);
        this.recordCalls = new JCheckBoxMenuItem(new RecordCallAction());
        this.recordCalls.setSelected(recordMethodCalls);
        menu.add(this.recordCalls);
        this.unlimitedBuffering = new JCheckBoxMenuItem(new BufferAction());
        this.unlimitedBuffering.setSelected(unlimitedBufferingCall);
        menu.add(this.unlimitedBuffering);
        menu.add(new JSeparator());
        item = menu.add(new CloseAction());
        item.setAccelerator(KeyStroke.getKeyStroke(87, SHORTCUT_MASK));
        menubar.add(menu);
        return menubar;
    }

    public void cleanup() {
        BlueJEvent.removeListener(this);
    }

    private Action getCopyAction() {
        Action[] textActions = this.text.getActions();
        for (int i = 0; i < textActions.length; ++i) {
            if (!textActions[i].getValue("Name").equals("copy-to-clipboard")) continue;
            return textActions[i];
        }
        return null;
    }

    @OnThread(value=Tag.Any)
    private class TerminalWriter
    extends Writer {
        private boolean isErrorOut;

        TerminalWriter(boolean isError) {
            this.isErrorOut = isError;
        }

        @Override
        public void write(final char[] cbuf, final int off, final int len) {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        Terminal.this.writeToPane(!TerminalWriter.this.isErrorOut, new String(cbuf, off, len));
                    }
                });
            }
            catch (InvocationTargetException ite) {
                ite.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() {
        }
    }

    @OnThread(value=Tag.Any)
    private class TerminalReader
    extends Reader {
        private TerminalReader() {
        }

        @Override
        public int read(char[] cbuf, int off, int len) {
            int charsRead;
            for (charsRead = 0; charsRead < len; ++charsRead) {
                cbuf[off + charsRead] = Terminal.this.buffer.getChar();
                if (!Terminal.this.buffer.isEmpty()) continue;
                break;
            }
            return charsRead;
        }

        @Override
        public boolean ready() {
            return !Terminal.this.buffer.isEmpty();
        }

        @Override
        public void close() {
        }
    }

    private class BufferAction
    extends AbstractAction {
        public BufferAction() {
            super(Config.getString("terminal.buffering"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            unlimitedBufferingCall = Terminal.this.unlimitedBuffering.isSelected();
            Terminal.this.text.setUnlimitedBuffering(unlimitedBufferingCall);
            Config.putPropBoolean(Terminal.UNLIMITEDBUFFERINGCALLPROPNAME, unlimitedBufferingCall);
        }
    }

    private class RecordCallAction
    extends AbstractAction {
        public RecordCallAction() {
            super(Config.getString("terminal.recordCalls"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            recordMethodCalls = Terminal.this.recordCalls.isSelected();
            Config.putPropBoolean(Terminal.RECORDMETHODCALLSPROPNAME, recordMethodCalls);
        }
    }

    private class AutoClearAction
    extends AbstractAction {
        public AutoClearAction() {
            super(Config.getString("terminal.clearScreen"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            clearOnMethodCall = Terminal.this.autoClear.isSelected();
            Config.putPropBoolean(Terminal.CLEARONMETHODCALLSPROPNAME, clearOnMethodCall);
        }
    }

    private class CloseAction
    extends AbstractAction {
        public CloseAction() {
            super(Config.getString("terminal.close"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Terminal.this.showHide(false);
        }
    }

    private class PrintAction
    extends AbstractAction {
        public PrintAction() {
            super(Config.getString("terminal.print"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Terminal.this.print();
        }
    }

    private class SaveAction
    extends AbstractAction {
        public SaveAction() {
            super(Config.getString("terminal.save"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Terminal.this.save();
        }
    }

    private class ClearAction
    extends AbstractAction {
        public ClearAction() {
            super(Config.getString("terminal.clear"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Terminal.this.clear();
        }
    }
}

