/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.slots;

import bluej.stride.generic.Frame;
import bluej.stride.generic.InteractionManager;
import bluej.stride.slots.CopyableHeaderItem;
import bluej.stride.slots.EditableSlot;
import bluej.stride.slots.HeaderItem;
import bluej.utility.javafx.JavaFXUtil;
import bluej.utility.javafx.ScalableHeightLabel;
import bluej.utility.javafx.SharedTransition;
import java.util.List;
import java.util.stream.Stream;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableSet;
import javafx.css.CssMetaData;
import javafx.css.PseudoClass;
import javafx.css.Styleable;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.control.OverrunStyle;
import javafx.scene.input.MouseEvent;
import javafx.scene.text.Font;

public class SlotLabel
implements HeaderItem,
Styleable,
CopyableHeaderItem {
    private final ScalableHeightLabel l;
    private final ObservableList<Node> list;
    private boolean animateCaption;

    public SlotLabel(String content, String ... styleClasses) {
        this.l = new ScalableHeightLabel(content, false);
        JavaFXUtil.addStyleClass((Styleable)this.l, "slot-label");
        JavaFXUtil.addStyleClass((Styleable)this.l, styleClasses);
        this.list = FXCollections.observableArrayList((Object[])new Node[]{this.l});
    }

    public ObservableList<Node> getComponents() {
        return this.list;
    }

    @Override
    public EditableSlot asEditable() {
        return null;
    }

    public String getTypeSelector() {
        return this.l.getTypeSelector();
    }

    public String getId() {
        return this.l.getId();
    }

    public ObservableList<String> getStyleClass() {
        return this.l.getStyleClass();
    }

    public String getStyle() {
        return this.l.getStyle();
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return this.l.getCssMetaData();
    }

    public Styleable getStyleableParent() {
        return this.l.getStyleableParent();
    }

    public ObservableSet<PseudoClass> getPseudoClassStates() {
        return this.l.getPseudoClassStates();
    }

    public void setStyle(String style) {
        this.l.setStyle(style);
    }

    public StringProperty textProperty() {
        return this.l.textProperty();
    }

    public BooleanProperty disableProperty() {
        return this.l.disableProperty();
    }

    public void setOnMouseClicked(EventHandler<? super MouseEvent> h) {
        this.l.setOnMouseClicked(h);
    }

    public void setOnMouseDragged(EventHandler<? super MouseEvent> value) {
        this.l.setOnMouseDragged(value);
    }

    public void setCursor(Cursor c) {
        this.l.setCursor(c);
    }

    public void setOpacity(double d) {
        this.l.setOpacity(0.0);
    }

    public Node getNode() {
        return this.l;
    }

    public void setText(String string) {
        this.l.setText(string);
    }

    public DoubleProperty rotateProperty() {
        return this.l.rotateProperty();
    }

    public DoubleProperty prefWidthProperty() {
        return this.l.prefWidthProperty();
    }

    public DoubleProperty minWidthProperty() {
        return this.l.minWidthProperty();
    }

    @Override
    public void setView(Frame.View oldView, Frame.View newView, SharedTransition animate) {
        if (!this.animateCaption) {
            return;
        }
        if (newView == Frame.View.JAVA_PREVIEW) {
            animate.addOnStopped(() -> JavaFXUtil.setPseudoclass("bj-java-preview", newView == Frame.View.JAVA_PREVIEW, new Node[]{this.l}));
        } else {
            JavaFXUtil.setPseudoclass("bj-java-preview", newView == Frame.View.JAVA_PREVIEW, new Node[]{this.l});
            JavaFXUtil.setPseudoclass("bj-birdseye", newView.isBirdseye(), new Node[]{this.l});
            animate.addOnStopped(() -> {
                this.l.minWidthProperty().unbind();
                this.l.setMinWidth(0.0);
            });
        }
    }

    public void shrinkHorizontally(SharedTransition animate) {
        this.l.setTextOverrun(OverrunStyle.CLIP);
        double cur = this.l.getWidth();
        this.l.minWidthProperty().set(0.0);
        this.l.maxWidthProperty().unbind();
        this.l.maxWidthProperty().bind((ObservableValue)animate.getProgress().negate().add(1.0).multiply(cur));
    }

    public void growHorizontally(SharedTransition animate) {
        this.l.maxWidthProperty().unbind();
        this.l.maxWidthProperty().bind((ObservableValue)animate.getProgress().multiply(JavaFXUtil.measureString((Labeled)this.l, this.l.getText())));
        animate.addOnStopped(() -> {
            this.l.setMinWidth(-1.0);
            this.l.maxWidthProperty().unbind();
            this.l.maxWidthProperty().set(-1.0);
        });
    }

    public void shrinkVertically(SharedTransition animate) {
        this.l.setTextOverrun(OverrunStyle.CLIP);
        this.l.shrinkToNothingWith(animate, true);
    }

    public void shrinkInstantly() {
        this.l.setTextOverrun(OverrunStyle.CLIP);
        this.l.setToNothing();
    }

    public void growVertically(SharedTransition animate) {
        this.l.growToFullHeightWith(animate, true);
    }

    public String getText() {
        return this.l.getText();
    }

    public ObjectProperty<Font> fontProperty() {
        return this.l.fontProperty();
    }

    public double measureString(String text) {
        return JavaFXUtil.measureString((Labeled)this.l, text);
    }

    public void setOnDragDetected(EventHandler<? super MouseEvent> value) {
        this.l.setOnDragDetected(value);
    }

    public void setOnMousePressed(EventHandler<? super MouseEvent> value) {
        this.l.setOnMousePressed(value);
    }

    public void setOnMouseReleased(EventHandler<? super MouseEvent> value) {
        this.l.setOnMouseReleased(value);
    }

    public void setLeftPadding(double amount) {
        Insets p = this.l.getPadding();
        this.l.setPadding(new Insets(p.getTop(), p.getRight(), p.getBottom(), amount));
    }

    public void setAnimateCaption(boolean animateCaption) {
        this.animateCaption = animateCaption;
    }

    public Stream<Label> makeDisplayClone(InteractionManager editor) {
        Label copy = JavaFXUtil.cloneLabel(this.l, (ObservableValue<String>)editor.getFontSizeCSS());
        return Stream.of(copy);
    }
}

