/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.generic;

import bluej.collect.StrideEditReason;
import bluej.stride.framedjava.ast.Loader;
import bluej.stride.framedjava.elements.CodeElement;
import bluej.stride.framedjava.elements.LocatableElement;
import bluej.stride.framedjava.frames.CodeFrame;
import bluej.stride.framedjava.frames.InterfaceFrame;
import bluej.stride.generic.Frame;
import bluej.stride.generic.FrameCanvas;
import bluej.stride.generic.FrameCursor;
import bluej.stride.generic.InteractionManager;
import bluej.stride.operations.AbstractOperation;
import bluej.stride.operations.FrameOperation;
import bluej.stride.slots.EditableSlot;
import bluej.stride.slots.SlotLabel;
import bluej.utility.Debug;
import bluej.utility.Utility;
import bluej.utility.javafx.JavaFXUtil;
import bluej.utility.javafx.SharedTransition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.control.CustomMenuItem;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import nu.xom.Element;
import threadchecker.OnThread;
import threadchecker.Tag;

public abstract class SingleLineFrame
extends Frame {
    protected final SlotLabel previewSemi = new SlotLabel("", new String[]{"preview-semi"}){

        @Override
        public void setView(Frame.View oldView, Frame.View v, SharedTransition animate) {
            if (v == Frame.View.JAVA_PREVIEW) {
                this.setText(";");
                this.getNode().opacityProperty().bind((ObservableValue)animate.getProgress());
                animate.addOnStopped(() -> this.getNode().opacityProperty().unbind());
            } else {
                this.setText("");
            }
        }
    };
    private final ObservableList<FrameState> recentValues = FXCollections.observableArrayList();

    public SingleLineFrame(InteractionManager editor, String caption, String stylePrefix) {
        super(editor, caption, stylePrefix);
    }

    @Override
    public double lowestCursorY() {
        Bounds sceneBounds = this.getNode().localToScene(this.getNode().getBoundsInLocal());
        return sceneBounds.getMaxY();
    }

    @Override
    public FrameCursor findCursor(double sceneX, double sceneY, FrameCursor prevCursor, FrameCursor nextCursor, List<Frame> exclude, boolean isDrag, boolean canDescend) {
        Bounds headBounds = this.getHeaderRow().getSceneBounds();
        if (sceneY <= 2.0 + (headBounds.getMinY() + headBounds.getMaxY()) / 2.0) {
            return prevCursor;
        }
        return nextCursor;
    }

    protected boolean isInInterface(FrameCanvas parentCanvas) {
        if (parentCanvas == null) {
            Debug.printCallStack("parentCanvas shouldn't be null");
            return false;
        }
        return parentCanvas.getParent() instanceof InterfaceFrame;
    }

    @Override
    public List<FrameOperation> getContextOperations() {
        ArrayList<FrameOperation> ops = new ArrayList<FrameOperation>(super.getContextOperations());
        int i = 0;
        for (final FrameState state : this.recentValues) {
            if (i > 0) {
                ops.add(new FrameOperation(this.getEditor(), "revert" + i, AbstractOperation.Combine.ONE){

                    @Override
                    @OnThread(value=Tag.FXPlatform)
                    protected void execute(List<Frame> frames) {
                        this.editor.recordEdits(StrideEditReason.FLUSH);
                        SingleLineFrame.this.getParentCanvas().replaceBlock(SingleLineFrame.this, Loader.loadElement(state.value).createFrame(this.editor));
                        this.editor.recordEdits(StrideEditReason.UNDO_LOCAL);
                    }

                    @Override
                    public List<AbstractOperation.ItemLabel> getLabels() {
                        return Arrays.asList(this.l("Recent Values", EditableSlot.MenuItemOrder.RECENT_VALUES), this.l("0", EditableSlot.MenuItemOrder.RECENT_VALUES));
                    }

                    @Override
                    protected CustomMenuItem initializeCustomItem() {
                        ImageView view = new ImageView(state.picture);
                        CustomMenuItem item = new CustomMenuItem((Node)view);
                        return item;
                    }

                    @Override
                    public boolean onlyOnContextMenu() {
                        return true;
                    }
                });
            }
            ++i;
        }
        return ops;
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void compiled() {
        super.compiled();
        this.saveAsRecent();
    }

    @OnThread(value=Tag.FXPlatform)
    protected void saveAsRecent() {
        if (!(this instanceof CodeFrame)) {
            return;
        }
        Object code = ((CodeFrame)((Object)this)).getCode();
        if (code == null) {
            return;
        }
        LocatableElement el = ((CodeElement)code).toXML();
        String xml = el.toXML();
        int existingRecent = Utility.findIndex(this.recentValues, fs -> fs.cachedXML.equals(xml));
        if (existingRecent != -1) {
            FrameState fs2 = (FrameState)this.recentValues.remove(existingRecent);
            this.recentValues.add(0, (Object)fs2);
        } else {
            JavaFXUtil.runAfterCurrent(() -> {
                Image pic = SingleLineFrame.takeShot(Arrays.asList(this), null);
                FrameState s = new FrameState(pic, el, xml);
                this.recentValues.add(0, (Object)s);
                while (this.recentValues.size() > 4) {
                    this.recentValues.remove(4);
                }
            });
        }
    }

    private static class FrameState {
        public final Element value;
        public final String cachedXML;
        public final Image picture;

        public FrameState(Image picture, Element value, String xml) {
            this.picture = picture;
            this.value = new Element(value);
            this.cachedXML = xml;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FrameState state = (FrameState)o;
            return this.cachedXML.equals(state.cachedXML);
        }

        public int hashCode() {
            return this.cachedXML.hashCode();
        }
    }
}

