/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.errors;

import bluej.stride.framedjava.ast.JavaFragment;
import bluej.stride.framedjava.errors.FixSuggestion;
import bluej.stride.framedjava.errors.JavaCompileError;
import bluej.stride.generic.InteractionManager;
import bluej.utility.javafx.JavaFXUtil;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import threadchecker.OnThread;
import threadchecker.Tag;

public abstract class CodeError {
    private boolean flaggedAsOld = false;
    private final BooleanProperty focusedProperty = new SimpleBooleanProperty(false);
    protected final JavaFragment relevantSlot;
    private final BooleanProperty freshProperty = new SimpleBooleanProperty(false);
    private final BooleanProperty showingIndicatorProperty = new SimpleBooleanProperty(false);
    private BooleanExpression visible;
    protected @OnThread(value=Tag.Any, requireSynchronized=true) String path;

    @OnThread(value=Tag.Any)
    protected CodeError(JavaFragment code) {
        if (code == null) {
            throw new IllegalArgumentException("Slot for error cannot be null");
        }
        this.relevantSlot = code;
        Platform.runLater(() -> {
            this.visible = this.freshProperty.not().and((ObservableBooleanValue)this.showingIndicatorProperty);
            code.addError(this);
        });
    }

    public void flagAsOld() {
        this.flaggedAsOld = true;
    }

    public boolean isFlaggedAsOld() {
        return this.flaggedAsOld;
    }

    public abstract boolean isJavaPos();

    @OnThread(value=Tag.Any)
    public abstract String getMessage();

    public abstract List<? extends FixSuggestion> getFixSuggestions();

    public int getStartPosition() {
        return 0;
    }

    public int getEndPosition() {
        return Integer.MAX_VALUE;
    }

    public static int compareErrors(CodeError a, CodeError b) {
        boolean aIsSmallerOrEqual;
        boolean aIsCompile = a instanceof JavaCompileError;
        boolean bIsCompile = b instanceof JavaCompileError;
        boolean overlap = a.overlaps(b);
        boolean bl = aIsSmallerOrEqual = a.getEndPosition() - a.getStartPosition() <= b.getEndPosition() - b.getStartPosition();
        if (!overlap) {
            return 0;
        }
        if (aIsCompile && !bIsCompile) {
            return 1;
        }
        if (!aIsCompile && bIsCompile) {
            return -1;
        }
        if (aIsSmallerOrEqual) {
            return -1;
        }
        return 1;
    }

    public boolean overlaps(CodeError e) {
        return this.getStartPosition() <= e.getEndPosition() && e.getStartPosition() <= this.getEndPosition();
    }

    public void jumpTo(InteractionManager editor) {
        Node n = this.getRelevantNode();
        if (n != null) {
            editor.scrollTo(n, -100.0);
            this.relevantSlot.getErrorShower().focusAndPositionAtError(this);
        }
    }

    public final Node getRelevantNode() {
        if (this.relevantSlot.getErrorShower() == null) {
            return null;
        }
        return this.relevantSlot.getErrorShower().getRelevantNodeForError(this);
    }

    public BooleanProperty focusedProperty() {
        return this.focusedProperty;
    }

    public ObservableBooleanValue visibleProperty() {
        return this.visible;
    }

    public void setShowingIndicator(boolean showing) {
        this.showingIndicatorProperty.set(showing);
    }

    public void bindFresh(ObservableBooleanValue fresh, InteractionManager editor) {
        this.freshProperty.bind((ObservableValue)fresh);
        if (!this.visibleProperty().get()) {
            JavaFXUtil.addSelfRemovingListener(this.visibleProperty(), vis -> {
                if (vis.booleanValue()) {
                    editor.recordErrorIndicatorShown(this.getIdentifier());
                }
            });
        } else {
            editor.recordErrorIndicatorShown(this.getIdentifier());
        }
    }

    @OnThread(value=Tag.Any)
    public abstract int getIdentifier();

    @OnThread(value=Tag.Any)
    public synchronized void recordPath(String path) {
        this.path = path;
    }
}

