/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.elements;

import bluej.stride.framedjava.ast.JavaSource;
import bluej.stride.framedjava.ast.SlotFragment;
import bluej.stride.framedjava.elements.CodeElement;
import bluej.stride.framedjava.elements.LocatableElement;
import bluej.stride.framedjava.frames.CommentFrame;
import bluej.stride.generic.Frame;
import bluej.stride.generic.InteractionManager;
import java.util.stream.Stream;
import nu.xom.Element;
import threadchecker.OnThread;
import threadchecker.Tag;

public class CommentElement
extends CodeElement {
    public static final String ELEMENT = "comment";
    private CommentFrame frame;
    private final String comment;

    public CommentElement(Element xmlEl) {
        this.comment = xmlEl.getChildCount() > 0 ? xmlEl.getChild(0).getValue() : "";
    }

    @OnThread(value=Tag.FX)
    public CommentElement(CommentFrame frame) {
        this.frame = frame;
        this.comment = frame.getComment();
    }

    public CommentElement(String s) {
        this.comment = s;
    }

    @Override
    public JavaSource toJavaSource() {
        String sanitised = " " + this.comment.replace("/*", "").replace("*/", "").replace("\n", "");
        return new JavaSource(null, this.f(this.frame, "/*"), this.f(this.frame, sanitised), this.f(this.frame, "*/"));
    }

    @Override
    public LocatableElement toXML() {
        LocatableElement commentEl = new LocatableElement(this, ELEMENT);
        CommentElement.preserveWhitespace(commentEl);
        commentEl.appendChild(this.comment);
        return commentEl;
    }

    @Override
    public Frame createFrame(InteractionManager editor) {
        this.frame = new CommentFrame(editor, this.comment);
        return this.frame;
    }

    @Override
    public void show(Frame.ShowReason reason) {
        this.frame.show(reason);
    }

    @Override
    protected Stream<SlotFragment> getDirectSlotFragments() {
        return Stream.empty();
    }
}

