/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.elements;

import bluej.stride.framedjava.ast.FilledExpressionSlotFragment;
import bluej.stride.framedjava.ast.HighlightedBreakpoint;
import bluej.stride.framedjava.ast.JavaSingleLineDebugHandler;
import bluej.stride.framedjava.ast.JavaSource;
import bluej.stride.framedjava.ast.Loader;
import bluej.stride.framedjava.ast.SlotFragment;
import bluej.stride.framedjava.elements.CodeElement;
import bluej.stride.framedjava.elements.ContainerCodeElement;
import bluej.stride.framedjava.elements.LocatableElement;
import bluej.stride.framedjava.frames.CaseFrame;
import bluej.stride.framedjava.frames.DebugInfo;
import bluej.stride.generic.Frame;
import bluej.stride.generic.InteractionManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import nu.xom.Element;
import nu.xom.Node;

public class CaseElement
extends ContainerCodeElement
implements JavaSingleLineDebugHandler {
    public static final String ELEMENT = "case";
    private final FilledExpressionSlotFragment expression;
    private final List<CodeElement> contents;
    private CaseFrame frame;

    public CaseElement(CaseFrame frame, FilledExpressionSlotFragment condition, List<CodeElement> contents, boolean enabled) {
        this.frame = frame;
        this.expression = condition;
        this.contents = contents;
        this.enable = enabled;
        contents.forEach(c -> c.setParent(this));
    }

    @Override
    public List<CodeElement> childrenUpTo(CodeElement c) {
        return this.contents.subList(0, this.contents.indexOf(c));
    }

    @Override
    public JavaSource toJavaSource() {
        return JavaSource.createCompoundStatement(this.frame, this, this, null, Arrays.asList(this.f(this.frame, "case "), this.expression, this.f(this.frame, " :")), CodeElement.toJavaCodes(this.contents));
    }

    @Override
    public LocatableElement toXML() {
        LocatableElement caseEl = new LocatableElement(this, ELEMENT);
        caseEl.addAttributeStructured("expression", this.expression);
        this.addEnableAttribute(caseEl);
        for (CodeElement c : this.contents) {
            caseEl.appendChild((Node)c.toXML());
        }
        return caseEl;
    }

    public CaseElement(Element el) {
        this.expression = new FilledExpressionSlotFragment(el.getAttributeValue("expression"), el.getAttributeValue("expression-java"));
        this.contents = new ArrayList<CodeElement>();
        for (int i = 0; i < el.getChildElements().size(); ++i) {
            Element child = el.getChildElements().get(i);
            CodeElement member = Loader.loadElement(child);
            this.contents.add(member);
            member.setParent(this);
        }
        this.enable = Boolean.valueOf(el.getAttributeValue("enable"));
    }

    @Override
    public Frame createFrame(InteractionManager editor) {
        this.frame = new CaseFrame(editor, this.expression, this.isEnable());
        for (CodeElement c : this.contents) {
            this.frame.getCanvas().insertBlockAfter(c.createFrame(editor), null);
        }
        return this.frame;
    }

    @Override
    public HighlightedBreakpoint showDebugBefore(DebugInfo debug) {
        return this.frame.showDebugBefore(debug);
    }

    @Override
    public void show(Frame.ShowReason reason) {
        this.frame.show(reason);
    }

    @Override
    public Stream<CodeElement> streamContained() {
        return CaseElement.streamContained(this.contents);
    }

    @Override
    protected Stream<SlotFragment> getDirectSlotFragments() {
        return Stream.of(this.expression);
    }
}

