/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.ast;

import bluej.stride.framedjava.ast.JavaFragment;
import bluej.stride.framedjava.ast.Parser;
import bluej.stride.framedjava.ast.StructuredSlotFragment;
import bluej.stride.framedjava.elements.CodeElement;
import bluej.stride.framedjava.elements.LocatableElement;
import bluej.stride.framedjava.errors.DirectSlotError;
import bluej.stride.framedjava.errors.EmptyError;
import bluej.stride.framedjava.errors.SyntaxCodeError;
import bluej.stride.framedjava.errors.UnknownTypeError;
import bluej.stride.framedjava.errors.UnneededSemiColonError;
import bluej.stride.framedjava.slots.ExpressionSlot;
import bluej.stride.framedjava.slots.TypeSlot;
import bluej.stride.generic.InteractionManager;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.stream.Stream;
import threadchecker.OnThread;
import threadchecker.Tag;

public class TypeSlotFragment
extends StructuredSlotFragment {
    private TypeSlot slot;

    public TypeSlotFragment(String content, String javaCode, TypeSlot slot) {
        super(content, javaCode);
        this.slot = slot;
    }

    public TypeSlotFragment(String content, String javaCode) {
        this(content, javaCode, null);
    }

    @Override
    public Map<String, CodeElement> getVars() {
        return Collections.emptyMap();
    }

    @Override
    public String getJavaCode(JavaFragment.Destination dest, ExpressionSlot<?> completing, Parser.DummyNameGenerator dummyNameGenerator) {
        if (!dest.substitute() || this.content != null && Parser.parseableAsType(this.content)) {
            return this.content;
        }
        return "int";
    }

    @Override
    public Stream<SyntaxCodeError> findEarlyErrors() {
        if (this.content != null && this.content.isEmpty()) {
            return Stream.of(new EmptyError(this, "Type cannot be empty"));
        }
        if (this.content != null && this.content.endsWith(";")) {
            return Stream.of(new UnneededSemiColonError(this, () -> this.getSlot().setText(this.content.substring(0, this.content.length() - 1))));
        }
        if (this.content == null || !Parser.parseableAsType(this.content)) {
            return Stream.of(new SyntaxCodeError(this, "Invalid type"));
        }
        return Stream.empty();
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public Future<List<DirectSlotError>> findLateErrors(InteractionManager editor, CodeElement parent, LocatableElement.LocationMap rootPathMap) {
        CompletableFuture<List<DirectSlotError>> f = new CompletableFuture<List<DirectSlotError>>();
        if (this.findEarlyErrors().count() > 0L || this.content.contains("[") || this.content.contains("<") || this.content.contains(".")) {
            f.complete(Collections.emptyList());
            return f;
        }
        editor.withTypes(types -> {
            if (types.containsKey(this.content)) {
                f.complete(Collections.emptyList());
                return;
            }
            UnknownTypeError error = new UnknownTypeError(this, this.content, this.slot::setText, editor, types.values().stream(), editor.getImportSuggestions().values().stream().flatMap(Collection::stream)){};
            error.recordPath(rootPathMap.locationFor(this));
            f.complete(Arrays.asList(error));
        });
        return f;
    }

    @Override
    public TypeSlot getSlot() {
        return this.slot;
    }

    public void registerSlot(TypeSlot slot) {
        if (this.slot == null) {
            this.slot = slot;
        }
    }
}

