/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.ast;

import bluej.stride.framedjava.ast.JavaFragment;
import bluej.stride.framedjava.ast.Parser;
import bluej.stride.framedjava.ast.StringSlotFragment;
import bluej.stride.framedjava.ast.TextSlotFragment;
import bluej.stride.framedjava.errors.EmptyError;
import bluej.stride.framedjava.errors.SyntaxCodeError;
import bluej.stride.framedjava.errors.UnneededSemiColonError;
import bluej.stride.framedjava.slots.ExpressionSlot;
import bluej.stride.slots.TextSlot;
import java.util.stream.Stream;

public class NameDefSlotFragment
extends TextSlotFragment {
    private TextSlot<NameDefSlotFragment> slot;

    public NameDefSlotFragment(String content, TextSlot<NameDefSlotFragment> slot) {
        super(content);
        this.slot = slot;
    }

    public NameDefSlotFragment(String content) {
        this(content, null);
    }

    public NameDefSlotFragment(StringSlotFragment f) {
        this(f.getContent());
    }

    @Override
    public String getJavaCode(JavaFragment.Destination dest, ExpressionSlot<?> completing, Parser.DummyNameGenerator dummyNameGenerator) {
        if (!dest.substitute() || this.content != null && Parser.parseableAsNameDef(this.content)) {
            return this.content;
        }
        return dummyNameGenerator.generateNewDummyName();
    }

    @Override
    public Stream<SyntaxCodeError> findEarlyErrors() {
        if (this.content != null && this.content.isEmpty()) {
            return Stream.of(new EmptyError(this, "Name cannot be empty"));
        }
        if (this.content != null && this.content.endsWith(";")) {
            return Stream.of(new UnneededSemiColonError(this, () -> ((TextSlot)this.getSlot()).setText(this.content.substring(0, this.content.length() - 1))));
        }
        if (this.content == null || !Parser.parseableAsNameDef(this.content)) {
            return Stream.of(new SyntaxCodeError(this, "Invalid name"));
        }
        return Stream.empty();
    }

    @Override
    public TextSlot<NameDefSlotFragment> getSlot() {
        return this.slot;
    }

    @Override
    public void registerSlot(TextSlot slot) {
        if (this.slot == null) {
            this.slot = slot;
        }
    }
}

