/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.ast;

import bluej.parser.AssistContent;
import bluej.stride.framedjava.ast.JavaFragment;
import bluej.stride.framedjava.elements.CodeElement;
import bluej.stride.framedjava.elements.ContainerCodeElement;
import bluej.stride.framedjava.elements.MethodWithBodyElement;
import bluej.stride.framedjava.elements.TopLevelCodeElement;
import bluej.stride.generic.AssistContentThreadSafe;
import bluej.stride.generic.InteractionManager;
import bluej.utility.javafx.FXPlatformConsumer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import threadchecker.OnThread;
import threadchecker.Tag;

public class ASTUtility {
    public static List<CodeElement.LocalParamInfo> findLocalsAndParamsInScopeAt(CodeElement orig, boolean includeFields, boolean includeCurDecl) {
        ArrayList<CodeElement.LocalParamInfo> vars = new ArrayList<CodeElement.LocalParamInfo>();
        CodeElement cur = orig;
        ContainerCodeElement parent = cur.getParent();
        if (includeCurDecl && cur instanceof ContainerCodeElement) {
            vars.addAll(((ContainerCodeElement)cur).getDeclaredVariablesWithin(cur));
        }
        while (parent != null && (includeFields || parent.getTopLevelElement() == null)) {
            for (CodeElement c : parent.childrenUpTo(cur)) {
                vars.addAll(c.getDeclaredVariablesAfter());
            }
            vars.addAll(parent.getDeclaredVariablesWithin(cur));
            cur = parent;
            parent = parent.getParent();
        }
        return vars;
    }

    public static TopLevelCodeElement getTopLevelElement(CodeElement orig) {
        ContainerCodeElement c = orig.getParent();
        while (c.getTopLevelElement() == null) {
            c = c.getParent();
        }
        return c.getTopLevelElement();
    }

    public static MethodWithBodyElement getMethodElement(CodeElement orig) {
        ContainerCodeElement c;
        for (c = orig.getParent(); c != null && c.getMethodElement() == null; c = c.getParent()) {
        }
        return c == null ? null : c.getMethodElement();
    }

    @OnThread(value=Tag.FXPlatform)
    public static void withLocalsParamsAndFields(CodeElement el, InteractionManager editor, JavaFragment.PosInSourceDoc pos, boolean includeCurDecl, FXPlatformConsumer<Map<String, CodeElement>> handler) {
        editor.withAccessibleMembers(pos, Collections.singleton(AssistContent.CompletionKind.FIELD), false, x -> {
            Stream<String> fieldStream = x.stream().map(AssistContentThreadSafe::getName);
            List<CodeElement.LocalParamInfo> localsAndParams = ASTUtility.findLocalsAndParamsInScopeAt(el, true, includeCurDecl);
            HashMap<String, CodeElement> r = new HashMap<String, CodeElement>();
            fieldStream.forEach(s -> {
                CodeElement cfr_ignored_0 = r.put((String)s, (CodeElement)null);
            });
            r.putAll(localsAndParams.stream().collect(Collectors.toMap(CodeElement.LocalParamInfo::getName, CodeElement.LocalParamInfo::getDeclarer, (early, late) -> late)));
            handler.accept(r);
        });
    }
}

