/*
 * Decompiled with CFR 0.152.
 */
package bluej.prefmgr;

import bluej.BlueJTheme;
import bluej.Config;
import bluej.classmgr.ClassMgrPrefPanel;
import bluej.editor.moe.EditorPrefPanel;
import bluej.editor.moe.KeyBindingsPanel;
import bluej.extmgr.ExtensionPrefManager;
import bluej.extmgr.ExtensionsManager;
import bluej.prefmgr.InterfacePanel;
import bluej.prefmgr.MiscPrefPanel;
import bluej.prefmgr.PrefPanelListener;
import bluej.prefmgr.RaspberryPiPanel;
import bluej.utility.javafx.FXPlatformRunnable;
import bluej.utility.javafx.JavaFXUtil;
import bluej.utility.javafx.SwingNodeFixed;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.css.Styleable;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TitledPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javafx.scene.text.TextFlow;
import javax.swing.SwingUtilities;
import threadchecker.OnThread;
import threadchecker.Tag;

public class PrefMgrDialog {
    private static PrefMgrDialog dialog = null;
    private @OnThread(value=Tag.FXPlatform) BooleanProperty prefPanesCreated = new SimpleBooleanProperty(false);
    private boolean prepared = false;
    private ArrayList<PrefPanelListener> listeners = new ArrayList();
    private ArrayList<Node> tabs = new ArrayList();
    private ArrayList<String> titles = new ArrayList();
    private Dialog<Void> window;
    private TabPane tabbedPane = null;

    public static void showDialog() {
        PrefMgrDialog.getInstance().prepareDialogThen(() -> {
            PrefMgrDialog.dialog.window.show();
            PrefMgrDialog.dialog.tabbedPane.getScene().getWindow().sizeToScene();
        });
    }

    public static void showDialog(int paneNumber) {
        PrefMgrDialog.getInstance().prepareDialogThen(() -> {
            dialog.selectTab(paneNumber);
            PrefMgrDialog.dialog.window.show();
            PrefMgrDialog.dialog.tabbedPane.getScene().getWindow().sizeToScene();
        });
    }

    @OnThread(value=Tag.FXPlatform)
    private void prepareDialogThen(FXPlatformRunnable runnable) {
        if (!this.prepared) {
            if (!this.prefPanesCreated.get()) {
                JavaFXUtil.addSelfRemovingListener(this.prefPanesCreated, b -> JavaFXUtil.runNowOrLater(() -> this.prepareDialogThen(runnable)));
                return;
            }
            this.makeDialog();
            this.prepared = true;
        }
        dialog.startEditing();
        runnable.run();
    }

    public static final PrefMgrDialog getInstance() {
        if (dialog == null) {
            dialog = new PrefMgrDialog();
        }
        return dialog;
    }

    private PrefMgrDialog() {
        this.createPrefPanes();
    }

    private void createPrefPanes() {
        EditorPrefPanel panel = new EditorPrefPanel();
        this.add(0, (Node)panel, Config.getString("prefmgr.edit.prefpaneltitle"), (PrefPanelListener)panel);
        MiscPrefPanel panel2 = new MiscPrefPanel();
        this.add(1, (Node)panel2, Config.getString("prefmgr.misc.prefpaneltitle"), panel2);
        InterfacePanel panel3 = new InterfacePanel();
        this.add(2, (Node)panel3, Config.getString("prefmgr.interface.title"), panel3);
        ClassMgrPrefPanel userConfigLibPanel = new ClassMgrPrefPanel();
        this.add(3, (Node)userConfigLibPanel, Config.getString("classmgr.prefpaneltitle"), userConfigLibPanel);
        SwingUtilities.invokeLater(() -> {
            SwingNodeFixed kbSwing = new SwingNodeFixed();
            KeyBindingsPanel kbPanel = new KeyBindingsPanel(() -> null);
            kbSwing.setContent(kbPanel.makePanel());
            Platform.runLater(() -> this.add(1, (Node)kbSwing, Config.getString("prefmgr.edit.keybindingstitle"), (PrefPanelListener)kbPanel));
            if (!Config.isGreenfoot()) {
                SwingNodeFixed extSwing = new SwingNodeFixed();
                ExtensionPrefManager mgr = ExtensionsManager.getInstance().getPrefManager();
                extSwing.setContent(mgr.getPanel());
                Platform.runLater(() -> this.add(5, (Node)extSwing, Config.getString("extmgr.extensions"), mgr));
                if (Config.isRaspberryPi()) {
                    RaspberryPiPanel rpp = new RaspberryPiPanel();
                    SwingNodeFixed piSwing = new SwingNodeFixed();
                    piSwing.setContent(rpp);
                    Platform.runLater(() -> this.add(6, (Node)piSwing, Config.getString("extmgr.raspberryPi.rpiPanelTitle"), rpp));
                }
            }
            Platform.runLater(() -> this.prefPanesCreated.set(true));
        });
    }

    public void add(int index, Node panel, String title, PrefPanelListener listener) {
        this.tabs.add(index, panel);
        this.listeners.add(index, listener);
        this.titles.add(index, title);
    }

    private void startEditing() {
        for (PrefPanelListener ppl : this.listeners) {
            ppl.beginEditing();
        }
    }

    private void selectTab(int tabNumber) {
        this.tabbedPane.getSelectionModel().select(tabNumber);
    }

    private void makeDialog() {
        this.window = new Dialog();
        BlueJTheme.setWindowIconFX(this.window);
        this.window.setTitle(Config.getApplicationName() + ": " + Config.getString("prefmgr.title"));
        Config.addDialogStylesheets(this.window.getDialogPane());
        JavaFXUtil.addStyleClass((Styleable)this.window.getDialogPane(), "prefmgr-dialog-pane");
        this.tabbedPane = new TabPane();
        JavaFXUtil.addStyleClass((Styleable)this.tabbedPane, "prefmgr-tab-pane");
        ListIterator<Node> i = this.tabs.listIterator();
        while (i.hasNext()) {
            int index = i.nextIndex();
            Node p = i.next();
            Tab tab = new Tab(this.titles.get(index), p);
            tab.setClosable(false);
            this.tabbedPane.getTabs().add((Object)tab);
        }
        this.window.setResultConverter(bt -> {
            if (bt == ButtonType.OK) {
                for (PrefPanelListener ppl : this.listeners) {
                    ppl.commitEditing();
                }
                return null;
            }
            for (PrefPanelListener ppl : this.listeners) {
                ppl.revertEditing();
            }
            return null;
        });
        this.window.getDialogPane().getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        this.window.getDialogPane().setContent((Node)this.tabbedPane);
    }

    public static Node headedVBox(String titleID, List<Node> contents) {
        return PrefMgrDialog.headedVBoxTranslated(Config.getString(titleID), contents);
    }

    public static Node headedVBoxTranslated(String title, List<Node> contents) {
        VBox body = new VBox();
        body.getChildren().setAll(contents);
        JavaFXUtil.addStyleClass((Styleable)body, "prefmgr-titled-content");
        TitledPane titledPane = new TitledPane(title, (Node)body);
        return (Node)JavaFXUtil.withStyleClass(titledPane, "prefmgr-titled");
    }

    public static Node labelledItem(String labelID, Node item) {
        return PrefMgrDialog.labelledItem(new Label(Config.getString(labelID)), item);
    }

    public static Node labelledItem(Label label, Node item) {
        return (Node)JavaFXUtil.withStyleClass(new HBox(new Node[]{label, item}), "prefmgr-label-hbox");
    }

    public static Node wrappedLabel(String content) {
        return new TextFlow(new Node[]{(Node)JavaFXUtil.withStyleClass(new Text(content), "prefmgr-text-wrapped")});
    }
}

