/*
 * Decompiled with CFR 0.152.
 */
package bluej.prefmgr;

import bluej.Config;
import bluej.prefmgr.PrefMgr;
import bluej.prefmgr.PrefMgrDialog;
import bluej.prefmgr.PrefPanelListener;
import bluej.utility.javafx.JavaFXUtil;
import java.util.ArrayList;
import java.util.Arrays;
import javafx.collections.FXCollections;
import javafx.css.Styleable;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.layout.VBox;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public class InterfacePanel
extends VBox
implements PrefPanelListener {
    private ArrayList<String> allLangsInternal;
    private ComboBox langDropdown;
    private CheckBox accessibility;

    public InterfacePanel() {
        String langString;
        JavaFXUtil.addStyleClass((Styleable)this, "prefmgr-pref-panel");
        ArrayList<Node> langPanel = new ArrayList<Node>();
        this.allLangsInternal = new ArrayList();
        ArrayList<String> allLangsReadable = new ArrayList<String>();
        int i = 1;
        while ((langString = Config.getPropString("bluej.language" + i, null)) != null) {
            int colonIndex = langString.indexOf(58);
            if (colonIndex != -1) {
                int secondColon = langString.indexOf(58, colonIndex + 1);
                if (secondColon == -1) {
                    secondColon = langString.length();
                }
                this.allLangsInternal.add(langString.substring(0, colonIndex));
                allLangsReadable.add(langString.substring(colonIndex + 1, secondColon));
            }
            ++i;
        }
        if (this.allLangsInternal.isEmpty()) {
            this.allLangsInternal.add(Config.language);
            allLangsReadable.add(Config.language);
        }
        Object[] langs = new String[allLangsReadable.size()];
        allLangsReadable.toArray(langs);
        this.langDropdown = new ComboBox(FXCollections.observableArrayList((Object[])langs));
        langPanel.add(PrefMgrDialog.labelledItem("prefmgr.interface.language", (Node)this.langDropdown));
        Label t = new Label(Config.getString("prefmgr.interface.language.restart"));
        langPanel.add((Node)t);
        this.getChildren().add((Object)PrefMgrDialog.headedVBox("prefmgr.interface.language.title", langPanel));
        this.accessibility = new CheckBox(Config.getString("prefmgr.accessibility.support"));
        this.getChildren().add((Object)PrefMgrDialog.headedVBox("prefmgr.accessibility.title", Arrays.asList(this.accessibility)));
    }

    @Override
    public void beginEditing() {
        String currentLang = Config.getPropString("bluej.language", "english");
        int curLangIndex = this.allLangsInternal.indexOf(currentLang);
        if (curLangIndex == -1) {
            curLangIndex = 0;
        }
        this.langDropdown.getSelectionModel().select(curLangIndex);
        this.accessibility.setSelected(PrefMgr.getFlag("bluej.accessibility.support"));
    }

    @Override
    public void commitEditing() {
        Config.putPropString("bluej.language", this.allLangsInternal.get(this.langDropdown.getSelectionModel().getSelectedIndex()));
        PrefMgr.setFlag("bluej.accessibility.support", this.accessibility.isSelected());
    }

    @Override
    public void revertEditing() {
    }
}

