/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr;

import bluej.BlueJEvent;
import bluej.BlueJEventListener;
import bluej.BlueJTheme;
import bluej.Config;
import bluej.Main;
import bluej.classmgr.BPClassLoader;
import bluej.collect.DataCollector;
import bluej.compiler.CompileReason;
import bluej.compiler.CompileType;
import bluej.debugger.Debugger;
import bluej.debugger.DebuggerObject;
import bluej.debugger.ExceptionDescription;
import bluej.debugger.gentype.GenTypeClass;
import bluej.debugmgr.ExecutionEvent;
import bluej.debugmgr.ExpressionInformation;
import bluej.debugmgr.Invoker;
import bluej.debugmgr.LibraryCallDialog;
import bluej.debugmgr.ResultWatcher;
import bluej.debugmgr.codepad.CodePad;
import bluej.debugmgr.objectbench.ObjectBench;
import bluej.debugmgr.objectbench.ObjectWrapper;
import bluej.extensions.SourceType;
import bluej.extmgr.ExtensionsManager;
import bluej.extmgr.FXMenuManager;
import bluej.extmgr.ToolsExtensionMenu;
import bluej.extmgr.ViewExtensionMenu;
import bluej.groupwork.actions.CheckoutAction;
import bluej.groupwork.actions.CommitCommentAction;
import bluej.groupwork.actions.ImportAction;
import bluej.groupwork.actions.StatusAction;
import bluej.groupwork.actions.TeamActionGroup;
import bluej.groupwork.actions.UpdateDialogAction;
import bluej.groupwork.ui.ActivityIndicatorFX;
import bluej.pkgmgr.AboutBlueJ;
import bluej.pkgmgr.ExportManager;
import bluej.pkgmgr.Import;
import bluej.pkgmgr.ImportFailedDialog;
import bluej.pkgmgr.MachineIcon;
import bluej.pkgmgr.MouseTrackingOverlayPane;
import bluej.pkgmgr.NewClassDialog;
import bluej.pkgmgr.NewPackageDialog;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.PackageEditor;
import bluej.pkgmgr.PackageEditorEvent;
import bluej.pkgmgr.PackageEditorListener;
import bluej.pkgmgr.Project;
import bluej.pkgmgr.ProjectPrintDialog;
import bluej.pkgmgr.TestRunnerThread;
import bluej.pkgmgr.actions.AddClassAction;
import bluej.pkgmgr.actions.CancelTestRecordAction;
import bluej.pkgmgr.actions.CheckExtensionsAction;
import bluej.pkgmgr.actions.CheckVersionAction;
import bluej.pkgmgr.actions.CloseProjectAction;
import bluej.pkgmgr.actions.CompileAction;
import bluej.pkgmgr.actions.CompileSelectedAction;
import bluej.pkgmgr.actions.EndTestRecordAction;
import bluej.pkgmgr.actions.ExportProjectAction;
import bluej.pkgmgr.actions.GenerateDocsAction;
import bluej.pkgmgr.actions.HelpAboutAction;
import bluej.pkgmgr.actions.ImportProjectAction;
import bluej.pkgmgr.actions.NewClassAction;
import bluej.pkgmgr.actions.NewInheritsAction;
import bluej.pkgmgr.actions.NewPackageAction;
import bluej.pkgmgr.actions.NewProjectAction;
import bluej.pkgmgr.actions.OpenArchiveAction;
import bluej.pkgmgr.actions.OpenNonBlueJAction;
import bluej.pkgmgr.actions.OpenProjectAction;
import bluej.pkgmgr.actions.PageSetupAction;
import bluej.pkgmgr.actions.PkgMgrToggleAction;
import bluej.pkgmgr.actions.PreferencesAction;
import bluej.pkgmgr.actions.PrintAction;
import bluej.pkgmgr.actions.QuitAction;
import bluej.pkgmgr.actions.RebuildAction;
import bluej.pkgmgr.actions.RemoveAction;
import bluej.pkgmgr.actions.RestartVMAction;
import bluej.pkgmgr.actions.RunTestsAction;
import bluej.pkgmgr.actions.SaveProjectAction;
import bluej.pkgmgr.actions.SaveProjectAsAction;
import bluej.pkgmgr.actions.ShowCopyrightAction;
import bluej.pkgmgr.actions.ShowDebuggerAction;
import bluej.pkgmgr.actions.ShowTerminalAction;
import bluej.pkgmgr.actions.ShowTestResultsAction;
import bluej.pkgmgr.actions.StandardAPIHelpAction;
import bluej.pkgmgr.actions.TutorialAction;
import bluej.pkgmgr.actions.UseLibraryAction;
import bluej.pkgmgr.actions.WebsiteAction;
import bluej.pkgmgr.print.PackagePrintManager;
import bluej.pkgmgr.target.ClassTarget;
import bluej.pkgmgr.target.PackageTarget;
import bluej.pkgmgr.target.Target;
import bluej.pkgmgr.target.role.UnitTestClassRole;
import bluej.prefmgr.PrefMgr;
import bluej.prefmgr.PrefMgrDialog;
import bluej.testmgr.TestDisplayFrame;
import bluej.testmgr.record.InvokerRecord;
import bluej.utility.Debug;
import bluej.utility.DialogManager;
import bluej.utility.FileUtility;
import bluej.utility.JavaNames;
import bluej.utility.Utility;
import bluej.utility.javafx.FXConsumer;
import bluej.utility.javafx.FXPlatformRunnable;
import bluej.utility.javafx.FXPlatformSupplier;
import bluej.utility.javafx.JavaFXUtil;
import bluej.utility.javafx.TriangleArrow;
import bluej.utility.javafx.UntitledCollapsiblePane;
import bluej.views.CallableView;
import bluej.views.ConstructorView;
import bluej.views.MethodView;
import java.awt.Frame;
import java.awt.SecondaryLoop;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterJob;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javafx.animation.Animation;
import javafx.animation.FillTransition;
import javafx.application.Platform;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.css.Styleable;
import javafx.embed.swing.JFXPanel;
import javafx.embed.swing.SwingNode;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.Label;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.SplitPane;
import javafx.scene.control.TitledPane;
import javafx.scene.control.ToggleButton;
import javafx.scene.image.ImageView;
import javafx.scene.input.Dragboard;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Ellipse;
import javafx.scene.shape.Shape;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Duration;
import javax.swing.Action;
import javax.swing.ButtonModel;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import threadchecker.OnThread;
import threadchecker.Tag;

public class PkgMgrFrame
implements BlueJEventListener,
PackageEditorListener {
    private static @OnThread(value=Tag.Any) PkgMgrFrame recentFrame = null;
    private static final AtomicInteger nextTestIdentifier = new AtomicInteger(0);
    private static @OnThread(value=Tag.Any, requireSynchronized=true) PageFormat pageFormat = null;
    private static final @OnThread(value=Tag.Any, requireSynchronized=true) List<PkgMgrFrame> frames = new ArrayList<PkgMgrFrame>();
    private static final ExtensionsManager extMgr = ExtensionsManager.getInstance();
    private @OnThread(value=Tag.FXPlatform) TitledPane testPanel;
    private @OnThread(value=Tag.FXPlatform) TitledPane teamPanel;
    private @OnThread(value=Tag.FXPlatform) ButtonBase imgExtendsButton;
    private @OnThread(value=Tag.FX) ButtonBase runButton;
    private @OnThread(value=Tag.FX) Label statusbar;
    private @OnThread(value=Tag.Any) ActivityIndicatorFX progressbar;
    private @OnThread(value=Tag.FX) Label testStatusMessage;
    private @OnThread(value=Tag.FXPlatform) Label recordingLabel;
    private final @OnThread(value=Tag.Any) EndTestRecordAction endTestRecordAction = new EndTestRecordAction(this);
    private final @OnThread(value=Tag.Any) CancelTestRecordAction cancelTestRecordAction = new CancelTestRecordAction(this);
    private ClassTarget testTarget = null;
    private String testTargetMethod;
    private int testIdentifier = 0;
    private JMenu recentProjectsMenu;
    private JMenu testingMenu;
    private final @OnThread(value=Tag.FXPlatform) SimpleObjectProperty<FXMenuManager> toolsMenuManager;
    private final @OnThread(value=Tag.FXPlatform) SimpleObjectProperty<FXMenuManager> viewMenuManager;
    private JMenu teamMenu;
    private JMenuItem shareProjectMenuItem;
    private JMenuItem teamSettingsMenuItem;
    private JMenuItem showLogMenuItem;
    private JMenuItem updateMenuItem;
    private JMenuItem commitMenuItem;
    private JMenuItem statusMenuItem;
    private @OnThread(value=Tag.FX) ButtonBase updateButton;
    private @OnThread(value=Tag.FX) ButtonBase commitButton;
    private @OnThread(value=Tag.FX) ButtonBase teamStatusButton;
    private @OnThread(value=Tag.FX) ButtonBase teamShareButton;
    private TeamActionGroup teamActions;
    private final @OnThread(value=Tag.FX) List<Node> itemsToDisable = new ArrayList<Node>();
    private final @OnThread(value=Tag.FX) List<MenuItem> menuItemsToDisable = new ArrayList<MenuItem>();
    private final List<Action> actionsToDisable = new ArrayList<Action>();
    private @OnThread(value=Tag.Any) MachineIcon machineIcon;
    private final Action closeProjectAction = new CloseProjectAction(this);
    private final Action saveProjectAction = new SaveProjectAction(this);
    private final Action saveProjectAsAction = new SaveProjectAsAction(this);
    private final Action importProjectAction = new ImportProjectAction(this);
    private final Action exportProjectAction = new ExportProjectAction(this);
    private final Action pageSetupAction = new PageSetupAction(this);
    private final Action printAction = new PrintAction(this);
    private final @OnThread(value=Tag.Any) Action newClassAction = new NewClassAction(this);
    private final Action newPackageAction = new NewPackageAction(this);
    private final Action addClassAction = new AddClassAction(this);
    private final Action removeAction = new RemoveAction(this);
    private final @OnThread(value=Tag.Any) Action newInheritsAction = new NewInheritsAction(this);
    private final @OnThread(value=Tag.Any) Action compileAction = new CompileAction(this);
    private final Action compileSelectedAction = new CompileSelectedAction(this);
    private final Action rebuildAction = new RebuildAction(this);
    private final @OnThread(value=Tag.Any) RestartVMAction restartVMAction = new RestartVMAction(this);
    private final Action useLibraryAction = new UseLibraryAction(this);
    private final Action generateDocsAction = new GenerateDocsAction(this);
    private final PkgMgrToggleAction showDebuggerAction = new ShowDebuggerAction(this){

        @Override
        public void setEnabled(boolean newValue) {
            super.setEnabled(newValue);
        }
    };
    private final PkgMgrToggleAction showTerminalAction = new ShowTerminalAction(this);
    private final @OnThread(value=Tag.Any) Action runTestsAction = new RunTestsAction(this);
    private @OnThread(value=Tag.Any, requireSynchronized=true) Package pkg = null;
    private @OnThread(value=Tag.Any) PackageEditor editor = null;
    private @OnThread(value=Tag.Any) ObjectBench objbench;
    private @OnThread(value=Tag.FXPlatform) CodePad codePad;
    private @OnThread(value=Tag.FXPlatform) SimpleBooleanProperty showingTextEval;
    private @OnThread(value=Tag.FXPlatform) LibraryCallDialog libraryCallDialog = null;
    private ProjectPrintDialog projectPrintDialog = null;
    private ExportManager exporter;
    private @OnThread(value=Tag.FX) Property<Stage> stageProperty;
    private @OnThread(value=Tag.FX) Property<BorderPane> paneProperty;
    private @OnThread(value=Tag.FXPlatform) FXPlatformRunnable cancelWiggle;
    private @OnThread(value=Tag.FXPlatform) VBox toolPanel;
    private @OnThread(value=Tag.FXPlatform) EventHandler<MouseEvent> editorMousePressed;
    private @OnThread(value=Tag.FXPlatform) ScrollPane pkgEditorScrollPane;
    private @OnThread(value=Tag.Any) SimpleBooleanProperty showUsesProperty;
    private @OnThread(value=Tag.Any) SimpleBooleanProperty showInheritsProperty;
    private @OnThread(value=Tag.FX) SplitPane bottomPane;
    private @OnThread(value=Tag.FX) double bottomPaneLastDividerPos = 0.6;
    private @OnThread(value=Tag.FX) Pane bottomOverlay;
    private @OnThread(value=Tag.Any) SwingNode dummySwingNode;
    private @OnThread(value=Tag.FX) SplitPane topBottomSplit;
    private final @OnThread(value=Tag.Any) MouseTrackingOverlayPane topOverlay = new MouseTrackingOverlayPane();
    private @OnThread(value=Tag.FX) UntitledCollapsiblePane teamAndTestFoldout;
    private @OnThread(value=Tag.FX) BooleanExpression teamShowSharedButtons;

    private PkgMgrFrame() {
        this.stageProperty = new SimpleObjectProperty(null);
        this.paneProperty = new SimpleObjectProperty(null);
        this.showingTextEval = new SimpleBooleanProperty(false);
        this.showUsesProperty = new SimpleBooleanProperty(true);
        this.showInheritsProperty = new SimpleBooleanProperty(true);
        this.toolsMenuManager = new SimpleObjectProperty(null);
        this.viewMenuManager = new SimpleObjectProperty(null);
        if (!Config.isGreenfoot()) {
            this.teamActions = new TeamActionGroup(false);
            this.teamActions.setAllDisabled(this);
            this.setupActionDisableSet();
            this.makeFrame();
            this.setStatus("BlueJ 4.0.0preview2");
            new JFXPanel();
            Platform.runLater(() -> {
                Stage stage = new Stage();
                BlueJTheme.setWindowIconFX(stage);
                this.objbench = new ObjectBench(this);
                this.addCtrlTabShortcut(this.objbench);
                this.itemsToDisable.add((Node)this.objbench);
                BorderPane topPane = new BorderPane();
                this.pkgEditorScrollPane = new ScrollPane(null){

                    @OnThread(value=Tag.FX)
                    public void requestFocus() {
                    }
                };
                this.pkgEditorScrollPane.setVisible(false);
                this.pkgEditorScrollPane.visibleProperty().bind((ObservableValue)this.pkgEditorScrollPane.contentProperty().isNotNull());
                this.pkgEditorScrollPane.setFitToWidth(true);
                this.pkgEditorScrollPane.setFitToHeight(true);
                Label emptyProjectMessage = new Label(Config.getString("pkgmgr.noProjectOpened.message"));
                JavaFXUtil.addStyleClass((Styleable)emptyProjectMessage, "pmf-empty-project-msg");
                StackPane centralPane = new StackPane(new Node[]{emptyProjectMessage, this.pkgEditorScrollPane});
                JavaFXUtil.addStyleClass((Styleable)centralPane, "pmf-central-pane");
                topPane.setCenter((Node)centralPane);
                topPane.setLeft((Node)this.toolPanel);
                final TriangleArrow triangleLabel = new TriangleArrow(Orientation.HORIZONTAL);
                StackPane.setAlignment((Node)triangleLabel, (Pos)Pos.CENTER_RIGHT);
                StackPane.setMargin((Node)triangleLabel, (Insets)new Insets(0.0, 5.0, 0.0, 0.0));
                triangleLabel.setOnMouseClicked(e -> this.showingTextEval.set(!this.showingTextEval.get()));
                triangleLabel.scaleProperty().bind((ObservableValue)Bindings.when((ObservableBooleanValue)this.showingTextEval).then(-1.0).otherwise(1.0));
                FXPlatformRunnable addScrollBarListener = new FXPlatformRunnable(){

                    @Override
                    @OnThread(value=Tag.FXPlatform)
                    public void run() {
                        Region scrollBar = (Region)PkgMgrFrame.this.objbench.lookup(".scroll-bar:horizontal");
                        if (scrollBar == null) {
                            JavaFXUtil.runAfterCurrent(this);
                            return;
                        }
                        FXConsumer<Object> update = showing -> JavaFXUtil.runPlatformLater(() -> {
                            if (scrollBar.isVisible()) {
                                StackPane.setMargin((Node)triangleLabel, (Insets)new Insets(0.0, 5.0 + scrollBar.getWidth(), 0.0, 0.0));
                            } else {
                                StackPane.setMargin((Node)triangleLabel, (Insets)new Insets(0.0, 5.0, 0.0, 0.0));
                            }
                        });
                        JavaFXUtil.addChangeListener(scrollBar.visibleProperty(), update);
                        JavaFXUtil.addChangeListener(scrollBar.widthProperty(), update);
                    }
                };
                JavaFXUtil.runAfterCurrent(addScrollBarListener);
                this.bottomOverlay = new Pane();
                this.bottomOverlay.setMouseTransparent(true);
                this.bottomPane = new SplitPane(new Node[]{new StackPane(new Node[]{this.objbench, triangleLabel})});
                this.bottomPane.setOrientation(Orientation.HORIZONTAL);
                this.bottomPane.getDividers().addListener(c -> {
                    c.next();
                    if (c.wasAdded()) {
                        ((SplitPane.Divider)c.getAddedSubList().get(0)).setPosition(this.bottomPaneLastDividerPos);
                    } else if (c.wasRemoved()) {
                        this.bottomPaneLastDividerPos = ((SplitPane.Divider)c.getRemoved().get(0)).getPosition();
                    }
                });
                StackPane bottomPaneAndOverlay = new StackPane(new Node[]{this.bottomPane, this.bottomOverlay});
                SplitPane.setResizableWithParent((Node)bottomPaneAndOverlay, (Boolean)false);
                StackPane topPaneAndOverlay = new StackPane(new Node[]{topPane, this.topOverlay});
                SplitPane.setResizableWithParent((Node)topPaneAndOverlay, (Boolean)false);
                JavaFXUtil.runAfter(Duration.seconds((double)5.0), () -> SplitPane.setResizableWithParent((Node)topPaneAndOverlay, (Boolean)true));
                this.topBottomSplit = new SplitPane(new Node[]{topPaneAndOverlay, bottomPaneAndOverlay});
                JavaFXUtil.addStyleClass((Styleable)this.topBottomSplit, "top-bottom-split");
                this.topBottomSplit.setOrientation(Orientation.VERTICAL);
                this.topBottomSplit.setDividerPositions(new double[]{0.8});
                EventHandler<MouseEvent> handler = new EventHandler<MouseEvent>(){
                    private boolean isResizingBoth;
                    public ObjectProperty cursorProperty;

                    @OnThread(value=Tag.FXPlatform)
                    public void handle(MouseEvent e) {
                        if (this.cursorProperty == null) {
                            this.cursorProperty = PkgMgrFrame.this.topBottomSplit.lookup(".top-bottom-split > .split-pane-divider").cursorProperty();
                        }
                        if (PkgMgrFrame.this.codePad == null) {
                            this.cursorProperty.set((Object)Cursor.V_RESIZE);
                            this.isResizingBoth = false;
                            return;
                        }
                        if (e.getEventType() == MouseEvent.MOUSE_MOVED) {
                            double sceneX = ((Node)PkgMgrFrame.this.bottomPane.getItems().get(0)).localToScene(((Node)PkgMgrFrame.this.bottomPane.getItems().get(0)).getBoundsInLocal()).getMaxX();
                            if (e.getSceneX() >= sceneX - 1.0 && e.getSceneX() <= sceneX + 8.0) {
                                this.isResizingBoth = true;
                                this.cursorProperty.set((Object)Cursor.MOVE);
                            } else {
                                this.isResizingBoth = false;
                                this.cursorProperty.set((Object)Cursor.V_RESIZE);
                            }
                        } else if (e.getEventType() == MouseEvent.MOUSE_DRAGGED && this.isResizingBoth) {
                            Bounds bottomBounds = PkgMgrFrame.this.bottomPane.localToScene(PkgMgrFrame.this.bottomPane.getBoundsInLocal());
                            PkgMgrFrame.this.bottomPane.setDividerPositions(new double[]{(e.getSceneX() - bottomBounds.getMinX()) / bottomBounds.getWidth()});
                        }
                    }
                };
                this.topBottomSplit.addEventFilter(MouseEvent.MOUSE_MOVED, (EventHandler)handler);
                this.topBottomSplit.addEventFilter(MouseEvent.MOUSE_DRAGGED, (EventHandler)handler);
                BorderPane contentRoot = new BorderPane((Node)this.topBottomSplit);
                JavaFXUtil.addStyleClass((Styleable)contentRoot, "pmf-root");
                this.statusbar = new Label();
                BorderPane.setAlignment((Node)this.statusbar, (Pos)Pos.CENTER_LEFT);
                BorderPane statusArea = new BorderPane();
                BorderPane.setMargin((Node)statusArea, (Insets)new Insets(2.0, 0.0, 0.0, 0.0));
                statusArea.setCenter((Node)this.statusbar);
                this.testStatusMessage = new Label();
                JavaFXUtil.addStyleClass((Styleable)this.testStatusMessage, "test-status-message");
                this.testStatusMessage.managedProperty().bind((ObservableValue)this.testStatusMessage.textProperty().isNotEmpty());
                this.testStatusMessage.visibleProperty().bind((ObservableValue)this.testStatusMessage.textProperty().isNotEmpty());
                BorderPane.setAlignment((Node)this.testStatusMessage, (Pos)Pos.CENTER_LEFT);
                statusArea.setLeft((Node)this.testStatusMessage);
                this.progressbar = new ActivityIndicatorFX();
                this.progressbar.setRunning(false);
                statusArea.setRight((Node)new HBox(new Node[]{this.progressbar, this.machineIcon}));
                contentRoot.setBottom((Node)statusArea);
                BorderPane rootPlusMenu = new BorderPane((Node)contentRoot);
                Scene scene = new Scene((Parent)rootPlusMenu);
                Config.addPMFStylesheets(scene);
                stage.setScene(scene);
                stage.setWidth(800.0);
                stage.setHeight(600.0);
                this.stageProperty.setValue((Object)stage);
                this.paneProperty.setValue((Object)rootPlusMenu);
                JavaFXUtil.runAfterCurrent(() -> stage.show());
                if (this.showingTextEval.get()) {
                    this.showHideTextEval(true);
                }
                JavaFXUtil.addChangeListener(this.showingTextEval, this::showHideTextEval);
                this.updateWindow();
            });
            if (this.isEmptyFrame()) {
                this.enableFunctions(false);
            }
        } else {
            Platform.runLater(() -> {
                this.objbench = new ObjectBench(this);
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PkgMgrFrame createFrame() {
        PkgMgrFrame frame = new PkgMgrFrame();
        BlueJEvent.addListener(frame);
        Class<PkgMgrFrame> clazz = PkgMgrFrame.class;
        synchronized (PkgMgrFrame.class) {
            frames.add(frame);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            Platform.runLater(() -> JavaFXUtil.onceNotNull(frame.stageProperty, stage -> JavaFXUtil.addChangeListener(stage.focusedProperty(), focused -> {
                if (focused.booleanValue()) {
                    recentFrame = frame;
                }
            })));
            return frame;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @OnThread(value=Tag.Swing)
    public static PkgMgrFrame createFrame(Package aPkg, PkgMgrFrame parentWindow) {
        PkgMgrFrame pmf = PkgMgrFrame.findFrame(aPkg);
        if (pmf != null) return pmf;
        if (PkgMgrFrame.frameCount() == 1) {
            Class<PkgMgrFrame> clazz = PkgMgrFrame.class;
            // MONITORENTER : bluej.pkgmgr.PkgMgrFrame.class
            pmf = frames.get(0);
            // MONITOREXIT : clazz
        }
        if (pmf == null || !pmf.isEmptyFrame()) {
            pmf = PkgMgrFrame.createFrame();
        }
        pmf.openPackage(aPkg, parentWindow);
        return pmf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnThread(value=Tag.FXPlatform)
    public static void closeFrame(PkgMgrFrame frame) {
        if (!frame.isEmptyFrame()) {
            throw new IllegalArgumentException();
        }
        Class<PkgMgrFrame> clazz = PkgMgrFrame.class;
        synchronized (PkgMgrFrame.class) {
            frames.remove(frame);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            SwingUtilities.invokeLater(() -> BlueJEvent.removeListener(frame));
            PrefMgr.setFlag("bluej.startWithTextEval", frame.showingTextEval.get());
            Stage window = frame.getFXWindow();
            if (window != null) {
                window.hide();
            }
            return;
        }
    }

    @OnThread(value=Tag.Any)
    public static synchronized PkgMgrFrame findFrame(Package aPkg) {
        for (PkgMgrFrame pmf : frames) {
            if (pmf.isEmptyFrame() || pmf.getPackage() != aPkg) continue;
            return pmf;
        }
        return null;
    }

    @OnThread(value=Tag.Any)
    public static synchronized int frameCount() {
        return frames.size();
    }

    @OnThread(value=Tag.Any)
    public static synchronized PkgMgrFrame[] getAllFrames() {
        PkgMgrFrame[] openFrames = new PkgMgrFrame[frames.size()];
        frames.toArray(openFrames);
        return openFrames;
    }

    public static PkgMgrFrame[] getAllProjectFrames(Project proj) {
        return PkgMgrFrame.getAllProjectFrames(proj, "");
    }

    public static PkgMgrFrame[] getAllProjectFrames(Project proj, String pkgPrefix) {
        ArrayList<PkgMgrFrame> list = new ArrayList<PkgMgrFrame>();
        String pkgPrefixWithDot = pkgPrefix + ".";
        for (PkgMgrFrame pmf : PkgMgrFrame.getAllFrames()) {
            if (pmf.isEmptyFrame() || pmf.getProject() != proj) continue;
            String fullName = pmf.getPackage().getQualifiedName();
            if (fullName.startsWith(pkgPrefixWithDot)) {
                list.add(pmf);
                continue;
            }
            if (!fullName.equals(pkgPrefix) && pkgPrefix.length() != 0) continue;
            list.add(pmf);
        }
        if (list.isEmpty()) {
            return null;
        }
        return list.toArray(new PkgMgrFrame[list.size()]);
    }

    public static PkgMgrFrame getMostRecent() {
        if (recentFrame != null) {
            return recentFrame;
        }
        PkgMgrFrame[] allFrames = PkgMgrFrame.getAllFrames();
        if (allFrames.length < 1) {
            return null;
        }
        PkgMgrFrame mostRecent = allFrames[0];
        return mostRecent;
    }

    public static void handleAbout() {
        new HelpAboutAction(PkgMgrFrame.getMostRecent()).actionPerformed(PkgMgrFrame.getMostRecent());
    }

    public static void handlePreferences() {
        new PreferencesAction(PkgMgrFrame.getMostRecent()).actionPerformed(PkgMgrFrame.getMostRecent());
    }

    public static void handleQuit() {
        new QuitAction(PkgMgrFrame.getMostRecent()).actionPerformed(PkgMgrFrame.getMostRecent());
    }

    public static void displayMessage(String message) {
        for (PkgMgrFrame frame : PkgMgrFrame.getAllFrames()) {
            frame.setStatus(message);
        }
    }

    public static void displayMessage(Package sourcePkg, String message) {
        PkgMgrFrame pmf = PkgMgrFrame.findFrame(sourcePkg);
        if (pmf != null) {
            pmf.setStatus(message);
        }
    }

    public static void displayMessage(Project sourceProj, String message) {
        PkgMgrFrame[] pmf = PkgMgrFrame.getAllProjectFrames(sourceProj);
        if (pmf != null) {
            for (PkgMgrFrame pmf1 : pmf) {
                if (pmf1 == null) continue;
                pmf1.setStatus(message);
            }
        }
    }

    public static void showError(Package sourcePkg, String msgId) {
        PkgMgrFrame pmf = PkgMgrFrame.findFrame(sourcePkg);
        if (pmf != null) {
            Platform.runLater(() -> DialogManager.showErrorFX((Window)pmf.getFXWindow(), msgId));
        }
    }

    public static void showMessage(Package sourcePkg, String msgId) {
        PkgMgrFrame pmf = PkgMgrFrame.findFrame(sourcePkg);
        if (pmf != null) {
            Platform.runLater(() -> DialogManager.showMessageFX((Window)pmf.getFXWindow(), msgId));
        }
    }

    public static void showMessageWithText(Package sourcePkg, String msgId, String text) {
        PkgMgrFrame pmf = PkgMgrFrame.findFrame(sourcePkg);
        if (pmf != null) {
            Platform.runLater(() -> DialogManager.showMessageWithTextFX((Window)pmf.getFXWindow(), msgId, text));
        }
    }

    public static boolean doOpen(File projectPath, PkgMgrFrame pmf) {
        boolean createdNewFrame = false;
        if (pmf == null && frames.size() > 0) {
            pmf = frames.get(0);
        } else if (pmf == null) {
            pmf = PkgMgrFrame.createFrame();
            createdNewFrame = true;
        }
        boolean openedProject = false;
        if (projectPath != null) {
            if (projectPath.isDirectory() || Project.isProject(projectPath.toString())) {
                if (pmf.openProject(projectPath.getAbsolutePath())) {
                    openedProject = true;
                }
            } else if (pmf.openArchive(projectPath)) {
                openedProject = true;
            }
        }
        if (createdNewFrame && !openedProject) {
            PkgMgrFrame pmfFinal = pmf;
            Platform.runLater(() -> PkgMgrFrame.closeFrame(pmfFinal));
        }
        return openedProject;
    }

    public static void closeProject(Project project) {
        PkgMgrFrame[] allFrames = PkgMgrFrame.getAllProjectFrames(project);
        if (allFrames != null) {
            for (PkgMgrFrame allFrame : allFrames) {
                Platform.runLater(() -> allFrame.doClose(true, true));
            }
        }
    }

    @OnThread(value=Tag.Any)
    public static synchronized PageFormat getPageFormat() {
        if (pageFormat == null) {
            pageFormat = PrinterJob.getPrinterJob().defaultPage();
        }
        int orientation = Config.getPropInteger("bluej.printer.paper.orientation", pageFormat.getOrientation());
        pageFormat.setOrientation(orientation);
        Paper paper = pageFormat.getPaper();
        int x = Config.getPropInteger("bluej.printer.paper.x", 72);
        int y = Config.getPropInteger("bluej.printer.paper.y", 72);
        int width = Config.getPropInteger("bluej.printer.paper.width", (int)paper.getWidth() - 72 - x);
        int height = Config.getPropInteger("bluej.printer.paper.height", (int)paper.getHeight() - 72 - y);
        paper.setImageableArea(x, y, width, height);
        pageFormat.setPaper(paper);
        return pageFormat;
    }

    public static synchronized void setPageFormat(PageFormat page) {
        pageFormat = page;
        Paper paper = pageFormat.getPaper();
        double x = paper.getImageableX();
        double y = paper.getImageableY();
        double width = paper.getImageableWidth();
        double height = paper.getImageableHeight();
        Config.putPropInteger("bluej.printer.paper.x", (int)x);
        Config.putPropInteger("bluej.printer.paper.y", (int)y);
        Config.putPropInteger("bluej.printer.paper.width", (int)width);
        Config.putPropInteger("bluej.printer.paper.height", (int)height);
        int orientation = pageFormat.getOrientation();
        Config.putPropInteger("bluej.printer.paper.orientation", orientation);
    }

    @OnThread(value=Tag.Swing)
    public void openPackage(Package aPkg, PkgMgrFrame parentWindow) {
        if (aPkg == null) {
            throw new NullPointerException();
        }
        if (this.pkg != null) {
            this.closePackage();
        }
        this.pkg = aPkg;
        if (!Config.isGreenfoot()) {
            this.editor = new PackageEditor(this, aPkg, this, (BooleanProperty)this.showUsesProperty, (BooleanProperty)this.showInheritsProperty, this.topOverlay);
            Platform.runLater(() -> {
                this.pkgEditorScrollPane.setContent((Node)this.editor);
                this.editor.setOnDragOver(event -> {
                    Dragboard db = event.getDragboard();
                    if (db.hasFiles()) {
                        event.acceptTransferModes(new TransferMode[]{TransferMode.COPY});
                    } else {
                        event.consume();
                    }
                });
                this.editor.setOnDragDropped(event -> {
                    Dragboard db = event.getDragboard();
                    boolean success = false;
                    if (db.hasFiles()) {
                        success = true;
                        SwingUtilities.invokeLater(() -> this.addFiles(db.getFiles()));
                    }
                    event.setDropCompleted(success);
                    event.consume();
                });
                this.editorMousePressed = e -> this.clearStatus();
                this.editor.addEventFilter(MouseEvent.MOUSE_PRESSED, this.editorMousePressed);
                this.editor.startMouseListening();
                this.addCtrlTabShortcut(this.editor);
            });
            aPkg.setEditor(this.editor);
            Properties p = aPkg.getLastSavedProperties();
            try {
                String x_str = p.getProperty("package.editor.x", parentWindow == null ? "30" : "-1");
                String y_str = p.getProperty("package.editor.y", parentWindow == null ? "30" : "-1");
                int x = Integer.parseInt(x_str);
                int y = Integer.parseInt(y_str);
                if (x > Config.screenBounds.width - 80) {
                    x = Config.screenBounds.width - 80;
                }
                if (y > Config.screenBounds.height - 80) {
                    y = Config.screenBounds.height - 80;
                }
                int xFinal = x;
                int yFinal = y;
                String width = p.getProperty("package.frame.width");
                String height = p.getProperty("package.frame.height");
                String mainDivPos = p.getProperty("package.divider.vertical");
                String bottomDivPos = p.getProperty("package.divider.horizontal");
                Platform.runLater(() -> JavaFXUtil.onceNotNull(this.stageProperty, s -> {
                    if (xFinal == -1 || yFinal == -1) {
                        s.setX(((Stage)parentWindow.stageProperty.getValue()).getX() + 20.0);
                        s.setY(((Stage)parentWindow.stageProperty.getValue()).getY() + 20.0);
                    } else {
                        s.setX((double)xFinal);
                        s.setY((double)yFinal);
                    }
                    if (width != null && height != null) {
                        s.setWidth((double)Integer.parseInt(width));
                        s.setHeight((double)Integer.parseInt(height));
                    } else {
                        s.setWidth(800.0);
                        s.setHeight(600.0);
                    }
                    if (mainDivPos != null) {
                        this.topBottomSplit.setDividerPositions(new double[]{Double.parseDouble(mainDivPos)});
                    } else {
                        this.topBottomSplit.setDividerPositions(new double[]{0.8});
                    }
                    if (bottomDivPos != null) {
                        if (this.bottomPane.getDividers().size() == 1) {
                            this.bottomPane.setDividerPositions(new double[]{Double.parseDouble(bottomDivPos)});
                        } else {
                            this.bottomPaneLastDividerPos = Double.parseDouble(bottomDivPos);
                        }
                    }
                }));
            }
            catch (NumberFormatException e) {
                Debug.reportError("Could not read preferred project screen position");
            }
            String uses_str = p.getProperty("package.showUses", "true");
            String extends_str = p.getProperty("package.showExtends", "true");
            Platform.runLater(() -> {
                this.editor.setShowUses(uses_str.equals("true"));
                this.editor.setShowExtends(extends_str.equals("true"));
                this.editor.requestFocus();
                this.updateWindow();
            });
            this.enableFunctions(true);
            this.setVisible(true);
            Package pkgFinal = aPkg;
            Platform.runLater(() -> {
                JavaFXUtil.onceNotNull(this.viewMenuManager, vm -> JavaFXUtil.runPlatformLater(() -> SwingUtilities.invokeLater(() -> {
                    vm.setMenuGenerator(new ViewExtensionMenu(pkgFinal));
                    vm.addExtensionMenu(pkgFinal.getProject());
                })));
                JavaFXUtil.onceNotNull(this.toolsMenuManager, vm -> JavaFXUtil.runPlatformLater(() -> SwingUtilities.invokeLater(() -> {
                    vm.setMenuGenerator(new ToolsExtensionMenu(pkgFinal));
                    vm.addExtensionMenu(pkgFinal.getProject());
                })));
            });
            this.teamActions = aPkg.getProject().getTeamActions();
            this.resetTeamActions();
            if (aPkg.getProject().getTeamSettingsController() != null && aPkg.getProject().getTeamSettingsController().isDVCS()) {
                this.commitMenuItem.setText(Config.getString("team.menu.commitPush"));
            } else {
                this.commitMenuItem.setText(Config.getString("team.menu.commit"));
            }
            aPkg.getProject().scheduleCompilation(true, CompileReason.LOADED, Config.isGreenfoot() ? CompileType.INDIRECT_USER_COMPILE : CompileType.ERROR_CHECK_ONLY, aPkg);
        }
        DataCollector.packageOpened(aPkg);
        extMgr.packageOpened(aPkg);
    }

    private void resetTeamActions() {
        StatusAction statusAction = this.teamActions.getStatusAction(this);
        UpdateDialogAction updateAction = this.teamActions.getUpdateAction(this);
        CommitCommentAction commitCommentAction = this.teamActions.getCommitCommentAction(this);
        ImportAction shareAction = this.teamActions.getImportAction(this);
        Platform.runLater(() -> {
            PkgMgrFrame.setButtonAction(statusAction, this.teamStatusButton, false);
            PkgMgrFrame.setButtonAction(updateAction, this.updateButton, false);
            PkgMgrFrame.setButtonAction(commitCommentAction, this.commitButton, false);
            PkgMgrFrame.setButtonAction(shareAction, this.teamShareButton, false);
        });
        this.teamSettingsMenuItem.setAction(this.teamActions.getTeamSettingsAction(this));
        this.shareProjectMenuItem.setAction(this.teamActions.getImportAction(this));
        this.statusMenuItem.setAction(this.teamActions.getStatusAction(this));
        this.commitMenuItem.setAction(this.teamActions.getCommitCommentAction(this));
        this.commitMenuItem.setText(Config.getString("team.menu.commit"));
        this.updateMenuItem.setAction(this.teamActions.getUpdateAction(this));
        this.updateMenuItem.setText(Config.getString("team.menu.update"));
        this.showLogMenuItem.setAction(this.teamActions.getShowLogAction(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnThread(value=Tag.Swing)
    public void closePackage() {
        if (this.isEmptyFrame()) {
            return;
        }
        Package thePkg = this.getPackage();
        extMgr.packageClosing(thePkg);
        if (!Config.isGreenfoot()) {
            ((FXMenuManager)this.toolsMenuManager.get()).setMenuGenerator(new ToolsExtensionMenu(thePkg));
            ((FXMenuManager)this.viewMenuManager.get()).setMenuGenerator(new ViewExtensionMenu(thePkg));
            ObjectBench bench = this.getObjectBench();
            String uniqueId = this.getProject().getUniqueId();
            Platform.runLater(() -> {
                bench.removeAllObjects(uniqueId);
                this.clearTextEval();
                if (this.codePad != null) {
                    this.codePad.setDisable(true);
                }
            });
            PackageEditor oldEd = this.editor;
            Platform.runLater(() -> {
                oldEd.removeEventFilter(MouseEvent.MOUSE_PRESSED, this.editorMousePressed);
                oldEd.graphClosed();
                this.pkgEditorScrollPane.setContent(null);
            });
            this.enableFunctions(false);
        }
        this.getPackage().closeAllEditors();
        DataCollector.packageClosed(thePkg);
        Project proj = this.getProject();
        this.editor = null;
        PkgMgrFrame pkgMgrFrame = this;
        synchronized (pkgMgrFrame) {
            this.pkg = null;
        }
        if (PkgMgrFrame.getAllProjectFrames(proj) == null) {
            Project.cleanUp(proj);
        }
    }

    public void setVisible(boolean visible) {
        if (!visible) {
            Platform.runLater(() -> JavaFXUtil.onceNotNull(this.stageProperty, Window::hide));
        } else if (!Config.isGreenfoot()) {
            Platform.runLater(() -> JavaFXUtil.onceNotNull(this.stageProperty, s -> {
                s.show();
                s.toFront();
            }));
        }
    }

    @OnThread(value=Tag.Any)
    public synchronized Package getPackage() {
        return this.pkg;
    }

    @OnThread(value=Tag.Any)
    public synchronized Project getProject() {
        return this.pkg == null ? null : this.pkg.getProject();
    }

    @OnThread(value=Tag.Any)
    public synchronized boolean isEmptyFrame() {
        return this.pkg == null;
    }

    @OnThread(value=Tag.FXPlatform)
    private void updateWindowTitle() {
        if (this.isEmptyFrame()) {
            this.setTitle("BlueJ");
        } else {
            String title = Config.getString("pkgmgr.title") + this.getProject().getProjectName();
            if (!this.getPackage().isUnnamedPackage()) {
                title = title + "  [" + this.getPackage().getQualifiedName() + "]";
            }
            if (this.getProject().isTeamProject()) {
                title = title + " (" + Config.getString("team.project.marker") + ")";
            }
            this.setTitle(title);
        }
    }

    @OnThread(value=Tag.FXPlatform)
    private void setTitle(String title) {
        JavaFXUtil.onceNotNull(this.stageProperty, stage -> stage.setTitle(title));
    }

    @OnThread(value=Tag.FXPlatform)
    private void updateWindow() {
        if (this.isEmptyFrame()) {
            // empty if block
        }
        this.updateWindowTitle();
    }

    @OnThread(value=Tag.Any)
    public final void setStatus(String status) {
        JavaFXUtil.runNowOrLater(() -> {
            if (this.statusbar != null) {
                this.statusbar.setText(status);
            }
        });
    }

    @OnThread(value=Tag.Any)
    public void startProgress() {
        JavaFXUtil.runNowOrLater(() -> this.progressbar.setRunning(true));
    }

    @OnThread(value=Tag.Any)
    public void stopProgress() {
        JavaFXUtil.runNowOrLater(() -> this.progressbar.setRunning(false));
    }

    @OnThread(value=Tag.Any)
    public void clearStatus() {
        JavaFXUtil.runNowOrLater(() -> {
            if (this.statusbar != null) {
                this.statusbar.setText(" ");
            }
        });
    }

    public void setWaitCursor(boolean wait) {
        Platform.runLater(() -> ((Stage)this.stageProperty.getValue()).getScene().setCursor((Cursor)(wait ? Cursor.WAIT : null)));
    }

    public ObjectBench getObjectBench() {
        return this.objbench;
    }

    @OnThread(value=Tag.FXPlatform)
    public CodePad getCodePad() {
        return this.codePad;
    }

    @Override
    public void targetEvent(PackageEditorEvent e) {
        int evtId = e.getID();
        switch (evtId) {
            case 1: {
                this.callMethod(e.getCallable());
                break;
            }
            case 2: {
                ((Target)e.getSource()).remove();
                break;
            }
            case 3: {
                this.openPackageTarget(e.getName());
                break;
            }
            case 4: {
                ClassTarget ct = (ClassTarget)e.getSource();
                ct.getRole().run(this, ct, e.getName());
                break;
            }
            case 5: {
                this.objectBenchToTestFixture((ClassTarget)e.getSource());
                break;
            }
            case 6: {
                this.testFixtureToObjectBench((ClassTarget)e.getSource());
                break;
            }
            case 7: {
                this.makeTestCase((ClassTarget)e.getSource());
                break;
            }
            case 8: {
                DebuggerObject gotObj = e.getDebuggerObject();
                String name = this.getProject().getDebugger().guessNewName(gotObj);
                Platform.runLater(() -> {
                    boolean tryAgain = true;
                    do {
                        String newObjectName;
                        String string = newObjectName = e.askForName() ? DialogManager.askStringFX((Window)e.getSource(), "getobject-new-name", name) : name;
                        if (newObjectName == null) {
                            tryAgain = false;
                            continue;
                        }
                        if (JavaNames.isIdentifier(newObjectName)) {
                            SwingUtilities.invokeLater(() -> {
                                DataCollector.benchGet(this.getPackage(), newObjectName, e.getDebuggerObject().getClassName(), this.getTestIdentifier());
                                this.putObjectOnBench(newObjectName, e.getDebuggerObject(), e.getIType(), e.getInvokerRecord(), e.getAnimateFromScenePoint());
                            });
                            tryAgain = false;
                            continue;
                        }
                        DialogManager.showErrorFX((Window)e.getSource(), "must-be-identifier");
                    } while (tryAgain);
                });
            }
        }
    }

    @Override
    public void recordInteraction(InvokerRecord ir) {
        this.getObjectBench().addInteraction(ir);
    }

    public int getTestIdentifier() {
        return this.testIdentifier;
    }

    @OnThread(value=Tag.Swing)
    public boolean newProject(String dirName) {
        if (Project.createNewProject(dirName)) {
            Project proj = Project.openProject(dirName);
            Package unNamedPkg = proj.getPackage("");
            if (this.isEmptyFrame()) {
                this.openPackage(unNamedPkg, this);
            } else {
                PkgMgrFrame pmf = PkgMgrFrame.createFrame(unNamedPkg, this);
                pmf.setVisible(true);
            }
            return true;
        }
        return false;
    }

    public Frame getWindow() {
        java.awt.Window windowAncestor = SwingUtilities.getWindowAncestor(this.dummySwingNode.getContent());
        return (Frame)windowAncestor;
    }

    public File[] importProjectDir(File dir, boolean showFailureDialog) {
        File[] fails = FileUtility.recursiveCopyFile(dir, this.getPackage().getPath());
        if (fails != null && showFailureDialog) {
            SecondaryLoop loop = Toolkit.getDefaultToolkit().getSystemEventQueue().createSecondaryLoop();
            File[] failsFinal = fails;
            Platform.runLater(() -> {
                ImportFailedDialog importFailedDlg = new ImportFailedDialog((Window)this.getFXWindow(), Arrays.asList(failsFinal));
                importFailedDlg.showAndWait();
                loop.exit();
            });
            loop.enter();
        }
        List<File> dirsToConvert = Import.findInterestingDirectories(this.getPackage().getPath());
        Import.convertDirectory(dirsToConvert);
        this.getProject().reloadAll();
        return fails;
    }

    public boolean createNewClass(String name, String template, SourceType sourceType, boolean showErr, double x, double y) {
        boolean success;
        Package thePkg = this.getPackage();
        if (thePkg.getTarget(name) != null) {
            Platform.runLater(() -> DialogManager.showErrorFX((Window)this.getFXWindow(), "duplicate-name"));
            return false;
        }
        String[] conflict = new String[1];
        Class<?> c = thePkg.loadClass(thePkg.getQualifiedName(name));
        if (c != null && !Package.checkClassMatchesFile(c, new File(this.getPackage().getPath(), name + ".class"))) {
            conflict[0] = Package.getResourcePath(c);
            AtomicBoolean shouldContinue = new AtomicBoolean();
            SecondaryLoop loop = Toolkit.getDefaultToolkit().getSystemEventQueue().createSecondaryLoop();
            Platform.runLater(() -> {
                boolean cont = DialogManager.askQuestionFX((Window)this.getFXWindow(), "class-library-conflict", conflict) != 0;
                shouldContinue.set(cont);
                loop.exit();
            });
            loop.enter();
            if (!shouldContinue.get()) {
                return false;
            }
        }
        ClassTarget target = new ClassTarget(thePkg, name, template);
        if (template != null && !(success = target.generateSkeleton(template, sourceType))) {
            return false;
        }
        thePkg.addTarget(target);
        Platform.runLater(() -> {
            if (this.editor != null) {
                if (x == -1.0) {
                    this.editor.findSpaceForVertex(target);
                } else {
                    target.setPos((int)x, (int)y);
                }
                JavaFXUtil.scrollTo(this.pkgEditorScrollPane, target.getNode());
            }
        });
        if (target.getRole() instanceof UnitTestClassRole) {
            thePkg.compileQuiet(target, CompileReason.NEW_CLASS, CompileType.INDIRECT_USER_COMPILE);
        }
        thePkg.getProject().scheduleCompilation(false, CompileReason.NEW_CLASS, CompileType.INDIRECT_USER_COMPILE, target);
        DataCollector.addClass(thePkg, target);
        return true;
    }

    public void doNewProject() {
        String title = Config.getString("pkgmgr.newPkg.title");
        Platform.runLater(() -> {
            File newnameFile = FileUtility.getSaveProjectFX((Window)this.getFXWindow(), title);
            if (newnameFile == null) {
                return;
            }
            SwingUtilities.invokeLater(() -> {
                if (!this.newProject(newnameFile.getAbsolutePath())) {
                    Platform.runLater(() -> DialogManager.showErrorWithTextFX(null, "cannot-create-directory", newnameFile.getPath()));
                }
            });
        });
    }

    public void doOpen() {
        Platform.runLater(() -> {
            File choice = FileUtility.getOpenProjectFX((Window)this.getFXWindow());
            if (choice != null) {
                SwingUtilities.invokeLater(() -> PkgMgrFrame.doOpen(choice, this));
            }
        });
    }

    public void doOpenNonBlueJ() {
        Platform.runLater(() -> {
            File choice = FileUtility.getOpenDirFX((Window)this.getFXWindow(), Config.getString("pkgmgr.openNonBlueJPkg.title"), true);
            if (choice != null) {
                SwingUtilities.invokeLater(() -> PkgMgrFrame.doOpenNonBlueJ(choice, this));
            }
        });
    }

    public void doOpenArchive() {
        Platform.runLater(() -> {
            File archiveFile = FileUtility.getOpenArchiveFX((Window)this.getFXWindow(), null, true);
            SwingUtilities.invokeLater(() -> PkgMgrFrame.doOpen(archiveFile, this));
        });
    }

    private boolean openProject(String projectPath) {
        Project openProj = Project.openProject(projectPath);
        if (openProj == null) {
            return false;
        }
        Package initialPkg = openProj.getPackage(openProj.getInitialPackageName());
        PkgMgrFrame pmf = PkgMgrFrame.findFrame(initialPkg);
        if (pmf == null) {
            if (this.isEmptyFrame()) {
                pmf = this;
                this.openPackage(initialPkg, this);
            } else {
                pmf = PkgMgrFrame.createFrame(initialPkg, this);
            }
        }
        pmf.setVisible(true);
        return true;
    }

    public static void doOpenNonBlueJ(File dirName, PkgMgrFrame pmf) {
        File absDirName = dirName.getAbsoluteFile();
        if (!absDirName.exists()) {
            Platform.runLater(() -> DialogManager.showErrorFX((Window)pmf.getFXWindow(), "file-does-not-exist"));
            return;
        }
        if (absDirName.isDirectory()) {
            if (Project.isProject(absDirName.getPath())) {
                Platform.runLater(() -> DialogManager.showErrorFX((Window)pmf.getFXWindow(), "open-non-bluej-already-bluej"));
                return;
            }
            if (!Import.convertNonBlueJ(pmf::getFXWindow, absDirName)) {
                return;
            }
            pmf.openProject(absDirName.getPath());
        }
    }

    private boolean openArchive(File archive) {
        File oPath = Utility.maybeExtractArchive(archive, this::getFXWindow);
        if (oPath == null) {
            return false;
        }
        if (Project.isProject(oPath.getPath())) {
            return this.openProject(oPath.getPath());
        }
        if (Import.convertNonBlueJ(this::getFXWindow, oPath)) {
            return this.openProject(oPath.getPath());
        }
        return false;
    }

    @OnThread(value=Tag.FXPlatform)
    public void doClose(boolean keepLastFrame, boolean doSave) {
        if (doSave) {
            this.doSave();
        }
        if (PkgMgrFrame.frameCount() == 1) {
            if (keepLastFrame && !Config.isGreenfoot()) {
                SwingUtilities.invokeLater(() -> {
                    this.closePackage();
                    this.testRecordingEnded();
                    this.updateRecentProjects();
                });
                this.updateWindow();
                FXMenuManager vm = (FXMenuManager)this.viewMenuManager.get();
                FXMenuManager tm = (FXMenuManager)this.toolsMenuManager.get();
                SwingUtilities.invokeLater(() -> {
                    tm.addExtensionMenu(null);
                    vm.addExtensionMenu(null);
                });
            } else {
                Main.doQuit();
            }
        } else {
            SwingUtilities.invokeLater(() -> {
                this.closePackage();
                Platform.runLater(() -> PkgMgrFrame.closeFrame(this));
            });
        }
    }

    @OnThread(value=Tag.FXPlatform)
    public synchronized void doSave() {
        Properties p;
        if (this.isEmptyFrame()) {
            return;
        }
        if (this.pkg.isUnnamedPackage()) {
            p = this.getProject().getProjectProperties();
            this.getProject().saveEditorLocations(p);
            this.getProject().getImportScanner().saveCachedImports();
        } else {
            p = new Properties();
        }
        if (!Config.isGreenfoot()) {
            p.put("package.editor.width", Integer.toString((int)this.pkgEditorScrollPane.getViewportBounds().getWidth()));
            p.put("package.editor.height", Integer.toString((int)this.pkgEditorScrollPane.getViewportBounds().getHeight()));
            p.put("objectbench.width", Integer.toString((int)this.objbench.getViewportBounds().getWidth()));
            p.put("objectbench.height", Integer.toString((int)this.objbench.getViewportBounds().getHeight()));
            p.put("package.editor.x", Integer.toString((int)((Stage)this.stageProperty.getValue()).getX()));
            p.put("package.editor.y", Integer.toString((int)((Stage)this.stageProperty.getValue()).getY()));
            p.put("package.frame.width", Integer.toString((int)((Stage)this.stageProperty.getValue()).getWidth()));
            p.put("package.frame.height", Integer.toString((int)((Stage)this.stageProperty.getValue()).getHeight()));
            p.put("package.divider.vertical", Double.toString(this.topBottomSplit.getDividerPositions()[0]));
            if (this.bottomPane.getDividers().size() == 1) {
                p.put("package.divider.horizontal", Double.toString(this.bottomPane.getDividerPositions()[0]));
            } else {
                p.put("package.divider.horizontal", Double.toString(this.bottomPaneLastDividerPos));
            }
            p.put("package.showUses", Boolean.toString(this.showUsesProperty.get()));
            p.put("package.showExtends", Boolean.toString(this.showInheritsProperty.get()));
        }
        this.pkg.save(p);
    }

    public void doImport() {
        Platform.runLater(() -> {
            File importDir = FileUtility.getOpenDirFX((Window)this.getFXWindow(), Config.getString("pkgmgr.importPkg.title"), false);
            if (importDir == null) {
                return;
            }
            if (!importDir.isDirectory()) {
                return;
            }
            SwingUtilities.invokeLater(() -> {
                if (this.isEmptyFrame()) {
                    return;
                }
                this.importProjectDir(importDir, true);
            });
        });
    }

    public void doAddFromFile() {
        Platform.runLater(() -> {
            List<File> classes = FileUtility.getMultipleFilesFX((Window)this.getFXWindow(), Config.getString("pkgmgr.addClass.title"), FileUtility.getJavaStrideSourceFilterFX());
            if (classes == null || classes.isEmpty()) {
                return;
            }
            SwingUtilities.invokeLater(() -> this.importFromFile(classes));
        });
    }

    public void addFiles(List<File> classes) {
        this.importFromFile(classes);
    }

    private void importFromFile(List<File> classes) {
        HashMap<Integer, String> errorNames = new HashMap<Integer, String>();
        errorNames.put(1, "file-does-not-exist");
        errorNames.put(2, "cannot-import");
        errorNames.put(4, "duplicate-name");
        errorNames.put(3, "error-in-import");
        for (File cls : classes) {
            int result = this.getPackage().importFile(cls);
            if (!errorNames.containsKey(result)) continue;
            Platform.runLater(() -> DialogManager.showErrorWithTextFX((Window)this.getFXWindow(), (String)errorNames.get(result), cls.getName()));
        }
    }

    public void doExport() {
        if (this.exporter == null) {
            this.exporter = new ExportManager(this);
        }
        this.exporter.export();
    }

    public void doPageSetup() {
        PrinterJob job = PrinterJob.getPrinterJob();
        PageFormat pfmt = job.pageDialog(PkgMgrFrame.getPageFormat());
        PkgMgrFrame.setPageFormat(pfmt);
    }

    public void doPrint() {
        if (this.projectPrintDialog == null) {
            this.projectPrintDialog = new ProjectPrintDialog(this);
        }
        if (this.projectPrintDialog.display()) {
            PackagePrintManager printManager = new PackagePrintManager(this.getPackage(), PkgMgrFrame.getPageFormat(), this.projectPrintDialog);
            printManager.start();
        }
    }

    public void showPreferences() {
        Platform.runLater(() -> PrefMgrDialog.showDialog());
    }

    public void aboutBlueJ() {
        Platform.runLater(() -> {
            AboutBlueJ about = new AboutBlueJ((Window)this.stageProperty.getValue(), "4.0.0preview2");
            about.showAndWait();
        });
    }

    public void showCopyright() {
        Platform.runLater(() -> DialogManager.showTextFX((Window)this.getFXWindow(), Arrays.asList(Config.getString("menu.help.copyright.line0"), " ", Config.getString("menu.help.copyright.line1"), Config.getString("menu.help.copyright.line2"), Config.getString("menu.help.copyright.line3"), Config.getString("menu.help.copyright.line4")).stream().collect(Collectors.joining("\n"))));
    }

    private void callMethod(final CallableView cv) {
        ResultWatcher watcher = null;
        if (cv instanceof ConstructorView) {
            watcher = new ResultWatcher(){

                @Override
                public void beginCompile() {
                    PkgMgrFrame.this.setWaitCursor(true);
                    PkgMgrFrame.this.setStatus(Config.getString("pkgmgr.creating"));
                }

                @Override
                public void beginExecution(InvokerRecord ir) {
                    BlueJEvent.raiseEvent(3, ir);
                    PkgMgrFrame.this.setWaitCursor(false);
                }

                @Override
                public void putResult(DebuggerObject result, String name, InvokerRecord ir) {
                    ExecutionEvent executionEvent = new ExecutionEvent(PkgMgrFrame.this.pkg, cv.getClassName(), null);
                    executionEvent.setParameters(cv.getParamTypes(false), ir.getArgumentValues());
                    executionEvent.setResult("Normal exit");
                    executionEvent.setResultObject(result);
                    BlueJEvent.raiseEvent(5, executionEvent);
                    Project proj = PkgMgrFrame.this.getPackage().getProject();
                    Platform.runLater(() -> proj.updateInspectors());
                    PkgMgrFrame.this.setStatus(Config.getString("pkgmgr.createDone"));
                    if (name == null || name.length() == 0) {
                        name = "result";
                    }
                    if (result != null) {
                        ObjectWrapper wrapper = ObjectWrapper.getWrapper(PkgMgrFrame.this, PkgMgrFrame.this.getObjectBench(), result, result.getGenType(), name);
                        PkgMgrFrame.this.getObjectBench().addObject(wrapper);
                        PkgMgrFrame.this.getPackage().getDebugger().addObject(PkgMgrFrame.this.pkg.getId(), wrapper.getName(), result);
                        PkgMgrFrame.this.getObjectBench().addInteraction(ir);
                    }
                }

                @Override
                public void putError(String msg, InvokerRecord ir) {
                    PkgMgrFrame.this.setStatus("");
                    PkgMgrFrame.this.setWaitCursor(false);
                }

                @Override
                public void putException(ExceptionDescription exception, InvokerRecord ir) {
                    ExecutionEvent executionEvent = new ExecutionEvent(PkgMgrFrame.this.pkg, cv.getClassName(), null);
                    executionEvent.setParameters(cv.getParamTypes(false), ir.getArgumentValues());
                    executionEvent.setResult("An exception occurred");
                    executionEvent.setException(exception);
                    BlueJEvent.raiseEvent(5, executionEvent);
                    PkgMgrFrame.this.setStatus("");
                    PkgMgrFrame.this.getPackage().exceptionMessage(exception);
                    Project proj = PkgMgrFrame.this.getPackage().getProject();
                    Platform.runLater(() -> proj.updateInspectors());
                }

                @Override
                public void putVMTerminated(InvokerRecord ir) {
                    ExecutionEvent executionEvent = new ExecutionEvent(PkgMgrFrame.this.pkg, cv.getClassName(), null);
                    executionEvent.setParameters(cv.getParamTypes(false), ir.getArgumentValues());
                    executionEvent.setResult("User terminated");
                    BlueJEvent.raiseEvent(5, executionEvent);
                    PkgMgrFrame.this.setStatus("");
                }
            };
        } else if (cv instanceof MethodView) {
            final MethodView mv = (MethodView)cv;
            watcher = new ResultWatcher(){
                private final ExpressionInformation expressionInformation;
                {
                    this.expressionInformation = new ExpressionInformation(mv, mv.getName());
                }

                @Override
                public void beginCompile() {
                    PkgMgrFrame.this.setWaitCursor(true);
                    if (mv.isMain()) {
                        PkgMgrFrame.this.getProject().removeClassLoader();
                        PkgMgrFrame.this.getProject().newRemoteClassLoaderLeavingBreakpoints();
                    }
                }

                @Override
                public void beginExecution(InvokerRecord ir) {
                    BlueJEvent.raiseEvent(3, ir);
                    PkgMgrFrame.this.setWaitCursor(false);
                }

                @Override
                public void putResult(DebuggerObject result, String name, InvokerRecord ir) {
                    ExecutionEvent executionEvent = new ExecutionEvent(PkgMgrFrame.this.pkg, cv.getClassName(), null);
                    executionEvent.setMethodName(mv.getName());
                    executionEvent.setParameters(cv.getParamTypes(false), ir.getArgumentValues());
                    executionEvent.setResult("Normal exit");
                    executionEvent.setResultObject(result);
                    BlueJEvent.raiseEvent(5, executionEvent);
                    Project proj = PkgMgrFrame.this.getPackage().getProject();
                    Platform.runLater(() -> proj.updateInspectors());
                    this.expressionInformation.setArgumentValues(ir.getArgumentValues());
                    PkgMgrFrame.this.getObjectBench().addInteraction(ir);
                    if (name == null) {
                        return;
                    }
                    if (result == null) {
                        return;
                    }
                    Project project = PkgMgrFrame.this.getProject();
                    Package pkg = PkgMgrFrame.this.getPackage();
                    Platform.runLater(() -> project.getResultInspectorInstance(result, name, pkg, ir, this.expressionInformation, (Window)PkgMgrFrame.this.getFXWindow()));
                }

                @Override
                public void putError(String msg, InvokerRecord ir) {
                    PkgMgrFrame.this.setWaitCursor(false);
                }

                @Override
                public void putException(ExceptionDescription exception, InvokerRecord ir) {
                    ExecutionEvent executionEvent = new ExecutionEvent(PkgMgrFrame.this.pkg, cv.getClassName(), null);
                    executionEvent.setParameters(cv.getParamTypes(false), ir.getArgumentValues());
                    executionEvent.setResult("An exception occurred");
                    executionEvent.setException(exception);
                    BlueJEvent.raiseEvent(5, executionEvent);
                    Project proj = PkgMgrFrame.this.getPackage().getProject();
                    Platform.runLater(() -> proj.updateInspectors());
                    PkgMgrFrame.this.getPackage().exceptionMessage(exception);
                }

                @Override
                public void putVMTerminated(InvokerRecord ir) {
                    ExecutionEvent executionEvent = new ExecutionEvent(PkgMgrFrame.this.pkg, cv.getClassName(), null);
                    executionEvent.setParameters(cv.getParamTypes(false), ir.getArgumentValues());
                    executionEvent.setResult("User terminated");
                    BlueJEvent.raiseEvent(5, executionEvent);
                }
            };
        }
        if (this.checkDebuggerState()) {
            new Invoker(this, cv, watcher).invokeInteractive();
        }
    }

    private void openPackageTarget(String newname) {
        Package p = this.getPackage().getProject().getPackage(newname);
        PkgMgrFrame pmf = PkgMgrFrame.findFrame(p);
        if (pmf == null) {
            pmf = PkgMgrFrame.createFrame(p, this);
        }
        pmf.setVisible(true);
    }

    private void objectBenchToTestFixture(ClassTarget target) {
        if (target.getRole() instanceof UnitTestClassRole) {
            UnitTestClassRole utcr = (UnitTestClassRole)target.getRole();
            utcr.doBenchToFixture(this, target);
        }
    }

    private void testFixtureToObjectBench(ClassTarget target) {
        if (target.getRole() instanceof UnitTestClassRole) {
            UnitTestClassRole utcr = (UnitTestClassRole)target.getRole();
            utcr.doFixtureToBench(this, target);
        }
    }

    private void makeTestCase(ClassTarget target) {
        if (target.getRole() instanceof UnitTestClassRole) {
            UnitTestClassRole utcr = (UnitTestClassRole)target.getRole();
            Platform.runLater(() -> {
                this.teamAndTestFoldout.expandedProperty().set(true);
                utcr.doMakeTestCase(this, target);
            });
        }
    }

    public String putObjectOnBench(String newInstanceName, DebuggerObject object, GenTypeClass iType, InvokerRecord ir, Optional<Point2D> animateFromScenePoint) {
        if (!object.isNullObject()) {
            ObjectWrapper wrapper = ObjectWrapper.getWrapper(this, this.getObjectBench(), object, iType, newInstanceName);
            this.getObjectBench().addObject(wrapper, animateFromScenePoint);
            newInstanceName = wrapper.getName();
            this.getPackage().getDebugger().addObject(this.getPackage().getId(), newInstanceName, object);
            if (ir != null) {
                ir.setBenchName(newInstanceName, wrapper.getTypeName());
            }
            return newInstanceName;
        }
        return null;
    }

    public void doCreateNewClass(double x, double y) {
        SourceType sourceType = this.pkg.getDefaultSourceType();
        Platform.runLater(() -> {
            NewClassDialog dlg = new NewClassDialog((Window)this.getFXWindow(), sourceType);
            Optional result = dlg.showAndWait();
            result.ifPresent(info -> SwingUtilities.invokeLater(() -> this.createNewClass(info.className, info.templateName, info.sourceType, true, x, y)));
        });
    }

    public void doCreateNewPackage(double x, double y) {
        Platform.runLater(() -> {
            NewPackageDialog dlg = new NewPackageDialog((Window)this.stageProperty.getValue());
            Optional pkgName = dlg.showAndWait();
            pkgName.ifPresent(name -> SwingUtilities.invokeLater(() -> this.createNewPackage((String)name, true, x, y)));
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createNewPackage(String name, boolean showErrDialog, double x, double y) {
        String fullName = name.indexOf(46) > -1 ? name : this.getPackage().getQualifiedName(name);
        String prefix = JavaNames.getPrefix(fullName);
        String base = JavaNames.getBase(fullName);
        Package basePkg = this.getProject().getPackage(prefix);
        if (basePkg != null && basePkg.getTarget(base) != null) {
            if (showErrDialog) {
                Platform.runLater(() -> DialogManager.showErrorFX((Window)this.getFXWindow(), "duplicate-name"));
            }
            return false;
        }
        this.getProject().createPackageDirectory(fullName);
        Package newPackage = this.getProject().getPackage(fullName);
        if (newPackage == null) {
            Debug.reportError("creation of new package failed unexpectedly");
            return false;
        }
        for (newPackage = newPackage.getParent(); newPackage != null; newPackage = newPackage.getParent()) {
            newPackage.reload();
        }
        PkgMgrFrame pkgMgrFrame = this;
        synchronized (pkgMgrFrame) {
            for (Target t : this.pkg.getVertices()) {
                PackageTarget pt;
                if (!(t instanceof PackageTarget) || !(pt = (PackageTarget)t).getQualifiedName().equals(fullName) || x == -1.0) continue;
                Platform.runLater(() -> pt.setPos((int)x, (int)y));
            }
        }
        return true;
    }

    public void doRemove() {
        Package pkgFinal = this.getPackage();
        String pkgId = pkgFinal.getId();
        Platform.runLater(() -> {
            if (this.editor.targetHasFocus()) {
                if (!this.doRemoveTargets(pkgFinal) && !this.editor.doRemoveDependency()) {
                    DialogManager.showErrorFX((Window)this.getFXWindow(), "no-class-selected");
                }
            } else if (this.objbench.objectHasFocus()) {
                this.objbench.removeSelectedObject(pkgId);
            }
        });
    }

    @OnThread(value=Tag.FXPlatform)
    private boolean doRemoveTargets(Package thePkg) {
        List<Target> targets = thePkg.getSelectedTargets();
        if (targets.size() <= 0) {
            return false;
        }
        if (this.askRemoveClass()) {
            SwingUtilities.invokeLater(() -> {
                for (Target target : targets) {
                    target.remove();
                }
            });
        }
        return true;
    }

    public void doTest() {
        Platform.runLater(() -> this.runButton.setDisable(true));
        List<ClassTarget> l = this.getPackage().getTestTargets();
        int numTests = 0;
        ListIterator<ClassTarget> i = l.listIterator();
        while (i.hasNext()) {
            ClassTarget ct = i.next();
            if (ct.isCompiled() && !ct.isAbstract()) {
                UnitTestClassRole utcr = (UnitTestClassRole)ct.getRole();
                numTests += utcr.getTestCount(ct);
                continue;
            }
            i.remove();
        }
        Iterator<ClassTarget> it = l.iterator();
        int numTestsFinal = numTests;
        Project projFinal = this.getProject();
        Platform.runLater(() -> TestDisplayFrame.getTestDisplay().startMultipleTests(projFinal, numTestsFinal));
        TestRunnerThread trt = new TestRunnerThread(this, it);
        trt.start();
    }

    public void endTestRun() {
        Platform.runLater(() -> {
            TestDisplayFrame.getTestDisplay().endMultipleTests();
            this.runButton.setDisable(false);
        });
    }

    public void doEndTest() {
        if (this.testTarget != null) {
            this.testRecordingEnded();
            DataCollector.endTestMethod(this.getPackage(), this.testIdentifier);
            if (this.testTarget.getRole() instanceof UnitTestClassRole) {
                UnitTestClassRole utcr = (UnitTestClassRole)this.testTarget.getRole();
                utcr.doEndMakeTestCase(this, this.testTarget, this.testTargetMethod);
            }
            this.getPackage().compileQuiet(this.testTarget, CompileReason.MODIFIED, CompileType.INDIRECT_USER_COMPILE);
            this.getProject().removeClassLoader();
            this.getProject().newRemoteClassLoaderLeavingBreakpoints();
            this.testTarget = null;
        }
    }

    public void doCancelTest() {
        this.testRecordingEnded();
        DataCollector.cancelTestMethod(this.getPackage(), this.testIdentifier);
        this.getProject().removeClassLoader();
        this.getProject().newRemoteClassLoaderLeavingBreakpoints();
        this.testTarget = null;
    }

    public void testRecordingStarted(String message) {
        Platform.runLater(() -> {
            this.testStatusMessage.setText(message);
            this.recordingLabel.setDisable(false);
        });
        this.endTestRecordAction.setEnabled(true);
        this.cancelTestRecordAction.setEnabled(true);
        this.getProject().setTestMode(true);
    }

    private void testRecordingEnded() {
        Platform.runLater(() -> {
            this.testStatusMessage.setText("");
            this.recordingLabel.setDisable(true);
        });
        this.endTestRecordAction.setEnabled(false);
        this.cancelTestRecordAction.setEnabled(false);
        Project proj = this.getProject();
        if (proj != null) {
            proj.setTestMode(false);
        }
    }

    public void setTestInfo(String testName, ClassTarget testClass) {
        this.testTargetMethod = testName;
        this.testTarget = testClass;
        this.testIdentifier = nextTestIdentifier.incrementAndGet();
        DataCollector.startTestMethod(this.getPackage(), this.testIdentifier, testClass.getSourceFile(), testName);
    }

    @OnThread(value=Tag.FXPlatform)
    public boolean askRemoveClass() {
        int response = DialogManager.askQuestionFX((Window)this.getFXWindow(), "really-remove-class");
        return response == 0;
    }

    public void compileSelected() {
        Package thePkg = this.getPackage();
        List<Target> targets = thePkg.getSelectedTargets();
        if (targets.size() > 0) {
            for (Target target : targets) {
                ClassTarget t;
                if (!(target instanceof ClassTarget) || !(t = (ClassTarget)target).hasSourceCode()) continue;
                thePkg.compile(t, CompileReason.USER, CompileType.EXPLICIT_USER_COMPILE);
            }
        } else {
            Platform.runLater(() -> DialogManager.showErrorFX((Window)this.getFXWindow(), "no-class-selected-compile"));
        }
    }

    public void callLibraryClass() {
        Package pkgRef = this.getPackage();
        BPClassLoader classLoader = this.getProject().getClassLoader();
        Platform.runLater(() -> {
            if (this.libraryCallDialog == null) {
                this.libraryCallDialog = new LibraryCallDialog((Window)this.getFXWindow(), pkgRef, classLoader);
            }
            this.libraryCallDialog.setResult(null);
            Optional result = this.libraryCallDialog.showAndWait();
            result.ifPresent(viewToCall -> SwingUtilities.invokeLater(() -> pkgRef.getEditor().raiseMethodCallEvent(pkgRef, (CallableView)viewToCall)));
        });
    }

    public void generateProjectDocumentation() {
        String message = this.getPackage().generateDocumentation();
        if (message.length() != 0) {
            Platform.runLater(() -> DialogManager.showTextFX((Window)this.getFXWindow(), message));
        }
    }

    public boolean checkDebuggerState() {
        Debugger debugger = this.getProject().getDebugger();
        if (debugger.getStatus() == 4) {
            this.setVisible(true);
            Platform.runLater(() -> DialogManager.showErrorFX((Window)this.getFXWindow(), "stuck-at-breakpoint"));
            return false;
        }
        if (debugger.getStatus() == 3) {
            this.setVisible(true);
            Platform.runLater(() -> DialogManager.showErrorFX((Window)this.getFXWindow(), "already-executing"));
            return false;
        }
        return true;
    }

    public void restartDebugger() {
        if (!this.isEmptyFrame()) {
            this.getProject().restartVM();
            DataCollector.restartVM(this.getProject());
        }
    }

    public void updateSharedStatus(boolean shared) {
        Platform.runLater(() -> this.updateWindow());
    }

    @OnThread(value=Tag.FXPlatform)
    private void showHideTextEval(boolean show) {
        if (show) {
            if (this.codePad == null) {
                this.codePad = new CodePad(this, this.bottomOverlay);
                this.addCtrlTabShortcut(this.codePad);
                CodePad cpFinal = this.codePad;
                this.itemsToDisable.add((Node)cpFinal);
                this.bottomPane.getItems().add((Object)this.codePad);
                this.codePad.focusInputField();
            }
            this.codePad.setDisable(false);
        } else {
            CodePad cpFinal = this.codePad;
            this.itemsToDisable.remove(cpFinal);
            this.bottomPane.getItems().remove((Object)this.codePad);
            this.codePad = null;
        }
    }

    @OnThread(value=Tag.FXPlatform)
    public void clearTextEval() {
        if (this.codePad != null) {
            this.codePad.clear();
        }
    }

    @Override
    public void blueJEvent(int eventId, Object arg) {
        switch (eventId) {
            case 0: {
                this.setStatus(Config.getString("pkgmgr.creatingVM"));
                break;
            }
            case 2: {
                this.setStatus(Config.getString("pkgmgr.creatingVMDone"));
                break;
            }
            case 6: {
                this.setStatus(Config.getString("pkgmgr.generatingDocu"));
                break;
            }
            case 7: {
                this.setStatus(Config.getString("pkgmgr.docuGenerated"));
                break;
            }
            case 8: {
                this.setStatus(Config.getString("pkgmgr.docuAborted"));
                break;
            }
            case 1: {
                Platform.runLater(() -> DialogManager.showErrorFX((Window)this.getFXWindow(), "error-create-vm"));
            }
        }
    }

    public void setDebuggerState(int state) {
        switch (state) {
            case 1: 
            case 5: {
                break;
            }
            case 2: {
                if (this.machineIcon != null) {
                    this.machineIcon.setIdle();
                }
                this.getProject().getTerminal().activate(false);
                break;
            }
            case 3: {
                if (this.machineIcon != null) {
                    this.machineIcon.setRunning();
                }
                this.getProject().getTerminal().activate(true);
                break;
            }
            case 4: {
                if (this.machineIcon == null) break;
                this.machineIcon.setStopped();
            }
        }
    }

    public String toString() {
        String str = "PkgMgrFrame(): ";
        str = this.isEmptyFrame() ? str + "empty" : str + this.getPackage().toString() + " " + this.getProject().toString();
        return str;
    }

    public void showWebPage(String url) {
        if (Utility.openWebBrowser(url)) {
            this.setStatus(Config.getString("pkgmgr.webBrowserMsg"));
        } else {
            this.setStatus(Config.getString("pkgmgr.webBrowserError"));
        }
    }

    private void makeFrame() {
        this.setupMenus();
        UpdateDialogAction updateAction = this.teamActions.getUpdateAction(this);
        CommitCommentAction commitCommentAction = this.teamActions.getCommitCommentAction(this);
        StatusAction statusAction = this.teamActions.getStatusAction(this);
        ImportAction shareAction = this.teamActions.getImportAction(this);
        this.endTestRecordAction.setEnabled(false);
        this.cancelTestRecordAction.setEnabled(false);
        JLabel dummyContent = new JLabel("");
        Platform.runLater(() -> {
            this.toolPanel = new VBox();
            JavaFXUtil.addStyleClass((Styleable)this.toolPanel, "pmf-tools");
            VBox topButtons = new VBox();
            JavaFXUtil.addStyleClass((Styleable)topButtons, "pmf-tools-top");
            ButtonBase button = PkgMgrFrame.createButton(this.newClassAction, false, false);
            topButtons.getChildren().add((Object)button);
            this.imgExtendsButton = PkgMgrFrame.createButton(this.newInheritsAction, false, true);
            this.imgExtendsButton.setText(null);
            this.imgExtendsButton.setGraphic((Node)new ImageView(Config.getImageAsFXImage("image.build.extends")));
            topButtons.getChildren().add((Object)this.imgExtendsButton);
            button = PkgMgrFrame.createButton(this.compileAction, false, false);
            topButtons.getChildren().add((Object)button);
            this.toolPanel.getChildren().add((Object)topButtons);
            this.dummySwingNode = new SwingNode();
            this.dummySwingNode.setContent((JComponent)dummyContent);
            this.dummySwingNode.setFocusTraversable(false);
            this.toolPanel.getChildren().add((Object)this.dummySwingNode);
            Pane space = new Pane();
            VBox.setVgrow((Node)space, (Priority)Priority.ALWAYS);
            this.toolPanel.getChildren().add((Object)space);
            this.testPanel = new TitledPane();
            this.testPanel.setFocusTraversable(false);
            JavaFXUtil.addStyleClass((Styleable)this.testPanel, "pmf-tools-test");
            this.testPanel.setText(Config.getString("pkgmgr.test.title"));
            VBox testPanelItems = new VBox();
            JavaFXUtil.addStyleClass((Styleable)testPanelItems, "pmf-tools-test-items");
            this.testPanel.setContent((Node)testPanelItems);
            this.runButton = PkgMgrFrame.createButton(this.runTestsAction, false, false);
            this.runButton.setText(Config.getString("pkgmgr.test.run"));
            testPanelItems.getChildren().add((Object)this.runButton);
            Ellipse recordingIcon = new Ellipse(7.0, 7.0);
            recordingIcon.setFill((Paint)Color.RED);
            this.recordingLabel = new Label(Config.getString("pkgmgr.test.record"), (Node)recordingIcon);
            this.recordingLabel.disabledProperty().addListener((ChangeListener)new ChangeListener<Boolean>((Shape)recordingIcon){
                private Animation pulseAnimation;
                final /* synthetic */ Shape val$recordingIcon;
                {
                    this.val$recordingIcon = shape;
                }

                @OnThread(value=Tag.FX)
                public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                    if (this.pulseAnimation != null) {
                        this.pulseAnimation.stop();
                        this.pulseAnimation = null;
                    }
                    if (!newValue.booleanValue()) {
                        this.pulseAnimation = new FillTransition(Duration.millis((double)2000.0), this.val$recordingIcon, new Color(1.0, 0.2, 0.2, 1.0), Color.DARKRED);
                        this.pulseAnimation.setAutoReverse(true);
                        this.pulseAnimation.setCycleCount(-1);
                        this.pulseAnimation.playFromStart();
                    } else {
                        this.val$recordingIcon.setFill((Paint)Color.DARKGRAY);
                    }
                }
            });
            this.recordingLabel.setDisable(true);
            testPanelItems.getChildren().add((Object)this.recordingLabel);
            ButtonBase endTestButton = PkgMgrFrame.createButton(this.endTestRecordAction, false, false);
            endTestButton.setText(Config.getString("pkgmgr.test.end"));
            testPanelItems.getChildren().add((Object)JavaFXUtil.withStyleClass(new VBox(new Node[]{endTestButton}), "pmf-tools-test-recording-button"));
            ButtonBase cancelTestButton = PkgMgrFrame.createButton(this.cancelTestRecordAction, false, false);
            cancelTestButton.setText(Config.getString("cancel"));
            testPanelItems.getChildren().add((Object)JavaFXUtil.withStyleClass(new VBox(new Node[]{cancelTestButton}), "pmf-tools-test-recording-button"));
            this.teamPanel = new TitledPane();
            this.teamPanel.setFocusTraversable(false);
            this.teamPanel.setText(Config.getString("pkgmgr.team.title"));
            JavaFXUtil.addStyleClass((Styleable)this.teamPanel, "pmf-tools-team");
            VBox teamPanelItemsOnceShared = new VBox();
            JavaFXUtil.addStyleClass((Styleable)teamPanelItemsOnceShared, "pmf-tools-team-items");
            teamPanelItemsOnceShared.setPickOnBounds(false);
            VBox teamPanelItemsUnshared = new VBox();
            JavaFXUtil.addStyleClass((Styleable)teamPanelItemsUnshared, "pmf-tools-team-items");
            teamPanelItemsUnshared.setPickOnBounds(false);
            this.teamPanel.setContent((Node)new StackPane(new Node[]{teamPanelItemsUnshared, teamPanelItemsOnceShared}));
            this.updateButton = PkgMgrFrame.createButton(updateAction, false, false);
            this.updateButton.visibleProperty().bind((ObservableValue)this.updateButton.disableProperty().not());
            teamPanelItemsOnceShared.getChildren().add((Object)this.updateButton);
            this.commitButton = PkgMgrFrame.createButton(commitCommentAction, false, false);
            this.commitButton.visibleProperty().bind((ObservableValue)this.commitButton.disableProperty().not());
            teamPanelItemsOnceShared.getChildren().add((Object)this.commitButton);
            this.teamStatusButton = PkgMgrFrame.createButton(statusAction, false, false);
            this.teamStatusButton.visibleProperty().bind((ObservableValue)this.teamStatusButton.disableProperty().not());
            teamPanelItemsOnceShared.getChildren().add((Object)this.teamStatusButton);
            this.teamShareButton = PkgMgrFrame.createButton(shareAction, false, false);
            this.teamShareButton.visibleProperty().bind((ObservableValue)this.teamShareButton.disableProperty().not());
            teamPanelItemsUnshared.getChildren().add((Object)this.teamShareButton);
            this.teamShareButton.setText(Config.getString("team.import.short"));
            this.teamShowSharedButtons = this.teamShareButton.disableProperty().and((ObservableBooleanValue)this.teamStatusButton.disableProperty().not());
            teamPanelItemsOnceShared.managedProperty().bind((ObservableValue)this.teamShowSharedButtons);
            VBox foldout = new VBox(new Node[]{this.teamPanel, this.testPanel});
            this.teamPanel.setCollapsible(false);
            this.teamPanel.setExpanded(true);
            this.testPanel.setCollapsible(false);
            this.testPanel.setExpanded(true);
            this.teamAndTestFoldout = new UntitledCollapsiblePane((Node)foldout, !PrefMgr.getFlag("bluej.testing.showtools") && !PrefMgr.getFlag("bluej.teamwork.showtools")){

                @Override
                @OnThread(value=Tag.FX)
                protected double computeMinHeight(double width) {
                    return 10.0;
                }
            };
            JavaFXUtil.addStyleClass((Styleable)foldout, "team-test-foldout-content");
            JavaFXUtil.addChangeListener(this.teamAndTestFoldout.expandedProperty(), expanded -> {
                PrefMgr.setFlag("bluej.teamwork.showtools", expanded);
                PrefMgr.setFlag("bluej.testing.showtools", expanded);
            });
            this.toolPanel.getChildren().add((Object)this.teamAndTestFoldout);
            this.machineIcon = new MachineIcon(this, this.restartVMAction);
            this.itemsToDisable.add((Node)this.machineIcon);
        });
        if (PrefMgr.getFlag("bluej.startWithTextEval")) {
            Platform.runLater(() -> this.showingTextEval.set(true));
        }
        Platform.runLater(() -> JavaFXUtil.onceNotNull(this.stageProperty, stage -> stage.setOnCloseRequest(e -> this.doClose(false, true))));
    }

    @OnThread(value=Tag.FXPlatform)
    public static ButtonBase createButton(Action action, boolean toggle, boolean noText) {
        Object button = toggle ? new ToggleButton() : new Button();
        PkgMgrFrame.setButtonAction(action, (ButtonBase)button, noText);
        button.setFocusTraversable(false);
        return button;
    }

    @OnThread(value=Tag.FXPlatform)
    private static void setButtonAction(Action action, ButtonBase button, boolean noText) {
        SwingUtilities.invokeLater(() -> {
            String name = (String)action.getValue("Name");
            boolean startEnabled = action.isEnabled();
            action.addPropertyChangeListener(c -> {
                if (c.getPropertyName().equals("enabled")) {
                    boolean enabled = action.isEnabled();
                    Platform.runLater(() -> button.setDisable(!enabled));
                }
            });
            Platform.runLater(() -> {
                if (!noText && (button.getText() == null || button.getText().isEmpty())) {
                    button.setText(name);
                }
                button.setDisable(!startEnabled);
            });
        });
        button.setOnAction(e -> SwingUtilities.invokeLater(() -> action.actionPerformed(new ActionEvent(button, 1001, null))));
    }

    private void setupMenus() {
        ArrayList<JavaFXUtil.SwingOrFXMenu> menubar = new ArrayList<JavaFXUtil.SwingOrFXMenu>();
        JMenu menu = new JMenu(Config.getString("menu.package"));
        int mnemonic = Config.getMnemonicKey("menu.package");
        menu.setMnemonic(mnemonic);
        menubar.add(new JavaFXUtil.SwingMenu(menu));
        this.createMenuItem(new NewProjectAction(this), menu);
        this.createMenuItem(new OpenProjectAction(this), menu);
        this.recentProjectsMenu = new JMenu(Config.getString("menu.package.openRecent"));
        menu.add(this.recentProjectsMenu);
        this.createMenuItem(new OpenNonBlueJAction(this), menu);
        this.createMenuItem(new OpenArchiveAction(this), menu);
        this.createMenuItem(this.closeProjectAction, menu);
        this.createMenuItem(this.saveProjectAction, menu);
        this.createMenuItem(this.saveProjectAsAction, menu);
        menu.addSeparator();
        this.createMenuItem(this.importProjectAction, menu);
        this.createMenuItem(this.exportProjectAction, menu);
        menu.addSeparator();
        this.createMenuItem(this.pageSetupAction, menu);
        this.createMenuItem(this.printAction, menu);
        if (!Config.usingMacScreenMenubar()) {
            menu.addSeparator();
            this.createMenuItem(new QuitAction(this), menu);
        }
        menu = new JMenu(Config.getString("menu.edit"));
        menu.setMnemonic(Config.getMnemonicKey("menu.edit"));
        menubar.add(new JavaFXUtil.SwingMenu(menu));
        this.createMenuItem(this.newClassAction, menu);
        this.createMenuItem(this.newPackageAction, menu);
        this.createMenuItem(this.addClassAction, menu);
        this.createMenuItem(this.removeAction, menu);
        menu.addSeparator();
        this.createMenuItem(this.newInheritsAction, menu);
        ExtensionsManager extMgr = ExtensionsManager.getInstance();
        JavaFXUtil.FXPlusSwingMenu mixedMenu = new JavaFXUtil.FXPlusSwingMenu(() -> {
            Menu fxMenu = new Menu(Config.getString("menu.tools"));
            this.toolsMenuManager.set((Object)new FXMenuManager(fxMenu, extMgr, null));
            return fxMenu;
        });
        ArrayList<JMenuItem> swingItems = new ArrayList<JMenuItem>();
        swingItems.add(new JMenuItem(this.compileAction));
        swingItems.add(new JMenuItem(this.compileSelectedAction));
        swingItems.add(new JMenuItem(this.rebuildAction));
        swingItems.add(new JMenuItem(this.restartVMAction));
        mixedMenu.addSwing(swingItems);
        mixedMenu.addFX(SeparatorMenuItem::new);
        swingItems.clear();
        swingItems.add(new JMenuItem(this.useLibraryAction));
        swingItems.add(new JMenuItem(this.generateDocsAction));
        this.testingMenu = new JMenu(Config.getString("menu.tools.testing"));
        this.testingMenu.setMnemonic(Config.getMnemonicKey("menu.tools"));
        this.createMenuItem(this.runTestsAction, this.testingMenu);
        this.createMenuItem(this.endTestRecordAction, this.testingMenu);
        this.createMenuItem(this.cancelTestRecordAction, this.testingMenu);
        swingItems.add(this.testingMenu);
        this.teamMenu = new JMenu(Config.getString("menu.tools.teamwork"));
        this.teamMenu.setMnemonic(Config.getMnemonicKey("menu.tools"));
        CheckoutAction checkoutAction = new CheckoutAction(this);
        this.createMenuItem(checkoutAction, this.teamMenu);
        this.shareProjectMenuItem = this.createMenuItem(this.teamActions.getImportAction(this), this.teamMenu);
        this.teamMenu.addSeparator();
        this.updateMenuItem = this.createMenuItem(this.teamActions.getUpdateAction(this), this.teamMenu);
        this.updateMenuItem.setText(Config.getString("team.menu.update"));
        this.commitMenuItem = this.createMenuItem(this.teamActions.getCommitCommentAction(this), this.teamMenu);
        this.commitMenuItem.setText(Config.getString("team.menu.commit"));
        this.statusMenuItem = this.createMenuItem(this.teamActions.getStatusAction(this), this.teamMenu);
        this.showLogMenuItem = this.createMenuItem(this.teamActions.getShowLogAction(this), this.teamMenu);
        this.teamMenu.addSeparator();
        this.teamSettingsMenuItem = this.createMenuItem(this.teamActions.getTeamSettingsAction(this), this.teamMenu);
        swingItems.add(this.teamMenu);
        mixedMenu.addSwing(swingItems);
        swingItems.clear();
        if (!Config.usingMacScreenMenubar()) {
            mixedMenu.addFX(SeparatorMenuItem::new);
            swingItems.add(new JMenuItem(new PreferencesAction(this)));
            mixedMenu.addSwing(swingItems);
        }
        if (PkgMgrFrame.frameCount() <= 1) {
            mixedMenu.runAtEnd(() -> Platform.runLater(() -> {
                FXMenuManager tm = (FXMenuManager)this.toolsMenuManager.get();
                SwingUtilities.invokeLater(() -> tm.addExtensionMenu(null));
            }));
        }
        menubar.add(mixedMenu);
        mixedMenu = new JavaFXUtil.FXPlusSwingMenu(() -> {
            Menu fxMenu = new Menu(Config.getString("menu.view"));
            this.viewMenuManager.set((Object)new FXMenuManager(fxMenu, extMgr, null));
            return fxMenu;
        });
        mixedMenu.addFX(() -> {
            CheckMenuItem item = JavaFXUtil.makeCheckMenuItem(Config.getString("menu.view.showUses"), (Property<Boolean>)this.showUsesProperty, null);
            this.menuItemsToDisable.add((MenuItem)item);
            return item;
        });
        mixedMenu.addFX(() -> {
            CheckMenuItem item = JavaFXUtil.makeCheckMenuItem(Config.getString("menu.view.showInherits"), (Property<Boolean>)this.showInheritsProperty, null);
            this.menuItemsToDisable.add((MenuItem)item);
            return item;
        });
        mixedMenu.addFX(SeparatorMenuItem::new);
        swingItems = new ArrayList();
        this.createCheckboxMenuItem(this.showDebuggerAction, swingItems, false);
        this.createCheckboxMenuItem(this.showTerminalAction, swingItems, false);
        mixedMenu.addSwing(swingItems);
        mixedMenu.addFX(() -> JavaFXUtil.makeCheckMenuItem(Config.getString("menu.view.showTextEval"), (Property<Boolean>)this.showingTextEval, Config.hasAcceleratorKey("menu.view.showTextEval") ? Config.getAcceleratorKeyFX("menu.view.showTextEval") : null));
        mixedMenu.addFX(() -> JavaFXUtil.makeCheckMenuItem(Config.getString("menu.view.showTeamTest"), (Property<Boolean>)this.teamAndTestFoldout.expandedProperty(), Config.hasAcceleratorKey("menu.view.showTeamTest") ? Config.getAcceleratorKeyFX("menu.view.showTeamTest") : null));
        mixedMenu.addFX(SeparatorMenuItem::new);
        swingItems = new ArrayList();
        this.createCheckboxMenuItem(new ShowTestResultsAction(this), swingItems, false);
        mixedMenu.addSwing(swingItems);
        if (PkgMgrFrame.frameCount() <= 1) {
            mixedMenu.runAtEnd(() -> Platform.runLater(() -> {
                FXMenuManager vm = (FXMenuManager)this.viewMenuManager.get();
                SwingUtilities.invokeLater(() -> vm.addExtensionMenu(null));
            }));
        }
        menubar.add(mixedMenu);
        JMenu menu2 = new JMenu(Config.getString("menu.help"));
        menu2.setMnemonic(Config.getMnemonicKey("menu.help"));
        menubar.add(new JavaFXUtil.SwingMenu(menu2));
        if (!Config.usingMacScreenMenubar()) {
            this.createMenuItem(new HelpAboutAction(this), menu2);
        }
        this.createMenuItem(new CheckVersionAction(this), menu2);
        this.createMenuItem(new CheckExtensionsAction(this), menu2);
        this.createMenuItem(new ShowCopyrightAction(this), menu2);
        menu2.addSeparator();
        this.createMenuItem(new WebsiteAction(this), menu2);
        this.createMenuItem(new TutorialAction(this), menu2);
        this.createMenuItem(new StandardAPIHelpAction(this), menu2);
        this.addUserHelpItems(menu2);
        this.updateRecentProjects();
        FXPlatformSupplier<MenuBar> fxMenuBarSupplier = JavaFXUtil.swingMenuBarToFX(menubar, (Object)this);
        Platform.runLater(() -> JavaFXUtil.onceNotNull(this.paneProperty, pane -> JavaFXUtil.runNowOrLater(() -> {
            MenuBar fxMenuBar = (MenuBar)fxMenuBarSupplier.get();
            fxMenuBar.setUseSystemMenuBar(true);
            pane.setTop((Node)fxMenuBar);
        })));
    }

    private JMenuItem createMenuItem(Action action, JMenu menu) {
        JMenuItem item = menu.add(action);
        item.setIcon(null);
        return item;
    }

    private JCheckBoxMenuItem createCheckboxMenuItem(PkgMgrToggleAction action, List<JMenuItem> menu, boolean selected) {
        ButtonModel bmodel = action.getToggleModel();
        JCheckBoxMenuItem item = new JCheckBoxMenuItem(action);
        if (bmodel != null) {
            item.setModel(bmodel);
        } else {
            item.setState(selected);
        }
        menu.add(item);
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void menuCall() {
        if (!this.isEmptyFrame()) {
            PkgMgrFrame pkgMgrFrame = this;
            synchronized (pkgMgrFrame) {
                PackageEditor pkgEd = this.pkg.getEditor();
                Platform.runLater(() -> pkgEd.clearState());
            }
        }
        this.clearStatus();
    }

    private void setupActionDisableSet() {
        this.actionsToDisable.add(this.closeProjectAction);
        this.actionsToDisable.add(this.saveProjectAction);
        this.actionsToDisable.add(this.saveProjectAsAction);
        this.actionsToDisable.add(this.importProjectAction);
        this.actionsToDisable.add(this.exportProjectAction);
        this.actionsToDisable.add(this.pageSetupAction);
        this.actionsToDisable.add(this.printAction);
        this.actionsToDisable.add(this.newClassAction);
        this.actionsToDisable.add(this.newPackageAction);
        this.actionsToDisable.add(this.addClassAction);
        this.actionsToDisable.add(this.removeAction);
        this.actionsToDisable.add(this.newInheritsAction);
        this.actionsToDisable.add(this.compileAction);
        this.actionsToDisable.add(this.compileSelectedAction);
        this.actionsToDisable.add(this.rebuildAction);
        this.actionsToDisable.add(this.restartVMAction);
        this.actionsToDisable.add(this.useLibraryAction);
        this.actionsToDisable.add(this.generateDocsAction);
        this.actionsToDisable.add(this.showDebuggerAction);
        this.actionsToDisable.add(this.showTerminalAction);
        this.actionsToDisable.add(this.runTestsAction);
    }

    private void addUserHelpItems(JMenu menu) {
        String helpItems = Config.getPropString("bluej.help.items", "");
        if (helpItems != null && helpItems.length() > 0) {
            menu.addSeparator();
            URLDisplayer urlDisplayer = new URLDisplayer();
            StringTokenizer t = new StringTokenizer(helpItems);
            while (t.hasMoreTokens()) {
                String itemID = t.nextToken();
                String itemName = Config.getPropString("bluej.help." + itemID + ".label");
                String itemURL = Config.getPropString("bluej.help." + itemID + ".url");
                JMenuItem item = new JMenuItem(itemName);
                item.setActionCommand(itemURL);
                item.addActionListener(urlDisplayer);
                menu.add(item);
            }
        }
    }

    private void updateRecentProjects() {
        ProjectOpener opener = new ProjectOpener();
        this.recentProjectsMenu.removeAll();
        List<String> projects = PrefMgr.getRecentProjects();
        Iterator<String> it = projects.iterator();
        while (it.hasNext()) {
            JMenuItem item = this.recentProjectsMenu.add(it.next());
            item.addActionListener(opener);
        }
    }

    protected void enableFunctions(boolean enable) {
        if (!enable) {
            this.teamActions.setAllDisabled(this);
        }
        Platform.runLater(() -> {
            for (Node node : this.itemsToDisable) {
                node.setDisable(!enable);
            }
            for (MenuItem menuItem : this.menuItemsToDisable) {
                menuItem.setDisable(!enable);
            }
        });
        this.actionsToDisable.stream().forEach(action -> action.setEnabled(enable));
    }

    @OnThread(value=Tag.FX)
    private void addCtrlTabShortcut(PkgMgrPane srcPane) {
        srcPane.asNode().addEventFilter(KeyEvent.KEY_PRESSED, e -> {
            if (e.getCode() == KeyCode.TAB && e.isControlDown()) {
                if (!e.isShiftDown()) {
                    if (srcPane == this.editor) {
                        if (!this.tryFocusObjBench()) {
                            this.tryFocusCodePad();
                        }
                    } else if (srcPane == this.objbench) {
                        if (!this.tryFocusCodePad()) {
                            this.tryFocusClassDiagram();
                        }
                    } else if (!this.tryFocusClassDiagram()) {
                        this.tryFocusObjBench();
                    }
                } else if (srcPane == this.editor) {
                    if (!this.tryFocusCodePad()) {
                        this.tryFocusObjBench();
                    }
                } else if (srcPane == this.objbench) {
                    if (!this.tryFocusClassDiagram()) {
                        this.tryFocusCodePad();
                    }
                } else if (!this.tryFocusObjBench()) {
                    this.tryFocusClassDiagram();
                }
                e.consume();
            }
        });
    }

    @OnThread(value=Tag.FXPlatform)
    private boolean tryFocusClassDiagram() {
        if (this.editor != null) {
            return this.editor.focusSelectedOrArbitrary();
        }
        return false;
    }

    @OnThread(value=Tag.FXPlatform)
    private boolean tryFocusCodePad() {
        if (this.codePad != null && !this.codePad.isDisabled()) {
            this.codePad.focusInputField();
            return true;
        }
        return false;
    }

    @OnThread(value=Tag.FXPlatform)
    private boolean tryFocusObjBench() {
        if (this.objbench.getObjectCount() > 0) {
            this.objbench.getObjects().get(0).requestFocus();
            return true;
        }
        return false;
    }

    @OnThread(value=Tag.FX)
    public Stage getFXWindow() {
        return (Stage)this.stageProperty.getValue();
    }

    void bringToFront() {
        Platform.runLater(() -> Utility.bringToFrontFX(this.getFXWindow()));
    }

    @OnThread(value=Tag.FXPlatform)
    private void scheduleWindowWiggle(Stage stage) {
        if (this.cancelWiggle != null) {
            this.cancelWiggle.run();
        }
        this.cancelWiggle = JavaFXUtil.runAfter(Duration.seconds((double)0.5), () -> {
            if (!stage.isMaximized() && !stage.isIconified()) {
                double x = stage.getX();
                stage.setX(x + 1.0);
                JavaFXUtil.runAfterCurrent(() -> stage.setX(x));
            }
        });
    }

    @OnThread(value=Tag.Swing)
    public synchronized void doNewInherits() {
        if (this.pkg != null && this.pkg.getEditor() != null) {
            PackageEditor pkgEg = this.pkg.getEditor();
            Platform.runLater(() -> pkgEg.doNewInherits());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnThread(value=Tag.Swing)
    public void graphChanged() {
        int numPackagesNested;
        int numClassTargetsWithSource;
        int numClassTargets;
        PkgMgrFrame pkgMgrFrame = this;
        synchronized (pkgMgrFrame) {
            if (this.pkg == null) {
                return;
            }
            ArrayList<ClassTarget> classTargets = this.pkg.getClassTargets();
            numClassTargets = classTargets.size();
            numClassTargetsWithSource = (int)classTargets.stream().filter(ClassTarget::hasSourceCode).count();
            numPackagesNested = this.pkg.getChildren(true).size();
        }
        this.compileAction.setEnabled(numClassTargetsWithSource > 0);
        this.newInheritsAction.setEnabled(numClassTargets >= 2 && numClassTargetsWithSource >= 1);
        Platform.runLater(() -> this.getPackage().getEditor().noClassesExistedMessage.setVisible(numClassTargets + numPackagesNested == 0));
    }

    public static interface PkgMgrPane {
        @OnThread(value=Tag.FX)
        default public Node asNode() {
            return (Node)this;
        }
    }

    class ProjectOpener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent evt) {
            String project = evt.getActionCommand();
            if (!PkgMgrFrame.this.openProject(project)) {
                PkgMgrFrame.this.setStatus(Config.getString("pkgmgr.error.open"));
            }
        }
    }

    class URLDisplayer
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent evt) {
            String url = evt.getActionCommand();
            PkgMgrFrame.this.showWebPage(url);
        }
    }
}

