/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr;

import bluej.Config;
import bluej.extensions.SourceType;
import bluej.pkgmgr.ExportDialog;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.pkgmgr.Project;
import bluej.utility.Debug;
import bluej.utility.DialogManager;
import bluej.utility.FileUtility;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javafx.application.Platform;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import threadchecker.OnThread;
import threadchecker.Tag;

final class ExportManager {
    private static final String specifyJar = Config.getString("pkgmgr.export.specifyJar");
    private static final String createJarText = Config.getString("pkgmgr.export.createJarText");
    private static final String sourceSuffix = "." + SourceType.Java.toString().toLowerCase();
    private static final String contextSuffix = ".ctxt";
    private static final String packageFilePrefix = "bluej.pk";
    private static final String packageFileBackup = "bluej.pkh";
    private final PkgMgrFrame frame;
    private @OnThread(value=Tag.FXPlatform) ExportDialog dialog;
    private static final @OnThread(value=Tag.Any) String[] skipDirs = new String[]{"CVS", ".svn", ".git"};

    public ExportManager(PkgMgrFrame frame) {
        this.frame = frame;
    }

    public void export() {
        Project proj = this.frame.getProject();
        ExportDialog.ProjectInfo projectInfo = new ExportDialog.ProjectInfo(proj);
        boolean hasStride = proj.getPackageNames().stream().map(proj::getPackage).flatMap(p -> p.getClassTargets().stream()).anyMatch(ct -> ct.getSourceType() == SourceType.Stride);
        Platform.runLater(() -> {
            Stage parent = this.frame.getFXWindow();
            if (this.dialog == null) {
                this.dialog = new ExportDialog((Window)parent, projectInfo);
            } else {
                this.dialog.updateDialog(projectInfo);
            }
            Optional result = this.dialog.showAndWait();
            if (!result.isPresent()) {
                return;
            }
            ExportDialog.ExportInfo info = (ExportDialog.ExportInfo)result.get();
            File fileName = FileUtility.getSaveFileFX((Window)parent, specifyJar, Arrays.asList(new FileChooser.ExtensionFilter("JAR file", new String[]{"*.jar"})), false);
            if (fileName == null) {
                return;
            }
            String sourceDir = proj.getProjectDir().getPath();
            this.createJar(proj, fileName.getAbsolutePath().toString(), sourceDir, info.mainClassName, info.selectedFiles, info.includeSource, info.includePkgFiles, hasStride);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnThread(value=Tag.FXPlatform)
    private void createJar(Project proj, String fileName, String sourceDir, String mainClass, List<File> userLibs, boolean includeSource, boolean includePkgFiles, boolean includeStrideLang) {
        File jarFile;
        if (!fileName.endsWith(".jar")) {
            fileName = fileName + ".jar";
        }
        if ((jarFile = new File(fileName)).exists() && DialogManager.askQuestionFX((Window)this.frame.getFXWindow(), "error-file-exists") != 0) {
            return;
        }
        FileOutputStream oStream = null;
        ZipOutputStream jStream = null;
        try {
            Manifest manifest = new Manifest();
            Attributes attr = manifest.getMainAttributes();
            attr.put(Attributes.Name.MANIFEST_VERSION, "1.0");
            attr.put(Attributes.Name.MAIN_CLASS, mainClass);
            oStream = new FileOutputStream(jarFile);
            jStream = new JarOutputStream((OutputStream)oStream, manifest);
            JarOutput jarOutput = new JarOutput((JarOutputStream)jStream);
            this.writeDirToJar(new File(sourceDir), "", jarOutput, includeSource, includePkgFiles, jarFile.getCanonicalFile());
            if (includeStrideLang) {
                this.includeJarContent(new File(Config.getBlueJLibDir(), "lang-stride.jar"), jarOutput);
            }
            for (URL url : proj.getPlusLibsContent()) {
                try {
                    this.includeJarContent(new File(new URI(url.toString())), jarOutput);
                }
                catch (URISyntaxException uRISyntaxException) {}
            }
            for (File f : userLibs) {
                this.includeJarContent(f, jarOutput);
            }
            this.frame.setStatus(Config.getString("pkgmgr.exported.jar"));
        }
        catch (IOException exc) {
            DialogManager.showErrorFX((Window)this.frame.getFXWindow(), "error-writing-jar");
            Debug.reportError("problem writing jar file: " + exc);
        }
        finally {
            try {
                if (jStream != null) {
                    jStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    @OnThread(value=Tag.Any)
    private void includeJarContent(File srcJarFile, JarOutput jarOutput) throws IOException {
        ZipEntry entry;
        ZipFile jar = new ZipFile(srcJarFile);
        Enumeration<? extends ZipEntry> contents = jar.entries();
        while (contents.hasMoreElements() && (entry = contents.nextElement()) != null) {
            jarOutput.writeJarEntry(jar.getInputStream(entry), entry.getName());
        }
    }

    @OnThread(value=Tag.Any)
    private void writeDirToJar(File sourceDir, String pathPrefix, JarOutput jarOutput, boolean includeSource, boolean includePkg, File outputFile) throws IOException {
        File[] dir = sourceDir.listFiles();
        for (int i = 0; i < dir.length; ++i) {
            if (dir[i].isDirectory()) {
                if (this.skipDir(dir[i], includePkg)) continue;
                this.writeDirToJar(dir[i], pathPrefix + dir[i].getName() + "/", jarOutput, includeSource, includePkg, outputFile);
                continue;
            }
            if (this.skipFile(dir[i].getName(), !includeSource, !includePkg) || outputFile.equals(dir[i].getCanonicalFile())) continue;
            jarOutput.writeJarEntry(dir[i], pathPrefix + dir[i].getName());
        }
    }

    @OnThread(value=Tag.Any)
    private void copyLibsToJar(List<File> userLibs, File destDir) throws IOException {
        for (File lib : userLibs) {
            FileUtility.copyFile(lib, new File(destDir, lib.getName()));
        }
    }

    @OnThread(value=Tag.Any)
    private boolean skipDir(File dir, boolean includePkg) {
        if (dir.getName().equals("+libs")) {
            return !includePkg;
        }
        for (int i = 0; i < skipDirs.length; ++i) {
            if (!dir.getName().equals(skipDirs[i])) continue;
            return true;
        }
        return false;
    }

    @OnThread(value=Tag.Any)
    private boolean skipFile(String fileName, boolean skipSource, boolean skipPkg) {
        if (fileName.equals(packageFileBackup)) {
            return true;
        }
        if (fileName.endsWith(sourceSuffix)) {
            return skipSource;
        }
        if (fileName.startsWith(packageFilePrefix) || fileName.endsWith(contextSuffix)) {
            return skipPkg;
        }
        return false;
    }

    @OnThread(value=Tag.Any)
    private static class JarOutput {
        private final JarOutputStream jStream;
        private final HashSet<String> existingNames = new HashSet();

        public JarOutput(JarOutputStream jStream) {
            this.jStream = jStream;
            this.existingNames.add("META-INF/MANIFEST.MF");
        }

        @OnThread(value=Tag.Any)
        public void writeJarEntry(File srcFile, String entryName) throws IOException {
            this.writeJarEntry(new FileInputStream(srcFile), entryName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @OnThread(value=Tag.Any)
        public void writeJarEntry(InputStream src, String entryName) throws IOException {
            try {
                if (!this.existingNames.contains(entryName)) {
                    this.existingNames.add(entryName);
                    this.jStream.putNextEntry(new ZipEntry(entryName));
                    FileUtility.copyStream(src, this.jStream);
                }
            }
            catch (ZipException exc) {
                Debug.message("warning: " + exc);
            }
            finally {
                if (src != null) {
                    src.close();
                }
            }
        }
    }
}

