/*
 * Decompiled with CFR 0.152.
 */
package bluej.parser.entity;

import bluej.debugger.gentype.GenTypeSolid;
import bluej.debugger.gentype.IntersectionType;
import bluej.debugger.gentype.JavaType;
import bluej.debugger.gentype.Reflective;
import bluej.parser.entity.EntityResolver;
import bluej.parser.entity.JavaEntity;
import bluej.parser.entity.TypeArgumentEntity;
import bluej.parser.entity.TypeEntity;
import java.util.Iterator;
import java.util.List;

public class IntersectionTypeEntity
extends JavaEntity {
    private List<JavaEntity> types;

    public static JavaEntity getIntersectionEntity(List<JavaEntity> types, EntityResolver resolver) {
        if (types.size() == 0) {
            return resolver.resolveQualifiedClass("java.lang.Object");
        }
        if (types.size() == 1) {
            return types.get(0);
        }
        return new IntersectionTypeEntity(types);
    }

    private IntersectionTypeEntity(List<JavaEntity> types) {
        this.types = types;
    }

    @Override
    public String getName() {
        Iterator<JavaEntity> i = this.types.iterator();
        String name = i.next().getName();
        while (i.hasNext()) {
            name = name + "&" + i.next().getName();
        }
        return name;
    }

    @Override
    public JavaEntity getSubentity(String name, Reflective accessSource) {
        return null;
    }

    @Override
    public JavaType getType() {
        GenTypeSolid[] components = new GenTypeSolid[this.types.size()];
        int index = 0;
        for (JavaEntity type : this.types) {
            TypeEntity tent = type.resolveAsType();
            if (tent == null) {
                return null;
            }
            components[index] = tent.getType().asSolid();
            if (components[index++] != null) continue;
            return null;
        }
        return IntersectionType.getIntersection(components);
    }

    @Override
    public JavaEntity setTypeArgs(List<TypeArgumentEntity> tparams) {
        return null;
    }

    @Override
    public TypeEntity resolveAsType() {
        JavaType type = this.getType();
        if (type == null) {
            return null;
        }
        return new TypeEntity(type);
    }
}

