/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork.ui;

import bluej.BlueJTheme;
import bluej.Config;
import bluej.groupwork.TeamSettings;
import bluej.groupwork.TeamSettingsController;
import bluej.groupwork.TeamworkProvider;
import bluej.groupwork.actions.ValidateConnectionAction;
import bluej.groupwork.ui.TeamPanelFocusPolicy;
import bluej.groupwork.ui.TeamSettingsDialog;
import bluej.utility.MiksGridLayout;
import java.awt.FocusTraversalPolicy;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class TeamSettingsPanel
extends JPanel {
    private static final int fieldsize = 30;
    private TeamSettingsController teamSettingsController;
    private TeamSettingsDialog teamSettingsDialog;
    private JPanel locationPanel;
    private JTextField yourNameField;
    private JTextField yourEmailField;
    private JTextField userField;
    private JPasswordField passwordField;
    private JTextField groupField;
    private JTextField prefixField;
    private JComboBox serverTypeComboBox;
    private JTextField serverField;
    private JComboBox protocolComboBox;
    private JButton validateButton;
    private JCheckBox useAsDefault;
    private JTextField uriField;
    private JLabel serverTypeLabel;
    private JLabel groupLabel;
    private JLabel prefixLabel;
    private JLabel serverLabel;
    private JLabel protocolLabel;
    private JLabel uriLabel;
    private int selectedServerType = -1;
    private boolean okEnabled = true;

    public TeamSettingsPanel(TeamSettingsController teamSettingsController, TeamSettingsDialog dialog) {
        this.teamSettingsController = teamSettingsController;
        this.teamSettingsDialog = dialog;
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(BlueJTheme.generalBorder);
        this.add(Box.createVerticalGlue());
        this.add(this.makePersonalPanel());
        this.add(Box.createVerticalStrut(5));
        this.add(this.makeLocationPanel());
        this.add(Box.createVerticalStrut(5));
        this.useAsDefault = new JCheckBox(Config.getString("team.settings.rememberSettings"));
        this.add(this.useAsDefault);
        this.add(Box.createVerticalStrut(5));
        this.validateButton = new JButton(new ValidateConnectionAction(Config.getString("team.settings.checkConnection"), this, dialog::asWindow));
        this.add(this.validateButton);
        DocumentListener changeListener = new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                TeamSettingsPanel.this.checkOkEnabled();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                TeamSettingsPanel.this.checkOkEnabled();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                TeamSettingsPanel.this.checkOkEnabled();
            }
        };
        this.yourNameField.getDocument().addDocumentListener(changeListener);
        this.yourEmailField.getDocument().addDocumentListener(changeListener);
        this.userField.getDocument().addDocumentListener(changeListener);
        this.serverField.getDocument().addDocumentListener(changeListener);
        this.uriField.getDocument().addDocumentListener(changeListener);
        this.add(Box.createVerticalGlue());
        this.setupContent();
        this.checkOkEnabled();
        if (!teamSettingsController.hasProject()) {
            this.useAsDefault.setSelected(true);
        }
    }

    public FocusTraversalPolicy getTraversalPolicy(FocusTraversalPolicy delegate) {
        if (this.yourNameField.isEditable() && this.getYourName().length() == 0) {
            return delegate;
        }
        if (this.yourEmailField.isEditable() && this.getYourEmail().length() == 0) {
            return new TeamPanelFocusPolicy(this.yourEmailField, delegate);
        }
        if (this.getUser().length() == 0) {
            return new TeamPanelFocusPolicy(this.userField, delegate);
        }
        return new TeamPanelFocusPolicy(this.passwordField, delegate);
    }

    public void disableRepositorySettings() {
        this.serverTypeComboBox.setEnabled(false);
        this.groupField.setEnabled(false);
        this.prefixField.setEnabled(false);
        this.serverField.setEnabled(false);
        this.protocolComboBox.setEnabled(false);
        this.uriField.setEnabled(false);
        if (this.uriField.isVisible() && this.uriField.getText().isEmpty()) {
            this.uriField.setText(TeamSettings.getURI(this.readProtocolString(), this.serverField.getText(), this.prefixField.getText()));
        }
        this.serverTypeLabel.setEnabled(false);
        this.groupLabel.setEnabled(false);
        this.prefixLabel.setEnabled(false);
        this.serverLabel.setEnabled(false);
        this.protocolLabel.setEnabled(false);
    }

    private JPanel makePersonalPanel() {
        JPanel authentificationPanel = new JPanel();
        authentificationPanel.setLayout(new MiksGridLayout(5, 2, 10, 5));
        String docTitle = Config.getString("team.settings.personal");
        authentificationPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(docTitle), BlueJTheme.generalBorder));
        authentificationPanel.setAlignmentX(0.0f);
        JLabel yourNameLabel = new JLabel(Config.getString("team.settings.yourName"));
        this.yourNameField = new JTextField(30);
        JLabel yourEmailLabel = new JLabel(Config.getString("team.settings.yourEmail"));
        this.yourEmailField = new JTextField(30);
        JLabel userLabel = new JLabel(Config.getString("team.settings.user"));
        this.userField = new JTextField(30);
        JLabel passwordLabel = new JLabel(Config.getString("team.settings.password"));
        this.passwordField = new JPasswordField(30);
        this.groupLabel = new JLabel(Config.getString("team.settings.group"));
        this.groupField = new JTextField(30);
        yourNameLabel.setMaximumSize(yourNameLabel.getMinimumSize());
        this.yourNameField.setMaximumSize(this.yourNameField.getMinimumSize());
        yourEmailLabel.setMaximumSize(yourEmailLabel.getMinimumSize());
        this.yourEmailField.setMaximumSize(this.yourEmailField.getMinimumSize());
        userLabel.setMaximumSize(userLabel.getMinimumSize());
        this.userField.setMaximumSize(this.userField.getMinimumSize());
        passwordLabel.setMaximumSize(passwordLabel.getMinimumSize());
        this.passwordField.setMaximumSize(this.passwordField.getMinimumSize());
        this.groupLabel.setMaximumSize(this.groupLabel.getMinimumSize());
        this.groupField.setMaximumSize(this.groupField.getMinimumSize());
        authentificationPanel.add(yourNameLabel);
        authentificationPanel.add(this.yourNameField);
        authentificationPanel.add(yourEmailLabel);
        authentificationPanel.add(this.yourEmailField);
        authentificationPanel.add(userLabel);
        authentificationPanel.add(this.userField);
        authentificationPanel.add(passwordLabel);
        authentificationPanel.add(this.passwordField);
        authentificationPanel.add(this.groupLabel);
        authentificationPanel.add(this.groupField);
        return authentificationPanel;
    }

    private JPanel makeLocationPanel() {
        this.locationPanel = new JPanel(new MiksGridLayout(0, 2, 10, 5));
        String docTitle2 = Config.getString("team.settings.location");
        this.locationPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(docTitle2), BlueJTheme.generalBorder));
        this.locationPanel.setAlignmentX(0.0f);
        this.serverTypeLabel = new JLabel(Config.getString("team.settings.serverType"));
        this.serverTypeComboBox = new JComboBox();
        List<TeamworkProvider> teamProviders = this.teamSettingsController.getTeamworkProviders();
        for (TeamworkProvider provider : teamProviders) {
            this.serverTypeComboBox.addItem(provider.getProviderName());
        }
        this.serverLabel = new JLabel(Config.getString("team.settings.server"));
        this.serverField = new JTextField(30);
        this.prefixLabel = new JLabel(Config.getString("team.settings.prefix"));
        this.prefixField = new JTextField(30);
        this.protocolLabel = new JLabel(Config.getString("team.settings.protocol"));
        this.protocolComboBox = new JComboBox();
        this.protocolComboBox.setEditable(false);
        this.uriLabel = new JLabel(Config.getString("team.settings.uri"));
        this.uriField = new JTextField(30);
        this.prefixLabel.setMaximumSize(this.prefixLabel.getMinimumSize());
        this.prefixField.setMaximumSize(this.prefixField.getMinimumSize());
        this.serverLabel.setMaximumSize(this.serverLabel.getMinimumSize());
        this.serverField.setMaximumSize(this.serverField.getMinimumSize());
        this.serverTypeLabel.setMaximumSize(this.serverTypeLabel.getMinimumSize());
        this.serverTypeComboBox.setMaximumSize(this.serverTypeComboBox.getMinimumSize());
        this.uriLabel.setMaximumSize(this.uriLabel.getMinimumSize());
        this.uriField.setMaximumSize(this.uriField.getMinimumSize());
        this.serverTypeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TeamSettingsPanel.this.setProviderSettings();
                if (TeamSettingsPanel.this.getSelectedProvider().needsEmail() && TeamSettingsPanel.this.getSelectedProvider().needsName()) {
                    TeamSettingsPanel.this.yourNameField.setEnabled(true);
                    TeamSettingsPanel.this.yourEmailField.setEnabled(true);
                    TeamSettingsPanel.this.useAsDefault.setVisible(false);
                    TeamSettingsPanel.this.useAsDefault.setSelected(true);
                    if (TeamSettingsPanel.this.serverLabel.getParent() == TeamSettingsPanel.this.locationPanel) {
                        TeamSettingsPanel.this.locationPanel.remove(TeamSettingsPanel.this.serverLabel);
                        TeamSettingsPanel.this.locationPanel.remove(TeamSettingsPanel.this.serverField);
                        TeamSettingsPanel.this.locationPanel.remove(TeamSettingsPanel.this.prefixLabel);
                        TeamSettingsPanel.this.locationPanel.remove(TeamSettingsPanel.this.prefixField);
                        TeamSettingsPanel.this.locationPanel.remove(TeamSettingsPanel.this.protocolLabel);
                        TeamSettingsPanel.this.locationPanel.remove(TeamSettingsPanel.this.protocolComboBox);
                        TeamSettingsPanel.this.locationPanel.add(TeamSettingsPanel.this.uriLabel);
                        TeamSettingsPanel.this.locationPanel.add(TeamSettingsPanel.this.uriField);
                        TeamSettingsPanel.this.locationPanel.revalidate();
                        TeamSettingsPanel.this.groupLabel.setEnabled(false);
                        TeamSettingsPanel.this.groupField.setEnabled(false);
                    }
                } else {
                    TeamSettingsPanel.this.useAsDefault.setVisible(true);
                    TeamSettingsPanel.this.yourNameField.setEnabled(false);
                    TeamSettingsPanel.this.yourEmailField.setEnabled(false);
                    if (TeamSettingsPanel.this.serverLabel.getParent() != TeamSettingsPanel.this.locationPanel) {
                        TeamSettingsPanel.this.locationPanel.remove(TeamSettingsPanel.this.uriLabel);
                        TeamSettingsPanel.this.locationPanel.remove(TeamSettingsPanel.this.uriField);
                        TeamSettingsPanel.this.locationPanel.add(TeamSettingsPanel.this.serverLabel);
                        TeamSettingsPanel.this.locationPanel.add(TeamSettingsPanel.this.serverField);
                        TeamSettingsPanel.this.locationPanel.add(TeamSettingsPanel.this.prefixLabel);
                        TeamSettingsPanel.this.locationPanel.add(TeamSettingsPanel.this.prefixField);
                        TeamSettingsPanel.this.locationPanel.add(TeamSettingsPanel.this.protocolLabel);
                        TeamSettingsPanel.this.locationPanel.add(TeamSettingsPanel.this.protocolComboBox);
                        TeamSettingsPanel.this.locationPanel.revalidate();
                        TeamSettingsPanel.this.groupLabel.setEnabled(true);
                        TeamSettingsPanel.this.groupField.setEnabled(true);
                    }
                }
                TeamSettingsPanel.this.checkOkEnabled();
                TeamSettingsPanel.this.teamSettingsDialog.pack();
            }
        });
        this.locationPanel.add(this.serverTypeLabel);
        this.locationPanel.add(this.serverTypeComboBox);
        this.locationPanel.add(this.serverLabel);
        this.locationPanel.add(this.serverField);
        this.locationPanel.add(this.prefixLabel);
        this.locationPanel.add(this.prefixField);
        this.locationPanel.add(this.protocolLabel);
        this.locationPanel.add(this.protocolComboBox);
        return this.locationPanel;
    }

    private void fillProtocolSelections() {
        int selected = this.serverTypeComboBox.getSelectedIndex();
        if (selected != this.selectedServerType) {
            this.selectedServerType = selected;
            this.protocolComboBox.removeAllItems();
            List<TeamworkProvider> teamProviders = this.teamSettingsController.getTeamworkProviders();
            TeamworkProvider provider = teamProviders.get(selected);
            String[] protocols = provider.getProtocols();
            for (int i = 0; i < protocols.length; ++i) {
                this.protocolComboBox.addItem(protocols[i]);
            }
        }
    }

    private void setupContent() {
        String useAsDefault;
        String group;
        String password;
        String yourEmail;
        String yourName;
        String user = this.teamSettingsController.getPropString("bluej.teamsettings.user");
        if (user != null) {
            this.setUser(user);
        }
        if ((yourName = this.teamSettingsController.getPropString("bluej.teamsettings.yourName")) != null) {
            this.setYourName(yourName);
        }
        if ((yourEmail = this.teamSettingsController.getPropString("bluej.teamsettings.yourEmail")) != null) {
            this.setYourEmail(yourEmail);
        }
        if ((password = this.teamSettingsController.getPasswordString()) != null) {
            this.setPassword(password);
        }
        if ((group = this.teamSettingsController.getPropString("bluej.teamsettings.groupname")) != null) {
            this.setGroup(group);
        }
        if ((useAsDefault = this.teamSettingsController.getPropString("bluej.teamsettings.useAsDefault")) != null) {
            this.setUseAsDefault(Boolean.getBoolean(useAsDefault));
        }
        String providerName = this.teamSettingsController.getPropString("bluej.teamsettings.vcs");
        List<TeamworkProvider> teamProviders = this.teamSettingsController.getTeamworkProviders();
        for (int index = 0; index < teamProviders.size(); ++index) {
            TeamworkProvider provider = teamProviders.get(index);
            if (!provider.getProviderName().equalsIgnoreCase(providerName) && (providerName != null || index != 0)) continue;
            this.serverTypeComboBox.setSelectedIndex(index);
            if (!provider.needsEmail() || this.teamSettingsController.getProject() == null) break;
            File respositoryRoot = this.teamSettingsController.getProject().getProjectDir();
            this.yourEmailField.setText(provider.getYourEmailFromRepo(respositoryRoot));
            this.yourEmailField.setEnabled(false);
            this.yourNameField.setText(provider.getYourNameFromRepo(respositoryRoot));
            this.yourNameField.setEnabled(false);
            this.useAsDefault.setSelected(true);
            break;
        }
        this.setProviderSettings();
    }

    private void setProviderSettings() {
        String server;
        String keyBase = "bluej.teamsettings." + this.getSelectedProvider().getProviderName().toLowerCase() + ".";
        String prefix = this.teamSettingsController.getPropString(keyBase + "repositoryPrefix");
        if (prefix != null) {
            this.setPrefix(prefix);
        }
        if ((server = this.teamSettingsController.getPropString(keyBase + "server")) != null) {
            this.setServer(server);
        }
        this.fillProtocolSelections();
        String protocol = this.readProtocolString();
        if (protocol != null) {
            this.setProtocol(protocol);
        }
    }

    private String readProtocolString() {
        String keyBase = "bluej.teamsettings." + this.getSelectedProvider().getProviderName().toLowerCase() + ".";
        return this.teamSettingsController.getPropString(keyBase + "protocol");
    }

    private void checkOkEnabled() {
        boolean newOkEnabled;
        boolean bl = newOkEnabled = this.userField.getText().length() != 0;
        if (this.yourEmailField.isEnabled() && this.yourNameField.isEnabled()) {
            newOkEnabled &= this.yourEmailField.getText().length() != 0 && this.yourEmailField.getText().contains("@");
            newOkEnabled &= this.yourNameField.getText().length() != 0;
        }
        newOkEnabled = this.uriField.isVisible() ? (newOkEnabled &= this.uriField.getText().length() != 0) : (newOkEnabled &= this.serverField.getText().length() != 0);
        if (newOkEnabled != this.okEnabled) {
            this.okEnabled = newOkEnabled;
            this.teamSettingsDialog.setOkButtonEnabled(this.okEnabled);
        }
    }

    private void setUser(String user) {
        this.userField.setText(user);
    }

    private void setYourName(String yourName) {
        this.yourNameField.setText(yourName);
    }

    private void setYourEmail(String yourEmail) {
        this.yourEmailField.setText(yourEmail);
    }

    private void setPassword(String password) {
        this.passwordField.setText(password);
    }

    private void setGroup(String group) {
        this.groupField.setText(group);
    }

    private void setPrefix(String prefix) {
        this.prefixField.setText(prefix);
    }

    private void setServer(String server) {
        this.serverField.setText(server);
    }

    private void setProtocol(String protocolKey) {
        String protocolLabel = this.getSelectedProvider().getProtocolLabel(protocolKey);
        this.protocolComboBox.setSelectedItem(protocolLabel);
    }

    private void setUseAsDefault(boolean use) {
        this.useAsDefault.setSelected(use);
    }

    public TeamworkProvider getSelectedProvider() {
        int selected = this.serverTypeComboBox.getSelectedIndex();
        return this.teamSettingsController.getTeamworkProviders().get(selected);
    }

    private String getUser() {
        return this.userField.getText();
    }

    private String getPassword() {
        return new String(this.passwordField.getPassword());
    }

    private String getGroup() {
        if (this.getSelectedProvider().needsEmail()) {
            return "";
        }
        return this.groupField.getText();
    }

    private String getPrefix() {
        if (this.getSelectedProvider().needsEmail()) {
            try {
                URI uri = new URI(this.uriField.getText());
                return uri.getPath();
            }
            catch (URISyntaxException ex) {
                return null;
            }
        }
        return this.prefixField.getText();
    }

    private String getServer() {
        if (this.getSelectedProvider().needsEmail()) {
            try {
                URI uri = new URI(this.uriField.getText());
                return uri.getHost();
            }
            catch (URISyntaxException ex) {
                return null;
            }
        }
        return this.serverField.getText();
    }

    private String getProtocolKey() {
        if (this.getSelectedProvider().needsEmail()) {
            try {
                URI uri = new URI(this.uriField.getText());
                return uri.getScheme();
            }
            catch (URISyntaxException ex) {
                return null;
            }
        }
        int protocol = this.protocolComboBox.getSelectedIndex();
        return this.getSelectedProvider().getProtocolKey(protocol);
    }

    public boolean getUseAsDefault() {
        return this.useAsDefault.isSelected();
    }

    private String getYourName() {
        return this.yourNameField.getText();
    }

    private String getYourEmail() {
        return this.yourEmailField.getText();
    }

    public TeamSettings getSettings() {
        TeamSettings result = new TeamSettings(this.getSelectedProvider(), this.getProtocolKey(), this.getServer(), this.getPrefix(), this.getGroup(), this.getUser(), this.getPassword());
        result.setYourEmail(this.getYourEmail());
        result.setYourName(this.getYourName());
        return result;
    }
}

