/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork.ui;

import bluej.Config;
import bluej.groupwork.TeamStatusInfo;
import bluej.groupwork.ui.ResourceDescriptor;
import bluej.pkgmgr.Project;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class StatusTableModel
extends AbstractTableModel {
    final String resourceLabel = Config.getString("team.status.resource");
    String statusLabel = Config.getString("team.status.status");
    final String remoteStatusLabel = Config.getString("team.status.remoteStatus");
    final String versionLabel = Config.getString("team.status.version");
    private Project project;
    private List<TeamStatusInfo> resources;

    public StatusTableModel(Project project, int initialRows) {
        this.project = project;
        this.resources = new ArrayList<TeamStatusInfo>();
        for (int i = 0; i < initialRows; ++i) {
            this.resources.add(new TeamStatusInfo());
        }
        this.statusLabel = project.getTeamSettingsController().isDVCS() ? Config.getString("team.status.status") : Config.getString("team.status");
    }

    @Override
    public String getColumnName(int col) {
        if (this.project.getTeamSettingsController().isDVCS()) {
            switch (col) {
                case 0: {
                    return this.resourceLabel;
                }
                case 1: {
                    return this.statusLabel;
                }
                case 2: {
                    return this.remoteStatusLabel;
                }
            }
        } else {
            switch (col) {
                case 0: {
                    return this.resourceLabel;
                }
                case 1: {
                    return this.versionLabel;
                }
                case 2: {
                    return this.statusLabel;
                }
            }
        }
        throw new IllegalArgumentException("bad column number in StatusTableModel::getColumnName()");
    }

    @Override
    public int getRowCount() {
        return this.resources.size();
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public Object getValueAt(int row, int col) {
        TeamStatusInfo info = this.resources.get(row);
        if (this.project.getTeamSettingsController().isDVCS()) {
            switch (col) {
                case 0: {
                    return ResourceDescriptor.getResource(this.project, info, false);
                }
                case 1: {
                    return info.getStatus();
                }
                case 2: {
                    return info.getRemoteStatus();
                }
            }
        } else {
            switch (col) {
                case 0: {
                    return ResourceDescriptor.getResource(this.project, info, false);
                }
                case 1: {
                    return info.getLocalVersion();
                }
                case 2: {
                    return info.getStatus();
                }
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
    }

    public void clear() {
        this.resources.clear();
        this.fireTableDataChanged();
    }

    public void setStatusData(List<TeamStatusInfo> statusResources) {
        this.resources = statusResources;
        this.fireTableDataChanged();
    }
}

