/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork.ui;

import bluej.Config;
import bluej.groupwork.TeamStatusInfo;
import bluej.pkgmgr.BlueJPackageFile;
import bluej.pkgmgr.Project;

public class ResourceDescriptor {
    public static String getResource(Project project, Object value, boolean annotate) {
        String status = value.toString();
        if (value instanceof TeamStatusInfo) {
            TeamStatusInfo info = (TeamStatusInfo)value;
            boolean isPkgFile = BlueJPackageFile.isPackageFileName(info.getFile().getName());
            if (isPkgFile) {
                status = Config.getString("team.commit.layout") + " " + project.getPackageForFile(info.getFile());
            }
            if (annotate) {
                int infoStatus = info.getStatus();
                switch (infoStatus) {
                    case 2: {
                        status = status + " (" + Config.getString("team.status.delete") + ")";
                        break;
                    }
                    case 6: {
                        status = status + " (" + Config.getString("team.status.add") + ")";
                        break;
                    }
                    case 1: {
                        status = status + " (" + Config.getString("team.status.new") + ")";
                        break;
                    }
                    case 7: 
                    case 13: {
                        status = status + " (" + Config.getString("team.status.removed") + ")";
                        break;
                    }
                    case 5: {
                        if (isPkgFile) break;
                        status = status + " (" + Config.getString("team.status.needsmerge") + ")";
                        break;
                    }
                }
                if (!(info.getRemoteStatus() != 1 && info.getRemoteStatus() != 2 || isPkgFile)) {
                    status = status + "(" + Config.getString("team.status.needsupdate") + ")";
                }
            }
        }
        return status;
    }

    public static String getDCVSResource(Project project, Object value, boolean annotate, boolean remote) {
        String status = value.toString();
        if (value instanceof TeamStatusInfo) {
            TeamStatusInfo info = (TeamStatusInfo)value;
            boolean isPkgFile = BlueJPackageFile.isPackageFileName(info.getFile().getName());
            if (isPkgFile) {
                status = Config.getString("team.commit.layout") + " " + project.getPackageForFile(info.getFile());
            }
            if (annotate) {
                int infoStatus = remote ? info.getRemoteStatus() : info.getStatus();
                switch (infoStatus) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 6: 
                    case 7: 
                    case 13: {
                        status = status + " (" + TeamStatusInfo.getDCVSStatusString(infoStatus, remote) + ")";
                        break;
                    }
                    case 5: {
                        if (isPkgFile) break;
                        status = status + " (" + TeamStatusInfo.getDCVSStatusString(infoStatus, remote) + ")";
                        break;
                    }
                }
            }
        }
        return status;
    }
}

