/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork.ui;

import bluej.BlueJTheme;
import bluej.Config;
import bluej.groupwork.CommitFilter;
import bluej.groupwork.Repository;
import bluej.groupwork.StatusHandle;
import bluej.groupwork.StatusListener;
import bluej.groupwork.TeamStatusInfo;
import bluej.groupwork.TeamUtils;
import bluej.groupwork.TeamworkCommand;
import bluej.groupwork.TeamworkCommandResult;
import bluej.groupwork.actions.CommitAction;
import bluej.groupwork.actions.PushAction;
import bluej.groupwork.ui.ActivityIndicator;
import bluej.groupwork.ui.CommitAndPushInterface;
import bluej.groupwork.ui.FileRenderer;
import bluej.pkgmgr.BlueJPackageFile;
import bluej.pkgmgr.Project;
import bluej.utility.DBox;
import bluej.utility.DBoxLayout;
import bluej.utility.DialogManager;
import bluej.utility.SwingWorker;
import bluej.utility.Utility;
import bluej.utility.javafx.SwingNodeDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javafx.application.Platform;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import threadchecker.OnThread;
import threadchecker.Tag;

public class CommitAndPushFrame
extends SwingNodeDialog
implements CommitAndPushInterface {
    private final Project project;
    private Set<TeamStatusInfo> changedLayoutFiles;
    private Repository repository;
    private JPanel topPanel;
    private JPanel middlePanel;
    private JPanel bottomPanel;
    private ActivityIndicator progressBar;
    private JCheckBox includeLayout;
    private JTextArea commitText;
    private JList commitFiles;
    private JList pushFiles;
    private DefaultListModel commitListModel;
    private DefaultListModel pushListModel;
    private JButton commitButton;
    private JButton pushButton;
    private CommitAction commitAction;
    private PushAction pushAction;
    private CommitAndPushWorker commitAndPushWorker;
    private boolean emptyCommitText = true;
    private boolean pushWithNoChanges = false;
    private static final String noFilesToCommit = Config.getString("team.nocommitfiles");
    private static final String noFilesToPush = Config.getString("team.nopushfiles");
    private static final String pushNeeded = Config.getString("team.pushNeeded");

    public CommitAndPushFrame(Project proj) {
        this.project = proj;
        this.changedLayoutFiles = new HashSet<TeamStatusInfo>();
        this.repository = this.project.getTeamSettingsController().getRepository(false);
        this.createUI();
        DialogManager.centreDialog(this);
    }

    protected void createUI() {
        this.setTitle(Config.getString("team.commit.dcvs.title"));
        this.commitListModel = new DefaultListModel();
        this.pushListModel = new DefaultListModel();
        this.rememberPosition("bluej.commitdisplay");
        this.topPanel = new JPanel();
        this.topPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        JPanel windowPanel = new JPanel();
        windowPanel.setBorder(BlueJTheme.generalBorder);
        JScrollPane commitFileScrollPane = new JScrollPane();
        this.topPanel.setLayout(new BorderLayout());
        windowPanel.setLayout(new BorderLayout());
        this.topPanel.setBorder(BorderFactory.createEmptyBorder());
        JLabel commitFilesLabel = new JLabel(Config.getString("team.commitPush.commit.files"));
        commitFilesLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        this.topPanel.add((Component)commitFilesLabel, "North");
        this.commitFiles = new JList(this.commitListModel);
        this.commitFiles.setVisibleRowCount(4);
        this.commitFiles.setCellRenderer(new FileRenderer(this.project, false));
        this.commitFiles.setEnabled(false);
        commitFileScrollPane.setViewportView(this.commitFiles);
        this.commitFiles.setMaximumSize(this.commitFiles.getMaximumSize());
        this.commitFiles.setMinimumSize(this.commitFiles.getMaximumSize());
        this.commitFiles.setBackground(new Color(windowPanel.getBackground().getRGB()));
        this.topPanel.add((Component)commitFileScrollPane, "Center");
        windowPanel.add((Component)this.topPanel, "North");
        this.middlePanel = new JPanel();
        JButton closeButton = BlueJTheme.getCancelButton();
        closeButton.setText(Config.getString("close"));
        Platform.runLater(() -> this.setCloseIsButton(closeButton));
        this.middlePanel.setLayout(new BorderLayout());
        this.middlePanel.setBorder(BorderFactory.createEmptyBorder());
        JLabel commentLabel = new JLabel(Config.getString("team.commit.comment"));
        commentLabel.setBorder(BorderFactory.createEmptyBorder(10, 0, 5, 0));
        this.middlePanel.add((Component)commentLabel, "North");
        this.commitText = new JTextArea("");
        this.commitText.setRows(5);
        this.commitText.setColumns(35);
        Dimension size = this.commitText.getPreferredSize();
        size.width = this.commitText.getMinimumSize().width;
        this.commitText.setMinimumSize(size);
        this.commitText.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                CommitAndPushFrame.this.emptyCommitText = false;
                if (CommitAndPushFrame.this.commitText.isEnabled()) {
                    CommitAndPushFrame.this.commitAction.setEnabled(!CommitAndPushFrame.this.emptyCommitText);
                }
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                CommitAndPushFrame.this.emptyCommitText = CommitAndPushFrame.this.commitText.getText().isEmpty();
                if (CommitAndPushFrame.this.commitText.isEnabled()) {
                    CommitAndPushFrame.this.commitAction.setEnabled(!CommitAndPushFrame.this.emptyCommitText);
                }
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                CommitAndPushFrame.this.emptyCommitText = CommitAndPushFrame.this.commitText.getText().isEmpty();
                if (CommitAndPushFrame.this.commitText.isEnabled()) {
                    CommitAndPushFrame.this.commitAction.setEnabled(!CommitAndPushFrame.this.emptyCommitText);
                }
            }
        });
        JScrollPane commitTextScrollPane = new JScrollPane(this.commitText);
        commitTextScrollPane.setMinimumSize(size);
        this.middlePanel.add((Component)commitTextScrollPane, "Center");
        this.commitAction = new CommitAction(this);
        this.commitButton = BlueJTheme.getOkButton();
        this.commitButton.setAction(this.commitAction);
        this.pushAction = new PushAction(this);
        this.pushButton = BlueJTheme.getOkButton();
        this.pushButton.setAction(this.pushAction);
        closeButton.addActionListener(e -> {
            this.commitAndPushWorker.abort();
            this.commitAction.cancel();
            this.setVisible(false);
        });
        DBox middleBox = new DBox(DBoxLayout.X_AXIS, 0, 5, 0.0f);
        middleBox.setBorder(BlueJTheme.generalBorder);
        DBox checkBoxPanel = new DBox(DBoxLayout.Y_AXIS, 0, 5, 0.0f);
        checkBoxPanel.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 10));
        this.includeLayout = new JCheckBox(Config.getString("team.commit.includelayout"));
        this.includeLayout.setEnabled(false);
        this.includeLayout.addActionListener(e -> {
            JCheckBox layoutCheck = (JCheckBox)e.getSource();
            if (layoutCheck.isSelected()) {
                this.addModifiedLayouts();
                if (!this.commitButton.isEnabled()) {
                    this.commitAction.setEnabled(!this.emptyCommitText);
                }
            } else {
                this.removeModifiedLayouts();
                if (this.isCommitListEmpty()) {
                    this.commitAction.setEnabled(false);
                }
            }
        });
        checkBoxPanel.add(this.includeLayout);
        JPanel commitArea = new JPanel(new BorderLayout());
        commitArea.setBorder(BorderFactory.createEmptyBorder(6, 0, 4, 6));
        commitArea.add((Component)this.commitButton, "East");
        middleBox.add(checkBoxPanel);
        middleBox.add(commitArea);
        this.middlePanel.add((Component)middleBox, "South");
        this.topPanel.add((Component)this.middlePanel, "South");
        this.bottomPanel = new JPanel();
        this.bottomPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        JScrollPane pushFileScrollPane = new JScrollPane();
        this.bottomPanel.setLayout(new BorderLayout());
        JLabel pushFilesLabel = new JLabel(Config.getString("team.commitPush.push.files"));
        pushFilesLabel.setBorder(BorderFactory.createEmptyBorder(6, 0, 5, 0));
        this.bottomPanel.add((Component)pushFilesLabel, "North");
        this.pushFiles = new JList(this.pushListModel);
        this.pushFiles.setCellRenderer(new FileRenderer(this.project, true));
        this.pushFiles.setEnabled(false);
        this.pushFiles.setVisibleRowCount(4);
        pushFileScrollPane.setViewportView(this.pushFiles);
        this.pushFiles.setBackground(new Color(this.bottomPanel.getBackground().getRGB()));
        this.bottomPanel.add((Component)pushFileScrollPane, "Center");
        DBox pushButtonPanel = new DBox(DBoxLayout.X_AXIS, 0, 5, 0.5f);
        pushButtonPanel.setBorder(BlueJTheme.generalBorderWithStatusBar);
        this.progressBar = new ActivityIndicator();
        this.progressBar.setRunning(false);
        pushButtonPanel.add(this.progressBar);
        pushButtonPanel.add(this.pushButton);
        pushButtonPanel.add(closeButton);
        this.bottomPanel.add((Component)pushButtonPanel, "South");
        JSeparator separator = new JSeparator(0);
        separator.setForeground(Color.black);
        windowPanel.add((Component)separator, "Center");
        windowPanel.add((Component)this.bottomPanel, "South");
        this.getContentPane().add(windowPanel);
        this.pack();
    }

    @Override
    public void setVisible(boolean show) {
        if (show) {
            this.commitAction.setEnabled(false);
            this.commitText.setEnabled(false);
            this.commitText.setText("");
            this.includeLayout.setSelected(false);
            this.includeLayout.setEnabled(false);
            this.changedLayoutFiles.clear();
            this.commitListModel.removeAllElements();
            this.pushAction.setEnabled(false);
            this.pushListModel.removeAllElements();
            this.repository = this.project.getTeamSettingsController().getRepository(false);
            if (this.repository != null) {
                block5: {
                    try {
                        this.project.saveAllEditors();
                        this.project.saveAll();
                    }
                    catch (IOException ioe) {
                        String msg = DialogManager.getMessage("team-error-saving-project", new String[0]);
                        if (msg == null) break block5;
                        String msgFinal = msg = Utility.mergeStrings(msg, ioe.getLocalizedMessage());
                        Platform.runLater(() -> DialogManager.showErrorTextFX(this.asWindow(), msgFinal));
                    }
                }
                this.startProgress();
                this.commitAndPushWorker = new CommitAndPushWorker();
                this.commitAndPushWorker.start();
            } else {
                super.setVisible(false);
            }
        }
        super.setVisible(show);
    }

    public void setComment(String newComment) {
        this.commitText.setText(newComment);
    }

    @Override
    public void reset() {
        this.commitListModel.clear();
        this.pushListModel.clear();
        this.setComment("");
    }

    private void removeModifiedLayouts() {
        for (TeamStatusInfo info : this.changedLayoutFiles) {
            this.commitListModel.removeElement(info);
        }
        if (this.commitListModel.isEmpty()) {
            this.commitListModel.addElement(noFilesToCommit);
            this.commitText.setEnabled(false);
        }
    }

    private boolean isCommitListEmpty() {
        return this.commitListModel.isEmpty() || this.commitListModel.contains(noFilesToCommit);
    }

    @Override
    public String getComment() {
        return this.commitText.getText();
    }

    @Override
    public Set<File> getChangedLayoutFiles() {
        HashSet<File> files = new HashSet<File>();
        this.changedLayoutFiles.stream().forEach(info -> files.add(info.getFile()));
        return files;
    }

    private void removeChangedLayoutFile(File file) {
        Iterator<TeamStatusInfo> it = this.changedLayoutFiles.iterator();
        while (it.hasNext()) {
            TeamStatusInfo info = it.next();
            if (!info.getFile().equals(file)) continue;
            it.remove();
            return;
        }
    }

    @Override
    public Set<TeamStatusInfo> getChangedLayoutInfo() {
        return this.changedLayoutFiles;
    }

    @Override
    public boolean includeLayout() {
        return this.includeLayout != null && this.includeLayout.isSelected();
    }

    private void addModifiedLayouts() {
        if (this.commitListModel.contains(noFilesToCommit)) {
            this.commitListModel.removeElement(noFilesToCommit);
            this.commitText.setEnabled(true);
        }
        HashSet<File> displayedLayouts = new HashSet<File>();
        for (TeamStatusInfo info : this.changedLayoutFiles) {
            File parentFile = info.getFile().getParentFile();
            if (displayedLayouts.contains(parentFile)) continue;
            this.commitListModel.addElement(info);
            displayedLayouts.add(info.getFile().getParentFile());
        }
    }

    @Override
    public void startProgress() {
        this.progressBar.setRunning(true);
    }

    @Override
    public void stopProgress() {
        this.progressBar.setRunning(false);
    }

    @Override
    public Project getProject() {
        return this.project;
    }

    private void setLayoutChanged(boolean hasChanged) {
        this.includeLayout.setEnabled(hasChanged);
    }

    @Override
    public void displayMessage(String msg) {
        this.progressBar.setMessage(msg);
    }

    class CommitAndPushWorker
    extends SwingWorker
    implements StatusListener {
        List<TeamStatusInfo> response = new ArrayList<TeamStatusInfo>();
        TeamworkCommand command;
        TeamworkCommandResult result;
        private boolean aborted;
        private boolean isPushAvailable;

        public CommitAndPushWorker() {
            FileFilter filter = CommitAndPushFrame.this.project.getTeamSettingsController().getFileFilter(true, false);
            this.command = CommitAndPushFrame.this.repository.getStatus(this, filter, false);
        }

        public boolean isPushAvailable() {
            return this.isPushAvailable;
        }

        @Override
        @OnThread(value=Tag.Any)
        public void gotStatus(TeamStatusInfo info) {
            this.response.add(info);
        }

        @Override
        @OnThread(value=Tag.Any)
        public void statusComplete(StatusHandle statusHandle) {
            CommitAndPushFrame.this.commitAction.setStatusHandle(statusHandle);
            CommitAndPushFrame.this.pushWithNoChanges = statusHandle.pushNeeded();
            CommitAndPushFrame.this.pushAction.setStatusHandle(statusHandle);
        }

        @Override
        @OnThread(value=Tag.Unique)
        public Object construct() {
            this.result = this.command.getResult();
            return this.response;
        }

        public void abort() {
            this.command.cancel();
            this.aborted = true;
        }

        @Override
        public void finished() {
            CommitAndPushFrame.this.stopProgress();
            if (!this.aborted) {
                if (this.result.isError()) {
                    CommitAndPushFrame.this.dialogThenHide(() -> TeamUtils.handleServerResponseFX(this.result, CommitAndPushFrame.this.asWindow()));
                } else if (this.response != null) {
                    boolean conflicts;
                    HashSet<File> filesToCommit = new HashSet<File>();
                    LinkedHashSet<File> filesToAdd = new LinkedHashSet<File>();
                    HashSet<File> filesToDelete = new HashSet<File>();
                    HashSet<File> mergeConflicts = new HashSet<File>();
                    HashSet<File> deleteConflicts = new HashSet<File>();
                    HashSet<File> otherConflicts = new HashSet<File>();
                    HashSet<File> needsMerge = new HashSet<File>();
                    HashSet<File> modifiedLayoutFiles = new HashSet<File>();
                    List<TeamStatusInfo> info = this.response;
                    this.getCommitFileSets(info, filesToCommit, filesToAdd, filesToDelete, mergeConflicts, deleteConflicts, otherConflicts, needsMerge, modifiedLayoutFiles, false);
                    if (!(mergeConflicts.isEmpty() && deleteConflicts.isEmpty() && otherConflicts.isEmpty() && needsMerge.isEmpty())) {
                        this.handleConflicts(mergeConflicts, deleteConflicts, otherConflicts, needsMerge);
                        return;
                    }
                    CommitAndPushFrame.this.commitAction.setFiles(filesToCommit);
                    CommitAndPushFrame.this.commitAction.setNewFiles(filesToAdd);
                    CommitAndPushFrame.this.commitAction.setDeletedFiles(filesToDelete);
                    this.updateListModel(CommitAndPushFrame.this.commitListModel, filesToCommit, info);
                    this.updateListModel(CommitAndPushFrame.this.commitListModel, filesToAdd, info);
                    this.updateListModel(CommitAndPushFrame.this.commitListModel, filesToDelete, info);
                    HashSet<File> filesToCommitInPush = new HashSet<File>();
                    HashSet<File> filesToAddInPush = new HashSet<File>();
                    HashSet<File> filesToDeleteInPush = new HashSet<File>();
                    HashSet<File> mergeConflictsInPush = new HashSet<File>();
                    HashSet<File> deleteConflictsInPush = new HashSet<File>();
                    HashSet<File> otherConflictsInPush = new HashSet<File>();
                    HashSet<File> needsMergeInPush = new HashSet<File>();
                    HashSet<File> modifiedLayoutFilesInPush = new HashSet<File>();
                    this.getCommitFileSets(info, filesToCommitInPush, filesToAddInPush, filesToDeleteInPush, mergeConflictsInPush, deleteConflictsInPush, otherConflictsInPush, needsMergeInPush, modifiedLayoutFilesInPush, true);
                    this.updateListModel(CommitAndPushFrame.this.pushListModel, filesToCommitInPush, info);
                    this.updateListModel(CommitAndPushFrame.this.pushListModel, filesToAddInPush, info);
                    this.updateListModel(CommitAndPushFrame.this.pushListModel, filesToDeleteInPush, info);
                    this.updateListModel(CommitAndPushFrame.this.pushListModel, modifiedLayoutFilesInPush, info);
                    this.isPushAvailable = CommitAndPushFrame.this.pushWithNoChanges || !filesToCommitInPush.isEmpty() || !filesToAddInPush.isEmpty() || !filesToDeleteInPush.isEmpty() || !modifiedLayoutFilesInPush.isEmpty();
                    CommitAndPushFrame.this.pushAction.setEnabled(this.isPushAvailable);
                    boolean bl = conflicts = !mergeConflictsInPush.isEmpty() || !deleteConflictsInPush.isEmpty() || !otherConflictsInPush.isEmpty() || !needsMergeInPush.isEmpty();
                    if (!CommitAndPushFrame.this.commitAction.isEnabled() && conflicts) {
                        HashSet<File> conflictingFilesInPush = new HashSet<File>();
                        conflictingFilesInPush.addAll(mergeConflictsInPush);
                        conflictingFilesInPush.addAll(deleteConflictsInPush);
                        conflictingFilesInPush.addAll(otherConflictsInPush);
                        conflictingFilesInPush.addAll(needsMergeInPush);
                        for (File conflictEntry : conflictingFilesInPush) {
                            if (filesToCommit.contains(conflictEntry)) {
                                conflictingFilesInPush.remove(conflictEntry);
                                mergeConflictsInPush.remove(conflictEntry);
                                deleteConflictsInPush.remove(conflictEntry);
                                otherConflictsInPush.remove(conflictEntry);
                                needsMergeInPush.remove(conflictEntry);
                            }
                            if (filesToAdd.contains(conflictEntry)) {
                                conflictingFilesInPush.remove(conflictEntry);
                                mergeConflictsInPush.remove(conflictEntry);
                                deleteConflictsInPush.remove(conflictEntry);
                                otherConflictsInPush.remove(conflictEntry);
                                needsMergeInPush.remove(conflictEntry);
                            }
                            if (!filesToDelete.contains(conflictEntry)) continue;
                            conflictingFilesInPush.remove(conflictEntry);
                            mergeConflictsInPush.remove(conflictEntry);
                            deleteConflictsInPush.remove(conflictEntry);
                            otherConflictsInPush.remove(conflictEntry);
                            needsMergeInPush.remove(conflictEntry);
                        }
                        boolean bl2 = conflicts = !conflictingFilesInPush.isEmpty();
                    }
                    if (!CommitAndPushFrame.this.commitAction.isEnabled() && conflicts) {
                        this.handleConflicts(mergeConflictsInPush, deleteConflictsInPush, otherConflictsInPush, null);
                        return;
                    }
                }
                if (CommitAndPushFrame.this.commitListModel.isEmpty()) {
                    CommitAndPushFrame.this.commitListModel.addElement(noFilesToCommit);
                } else {
                    CommitAndPushFrame.this.commitText.setEnabled(true);
                    CommitAndPushFrame.this.commitText.requestFocusInWindow();
                    CommitAndPushFrame.this.commitAction.setEnabled(!CommitAndPushFrame.this.emptyCommitText);
                }
                if (CommitAndPushFrame.this.pushListModel.isEmpty()) {
                    if (this.isPushAvailable) {
                        CommitAndPushFrame.this.pushListModel.addElement(pushNeeded);
                    } else {
                        CommitAndPushFrame.this.pushListModel.addElement(noFilesToPush);
                    }
                }
            }
        }

        private void handleConflicts(Set<File> mergeConflicts, Set<File> deleteConflicts, Set<File> otherConflicts, Set<File> needsMerge) {
            String filesList;
            String dlgLabel;
            if (!mergeConflicts.isEmpty()) {
                dlgLabel = "team-resolve-merge-conflicts";
                filesList = this.buildConflictsList(mergeConflicts);
            } else if (!deleteConflicts.isEmpty()) {
                dlgLabel = "team-resolve-conflicts-delete";
                filesList = this.buildConflictsList(deleteConflicts);
            } else if (!otherConflicts.isEmpty()) {
                dlgLabel = "team-update-first";
                filesList = this.buildConflictsList(otherConflicts);
            } else {
                CommitAndPushFrame.this.stopProgress();
                CommitAndPushFrame.this.dialogThenHide(() -> DialogManager.showMessageFX(CommitAndPushFrame.this.asWindow(), "team-uptodate-failed"));
                return;
            }
            CommitAndPushFrame.this.stopProgress();
            CommitAndPushFrame.this.dialogThenHide(() -> DialogManager.showMessageWithTextFX(CommitAndPushFrame.this.asWindow(), dlgLabel, filesList));
        }

        private String buildConflictsList(Set<File> conflicts) {
            String filesList = "";
            Iterator<File> i = conflicts.iterator();
            for (int j = 0; j < 10 && i.hasNext(); ++j) {
                File conflictFile = i.next();
                filesList = filesList + "    " + conflictFile.getName() + "\n";
            }
            if (i.hasNext()) {
                filesList = filesList + "    " + Config.getString("team.commit.moreFiles");
            }
            return filesList;
        }

        private void getCommitFileSets(List<TeamStatusInfo> info, Set<File> filesToCommit, Set<File> filesToAdd, Set<File> filesToRemove, Set<File> mergeConflicts, Set<File> deleteConflicts, Set<File> otherConflicts, Set<File> needsMerge, Set<File> modifiedLayoutFiles, boolean remote) {
            CommitFilter filter = new CommitFilter();
            HashMap<File, File> modifiedLayoutDirs = new HashMap<File, File>();
            for (TeamStatusInfo statusInfo : info) {
                File file = statusInfo.getFile();
                boolean isPkgFile = BlueJPackageFile.isPackageFileName(file.getName());
                int status = remote ? statusInfo.getRemoteStatus() : statusInfo.getStatus();
                if (filter.accept(statusInfo, !remote)) {
                    if (!isPkgFile) {
                        filesToCommit.add(file);
                    } else if (status == 6 || status == 2 || status == 14) {
                        File otherPkgFile;
                        if (filesToCommit.add(statusInfo.getFile().getParentFile()) && (otherPkgFile = (File)modifiedLayoutDirs.remove(file.getParentFile())) != null) {
                            CommitAndPushFrame.this.removeChangedLayoutFile(otherPkgFile);
                            filesToCommit.add(otherPkgFile);
                        }
                        filesToCommit.add(statusInfo.getFile());
                    } else {
                        File parentFile = file.getParentFile();
                        if (!filesToCommit.contains(parentFile)) {
                            modifiedLayoutFiles.add(file);
                            modifiedLayoutDirs.put(parentFile, file);
                            CommitAndPushFrame.this.changedLayoutFiles.add(statusInfo);
                        } else {
                            filesToCommit.add(file);
                        }
                    }
                    if (status == 6) {
                        filesToAdd.add(statusInfo.getFile());
                        continue;
                    }
                    if (status != 2 && status != 14) continue;
                    filesToRemove.add(statusInfo.getFile());
                    continue;
                }
                if (isPkgFile) continue;
                if (status == 9) {
                    mergeConflicts.add(statusInfo.getFile());
                }
                if (status == 8 || status == 12 || status == 13) {
                    deleteConflicts.add(statusInfo.getFile());
                }
                if (status == 14) {
                    otherConflicts.add(statusInfo.getFile());
                }
                if (status != 5) continue;
                needsMerge.add(statusInfo.getFile());
            }
            if (!remote) {
                CommitAndPushFrame.this.setLayoutChanged(!CommitAndPushFrame.this.changedLayoutFiles.isEmpty());
            }
        }

        private void updateListModel(DefaultListModel listModel, Set<File> fileSet, List<TeamStatusInfo> info) {
            fileSet.stream().map(f -> this.getTeamStatusInfoFromFile((File)f, info)).filter(tsi -> !listModel.contains(tsi)).forEach(tsi -> {
                if (tsi != null) {
                    listModel.addElement(tsi);
                }
            });
        }

        private TeamStatusInfo getTeamStatusInfoFromFile(File f, List<TeamStatusInfo> info) {
            if (f != null && !info.isEmpty()) {
                for (TeamStatusInfo item : info) {
                    if (!item.getFile().equals(f)) continue;
                    return item;
                }
            }
            return null;
        }
    }
}

