/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork.git;

import bluej.groupwork.StatusListener;
import bluej.groupwork.TeamStatusInfo;
import bluej.groupwork.TeamworkCommandError;
import bluej.groupwork.TeamworkCommandResult;
import bluej.groupwork.git.GitCommand;
import bluej.groupwork.git.GitFetchCommand;
import bluej.groupwork.git.GitRepository;
import bluej.groupwork.git.GitStatusHandle;
import bluej.groupwork.git.GitTreeException;
import bluej.groupwork.git.GitUtillities;
import bluej.utility.Debug;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.errors.NoWorkTreeException;
import org.eclipse.jgit.lib.IndexDiff;
import org.eclipse.jgit.revwalk.RevCommit;

public class GitStatusCommand
extends GitCommand {
    StatusListener listener;
    FileFilter filter;
    boolean includeRemote;

    public GitStatusCommand(GitRepository repository, StatusListener listener, FileFilter filter, boolean includeRemote) {
        super(repository);
        this.listener = listener;
        this.filter = filter;
        this.includeRemote = includeRemote;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public TeamworkCommandResult getResult() {
        boolean didFilesChange = true;
        LinkedList<TeamStatusInfo> returnInfo = new LinkedList<TeamStatusInfo>();
        File gitPath = this.getRepository().getProjectPath();
        try (Git repo = Git.open((File)this.getRepository().getProjectPath());){
            GitFetchCommand fetchCommand;
            TeamworkCommandResult fetchResult;
            Status s = repo.status().call();
            s.getMissing().stream().filter(p -> this.filter.accept(new File(gitPath, (String)p))).map(item -> new TeamStatusInfo(new File(gitPath, (String)item), "", null, 2)).forEach(teamInfo -> returnInfo.add((TeamStatusInfo)teamInfo));
            s.getUncommittedChanges().stream().filter(p -> this.filter.accept(new File(gitPath, (String)p))).map(item -> new TeamStatusInfo(new File(gitPath, (String)item), "", null, 4)).forEach(teamInfo -> {
                TeamStatusInfo existingStatusInfo = this.getTeamStatusInfo(returnInfo, teamInfo.getFile());
                if (existingStatusInfo == null) {
                    returnInfo.add((TeamStatusInfo)teamInfo);
                }
            });
            s.getUntracked().stream().filter(p -> this.filter.accept(new File(gitPath, (String)p))).map(item -> new TeamStatusInfo(new File(gitPath, (String)item), "", null, 6)).forEach(teamInfo -> returnInfo.add((TeamStatusInfo)teamInfo));
            s.getUntrackedFolders().stream().filter(p -> this.filter.accept(new File(gitPath, (String)p))).map(item -> new TeamStatusInfo(new File(gitPath, (String)item), "", null, 6)).forEach(teamInfo -> returnInfo.add((TeamStatusInfo)teamInfo));
            s.getRemoved().stream().filter(p -> this.filter.accept(new File(gitPath, (String)p))).map(item -> new TeamStatusInfo(new File(gitPath, (String)item), "", null, 7)).forEach(teamInfo -> returnInfo.add((TeamStatusInfo)teamInfo));
            s.getConflicting().stream().filter(p -> this.filter.accept(new File(gitPath, (String)p))).map(item -> new TeamStatusInfo(new File(gitPath, (String)item), "", null, 5)).forEach(teamInfo -> {
                TeamStatusInfo existingStatusInfo = this.getTeamStatusInfo(returnInfo, teamInfo.getFile());
                if (existingStatusInfo == null) {
                    returnInfo.add((TeamStatusInfo)teamInfo);
                }
            });
            Map conflictsMap = s.getConflictingStageState();
            conflictsMap.keySet().stream().forEach(key -> {
                File f = new File(gitPath, (String)key);
                TeamStatusInfo statusInfo = this.getTeamStatusInfo(returnInfo, f);
                if (statusInfo == null) {
                    statusInfo = new TeamStatusInfo(f, "", null, 11);
                }
                IndexDiff.StageState state = (IndexDiff.StageState)conflictsMap.get(key);
                switch (state) {
                    case DELETED_BY_THEM: {
                        if (statusInfo.getStatus() == 11) {
                            statusInfo.setStatus(13);
                            break;
                        }
                        if (statusInfo.getStatus() != 4 || statusInfo.getFile().exists()) break;
                        statusInfo.setStatus(2);
                        break;
                    }
                    case DELETED_BY_US: {
                        if (statusInfo.getStatus() == 11) {
                            statusInfo.setStatus(14);
                            break;
                        }
                        if (statusInfo.getFile().exists()) break;
                        statusInfo.setStatus(2);
                        break;
                    }
                    case BOTH_ADDED: {
                        statusInfo.setStatus(12);
                        break;
                    }
                    case BOTH_MODIFIED: {
                        if (statusInfo.getStatus() == 4) break;
                        statusInfo.setStatus(5);
                    }
                }
            });
            if (this.includeRemote && (fetchResult = (fetchCommand = new GitFetchCommand(this.getRepository())).getResult()).isError()) {
                TeamworkCommandResult teamworkCommandResult = fetchResult;
                return teamworkCommandResult;
            }
            RevCommit forkPoint = GitUtillities.findForkPoint(repo.getRepository(), "origin/master", "HEAD");
            List<DiffEntry> listOfDiffsLocal = GitUtillities.getDiffs(repo, "HEAD", forkPoint);
            List<DiffEntry> listOfDiffsRemote = GitUtillities.getDiffs(repo, "origin/master", forkPoint);
            this.updateRemoteStatus(gitPath, listOfDiffsLocal, listOfDiffsRemote, returnInfo);
            if (returnInfo.isEmpty()) {
                didFilesChange = false;
            }
            this.addUpToDateFiles(returnInfo, gitPath);
            if (this.listener == null) return new TeamworkCommandResult();
            while (!returnInfo.isEmpty()) {
                TeamStatusInfo teamInfo2 = returnInfo.removeFirst();
                this.listener.gotStatus(teamInfo2);
            }
            this.listener.statusComplete(new GitStatusHandle(this.getRepository(), didFilesChange && GitUtillities.isAheadOnly(repo), didFilesChange && GitUtillities.getBehindCount(repo) > 0));
            return new TeamworkCommandResult();
        }
        catch (GitTreeException | IOException | GitAPIException | NoWorkTreeException ex) {
            Debug.reportError("Git status command exception", ex);
            return new TeamworkCommandError(ex.getMessage(), ex.getLocalizedMessage());
        }
    }

    private void addUpToDateFiles(LinkedList<TeamStatusInfo> returnInfo, File gitPath) {
        for (File item : gitPath.listFiles()) {
            TeamStatusInfo itemStatus;
            if (!this.filter.accept(item) || (itemStatus = this.getTeamStatusInfo(returnInfo, item)) != null) continue;
            returnInfo.add(new TeamStatusInfo(item, "", null, 0, 0));
        }
    }

    private TeamStatusInfo getTeamStatusInfo(LinkedList<TeamStatusInfo> returnInfo, File file) {
        try {
            return returnInfo.stream().filter(entry -> entry.getFile().getPath().contains(file.getPath())).findFirst().get();
        }
        catch (Exception e) {
            return null;
        }
    }

    private Optional<DiffEntry> getDiffFromList(List<DiffEntry> list, DiffEntry entry) {
        String entryFileName = GitUtillities.getFileNameFromDiff(entry);
        Optional<DiffEntry> result = list.stream().filter(p -> GitUtillities.getFileNameFromDiff(p).equals(entryFileName)).findFirst();
        return result;
    }

    private void updateRemoteStatus(LinkedList<TeamStatusInfo> returnInfo, File file, int remoteStatus) {
        TeamStatusInfo entry = this.getTeamStatusInfo(returnInfo, file);
        if (entry != null) {
            entry.setRemoteStatus(remoteStatus);
        } else {
            entry = new TeamStatusInfo(file, "", null, 0, remoteStatus);
            returnInfo.add(entry);
        }
    }

    private void updateRemoteStatus(File gitPath, List<DiffEntry> listOfDiffsLocal, List<DiffEntry> listOfDiffsRemote, LinkedList<TeamStatusInfo> returnInfo) {
        for (DiffEntry localDiffItem : listOfDiffsLocal) {
            File file = new File(gitPath, GitUtillities.getFileNameFromDiff(localDiffItem));
            switch (localDiffItem.getChangeType()) {
                case MODIFY: {
                    this.updateRemoteStatus(returnInfo, file, 4);
                    break;
                }
                case DELETE: {
                    this.updateRemoteStatus(returnInfo, file, 2);
                    break;
                }
                case ADD: {
                    this.updateRemoteStatus(returnInfo, file, 6);
                }
            }
        }
        for (DiffEntry remoteDiffItem : listOfDiffsRemote) {
            Optional<DiffEntry> localDiffItem = this.getDiffFromList(listOfDiffsLocal, remoteDiffItem);
            File file = new File(gitPath, GitUtillities.getFileNameFromDiff(remoteDiffItem));
            block5 : switch (remoteDiffItem.getChangeType()) {
                case MODIFY: {
                    if (localDiffItem.isPresent()) {
                        TeamStatusInfo entry = this.getTeamStatusInfo(returnInfo, file);
                        switch (localDiffItem.get().getChangeType()) {
                            case MODIFY: {
                                if (entry == null) {
                                    this.updateRemoteStatus(returnInfo, file, 16);
                                    break block5;
                                }
                                this.updateRemoteStatus(returnInfo, file, 5);
                                break block5;
                            }
                            case DELETE: {
                                this.updateRemoteStatus(returnInfo, file, 14);
                                break block5;
                            }
                            case ADD: {
                                this.updateRemoteStatus(returnInfo, file, 12);
                            }
                        }
                        break;
                    }
                    this.updateRemoteStatus(returnInfo, file, 3);
                    break;
                }
                case DELETE: {
                    if (localDiffItem.isPresent()) {
                        switch (localDiffItem.get().getChangeType()) {
                            case MODIFY: {
                                this.updateRemoteStatus(returnInfo, file, 13);
                                break block5;
                            }
                            case DELETE: {
                                this.updateRemoteStatus(returnInfo, file, 2);
                                break block5;
                            }
                            case ADD: {
                                this.updateRemoteStatus(returnInfo, file, 4);
                            }
                        }
                        break;
                    }
                    this.updateRemoteStatus(returnInfo, file, 7);
                    break;
                }
                case ADD: {
                    if (localDiffItem.isPresent()) {
                        switch (localDiffItem.get().getChangeType()) {
                            case ADD: {
                                this.updateRemoteStatus(returnInfo, file, 12);
                            }
                        }
                        break;
                    }
                    this.updateRemoteStatus(returnInfo, file, 1);
                    if (file.exists()) break;
                    TeamStatusInfo tsi = this.getTeamStatusInfo(returnInfo, file);
                    tsi.setStatus(1);
                }
            }
        }
    }
}

