/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork.actions;

import bluej.Config;
import bluej.groupwork.Repository;
import bluej.groupwork.TeamSettingsController;
import bluej.groupwork.TeamUtils;
import bluej.groupwork.TeamworkCommand;
import bluej.groupwork.TeamworkCommandResult;
import bluej.groupwork.actions.TeamAction;
import bluej.groupwork.ui.ModuleSelectDialog;
import bluej.groupwork.ui.TeamSettingsDialog;
import bluej.pkgmgr.Import;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.pkgmgr.Project;
import bluej.utility.Debug;
import bluej.utility.DialogManager;
import bluej.utility.FileUtility;
import bluej.utility.SwingWorker;
import bluej.utility.javafx.FXPlatformConsumer;
import java.io.File;
import javafx.application.Platform;
import javafx.stage.Window;
import javax.swing.SwingUtilities;
import threadchecker.OnThread;
import threadchecker.Tag;

public class CheckoutAction
extends TeamAction {
    public CheckoutAction(PkgMgrFrame pmf) {
        super(pmf, "team.checkout");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void actionPerformed(PkgMgrFrame oldFrame) {
        TeamSettingsController tsc = new TeamSettingsController(new File(".").getAbsoluteFile());
        TeamSettingsDialog tsd = tsc.getTeamSettingsDialog();
        Platform.runLater(() -> tsd.setLocationRelativeTo((Window)oldFrame.getFXWindow()));
        if (tsd.doTeamSettings() != 0) return;
        FXPlatformConsumer<File> finishCheckout = projectDir -> SwingUtilities.invokeLater(() -> {
            PkgMgrFrame newFrame;
            if (oldFrame.isEmptyFrame()) {
                newFrame = oldFrame;
            } else {
                newFrame = PkgMgrFrame.createFrame();
                newFrame.setVisible(true);
            }
            new CheckoutWorker(newFrame, tsc.getRepository(true), (File)projectDir, tsc).start();
        });
        if (!tsc.isDVCS()) {
            ModuleSelectDialog moduleDialog = new ModuleSelectDialog(oldFrame::getFXWindow, tsc.getRepository(true));
            Platform.runLater(() -> moduleDialog.setLocationRelativeTo((Window)oldFrame.getFXWindow()));
            moduleDialog.setVisible(true);
            String moduleName = moduleDialog.getModuleName();
            if (moduleName == null) return;
            Platform.runLater(() -> {
                File parentDir = FileUtility.getSaveProjectFX((Window)oldFrame.getFXWindow(), Config.getString("team.checkout.filechooser.title"));
                if (parentDir == null) {
                    return;
                }
                if (Package.isPackage(parentDir)) {
                    Debug.message("Attempted to checkout a project into an existing project: " + parentDir);
                    DialogManager.showErrorFX(null, "team-cannot-import-into-existing-project");
                    return;
                }
                finishCheckout.accept(new File(parentDir, moduleName));
            });
            return;
        } else {
            Platform.runLater(() -> {
                File projectDir = FileUtility.getSaveProjectFX((Window)oldFrame.getFXWindow(), Config.getString("team.checkout.DVCS.filechooser.title"));
                if (projectDir != null) {
                    if (Package.isPackage(projectDir)) {
                        Debug.message("Attempted to checkout a project into an existing project: " + projectDir);
                        DialogManager.showErrorFX(null, "team-cannot-import-into-existing-project");
                        return;
                    }
                } else {
                    return;
                }
                finishCheckout.accept(projectDir);
            });
        }
    }

    private class CheckoutWorker
    extends SwingWorker {
        private Repository repository;
        private PkgMgrFrame newFrame;
        private File projDir;
        private TeamSettingsController tsc;
        private TeamworkCommandResult response;
        private boolean failed = true;

        public CheckoutWorker(PkgMgrFrame newFrame, Repository repository, File projDir, TeamSettingsController tsc) {
            this.newFrame = newFrame;
            this.repository = repository;
            this.projDir = projDir;
            this.tsc = tsc;
        }

        @Override
        public Object construct() {
            this.newFrame.setStatus(Config.getString("team.checkingout"));
            this.newFrame.startProgress();
            TeamworkCommand checkoutCmd = this.repository.checkout(this.projDir);
            this.response = checkoutCmd.getResult();
            this.failed = this.response.isError();
            this.newFrame.stopProgress();
            if (!this.failed) {
                this.newFrame.setStatus(Config.getString("team.checkedout"));
            }
            this.newFrame.stopProgress();
            return this.response;
        }

        @Override
        public void finished() {
            if (!this.failed) {
                if (!Project.isProject(this.projDir.toString())) {
                    if (!Import.convertNonBlueJ(this.newFrame::getFXWindow, this.projDir)) {
                        this.cleanup();
                        return;
                    }
                }
                Project project = Project.openProject(this.projDir.toString());
                project.setTeamSettingsController(this.tsc);
                Package initialPackage = project.getPackage(project.getInitialPackageName());
                this.newFrame.openPackage(initialPackage, this.newFrame);
            } else {
                Platform.runLater(() -> {
                    TeamUtils.handleServerResponseFX(this.response, (Window)this.newFrame.getFXWindow());
                    SwingUtilities.invokeLater(() -> this.cleanup());
                });
            }
        }

        @OnThread(value=Tag.Swing)
        public void cleanup() {
            this.deleteDirectory(this.projDir);
            this.projDir.delete();
            Platform.runLater(() -> this.newFrame.doClose(true, false));
        }

        private void deleteDirectory(File dir) {
            if (dir != null && dir.listFiles() != null) {
                for (File f : dir.listFiles()) {
                    if (f.isDirectory()) {
                        this.deleteDirectory(f);
                    }
                    f.delete();
                }
            }
        }
    }
}

