/*
 * Decompiled with CFR 0.152.
 */
package bluej.graph;

import bluej.graph.TraverseStrategy;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.target.Target;
import javafx.scene.input.KeyCode;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public class TraverseStrategyImpl
implements TraverseStrategy {
    private double calcDistance(Target vertex1, Target vertex2) {
        if (vertex1 == null || vertex2 == null) {
            return Double.POSITIVE_INFINITY;
        }
        int x1 = vertex1.getX() + vertex1.getWidth() / 2;
        int y1 = vertex1.getY() + vertex1.getHeight() / 2;
        int x2 = vertex2.getX() + vertex2.getWidth() / 2;
        int y2 = vertex2.getY() + vertex2.getHeight() / 2;
        double d = Math.sqrt(Math.pow(x2 - x1, 2.0) + Math.pow(y2 - y1, 2.0));
        return d;
    }

    @Override
    public Target findNextVertex(Package graph, Target currentVertex, KeyCode key) {
        int currentVertexCenterX = currentVertex.getX() + currentVertex.getWidth() / 2;
        int currentVertexCenterY = currentVertex.getY() + currentVertex.getHeight() / 2;
        double closest = Double.POSITIVE_INFINITY;
        Target closestVertex = null;
        for (Target v : graph.getVertices()) {
            double d;
            int x = v.getX() + v.getWidth() / 2 - currentVertexCenterX;
            int y = v.getY() + v.getHeight() / 2 - currentVertexCenterY;
            boolean left = key == KeyCode.LEFT && y >= x && y <= -x;
            boolean right = key == KeyCode.RIGHT && y <= x && y >= -x;
            boolean up = key == KeyCode.UP && y <= x && y <= -x;
            boolean down = key == KeyCode.DOWN && y >= x && y >= -x;
            boolean notSelf = currentVertex != v;
            boolean inRightRegion = (left || right || up || down) && notSelf;
            if (!inRightRegion) continue;
            if (closestVertex == null) {
                closestVertex = v;
                closest = this.calcDistance(v, currentVertex);
            }
            double currentDistance = this.calcDistance(v, currentVertex);
            if (!(closest > d)) continue;
            closest = currentDistance;
            closestVertex = v;
        }
        if (closestVertex == null) {
            closestVertex = currentVertex;
        }
        return closestVertex;
    }
}

