/*
 * Decompiled with CFR 0.152.
 */
package bluej.extmgr;

import bluej.Config;
import bluej.extmgr.ExtensionWrapper;
import bluej.utility.Utility;
import bluej.utility.javafx.FXPlatformSupplier;
import bluej.utility.javafx.JavaFXUtil;
import java.net.URL;
import java.util.List;
import javafx.application.Platform;
import javafx.css.Styleable;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TitledPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javafx.scene.text.TextFlow;
import javafx.stage.Modality;
import javafx.stage.Window;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public class ExtensionsDialog {
    private final String systemString = Config.getString("extmgr.systemExtensionShort");
    private final String projectString = Config.getString("extmgr.projectExtensionShort");
    private final String systemLongString = Config.getString("extmgr.systemExtensionLong");
    private final String projectLongString = Config.getString("extmgr.projectExtensionLong");
    private final String locationTag = Config.getString("extmgr.details.location");
    private final String versionTag = Config.getString("extmgr.details.version");
    private Dialog<Void> mainFrame;
    private VBox extensionsVBox;

    @OnThread(value=Tag.Swing)
    ExtensionsDialog(List<ExtensionWrapper> extensionsList, FXPlatformSupplier<Window> parent) {
        Platform.runLater(() -> {
            this.mainFrame = new Dialog();
            this.mainFrame.initOwner((Window)parent.get());
            this.mainFrame.setTitle(Config.getString("extmgr.title"));
            this.mainFrame.initModality(Modality.WINDOW_MODAL);
            this.mainFrame.setResizable(true);
            this.extensionsVBox = new VBox();
            this.extensionsVBox.setFillWidth(true);
            this.extensionsVBox.setMinWidth(200.0);
            JavaFXUtil.addStyleClass((Styleable)this.extensionsVBox, "extension-list");
            ScrollPane extensionsPane = new ScrollPane((Node)this.extensionsVBox);
            extensionsPane.setPrefHeight(300.0);
            extensionsPane.setPrefWidth(500.0);
            extensionsPane.setFitToWidth(true);
            Config.addDialogStylesheets(this.mainFrame.getDialogPane());
            this.mainFrame.getDialogPane().setContent((Node)extensionsPane);
            this.mainFrame.getDialogPane().getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.CLOSE});
        });
        extensionsList.forEach(wrapper -> {
            String extensionName = wrapper.safeGetExtensionName();
            String extensionStatus = wrapper.getExtensionStatus();
            String extensionVersion = wrapper.safeGetExtensionVersion();
            String extensionDescription = wrapper.safeGetExtensionDescription();
            boolean isProject = wrapper.getProject() != null;
            String extensionFileName = wrapper.getExtensionFileName();
            URL url = wrapper.safeGetURL();
            Platform.runLater(() -> this.extensionsVBox.getChildren().add((Object)this.makeDisplay(extensionName, extensionStatus, extensionVersion, extensionDescription, isProject, extensionFileName, url)));
        });
    }

    public void showAndWait() {
        this.mainFrame.showAndWait();
    }

    @OnThread(value=Tag.FXPlatform)
    private TitledPane makeDisplay(String extensionName, String extensionStatus, String extensionVersion, String extensionDescription, boolean isProject, String extensionFileName, URL url) {
        String typeShort = isProject ? this.projectString : this.systemString;
        String typeLong = isProject ? this.projectLongString : this.systemLongString;
        String title = extensionName + " (" + typeShort + ", " + extensionStatus + ")";
        VBox mainPanel = new VBox();
        JavaFXUtil.addStyleClass((Styleable)mainPanel, "extension-info");
        mainPanel.getChildren().add((Object)new Label(extensionName + " " + this.versionTag + " " + extensionVersion));
        mainPanel.getChildren().add((Object)new Label(typeLong));
        mainPanel.getChildren().add((Object)new Label(this.locationTag + " " + extensionFileName + " (" + extensionStatus + ')'));
        Text description = new Text(extensionDescription);
        mainPanel.getChildren().add((Object)new TextFlow(new Node[]{description}));
        if (url != null) {
            Hyperlink link = new Hyperlink(url.toExternalForm());
            link.setOnAction(e -> Utility.openWebBrowser(url.toExternalForm()));
            mainPanel.getChildren().add((Object)link);
        }
        TitledPane titledPane = new TitledPane(title, (Node)mainPanel);
        titledPane.setExpanded(false);
        return titledPane;
    }
}

