/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugmgr;

import bluej.utility.javafx.FXConsumer;
import bluej.utility.javafx.FXPlatformRunnable;
import bluej.utility.javafx.GrowableList;
import bluej.utility.javafx.HangingFlowPane;
import bluej.utility.javafx.JavaFXUtil;
import java.util.ArrayList;
import java.util.List;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TextField;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public class ParameterList {
    private List<ComboBox<String>> parameters;
    private GrowableList<ComboBox<String>> varArgsList;
    private ObservableList<String> varArgsHistory = FXCollections.observableArrayList();
    private String defaultParamValue;
    private final FXConsumer<TextField> setLastFocused;
    private final FXPlatformRunnable fireOK;

    public ParameterList(int initialSize, String defaultParamValue, FXConsumer<TextField> setLastFocused, FXPlatformRunnable fireOK) {
        this.parameters = new ArrayList<ComboBox<String>>(initialSize);
        this.defaultParamValue = defaultParamValue;
        this.setLastFocused = setLastFocused;
        this.fireOK = fireOK;
    }

    public ComboBox<String> getActualParameter(int index) {
        if (this.varArgsList != null && index >= this.parameters.size()) {
            int varArgIndex = index - this.parameters.size();
            return this.varArgsList.getItem(varArgIndex);
        }
        return this.parameters.get(index);
    }

    public ObservableList<? extends Node> getNodesForFormal(int index) {
        if (this.varArgsList != null && index == this.parameters.size()) {
            return this.varArgsList.getNodes();
        }
        return FXCollections.observableArrayList((Object[])new ComboBox[]{this.parameters.get(index)});
    }

    public void addNormalParameter(String paramType, String paramName, List<String> history) {
        String paramString = paramType + (paramName == null ? "" : " " + paramName);
        this.parameters.add(this.createComboBox(paramString, (ObservableList<String>)(history == null ? null : FXCollections.observableArrayList(history))));
    }

    public int formalCount() {
        return this.parameters.size() + (this.varArgsList != null ? 1 : 0);
    }

    public int actualCount() {
        return this.parameters.size() + (this.varArgsList != null ? this.varArgsList.size() : 0);
    }

    public void setHistory(int i, List<String> historyList) {
        if (historyList == null) {
            return;
        }
        if (this.varArgsList != null && i >= this.parameters.size()) {
            this.varArgsHistory.setAll(historyList);
        } else {
            this.getActualParameter(i).getItems().setAll(historyList);
            this.getActualParameter(i).getItems().add(0, (Object)this.defaultParamValue);
        }
    }

    protected ComboBox<String> createComboBox(String prompt, ObservableList<String> history) {
        if (history == null) {
            history = FXCollections.observableArrayList();
        }
        history.add(0, (Object)this.defaultParamValue);
        ComboBox component = new ComboBox(history);
        component.setEditable(true);
        component.setPromptText(prompt);
        component.getEditor().setText(this.defaultParamValue);
        HangingFlowPane.setBreakBefore((Node)component, true);
        HangingFlowPane.setMargin((Node)component, new Insets(0.0, 8.0, 0.0, 8.0));
        JavaFXUtil.addChangeListener(component.focusedProperty(), focused -> {
            if (focused.booleanValue()) {
                this.setLastFocused.accept(component.getEditor());
            }
        });
        component.getEditor().setOnAction(e -> this.fireOK.run());
        return component;
    }

    public void addVarArgsTypes(String paramType, String paramName) {
        String paramString = paramType + (paramName == null ? "" : " " + paramName);
        this.varArgsList = new GrowableList<Object>(() -> this.createComboBox(paramString, this.varArgsHistory));
    }
}

