/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugmgr;

import bluej.Config;
import bluej.debugger.gentype.GenTypeParameter;
import bluej.debugmgr.CallDialog;
import bluej.debugmgr.CallHistory;
import bluej.debugmgr.Invoker;
import bluej.debugmgr.objectbench.ObjectBenchInterface;
import bluej.utility.JavaNames;
import bluej.utility.javafx.FXFormattedPrintWriter;
import bluej.views.CallableView;
import bluej.views.MethodView;
import java.util.Map;
import javafx.stage.Window;
import javax.swing.SwingUtilities;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public class MethodDialog
extends CallDialog {
    private final boolean rawObject;
    private static final String appName = Config.getApplicationName();
    static final String wCallRoutineTitle = appName + ":  " + Config.getString("pkgmgr.methodCall.titleCall");
    private final String methodName;
    private final MethodView method;
    private final Map<String, GenTypeParameter> typeParameterMap;
    private final Invoker invoker;

    public MethodDialog(Window parentFrame, ObjectBenchInterface ob, CallHistory callHistory, String instanceName, MethodView method, Map<String, GenTypeParameter> typeMap, Invoker invoker) {
        super(parentFrame, ob, "");
        this.invoker = invoker;
        this.history = callHistory;
        this.methodName = method.getName();
        this.method = method;
        this.setTitle(wCallRoutineTitle);
        String callLabel1 = this.method.isStatic() ? JavaNames.stripPrefix(method.getClassName()) + "." + this.methodName : JavaNames.stripPrefix(instanceName) + "." + this.methodName;
        if (this.method.isMain()) {
            this.defaultParamValue = "{ }";
        }
        this.makeDialog(this.createParameterPanel(callLabel1));
        this.typeParameterMap = typeMap;
        this.rawObject = instanceName != null && typeMap == null;
        FXFormattedPrintWriter writer = new FXFormattedPrintWriter();
        this.method.print(writer, this.typeParameterMap, 0);
        this.setDescription(writer.getNode());
        this.setOnShown(e -> {
            if (this.typeParameterList != null) {
                this.typeParameterList.getActualParameter(0).getEditor().requestFocus();
            } else if (this.parameterList != null) {
                this.parameterList.getActualParameter(0).getEditor().requestFocus();
            }
        });
    }

    @Override
    public void handleOK() {
        if (!this.parameterFieldsOk()) {
            this.setErrorMessage(emptyFieldMsg);
        } else if (!this.typeParameterFieldsOk()) {
            this.setErrorMessage(emptyTypeFieldMsg);
        } else {
            this.setWaitCursor(true);
            SwingUtilities.invokeLater(this.invoker::callDialogOK);
        }
    }

    @Override
    protected CallableView getCallableView() {
        return this.method;
    }

    @Override
    protected boolean targetIsRaw() {
        return this.rawObject;
    }

    @Override
    protected Map<String, GenTypeParameter> getTargetTypeArgs() {
        return this.typeParameterMap;
    }
}

