/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugmgr;

import bluej.Config;
import bluej.classmgr.BPClassLoader;
import bluej.debugmgr.ClassHistory;
import bluej.pkgmgr.Package;
import bluej.utility.javafx.JavaFXUtil;
import bluej.views.CallableView;
import bluej.views.ConstructorView;
import bluej.views.MethodView;
import bluej.views.View;
import bluej.views.ViewFilter;
import java.util.Arrays;
import java.util.stream.Collectors;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.Styleable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.TextFieldListCell;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;
import javafx.stage.Window;
import javafx.util.StringConverter;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public class LibraryCallDialog
extends Dialog<CallableView> {
    private static final String[] clickHere = new String[]{Config.getString("callLibraryDialog.clickHere1"), Config.getString("callLibraryDialog.clickHere2")};
    private static final String[] classNotFound = new String[]{Config.getString("callLibraryDialog.classNotFound1"), Config.getString("callLibraryDialog.classNotFound2")};
    private ComboBox classField;
    private ListView<CallableView> methodList;
    private Label textOverlay;
    private Button docButton;
    private final ClassHistory history;
    private final Package pkg;
    private final ObservableList<CallableView> currentViews;
    private final BPClassLoader classLoader;

    public LibraryCallDialog(Window parent, Package pkg, BPClassLoader classLoader) {
        this.setTitle(Config.getString("callLibraryDialog.title"));
        this.initOwner(parent);
        this.initModality(Modality.WINDOW_MODAL);
        Config.addDialogStylesheets(this.getDialogPane());
        this.setResultConverter(this::calculateResult);
        this.pkg = pkg;
        this.classLoader = classLoader;
        this.currentViews = FXCollections.observableArrayList();
        this.history = ClassHistory.getClassHistory(10);
        this.makeDialog();
        this.classSelected();
    }

    private void showDocumentation() {
        String className = this.classField.getEditor().getText();
        if (className.indexOf(46) == -1) {
            className = "java.lang." + className;
        }
        this.pkg.getProject().getDefaultFXTabbedEditor().openJavaCoreDocTab(className, "#constructor_summary");
    }

    private CallableView calculateResult(ButtonType buttonType) {
        if (buttonType == ButtonType.OK) {
            CallableView viewToCall = (CallableView)this.methodList.getSelectionModel().getSelectedItem();
            if (viewToCall != null) {
                this.history.add(this.classField.getEditor().getText());
            }
            return viewToCall;
        }
        return null;
    }

    private void classSelected() {
        boolean loaded;
        BPClassLoader loader;
        Class<?> cl = null;
        this.currentViews.clear();
        String className = this.classField.getEditor().getText();
        if (className.length() == 0) {
            this.displayTextInClassList(clickHere);
            return;
        }
        try {
            loader = this.classLoader;
            cl = loader.loadClass(className);
            loaded = true;
        }
        catch (Exception exc) {
            loaded = false;
        }
        if (!loaded) {
            try {
                loader = this.classLoader;
                cl = loader.loadClass("java.lang." + className);
            }
            catch (Exception exc) {
                this.displayTextInClassList(classNotFound);
                return;
            }
        }
        this.displayMethodsForClass(cl);
    }

    private void displayMethodsForClass(Class<?> cl) {
        View classView = View.getView(cl);
        ConstructorView[] constructors = classView.getConstructors();
        int visibilityMod = 1;
        if (classView.getPackageName().equals(this.pkg.getQualifiedName())) {
            visibilityMod = 65541;
        }
        ViewFilter filter = new ViewFilter(0x20000 | visibilityMod);
        Arrays.stream(constructors).filter(filter::accept).forEach(arg_0 -> this.currentViews.add(arg_0));
        MethodView[] methods = classView.getAllMethods();
        filter = new ViewFilter(8 | visibilityMod);
        Arrays.stream(methods).filter(filter::accept).forEach(arg_0 -> this.currentViews.add(arg_0));
        this.textOverlay.setVisible(false);
        this.methodList.getSelectionModel().clearSelection();
        this.methodList.setDisable(false);
        this.docButton.setDisable(false);
    }

    private void displayTextInClassList(String[] text) {
        this.textOverlay.setVisible(true);
        this.textOverlay.setText(Arrays.stream(text).collect(Collectors.joining("\n")));
        this.methodList.getItems().clear();
        this.methodList.setDisable(true);
        this.docButton.setDisable(true);
    }

    private void makeDialog() {
        this.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.CANCEL, ButtonType.OK});
        HBox classPanel = new HBox();
        JavaFXUtil.addStyleClass((Styleable)classPanel, "library-call-class");
        Label classLabel = new Label(Config.getString("callLibraryDialog.classLabel"));
        this.classField = new ComboBox(FXCollections.observableArrayList(this.history.getHistory()));
        this.classField.setEditable(true);
        this.classField.setVisibleRowCount(10);
        TextField textField = this.classField.getEditor();
        textField.setPrefColumnCount(16);
        JavaFXUtil.addChangeListener(this.classField.getSelectionModel().selectedItemProperty(), x -> JavaFXUtil.runNowOrLater(this::classSelected));
        this.docButton = new Button(Config.getString("callLibraryDialog.docButton"));
        this.docButton.setOnAction(e -> this.showDocumentation());
        this.docButton.setDisable(true);
        classPanel.getChildren().setAll((Object[])new Node[]{classLabel, this.classField, this.docButton});
        this.methodList = new ListView();
        JavaFXUtil.addStyleClass(this.methodList, new String[]{"library-call-methods"});
        this.methodList.setEditable(false);
        this.methodList.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
        this.methodList.setItems(this.currentViews);
        this.getDialogPane().lookupButton(ButtonType.OK).disableProperty().bind((ObservableValue)this.methodList.getSelectionModel().selectedItemProperty().isNull());
        this.textOverlay = new Label();
        this.methodList.setCellFactory(v -> {
            TextFieldListCell cell = new TextFieldListCell((StringConverter)new StringConverter<CallableView>(){

                public String toString(CallableView object) {
                    return object.getShortDesc();
                }

                public CallableView fromString(String string) {
                    throw new UnsupportedOperationException();
                }
            });
            cell.setOnMouseClicked(arg_0 -> this.lambda$null$2((ListCell)cell, arg_0));
            return cell;
        });
        VBox contentPane = new VBox();
        JavaFXUtil.addStyleClass((Styleable)contentPane, "library-call-dialog-content");
        contentPane.getChildren().add((Object)classPanel);
        contentPane.getChildren().add((Object)JavaFXUtil.withStyleClass(new Label(Config.getString("callLibraryDialog.listHeading")), "library-call-heading"));
        contentPane.getChildren().add((Object)new StackPane(new Node[]{this.methodList, this.textOverlay}));
        this.getDialogPane().setContent((Node)contentPane);
    }

    private /* synthetic */ void lambda$null$2(ListCell cell, MouseEvent e) {
        if (e.getClickCount() == 2 && e.getButton() == MouseButton.PRIMARY) {
            this.methodList.getSelectionModel().select(cell.getItem());
            ((Button)this.getDialogPane().lookupButton(ButtonType.OK)).fire();
        }
    }
}

