/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugmgr;

import bluej.Config;
import bluej.debugmgr.CallDialog;
import bluej.debugmgr.CallHistory;
import bluej.debugmgr.Invoker;
import bluej.debugmgr.ParameterList;
import bluej.debugmgr.objectbench.ObjectBenchInterface;
import bluej.utility.JavaNames;
import bluej.utility.javafx.FXFormattedPrintWriter;
import bluej.utility.javafx.HangingFlowPane;
import bluej.utility.javafx.JavaFXUtil;
import bluej.views.CallableView;
import bluej.views.ConstructorView;
import bluej.views.TypeParamView;
import bluej.views.View;
import javafx.application.Platform;
import javafx.css.Styleable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.stage.Window;
import javax.swing.SwingUtilities;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public class ConstructorDialog
extends CallDialog {
    private static final String appName = Config.getApplicationName();
    private static final String wCreateTitle = appName + ":  " + Config.getString("pkgmgr.methodCall.titleCreate");
    static final String sNameOfInstance = Config.getString("pkgmgr.methodCall.namePrompt");
    static final String sTypeParameters = Config.getString("pkgmgr.methodCall.typeParametersPrompt");
    static final String sTypeParameter = Config.getString("pkgmgr.methodCall.typeParameterPrompt");
    static final String illegalNameMsg = Config.getString("error.methodCall.illegalName");
    static final String duplicateNameMsg = Config.getString("error.methodCall.duplicateName");
    private final TextField instanceNameText;
    private final ConstructorView constructor;
    private final Invoker invoker;

    public ConstructorDialog(Window parentFrame, ObjectBenchInterface ob, CallHistory callHistory, String initialName, ConstructorView constructor, Invoker invoker) {
        super(parentFrame, ob, "");
        View clazz;
        this.invoker = invoker;
        this.history = callHistory;
        this.constructor = constructor;
        this.setTitle(wCreateTitle);
        Label instName = new Label(sNameOfInstance);
        instName.setAlignment(Pos.BASELINE_LEFT);
        this.instanceNameText = new TextField(initialName);
        this.instanceNameText.setPrefColumnCount(16);
        this.instanceNameText.setAlignment(Pos.BASELINE_LEFT);
        instName.setLabelFor((Node)this.instanceNameText);
        this.instanceNameText.setOnAction(e1 -> this.fireOK());
        VBox tmpPanel = new VBox();
        JavaFXUtil.addStyleClass((Styleable)tmpPanel, "constructor-dialog-fields");
        if (!Config.isGreenfoot()) {
            HBox hBox = new HBox(new Node[]{instName, this.instanceNameText});
            hBox.setAlignment(Pos.BASELINE_LEFT);
            JavaFXUtil.addStyleClass((Styleable)hBox, "constructor-instance-name-row");
            tmpPanel.getChildren().add((Object)hBox);
        }
        if ((clazz = this.constructor.getDeclaringView()).isGeneric()) {
            String name = ConstructorDialog.getFormalTypeParams(this.constructor).length > 1 ? sTypeParameters + "  " : sTypeParameter + "  ";
            HangingFlowPane typeParameterPanel = this.createTypeParameterPanel(name);
            tmpPanel.getChildren().add((Object)typeParameterPanel);
        }
        if (this.constructor.hasParameters()) {
            Pane parameterPanel = this.createParameterPanel("new " + constructor.getClassName());
            tmpPanel.getChildren().add((Object)parameterPanel);
        }
        this.makeDialog((Pane)tmpPanel);
        this.instanceNameText.setText(initialName);
        FXFormattedPrintWriter writer = new FXFormattedPrintWriter();
        this.constructor.print(writer);
        this.setDescription(writer.getNode());
        this.setOnShown(e -> {
            if (this.typeParameterList != null) {
                this.typeParameterList.getActualParameter(0).getEditor().requestFocus();
            } else if (this.parameterList != null) {
                this.parameterList.getActualParameter(0).getEditor().requestFocus();
            } else {
                this.instanceNameText.requestFocus();
            }
        });
    }

    private HangingFlowPane createTypeParameterPanel(String prefix) {
        TypeParamView[] formalTypeParams = ConstructorDialog.getFormalTypeParams(this.constructor);
        this.typeParameterList = new ParameterList(formalTypeParams.length, this.defaultParamValue, f -> {
            this.focusedTextField = f;
        }, this::fireOK);
        for (TypeParamView formalTypeParam : formalTypeParams) {
            this.typeParameterList.addNormalParameter(formalTypeParam.toString(), null, this.history.getHistory(formalTypeParam));
        }
        String startString = prefix + "<";
        String endString = ">";
        ParameterList superParamList = this.typeParameterList;
        return this.createParameterPanel(startString, endString, superParamList);
    }

    @Override
    public void handleOK() {
        String newInstanceName = this.getNewInstanceName();
        if (!JavaNames.isIdentifier(newInstanceName)) {
            this.setErrorMessage(illegalNameMsg);
            JavaFXUtil.setPseudoclass("bj-dialog-error", true, new Node[]{this.instanceNameText});
            return;
        }
        SwingUtilities.invokeLater(() -> {
            boolean alreadyOnBench = this.bench != null && this.bench.hasObject(newInstanceName);
            Platform.runLater(() -> {
                if (alreadyOnBench) {
                    this.setErrorMessage(duplicateNameMsg);
                    JavaFXUtil.setPseudoclass("bj-dialog-error", true, new Node[]{this.instanceNameText});
                    return;
                }
                JavaFXUtil.setPseudoclass("bj-dialog-error", false, new Node[]{this.instanceNameText});
                if (!this.parameterFieldsOk()) {
                    this.setErrorMessage(emptyFieldMsg);
                } else if (!this.typeParameterFieldsOk()) {
                    this.setErrorMessage(emptyTypeFieldMsg);
                } else {
                    this.setWaitCursor(true);
                    SwingUtilities.invokeLater(this.invoker::callDialogOK);
                }
            });
        });
    }

    @Override
    @OnThread(value=Tag.FXPlatform, ignoreParent=true)
    public @OnThread(value=Tag.FXPlatform, ignoreParent=true) String getNewInstanceName() {
        if (this.instanceNameText == null) {
            return "";
        }
        return this.instanceNameText.getText().trim();
    }

    @Override
    protected CallableView getCallableView() {
        return this.constructor;
    }
}

