/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugmgr;

import bluej.views.TypeParamView;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.Any)
public class CallHistory {
    private Map<String, List<String>> objectTypes = null;
    private List<Class<?>> objectClasses = null;
    private List<String> objectParams = null;
    private Map<String, List<String>> typeParams = null;
    private int historyLength;
    static final int DEFAULT_LENGTH = 6;
    static final String INT_NAME = "int";
    static final String BOOLEAN_NAME = "boolean";
    static final String LONG_NAME = "long";
    static final String FLOAT_NAME = "float";
    static final String DOUBLE_NAME = "double";
    static final String SHORT_NAME = "short";
    static final String STRING_NAME = "java.lang.String";

    public CallHistory() {
        this(6);
    }

    public CallHistory(int length) {
        this.historyLength = length;
        this.objectTypes = new HashMap<String, List<String>>(8);
        this.objectTypes.put(INT_NAME, new ArrayList(length));
        this.objectTypes.put(LONG_NAME, new ArrayList(length));
        this.objectTypes.put(BOOLEAN_NAME, new ArrayList(length));
        this.objectTypes.put(FLOAT_NAME, new ArrayList(length));
        this.objectTypes.put(DOUBLE_NAME, new ArrayList(length));
        this.objectTypes.put(SHORT_NAME, new ArrayList(length));
        this.objectTypes.put(STRING_NAME, new ArrayList(length));
        this.objectClasses = new ArrayList();
        this.objectParams = new ArrayList<String>();
        this.typeParams = new HashMap<String, List<String>>();
    }

    public List<String> getHistory(Class<?> objectClass) {
        ArrayList<String> history = null;
        if (this.objectTypes.containsKey(objectClass.getName())) {
            history = this.objectTypes.get(objectClass.getName());
        } else {
            history = new ArrayList();
            for (int i = 0; i < this.objectClasses.size(); ++i) {
                if (!objectClass.isAssignableFrom(this.objectClasses.get(i))) continue;
                history.add(this.objectParams.get(i));
            }
        }
        return history;
    }

    public List<String> getHistory(TypeParamView typeParam) {
        return this.typeParams.get(typeParam.toString());
    }

    public void addCall(TypeParamView typeParam, String parameter) {
        List<String> history = this.typeParams.get(typeParam.toString());
        if (history == null) {
            history = new ArrayList<String>();
            this.typeParams.put(typeParam.toString(), history);
        }
        history.add(parameter);
    }

    public void addCall(Class<?> objectType, String argument) {
        if (argument != null) {
            if (this.objectTypes.containsKey(objectType.getName())) {
                List<String> history = this.getHistory(objectType);
                int index = history.indexOf(argument);
                if (index != 0) {
                    if (index > 0) {
                        history.remove(index);
                    }
                    history.add(0, argument);
                }
                if (history.size() > this.historyLength) {
                    history.remove(this.historyLength);
                }
            } else {
                int index = this.objectParams.indexOf(argument);
                if (index != 0) {
                    if (index > 0) {
                        this.objectParams.remove(index);
                        this.objectClasses.remove(index);
                    }
                    this.objectClasses.add(0, objectType);
                    this.objectParams.add(0, argument);
                }
            }
        }
    }
}

