/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugger.jdi;

import bluej.debugger.DebuggerTestResult;
import bluej.debugger.SourceLocation;
import java.io.BufferedReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;

public class JdiTestResult
extends DebuggerTestResult {
    protected String className;
    protected String methodName;
    protected String exceptionMsg;
    protected String traceMsg;
    protected int runTimeMs;

    JdiTestResult(String className, String methodName, int runTimeMs) {
        if (className == null || methodName == null) {
            throw new NullPointerException("constructing JdiTestResult");
        }
        this.className = className;
        this.methodName = methodName;
        this.runTimeMs = runTimeMs;
        this.exceptionMsg = null;
        this.traceMsg = null;
    }

    @Override
    public String getQualifiedClassName() {
        return this.className;
    }

    @Override
    public String getMethodName() {
        return this.methodName;
    }

    @Override
    public String getExceptionMessage() {
        throw new IllegalStateException("getting Exception message from successful test");
    }

    @Override
    public int getRunTimeMs() {
        return this.runTimeMs;
    }

    @Override
    public String getTrace() {
        throw new IllegalStateException("getting stack trace from successful test");
    }

    @Override
    public SourceLocation getExceptionLocation() {
        throw new IllegalStateException("getting stack trace from successful test");
    }

    @Override
    public boolean isError() {
        return false;
    }

    @Override
    public boolean isFailure() {
        return false;
    }

    @Override
    public boolean isSuccess() {
        return true;
    }

    public static String getFilteredTrace(String stack) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        StringReader sr = new StringReader(stack);
        BufferedReader br = new BufferedReader(sr);
        try {
            String line;
            while ((line = br.readLine()) != null) {
                if (JdiTestResult.filterLine(line)) continue;
                pw.println(line);
            }
        }
        catch (Exception IOException2) {
            return stack;
        }
        return sw.toString();
    }

    static boolean filterLine(String line) {
        String[] patterns = new String[]{"junit.framework.TestCase", "junit.framework.TestResult", "junit.framework.TestSuite", "junit.framework.Assert.", "junit.swingui.TestRunner", "junit.awtui.TestRunner", "junit.textui.TestRunner", "org.junit.runner", "org.junit.internal", "sun.reflect.", "bluej.", "java.lang.reflect.Method.invoke("};
        for (int i = 0; i < patterns.length; ++i) {
            if (line.indexOf(patterns[i]) <= 0) continue;
            return true;
        }
        return false;
    }
}

