/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugger;

import bluej.classmgr.BPClassLoader;
import bluej.debugger.DebuggerClass;
import bluej.debugger.DebuggerListener;
import bluej.debugger.DebuggerObject;
import bluej.debugger.DebuggerResult;
import bluej.debugger.DebuggerTerminal;
import bluej.debugger.DebuggerTestResult;
import bluej.debugger.DebuggerThreadTreeModel;
import bluej.debugger.jdi.JdiDebugger;
import java.io.File;
import java.net.URL;
import java.util.Map;

public abstract class Debugger {
    public static final String PERSIST_BREAKPOINT_PROPERTY = "VMReference.PERSIST_BREAKPOINT";
    public static final int NORMAL_EXIT = 0;
    public static final int EXCEPTION = 2;
    public static final int TERMINATED = 3;
    public static final int UNKNOWN = 0;
    public static final int NOTREADY = 1;
    public static final int IDLE = 2;
    public static final int RUNNING = 3;
    public static final int SUSPENDED = 4;
    public static final int LAUNCH_FAILED = 5;

    public static Debugger getDebuggerImpl(File startingDirectory, DebuggerTerminal terminal) {
        return new JdiDebugger(startingDirectory, terminal);
    }

    public abstract void setUserLibraries(URL[] var1);

    public abstract void launch();

    public abstract void close(boolean var1);

    public abstract int addDebuggerListener(DebuggerListener var1);

    public abstract void removeDebuggerListener(DebuggerListener var1);

    public abstract void newClassLoader(BPClassLoader var1);

    public abstract void removeBreakpointsForClass(String var1);

    public abstract boolean addObject(String var1, String var2, DebuggerObject var3);

    public abstract void removeObject(String var1, String var2);

    public abstract Map<String, DebuggerObject> getObjects();

    public abstract String guessNewName(String var1);

    public abstract String guessNewName(DebuggerObject var1);

    public abstract int getStatus();

    public abstract Map<String, DebuggerObject> runTestSetUp(String var1);

    public abstract DebuggerTestResult runTestMethod(String var1, String var2);

    public abstract void disposeWindows();

    public abstract DebuggerResult runClassMain(String var1) throws ClassNotFoundException;

    public abstract DebuggerResult instantiateClass(String var1);

    public abstract DebuggerResult instantiateClass(String var1, String[] var2, DebuggerObject[] var3);

    public abstract DebuggerClass getClass(String var1, boolean var2) throws ClassNotFoundException;

    public abstract DebuggerResult launchFXApp(String var1);

    public abstract DebuggerObject getMirror(String var1);

    public abstract String toggleBreakpoint(String var1, int var2, boolean var3, Map<String, String> var4);

    public abstract String toggleBreakpoint(String var1, String var2, boolean var3, Map<String, String> var4);

    public abstract String toggleBreakpoint(DebuggerClass var1, String var2, boolean var3, Map<String, String> var4);

    public abstract DebuggerThreadTreeModel getThreadTreeModel();

    public abstract void hideSystemThreads(boolean var1);
}

