/*
 * Decompiled with CFR 0.152.
 */
package com.javafx.main;

import com.javafx.main.Main;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;
import java.net.URL;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JTextPane;

public class NoJavaFXFallback
extends JApplet
implements ActionListener {
    boolean isInBrowser = false;
    boolean oldJRE = true;
    String requiredJavaFXVersion = null;
    boolean oldJavaFX = false;
    boolean doNotUseJNLPAPI = false;

    public NoJavaFXFallback() {
    }

    public NoJavaFXFallback(boolean bl, boolean bl2, String string) {
        this.isInBrowser = false;
        this.oldJavaFX = bl2;
        this.requiredJavaFXVersion = string;
        this.oldJRE = bl;
        this.doNotUseJNLPAPI = true;
        this.populate();
    }

    private void test() {
        this.oldJRE = Main.isOldJRE();
        try {
            Class<?> clazz = Class.forName("netscape.javascript.JSObject");
            Method method = clazz.getMethod("getWindow", Applet.class);
            this.isInBrowser = method.invoke(null, this) != null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    String getText() {
        String string = "This application requires a newer version of the Java runtime. Please download and install the latest Java runtime from java.com.";
        string = this.isInBrowser ? string + " Then restart the browser." : string + " Then restart the application.";
        return string;
    }

    @Override
    public void init() {
        this.requiredJavaFXVersion = this.getParameter("requiredFXVersion");
        this.test();
        this.populate();
    }

    private void populate() {
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        JTextPane jTextPane = new JTextPane();
        jTextPane.setText(this.getText());
        jTextPane.setEditable(false);
        container.add((Component)jTextPane, "Center");
        if (Main.getJavaVersionAsFloat() > 160.0f || Main.getJavaVersionAsFloat() > 150.0f && !this.doNotUseJNLPAPI) {
            JButton jButton = new JButton("Install Now");
            jButton.addActionListener((ActionListener)this);
            container.add((Component)jButton, "South");
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        try {
            URL uRL = new URL("http://java.com/");
            if (this.isInBrowser) {
                this.getAppletContext().showDocument(uRL);
            } else if (!this.doNotUseJNLPAPI) {
                Class<?> clazz = Class.forName("javax.jnlp.ServiceManager");
                Class<?> clazz2 = Class.forName("javax.jnlp.BasicService");
                Method method = clazz.getMethod("lookup", String.class);
                Method method2 = clazz2.getMethod("showDocument", URL.class);
                Object object = method.invoke(null, "javax.jnlp.BasicService");
                method2.invoke(object, uRL);
            } else {
                Desktop desktop = Desktop.getDesktop();
                if (desktop != null) {
                    desktop.browse(uRL.toURI());
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

