/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.actionprovider;

import com.jrockit.mc.rjmx.IServerHandle;
import com.jrockit.mc.rjmx.RJMXPlugin;
import com.jrockit.mc.rjmx.actionprovider.ActionDescriptor;
import com.jrockit.mc.rjmx.actionprovider.ActionProvider;
import com.jrockit.mc.rjmx.actionprovider.ActionProviderDescriptor;
import com.jrockit.mc.rjmx.actionprovider.IActionProvider;
import com.jrockit.mc.rjmx.actionprovider.IActionProviderFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public class ActionProviderRepository {
    public static IActionProvider buildActionProvider(IServerHandle handle, Runnable onChangeCallback) {
        ActionProvider ap = new ActionProvider();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        ArrayList<IConfigurationElement> addOnElements = new ArrayList<IConfigurationElement>();
        HashMap<String, ActionProviderDescriptor> declaredProviders = new HashMap<String, ActionProviderDescriptor>();
        List<IConfigurationElement> configurationElements = Arrays.asList(registry.getConfigurationElementsFor("com.jrockit.mc.rjmx.actionProvider"));
        Comparator<IConfigurationElement> comparator = new Comparator<IConfigurationElement>(){

            public int getPrio(IConfigurationElement e) {
                String prio = e.getAttribute("priority");
                return prio == null ? 0 : Integer.parseInt(prio);
            }

            @Override
            public int compare(IConfigurationElement o1, IConfigurationElement o2) {
                return this.getPrio(o1) - this.getPrio(o2);
            }
        };
        Collections.sort(configurationElements, comparator);
        for (IConfigurationElement element : configurationElements) {
            try {
                ActionProviderRepository.loadElement(element, handle, onChangeCallback, ap, declaredProviders);
                if (!element.getName().equals("addon")) continue;
                addOnElements.add(element);
            }
            catch (Exception e) {
                RJMXPlugin.getDefault().getLogger().log(Level.WARNING, "Could not load extension for com.jrockit.mc.rjmx.actionProvider", e);
            }
        }
        Collections.sort(addOnElements, comparator);
        for (IConfigurationElement element : addOnElements) {
            String id = element.getAttribute("location");
            ActionProviderDescriptor apd = (ActionProviderDescriptor)declaredProviders.get(id);
            if (apd == null) continue;
            try {
                IConfigurationElement[] iConfigurationElementArray = element.getChildren();
                int n = iConfigurationElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement e = iConfigurationElementArray[n2];
                    ActionProviderRepository.loadElement(e, handle, onChangeCallback, apd, null);
                    ++n2;
                }
            }
            catch (Exception e) {
                RJMXPlugin.getDefault().getLogger().log(Level.WARNING, "Could not load extension for com.jrockit.mc.rjmx.actionProvider", e);
            }
        }
        return ap;
    }

    private static IActionProvider buildProvider(IConfigurationElement providerElement, IServerHandle handle, Runnable onChangeCallback, Map<String, ActionProviderDescriptor> declaredProviders) throws Exception {
        ActionProviderDescriptor adp = new ActionProviderDescriptor(providerElement);
        IConfigurationElement[] iConfigurationElementArray = providerElement.getChildren();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            ActionProviderRepository.loadElement(e, handle, onChangeCallback, adp, declaredProviders);
            ++n2;
        }
        if (adp.getId() != null && declaredProviders != null) {
            declaredProviders.put(adp.getId(), adp);
        }
        return adp;
    }

    private static void loadElement(IConfigurationElement element, IServerHandle handle, Runnable onChangeCallback, ActionProvider into, Map<String, ActionProviderDescriptor> declaredProviders) throws Exception {
        if (element.getName().equals("action")) {
            into.getActions().add(new ActionDescriptor(element, handle));
        } else if (element.getName().equals("provider")) {
            into.getProviders().add(ActionProviderRepository.buildProvider(element, handle, onChangeCallback, declaredProviders));
        } else if (element.getName().equals("providerFactory")) {
            IActionProviderFactory factory = (IActionProviderFactory)element.createExecutableExtension("class");
            factory.initialize(handle, onChangeCallback);
            into.getProviders().addAll(factory.getActionProviders());
            into.getActions().addAll(factory.getActions());
        }
    }
}

