/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.export;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.SyncFailedException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.netbeans.modules.options.export.OptionsChooserPanel;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.EditableProperties;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public final class OptionsExportModel {
    private static final Logger LOGGER = Logger.getLogger(OptionsExportModel.class.getName());
    private static final String OPTIONS_EXPORT_FOLDER = "OptionsExport";
    private static final String GROUP_PATTERN = "([^/]*)";
    private File source;
    private List<Category> categories;
    List<String> relativePaths;
    private ZipOutputStream zipOutputStream;
    private File targetUserdir;
    private Set<String> includePatterns;
    private Set<String> excludePatterns;
    private EditableProperties currentProperties;
    private static final List<String> IGNORED_FOLDERS = Arrays.asList("var/cache");
    private final String PASSWORDS_PATTERN = "config/Preferences/org/netbeans/modules/keyring.*";
    static final String ENABLED_ITEMS_INFO = "enabledItems.info";

    public OptionsExportModel(File file) {
        this.source = file;
    }

    List<Category> getCategories() {
        if (this.categories == null) {
            this.loadCategories();
        }
        return this.categories;
    }

    State getState() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        for (Category category : this.getCategories()) {
            if (!category.isApplicable()) continue;
            ++n3;
            if (category.getState() == State.ENABLED) {
                ++n;
                continue;
            }
            if (category.getState() != State.DISABLED) continue;
            ++n2;
        }
        if (n == n3) {
            return State.ENABLED;
        }
        if (n2 == n3) {
            return State.DISABLED;
        }
        return State.PARTIAL;
    }

    void setState(State state) {
        String string = NbBundle.getMessage(OptionsChooserPanel.class, (String)"OptionsChooserPanel.export.passwords.category.displayName");
        for (Category category : this.getCategories()) {
            if (!category.isApplicable()) continue;
            if (state.equals((Object)State.ENABLED)) {
                if (category.getDisplayName() == null || category.getDisplayName().equals(string)) continue;
                category.setState(state);
                continue;
            }
            category.setState(state);
        }
    }

    void doImport(File file) throws IOException {
        LOGGER.fine("Copying from: " + this.source + "\n    to: " + file);
        this.targetUserdir = file;
        this.copyFiles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doExport(File file, ArrayList<String> arrayList) {
        try {
            OptionsExportModel.ensureParent(file);
            this.zipOutputStream = new ZipOutputStream(OptionsExportModel.createOutputStream(file));
            this.copyFiles();
            this.createEnabledItemsInfo(this.zipOutputStream, arrayList);
            OptionsExportModel.createProductInfo(this.zipOutputStream);
            this.zipOutputStream.close();
        }
        catch (IOException iOException) {
            Exceptions.attachLocalizedMessage((Throwable)iOException, (String)NbBundle.getMessage(OptionsExportModel.class, (String)"OptionsExportModel.export.zip.error", (Object)file));
            Exceptions.printStackTrace((Throwable)iOException);
        }
        finally {
            if (this.zipOutputStream != null) {
                try {
                    this.zipOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void createEnabledItemsInfo(ZipOutputStream zipOutputStream, ArrayList<String> arrayList) throws IOException {
        zipOutputStream.putNextEntry(new ZipEntry(ENABLED_ITEMS_INFO));
        if (!arrayList.isEmpty()) {
            PrintWriter printWriter = new PrintWriter(zipOutputStream);
            for (String string : arrayList) {
                printWriter.println(string);
            }
            printWriter.flush();
        }
        zipOutputStream.closeEntry();
    }

    static Set<String> parsePattern(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        if (string.contains("#")) {
            StringBuilder stringBuilder = new StringBuilder();
            ParserState parserState = ParserState.START;
            int n = 0;
            block6: for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                switch (parserState) {
                    case START: {
                        if (c == '#') {
                            parserState = ParserState.IN_KEY_PATTERN;
                            stringBuilder.append(c);
                            continue block6;
                        }
                        if (c == '(') {
                            parserState = ParserState.IN_BLOCK;
                            ++n;
                            stringBuilder.append(c);
                            continue block6;
                        }
                        if (c == '|') {
                            hashSet.add(stringBuilder.toString());
                            stringBuilder = new StringBuilder();
                            continue block6;
                        }
                        stringBuilder.append(c);
                        continue block6;
                    }
                    case IN_KEY_PATTERN: {
                        if (c == '#') {
                            parserState = ParserState.AFTER_KEY_PATTERN;
                            continue block6;
                        }
                        stringBuilder.append(c);
                        continue block6;
                    }
                    case AFTER_KEY_PATTERN: {
                        if (c == '|') {
                            parserState = ParserState.START;
                            hashSet.add(stringBuilder.toString());
                            stringBuilder = new StringBuilder();
                            continue block6;
                        }
                        assert (false) : "Wrong OptionsExport pattern " + string + ". Only format like filePattern1#keyPattern#|filePattern2 is supported.";
                        continue block6;
                    }
                    case IN_BLOCK: {
                        stringBuilder.append(c);
                        if (c != ')' || --n != 0) continue block6;
                        parserState = ParserState.START;
                    }
                }
            }
            hashSet.add(stringBuilder.toString());
        } else {
            hashSet.add(string);
        }
        return hashSet;
    }

    private Set<String> getIncludePatterns() {
        if (this.includePatterns == null) {
            this.includePatterns = new HashSet<String>();
            for (Category category : this.getCategories()) {
                for (Item item : category.getItems()) {
                    String string;
                    if (!item.isEnabled() || (string = item.getInclude()) == null || string.length() <= 0) continue;
                    this.includePatterns.addAll(OptionsExportModel.parsePattern(string));
                }
            }
        }
        return this.includePatterns;
    }

    private Set<String> getExcludePatterns() {
        if (this.excludePatterns == null) {
            this.excludePatterns = new HashSet<String>();
            String string = NbBundle.getMessage(OptionsChooserPanel.class, (String)"OptionsChooserPanel.export.passwords.displayName");
            for (Category category : this.getCategories()) {
                for (Item item : category.getItems()) {
                    if (item.isEnabled()) {
                        String string2 = item.getExclude();
                        if (string2 == null || string2.length() <= 0) continue;
                        this.excludePatterns.addAll(OptionsExportModel.parsePattern(string2));
                        continue;
                    }
                    if (!item.getDisplayName().equals(string)) continue;
                    this.excludePatterns.add("config/Preferences/org/netbeans/modules/keyring.*");
                }
            }
        }
        return this.excludePatterns;
    }

    public String toString() {
        return this.getClass().getName() + " source=" + this.source;
    }

    private void loadCategories() {
        FileObject[] fileObjectArray = FileUtil.getConfigFile((String)OPTIONS_EXPORT_FOLDER).getChildren();
        List list = FileUtil.getOrder(Arrays.asList(fileObjectArray), (boolean)false);
        this.categories = new ArrayList<Category>(list.size());
        for (FileObject fileObject : list) {
            String string = (String)fileObject.getAttribute("displayName");
            this.categories.add(new Category(fileObject, string));
        }
    }

    private List<String> getApplicablePaths(Set<String> set, Set<String> set2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : this.getRelativePaths()) {
            if (!OptionsExportModel.matches(string, set, set2)) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    private void copyFiles() throws IOException {
        if (this.source.isFile()) {
            try {
                this.copyZipFile();
            }
            catch (IOException iOException) {
                Exceptions.attachLocalizedMessage((Throwable)iOException, (String)NbBundle.getMessage(OptionsExportModel.class, (String)"OptionsExportModel.invalid.zipfile", (Object)this.source));
                Exceptions.printStackTrace((Throwable)iOException);
            }
        } else {
            this.copyFolder(this.source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyZipFile() throws IOException {
        ZipFile zipFile = new ZipFile(this.source);
        try {
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                if (zipEntry.isDirectory()) continue;
                this.copyFile(zipEntry.getName());
            }
        }
        finally {
            if (zipFile != null) {
                zipFile.close();
            }
        }
    }

    private void copyFolder(File file) throws IOException {
        String string = OptionsExportModel.getRelativePath(this.source, file);
        if (IGNORED_FOLDERS.contains(string)) {
            return;
        }
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        for (File file2 : fileArray) {
            if (file2.isDirectory()) {
                this.copyFolder(file2);
                continue;
            }
            this.copyFile(OptionsExportModel.getRelativePath(this.source, file2));
        }
    }

    private List<String> getRelativePaths() {
        if (this.relativePaths == null) {
            if (this.source.isFile()) {
                try {
                    this.relativePaths = OptionsExportModel.listZipFile(this.source);
                }
                catch (IOException iOException) {
                    Exceptions.attachLocalizedMessage((Throwable)iOException, (String)NbBundle.getMessage(OptionsExportModel.class, (String)"OptionsExportModel.invalid.zipfile", (Object)this.source));
                    Exceptions.printStackTrace((Throwable)iOException);
                    this.relativePaths = Collections.emptyList();
                }
            } else {
                this.relativePaths = OptionsExportModel.getRelativePaths(this.source);
            }
            LOGGER.fine("relativePaths=" + this.relativePaths);
        }
        return this.relativePaths;
    }

    static List<String> getRelativePaths(File file) {
        return OptionsExportModel.getRelativePaths(file, file);
    }

    private static List<String> getRelativePaths(File file, File file2) {
        String string = OptionsExportModel.getRelativePath(file, file2);
        ArrayList<String> arrayList = new ArrayList<String>();
        if (file2.isDirectory()) {
            if (IGNORED_FOLDERS.contains(string)) {
                return arrayList;
            }
            File[] fileArray = file2.listFiles();
            if (fileArray == null) {
                return Collections.emptyList();
            }
            for (File file3 : fileArray) {
                arrayList.addAll(OptionsExportModel.getRelativePaths(file, file3));
            }
        } else {
            arrayList.add(string);
        }
        return arrayList;
    }

    private static String getRelativePath(File file, File file2) {
        String string = file2.getAbsolutePath().substring(file.getAbsolutePath().length());
        if ((string = string.replace('\\', '/')).startsWith("/") && !string.startsWith("//")) {
            string = string.substring(1);
        }
        return string;
    }

    private static boolean matches(String string, Set<String> set, Set<String> set2) {
        boolean bl = false;
        for (String string2 : set) {
            if (!OptionsExportModel.matches(string, string2)) continue;
            bl = true;
            break;
        }
        if (bl) {
            for (String string2 : set2) {
                if (string2.contains("#") || !OptionsExportModel.matches(string, string2)) continue;
                return false;
            }
        }
        return bl;
    }

    private static boolean matches(String string, String string2) {
        if (string2.contains("#")) {
            string2 = string2.split("#", 2)[0];
        }
        return string.matches(string2);
    }

    private Set<String> matchingKeys(String string, String string2) throws IOException {
        HashSet<String> hashSet = new HashSet<String>();
        String[] stringArray = string2.split("#", 2);
        String string3 = stringArray[0];
        String string4 = stringArray[1];
        if (string.matches(string3)) {
            if (this.currentProperties == null) {
                this.currentProperties = this.getProperties(string);
            }
            for (String string5 : this.currentProperties.keySet()) {
                if (!string5.matches(string4)) continue;
                hashSet.add(string5);
            }
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFile(String string) throws IOException {
        this.currentProperties = null;
        boolean bl = false;
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        for (String object : this.getIncludePatterns()) {
            if (object.contains("#")) {
                hashSet.addAll(this.matchingKeys(string, object));
                continue;
            }
            if (!string.matches(object)) continue;
            bl = true;
            hashSet.clear();
            break;
        }
        if (bl || !hashSet.isEmpty()) {
            for (String string2 : this.getExcludePatterns()) {
                if (string2.contains("#")) {
                    hashSet2.addAll(this.matchingKeys(string, string2));
                    continue;
                }
                if (!string.matches(string2)) continue;
                bl = false;
                hashSet.clear();
                break;
            }
        }
        LOGGER.log(Level.FINEST, "{0}, includeFile={1}, includeKeys={2}, excludeKeys={3}", new Object[]{string, bl, hashSet, hashSet2});
        if (!bl && hashSet.isEmpty()) {
            return;
        }
        if (this.zipOutputStream != null) {
            LOGGER.log(Level.FINE, "Adding to zip: {0}", string);
            this.zipOutputStream.putNextEntry(new ZipEntry(string));
            this.copyFileOrProperties(string, hashSet, hashSet2, this.zipOutputStream);
            this.zipOutputStream.closeEntry();
        } else {
            Object object2 = null;
            File file = new File(this.targetUserdir, string);
            LOGGER.log(Level.FINE, "Path: {0}", string);
            if (hashSet.isEmpty() && hashSet2.isEmpty()) {
                try {
                    object2 = OptionsExportModel.createOutputStream(file);
                    this.copyFile(string, (OutputStream)object2);
                }
                finally {
                    if (object2 != null) {
                        ((OutputStream)object2).close();
                    }
                }
            } else {
                this.mergeProperties(string, hashSet, hashSet2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeProperties(String string, Set<String> set, Set<String> set2) throws IOException {
        if (!set.isEmpty()) {
            this.currentProperties.keySet().retainAll(set);
        }
        this.currentProperties.keySet().removeAll(set2);
        LOGGER.log(Level.FINE, "  Keys merged with existing properties: {0}", this.currentProperties.keySet());
        if (this.currentProperties.isEmpty()) {
            return;
        }
        EditableProperties editableProperties = new EditableProperties(false);
        InputStream inputStream = null;
        File file = new File(this.targetUserdir, string);
        try {
            if (file.exists()) {
                inputStream = new FileInputStream(file);
                editableProperties.load(inputStream);
            }
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        for (Map.Entry entry : this.currentProperties.entrySet()) {
            editableProperties.put((String)entry.getKey(), (String)entry.getValue());
        }
        Object object = null;
        try {
            object = OptionsExportModel.createOutputStream(file);
            editableProperties.store((OutputStream)object);
        }
        finally {
            if (object != null) {
                ((OutputStream)object).close();
            }
        }
    }

    private void copyFileOrProperties(String string, Set<String> set, Set<String> set2, OutputStream outputStream) throws IOException {
        if (set.isEmpty() && set2.isEmpty()) {
            this.copyFile(string, outputStream);
        } else {
            if (!set.isEmpty()) {
                this.currentProperties.keySet().retainAll(set);
            }
            this.currentProperties.keySet().removeAll(set2);
            LOGGER.log(Level.FINE, "  Only keys: {0}", this.currentProperties.keySet());
            this.currentProperties.store(outputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EditableProperties getProperties(String string) throws IOException {
        EditableProperties editableProperties = new EditableProperties(false);
        InputStream inputStream = null;
        try {
            inputStream = this.getInputStream(string);
            editableProperties.load(inputStream);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        return editableProperties;
    }

    private InputStream getInputStream(String string) throws IOException {
        if (this.source.isFile()) {
            ZipFile zipFile = new ZipFile(this.source);
            ZipEntry zipEntry = zipFile.getEntry(string);
            return zipFile.getInputStream(zipEntry);
        }
        return new FileInputStream(new File(this.source, string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFile(String string, OutputStream outputStream) throws IOException {
        InputStream inputStream = null;
        try {
            inputStream = this.getInputStream(string);
            FileUtil.copy((InputStream)inputStream, (OutputStream)outputStream);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    private static void ensureParent(File file) throws IOException {
        File file2 = file.getParentFile();
        if (file2 != null && !file2.exists() && !file2.mkdirs()) {
            throw new IOException("Cannot create folder: " + file2.getAbsolutePath());
        }
    }

    static List<String> listZipFile(File file) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        ZipFile zipFile = new ZipFile(file);
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            if (zipEntry.isDirectory()) continue;
            arrayList.add(zipEntry.getName());
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void createZipFile(File file, File file2, List<String> list) throws IOException {
        OptionsExportModel.ensureParent(file);
        ZipOutputStream zipOutputStream = null;
        try {
            zipOutputStream = new ZipOutputStream(OptionsExportModel.createOutputStream(file));
            for (String string : list) {
                LOGGER.finest("Adding to zip: " + string);
                zipOutputStream.putNextEntry(new ZipEntry(string));
                FileInputStream fileInputStream = null;
                try {
                    fileInputStream = new FileInputStream(new File(file2, string));
                    FileUtil.copy((InputStream)fileInputStream, (OutputStream)zipOutputStream);
                }
                finally {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                zipOutputStream.closeEntry();
            }
            OptionsExportModel.createProductInfo(zipOutputStream);
            zipOutputStream.close();
        }
        finally {
            if (zipOutputStream != null) {
                zipOutputStream.close();
            }
        }
    }

    private static void createProductInfo(ZipOutputStream zipOutputStream) throws IOException {
        String string = MessageFormat.format(NbBundle.getBundle((String)"org.netbeans.core.startup.Bundle").getString("currentVersion"), System.getProperty("netbeans.buildnumber"));
        String string2 = System.getProperty("os.name", "unknown") + ", " + System.getProperty("os.version", "unknown") + ", " + System.getProperty("os.arch", "unknown");
        String string3 = System.getProperty("java.version", "unknown") + ", " + System.getProperty("java.vm.name", "unknown") + ", " + System.getProperty("java.vm.version", "");
        zipOutputStream.putNextEntry(new ZipEntry("build.info"));
        PrintWriter printWriter = new PrintWriter(zipOutputStream);
        printWriter.println("ProductVersion=" + string);
        printWriter.println("OS=" + string2);
        printWriter.println("Java=" + string3);
        printWriter.println("Userdir=" + System.getProperty("netbeans.user"));
        printWriter.flush();
        zipOutputStream.closeEntry();
    }

    private static OutputStream createOutputStream(File file) throws IOException {
        if (OptionsExportModel.containsConfig(file)) {
            String string;
            file = file.getCanonicalFile();
            File file2 = FileUtil.toFile((FileObject)FileUtil.getConfigRoot());
            String string2 = file.getPath();
            if (string2.startsWith(string = file2.getPath())) {
                String string3 = string2.substring(string.length()).replace(File.separatorChar, '/');
                try {
                    FileObject fileObject = FileUtil.createData((FileObject)FileUtil.getConfigRoot(), (String)string3);
                    if (fileObject != null) {
                        return fileObject.getOutputStream();
                    }
                }
                catch (SyncFailedException syncFailedException) {
                    LOGGER.log(Level.INFO, "File already exists: {0}", string2);
                }
                catch (IOException iOException) {
                    LOGGER.log(Level.INFO, "IOException while getting output stream: {0}", string2);
                }
            }
        }
        OptionsExportModel.ensureParent(file);
        return new FileOutputStream(file);
    }

    private static boolean containsConfig(File file) {
        while (file != null) {
            if (file.getName().equals("config")) {
                return true;
            }
            file = file.getParentFile();
        }
        return false;
    }

    class Category {
        private static final String INCLUDE = "include";
        private static final String EXCLUDE = "exclude";
        private static final String DISPLAY_NAME = "displayName";
        private FileObject categoryFO;
        private String displayName;
        private List<Item> items;
        private State state = State.DISABLED;

        public Category(FileObject fileObject, String string) {
            this.categoryFO = fileObject;
            this.displayName = string;
        }

        private void addItem(String string, String string2, String string3) {
            this.items.add(new Item(string, string2, string3));
        }

        private void resolveGroups(String string, String string2, String string3) {
            Object object;
            LOGGER.fine("resolveGroups include=" + string2);
            List list = OptionsExportModel.this.getApplicablePaths(Collections.singleton(string2), Collections.singleton(string3));
            HashSet<String> hashSet = new HashSet<String>();
            Pattern pattern = Pattern.compile(string2);
            for (String string4 : list) {
                String string5;
                object = pattern.matcher(string4);
                ((Matcher)object).matches();
                if (((Matcher)object).groupCount() != 1 || (string5 = ((Matcher)object).group(1)) == null) continue;
                hashSet.add(string5);
            }
            LOGGER.fine("GROUPS=" + hashSet);
            for (String string4 : hashSet) {
                object = string4;
                if (string.contains("{")) {
                    object = MessageFormat.format(string, string4);
                }
                this.addItem((String)object, string2.replace(OptionsExportModel.GROUP_PATTERN, string4), string3);
            }
        }

        public List<Item> getItems() {
            if (this.items == null) {
                this.items = Collections.synchronizedList(new ArrayList());
                FileObject[] fileObjectArray = this.categoryFO.getChildren();
                List list = FileUtil.getOrder(Arrays.asList(fileObjectArray), (boolean)false);
                for (FileObject fileObject : fileObjectArray = list.toArray(new FileObject[list.size()])) {
                    String string;
                    String string2 = (String)fileObject.getAttribute(DISPLAY_NAME);
                    assert (string2 != null) : "Display name of export option item not defined in layer.";
                    String string3 = (String)fileObject.getAttribute(INCLUDE);
                    if (string3 == null) {
                        string3 = "";
                    }
                    if ((string = (String)fileObject.getAttribute(EXCLUDE)) == null) {
                        string = "";
                    }
                    if (string3.contains(OptionsExportModel.GROUP_PATTERN)) {
                        this.resolveGroups(string2, string3, string);
                        continue;
                    }
                    this.addItem(string2, string3, string);
                }
            }
            return this.items;
        }

        public String getName() {
            return this.categoryFO.getNameExt();
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public void setState(State state) {
            this.state = state;
            this.updateItems(state);
        }

        public State getState() {
            return this.state;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isApplicable() {
            List<Item> list = this.items;
            synchronized (list) {
                for (Item item : this.items) {
                    if (!item.isApplicable()) continue;
                    return true;
                }
            }
            return false;
        }

        public String toString() {
            return this.getDisplayName() + ", state=" + (Object)((Object)this.getState());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateItems(State state) {
            List<Item> list = this.items;
            synchronized (list) {
                for (Item item : this.items) {
                    if (state == State.PARTIAL || !item.isApplicable()) continue;
                    item.setEnabled(state.toBoolean());
                }
            }
        }
    }

    static enum State {
        ENABLED(Boolean.TRUE),
        DISABLED(Boolean.FALSE),
        PARTIAL(null);

        private final Boolean bool;

        private State(Boolean bl) {
            this.bool = bl;
        }

        public Boolean toBoolean() {
            return this.bool;
        }

        public static State valueOf(Boolean bl) {
            if (bl == null) {
                return PARTIAL;
            }
            return bl != false ? ENABLED : DISABLED;
        }
    }

    class Item {
        private String displayName;
        private String include;
        private String exclude;
        private boolean enabled = false;
        private boolean applicable = false;
        private boolean applicableInitialized = false;

        public Item(String string, String string2, String string3) {
            this.displayName = string;
            this.include = string2;
            this.exclude = string3;
            assert (this.assertIgnoredFolders(string2));
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getInclude() {
            return this.include;
        }

        public String getExclude() {
            return this.exclude;
        }

        public boolean isApplicable() {
            if (!this.applicableInitialized) {
                List list = OptionsExportModel.this.getApplicablePaths(Collections.singleton(this.include), Collections.singleton(this.exclude));
                LOGGER.fine("    applicablePaths=" + list);
                this.applicable = !list.isEmpty();
                this.applicableInitialized = true;
            }
            return this.applicable;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean bl) {
            if (this.enabled != bl) {
                this.enabled = bl;
                OptionsExportModel.this.includePatterns = null;
                OptionsExportModel.this.excludePatterns = null;
            }
        }

        public String toString() {
            return this.getDisplayName() + ", enabled=" + this.isEnabled();
        }

        private boolean assertIgnoredFolders(String string) {
            boolean bl = true;
            for (String string2 : IGNORED_FOLDERS) {
                assert (bl = !string.contains(string2)) : "Pattern " + string + " matches ignored folder " + string2;
            }
            return bl;
        }
    }

    private static enum ParserState {
        START,
        IN_KEY_PATTERN,
        AFTER_KEY_PATTERN,
        IN_BLOCK;

    }
}

