/*
 * Decompiled with CFR 0.152.
 */
package bluej.doclet.doclets.formats.html;

import bluej.doclet.doclets.formats.html.AbstractIndexWriter;
import bluej.doclet.doclets.formats.html.ConfigurationImpl;
import bluej.doclet.doclets.internal.toolkit.util.DocletAbortException;
import bluej.doclet.doclets.internal.toolkit.util.IndexBuilder;
import java.io.IOException;

public class SingleIndexWriter
extends AbstractIndexWriter {
    public SingleIndexWriter(ConfigurationImpl configuration, String filename, IndexBuilder indexbuilder) throws IOException {
        super(configuration, filename, indexbuilder);
        this.relativepathNoSlash = ".";
        this.relativePath = "./";
    }

    public static void generate(ConfigurationImpl configuration, IndexBuilder indexbuilder) {
        String filename = "index-all.html";
        try {
            SingleIndexWriter indexgen = new SingleIndexWriter(configuration, filename, indexbuilder);
            indexgen.generateIndexFile();
            indexgen.close();
        }
        catch (IOException exc) {
            configuration.standardmessage.error("doclet.exception_encountered", exc.toString(), filename);
            throw new DocletAbortException();
        }
    }

    protected void generateIndexFile() throws IOException {
        this.printHtmlHeader(this.configuration.getText("doclet.Window_Single_Index"), null, true);
        this.printTop();
        this.navLinks(true);
        this.printLinksForIndexes();
        this.hr();
        for (int i = 0; i < this.indexbuilder.elements().length; ++i) {
            Character unicode = (Character)this.indexbuilder.elements()[i];
            this.generateContents(unicode, this.indexbuilder.getMemberList(unicode));
        }
        this.printLinksForIndexes();
        this.navLinks(false);
        this.printBottom();
        this.printBodyHtmlEnd();
    }

    protected void printLinksForIndexes() {
        for (int i = 0; i < this.indexbuilder.elements().length; ++i) {
            String unicode = this.indexbuilder.elements()[i].toString();
            this.printHyperLink("#_" + unicode + "_", unicode);
            this.print(' ');
        }
    }
}

