/*
 * Decompiled with CFR 0.152.
 */
package bluej.views;

import bluej.debugger.gentype.GenTypeDeclTpar;
import bluej.utility.JavaNames;
import bluej.utility.JavaUtils;
import bluej.views.Comment;
import bluej.views.CommentList;
import bluej.views.ConstructorView;
import bluej.views.FieldView;
import bluej.views.MemberView;
import bluej.views.MethodView;
import bluej.views.TypeParamView;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.Any)
public class View {
    protected Class<?> cl;
    protected FieldView[] fields;
    protected FieldView[] allFields;
    protected ConstructorView[] constructors;
    protected MethodView[] methods;
    protected MethodView[] allMethods;
    protected TypeParamView[] typeParams;
    protected Comment comment;
    private static Map<Class<?>, View> views = new HashMap();
    boolean comments_loaded = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static View getView(Class<?> cl) {
        if (cl == null) {
            return null;
        }
        Map<Class<?>, View> map = views;
        synchronized (map) {
            View v = views.get(cl);
            if (v == null) {
                v = new View(cl);
                views.put(cl, v);
            }
            return v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeAll(ClassLoader loader) {
        Map<Class<?>, View> map = views;
        synchronized (map) {
            Iterator<View> it = views.values().iterator();
            while (it.hasNext()) {
                View v = it.next();
                if (v.getClassLoader() != loader) continue;
                it.remove();
            }
        }
    }

    private View(Class<?> cl) {
        this.cl = cl;
    }

    private ClassLoader getClassLoader() {
        return this.cl.getClassLoader();
    }

    public String getQualifiedName() {
        return this.cl.getName();
    }

    public String getPackageName() {
        String clName = this.cl.getName();
        int i = clName.lastIndexOf(46);
        if (i == -1) {
            return "";
        }
        return clName.substring(0, i);
    }

    public Class<?> getViewClass() {
        return this.cl;
    }

    public String getBaseName() {
        return JavaNames.getBase(this.cl.getName());
    }

    public View getSuper() {
        return View.getView(this.cl.getSuperclass());
    }

    public View[] getInterfaces() {
        Class<?>[] interfaces = this.cl.getInterfaces();
        View[] interfaceViews = new View[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            interfaceViews[i] = View.getView(interfaces[i]);
        }
        return interfaceViews;
    }

    public final boolean isInterface() {
        return this.cl.isInterface();
    }

    public final boolean isGeneric() {
        return this.getTypeParams().length > 0;
    }

    public TypeParamView[] getTypeParams() {
        if (this.typeParams == null) {
            List<GenTypeDeclTpar> genTypeParams = JavaUtils.getJavaUtils().getTypeParams(this.cl);
            this.typeParams = new TypeParamView[genTypeParams.size()];
            for (int i = 0; i < this.typeParams.length; ++i) {
                this.typeParams[i] = new TypeParamView(this, genTypeParams.get(i));
            }
        }
        return this.typeParams;
    }

    public synchronized MethodView[] getAllMethods() {
        if (this.allMethods == null) {
            HashMap<String, MemberElement> map = new HashMap<String, MemberElement>();
            this.getAllMethods(map, 0);
            ArrayList<MemberElement> methods = new ArrayList<MemberElement>(map.values());
            Collections.sort(methods, new ElementComparer());
            int numMethods = methods.size();
            this.allMethods = new MethodView[numMethods];
            for (int i = 0; i < numMethods; ++i) {
                MemberElement elem = (MemberElement)methods.get(i);
                this.allMethods[i] = (MethodView)elem.member;
            }
        }
        return this.allMethods;
    }

    public FieldView[] getAllFields() {
        if (this.allFields == null) {
            HashMap<String, MemberElement> map = new HashMap<String, MemberElement>();
            this.getAllFields(map, 0);
            ArrayList<MemberElement> fields = new ArrayList<MemberElement>(map.values());
            Collections.sort(fields, new ElementComparer());
            int numFields = fields.size();
            this.allFields = new FieldView[numFields];
            for (int i = 0; i < numFields; ++i) {
                MemberElement elem = (MemberElement)fields.get(i);
                this.allFields[i] = (FieldView)elem.member;
            }
        }
        return this.allFields;
    }

    protected int getAllMethods(HashMap<String, MemberElement> h, int methnum) {
        if (this.allMethods != null) {
            methnum = this.addMembers(h, this.allMethods, methnum);
            return methnum;
        }
        View sView = this.getSuper();
        if (sView != null) {
            methnum = sView.getAllMethods(h, methnum);
        }
        if (this.isInterface()) {
            View[] ifaces = this.getInterfaces();
            for (int i = 0; i < ifaces.length; ++i) {
                methnum = ifaces[i].getAllMethods(h, methnum);
            }
        }
        methnum = this.addMembers(h, this.getDeclaredMethods(), methnum);
        return methnum;
    }

    protected int getAllFields(HashMap<String, MemberElement> h, int fieldnum) {
        if (this.allFields != null) {
            fieldnum = this.addMembers(h, this.allFields, fieldnum);
            return fieldnum;
        }
        View sView = this.getSuper();
        if (sView != null) {
            fieldnum = sView.getAllFields(h, fieldnum);
        }
        View[] ifaces = this.getInterfaces();
        for (int i = 0; i < ifaces.length; ++i) {
            fieldnum = ifaces[i].getAllFields(h, fieldnum);
        }
        fieldnum = this.addMembers(h, this.getDeclaredFields(), fieldnum);
        return fieldnum;
    }

    private int addMembers(HashMap<String, MemberElement> h, MemberView[] members, int num) {
        for (int i = members.length - 1; i >= 0; --i) {
            h.put(members[i].toString(), new MemberElement(num++, members[i]));
        }
        return num;
    }

    public MethodView[] getDeclaredMethods() {
        if (this.methods == null) {
            int count = 0;
            try {
                int i;
                Method[] cl_methods = this.cl.getDeclaredMethods();
                for (i = 0; i < cl_methods.length; ++i) {
                    if (cl_methods[i].isSynthetic()) continue;
                    ++count;
                }
                this.methods = new MethodView[count];
                count = 0;
                for (i = 0; i < cl_methods.length; ++i) {
                    block8: {
                        if (cl_methods[i].isSynthetic()) continue;
                        try {
                            this.methods[count] = new MethodView(this, cl_methods[i]);
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                            if (!(t instanceof ClassNotFoundException)) break block8;
                            throw (ClassNotFoundException)t;
                        }
                    }
                    ++count;
                }
            }
            catch (LinkageError le) {
                this.methods = new MethodView[0];
            }
            catch (ClassNotFoundException cnfe) {
                this.methods = new MethodView[0];
            }
        }
        return this.methods;
    }

    public FieldView[] getDeclaredFields() {
        if (this.fields == null) {
            try {
                Field[] cl_fields = this.cl.getDeclaredFields();
                this.fields = new FieldView[cl_fields.length];
                for (int i = 0; i < cl_fields.length; ++i) {
                    this.fields[i] = new FieldView(this, cl_fields[i]);
                }
            }
            catch (LinkageError le) {
                this.fields = new FieldView[0];
            }
        }
        return this.fields;
    }

    public ConstructorView[] getConstructors() {
        if (this.constructors == null) {
            try {
                Constructor<?>[] cl_constrs = this.cl.getDeclaredConstructors();
                this.constructors = new ConstructorView[cl_constrs.length];
                for (int i = 0; i < this.constructors.length; ++i) {
                    this.constructors[i] = new ConstructorView(this, cl_constrs[i]);
                }
            }
            catch (LinkageError le) {
                return new ConstructorView[0];
            }
        }
        return this.constructors;
    }

    public Comment getComment() {
        this.loadComments();
        return this.comment;
    }

    public void setComment(Comment comment) {
        this.comment = comment;
    }

    protected void loadComments() {
        if (this.comments_loaded) {
            return;
        }
        this.comments_loaded = true;
        HashMap<String, MemberView> table = new HashMap<String, MemberView>();
        this.addMembers(table, this.getAllFields());
        this.addMembers(table, this.getConstructors());
        this.addMembers(table, this.getAllMethods());
        this.loadClassComments(this, table);
    }

    protected void loadClassComments(View curview, Map<String, MemberView> table) {
        if (curview.getSuper() != null) {
            this.loadClassComments(curview.getSuper(), table);
        }
        CommentList comments = null;
        String filename = curview.getQualifiedName().replace('.', '/') + ".ctxt";
        try {
            InputStream in = null;
            in = curview.cl.getClassLoader() == null ? ClassLoader.getSystemResourceAsStream(filename) : curview.cl.getClassLoader().getResourceAsStream(filename);
            if (in != null) {
                comments = new CommentList();
                comments.load(in);
                in.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (comments != null) {
            Iterator<Comment> it = comments.getComments();
            while (it.hasNext()) {
                Comment c = it.next();
                if (c.getTarget().startsWith("class ") || c.getTarget().startsWith("interface ")) {
                    if (curview != this) continue;
                    this.setComment(c);
                    continue;
                }
                MemberView m = table.get(c.getTarget());
                if (m == null) continue;
                m.setComment(c);
            }
        }
    }

    private void addMembers(Map<String, MemberView> table, MemberView[] members) {
        for (int i = 0; i < members.length; ++i) {
            table.put(members[i].getSignature(), members[i]);
        }
    }

    public String getTypeName() {
        return View.getTypeName(this.cl);
    }

    static String getTypeName(Class<?> type) {
        if (type.isArray()) {
            try {
                Class<?> primtype = type;
                int dimensions = 0;
                while (primtype.isArray()) {
                    ++dimensions;
                    primtype = primtype.getComponentType();
                }
                StringBuffer sb = new StringBuffer();
                sb.append(JavaNames.stripPrefix(primtype.getName()));
                for (int i = 0; i < dimensions; ++i) {
                    sb.append("[]");
                }
                return sb.toString();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return JavaNames.stripPrefix(type.getName());
    }

    class ElementComparer
    implements Comparator<MemberElement> {
        ElementComparer() {
        }

        @Override
        public final int compare(MemberElement a, MemberElement b) {
            int cmp = a.index - b.index;
            return cmp < 0 ? -1 : (cmp > 0 ? 1 : 0);
        }
    }

    class MemberElement {
        int index;
        MemberView member;

        MemberElement(int index, MemberView member) {
            this.index = index;
            this.member = member;
        }
    }
}

