/*
 * Decompiled with CFR 0.152.
 */
package bluej.utility.javafx;

import bluej.utility.javafx.JavaFXUtil;
import bluej.utility.javafx.TriangleArrow;
import javafx.animation.Animation;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.css.Styleable;
import javafx.geometry.HPos;
import javafx.geometry.Orientation;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import javafx.scene.shape.Rectangle;
import javafx.util.Duration;

public class UntitledCollapsiblePane
extends Pane {
    private final TriangleArrow arrow = new TriangleArrow(Orientation.VERTICAL);
    private final DoubleProperty transitionProperty = new SimpleDoubleProperty(1.0){

        protected void invalidated() {
            UntitledCollapsiblePane.this.requestLayout();
        }
    };
    private final Node content;
    private final Rectangle clipRect;
    private final BooleanProperty expanded = new SimpleBooleanProperty();
    private Animation animation;

    public UntitledCollapsiblePane(Node content, boolean startCollapsed) {
        this.content = content;
        this.clipRect = new Rectangle();
        this.getChildren().addAll((Object[])new Node[]{this.arrow, content});
        content.setClip((Node)this.clipRect);
        this.clipRect.widthProperty().bind((ObservableValue)this.widthProperty());
        JavaFXUtil.addStyleClass((Styleable)this, "untitled-pane");
        this.expanded.set(!startCollapsed);
        this.arrow.setOnMouseClicked(e -> this.expanded.set(!this.expanded.get()));
        if (startCollapsed) {
            this.transitionProperty.set(0.0);
            this.arrow.scaleProperty().set(1.0);
        } else {
            this.transitionProperty.set(1.0);
            this.arrow.scaleProperty().set(-1.0);
        }
        JavaFXUtil.addChangeListener(this.expanded, this::runAnimation);
    }

    private void runAnimation(boolean toExpanded) {
        if (this.animation != null) {
            this.animation.stop();
        }
        double dest = toExpanded ? 1.0 : 0.0;
        double destScale = toExpanded ? -1.0 : 1.0;
        this.animation = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)300.0), new KeyValue[]{new KeyValue((WritableValue)this.transitionProperty, (Object)dest), new KeyValue((WritableValue)this.arrow.scaleProperty(), (Object)destScale)})});
        this.animation.setOnFinished(ev -> {
            this.animation = null;
        });
        this.animation.playFromStart();
    }

    public BooleanProperty expandedProperty() {
        return this.expanded;
    }

    protected void layoutChildren() {
        this.layoutChildren(0.0, 0.0, this.getWidth(), this.getHeight());
    }

    private void layoutChildren(double x, double y, double w, double h) {
        double headerHeight = this.snapSize(10.0);
        this.arrow.resize(w, headerHeight);
        this.positionInArea((Node)this.arrow, x, y, w, headerHeight, 0.0, HPos.CENTER, VPos.CENTER);
        double contentHeight = (h - headerHeight) * this.getTransition();
        contentHeight = this.snapSize(contentHeight);
        this.content.resize(w, contentHeight);
        this.clipRect.setHeight(contentHeight);
        this.positionInArea(this.content, x, y += this.snapSize(headerHeight), w, contentHeight, 0.0, HPos.CENTER, VPos.CENTER);
    }

    protected double computePrefWidth(double height) {
        return this.content.prefWidth(height);
    }

    protected double computePrefHeight(double width) {
        return this.content.prefHeight(width) * this.getTransition() + 10.0;
    }

    protected double computeMinWidth(double height) {
        return this.content.minWidth(height);
    }

    protected double computeMinHeight(double width) {
        return this.content.minHeight(width) * this.getTransition() + 10.0;
    }

    private double getTransition() {
        return this.transitionProperty.get();
    }
}

