/*
 * Decompiled with CFR 0.152.
 */
package bluej.utility.javafx;

import bluej.BlueJTheme;
import bluej.Config;
import bluej.utility.javafx.FXPlatformRunnable;
import bluej.utility.javafx.FXPlatformSupplier;
import bluej.utility.javafx.SwingNodeFixed;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.SecondaryLoop;
import java.awt.Toolkit;
import javafx.application.Platform;
import javafx.embed.swing.SwingNode;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.stage.Modality;
import javafx.stage.Window;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import threadchecker.OnThread;
import threadchecker.Tag;

public class SwingNodeDialog {
    private @OnThread(value=Tag.Any) SwingNode swingNode = new SwingNodeFixed();
    private @OnThread(value=Tag.Swing) boolean modal = false;
    private @OnThread(value=Tag.FXPlatform) Dialog<Object> dialog;
    private boolean clickedSwingClose = false;

    @OnThread(value=Tag.Swing)
    protected SwingNodeDialog() {
        JPanel content = new JPanel();
        content.setLayout(new BorderLayout());
        this.swingNode.setContent((JComponent)content);
        Platform.runLater(() -> {
            this.dialog = new Dialog();
            BlueJTheme.setWindowIconFX(this.dialog);
            this.dialog.setResultConverter(bt -> new Object());
            this.dialog.setResult(new Object());
            this.dialog.getDialogPane().setContent((Node)this.swingNode);
            this.dialog.initModality(Modality.NONE);
            this.dialog.setOnShown(e -> SwingUtilities.invokeLater(() -> this.pack()));
        });
    }

    @OnThread(value=Tag.Swing)
    protected SwingNodeDialog(FXPlatformSupplier<Window> owner) {
        this();
        Platform.runLater(() -> this.dialog.initOwner((Window)owner.get()));
    }

    @OnThread(value=Tag.Swing)
    protected void setModal(boolean makeModal) {
        this.modal = makeModal;
        Platform.runLater(() -> this.dialog.initModality(makeModal ? Modality.APPLICATION_MODAL : Modality.NONE));
    }

    @OnThread(value=Tag.Swing)
    protected void rememberPosition(String locationPrefix) {
        Platform.runLater(() -> this.dialog.setOnShown(e -> {
            Config.rememberPosition(this.asWindow(), locationPrefix);
            SwingUtilities.invokeLater(() -> this.pack());
        }));
    }

    @OnThread(value=Tag.Swing)
    public void setVisible(boolean show) {
        if (show) {
            if (this.modal) {
                SecondaryLoop loop = Toolkit.getDefaultToolkit().getSystemEventQueue().createSecondaryLoop();
                Platform.runLater(() -> {
                    this.dialog.setOnHidden(e -> SwingUtilities.invokeLater(() -> loop.exit()));
                    this.dialog.show();
                });
                loop.enter();
            } else {
                Platform.runLater(() -> this.dialog.show());
            }
        } else {
            Platform.runLater(() -> this.dialog.hide());
        }
    }

    @OnThread(value=Tag.Swing)
    protected void setTitle(String title) {
        Platform.runLater(() -> this.dialog.setTitle(title));
    }

    @OnThread(value=Tag.Swing)
    public void pack() {
        Dimension preferredSize = this.swingNode.getContent().getPreferredSize();
        preferredSize.setSize(preferredSize.getWidth(), preferredSize.getHeight() + 22.0);
        this.swingNode.getContent().validate();
        Platform.runLater(() -> {
            this.dialog.getDialogPane().setPrefWidth(preferredSize.getWidth());
            this.dialog.getDialogPane().setPrefHeight(preferredSize.getHeight());
            this.dialog.getDialogPane().setMinWidth(Double.NEGATIVE_INFINITY);
            this.dialog.getDialogPane().setMinHeight(Double.NEGATIVE_INFINITY);
            if (this.asWindow() != null && this.asWindow().getHeight() < preferredSize.getHeight()) {
                this.asWindow().setHeight(preferredSize.getHeight());
            }
        });
    }

    @OnThread(value=Tag.Swing)
    protected JComponent getContentPane() {
        return this.swingNode.getContent();
    }

    @OnThread(value=Tag.Swing)
    protected void setContentPane(JComponent content) {
        this.swingNode.setContent(content);
    }

    @OnThread(value=Tag.Swing)
    public void dispose() {
        this.setVisible(false);
    }

    @OnThread(value=Tag.FXPlatform)
    public Window asWindow() {
        Scene scene = this.dialog.getDialogPane().getScene();
        if (scene == null) {
            return null;
        }
        return scene.getWindow();
    }

    @OnThread(value=Tag.Swing)
    protected void setDefaultButton(JButton button) {
    }

    @OnThread(value=Tag.Swing)
    public FocusTraversalPolicy getFocusTraversalPolicy() {
        return this.swingNode.getContent().getFocusTraversalPolicy();
    }

    @OnThread(value=Tag.Swing)
    public void setFocusTraversalPolicy(FocusTraversalPolicy policy) {
        this.swingNode.getContent().setFocusTraversalPolicy(policy);
    }

    @OnThread(value=Tag.Swing)
    public void setLocationRelativeTo(JComponent comp) {
    }

    @OnThread(value=Tag.FXPlatform)
    public void setLocationRelativeTo(Window window) {
    }

    @OnThread(value=Tag.Swing)
    protected void dialogThenHide(FXPlatformRunnable action) {
        Platform.runLater(() -> {
            action.run();
            SwingUtilities.invokeLater(() -> this.setVisible(false));
        });
    }

    @OnThread(value=Tag.FXPlatform)
    protected void setCloseIsButton(JButton button) {
        this.dialog.getDialogPane().getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.CANCEL});
        Button dummy = (Button)this.dialog.getDialogPane().lookupButton(ButtonType.CANCEL);
        dummy.setVisible(false);
        dummy.setManaged(false);
        this.dialog.setOnHiding(e -> {
            if (!this.clickedSwingClose) {
                SwingUtilities.invokeLater(() -> button.doClick());
                this.clickedSwingClose = true;
            }
        });
    }

    @OnThread(value=Tag.Swing)
    protected void setResizable(boolean resizable) {
        Platform.runLater(() -> this.dialog.setResizable(resizable));
    }
}

