/*
 * Decompiled with CFR 0.152.
 */
package bluej.utility.javafx;

import bluej.utility.javafx.JavaFXUtil;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.css.Styleable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.RadioButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.HBox;

public class HorizontalRadio<T> {
    private final HBox hBox;
    private final IdentityHashMap<T, ButtonBase> buttonsByValue = new IdentityHashMap();
    private final SimpleObjectProperty<T> selected = new SimpleObjectProperty();

    public HorizontalRadio(List<T> choices) {
        ArrayList<RadioButton> buttons = new ArrayList<RadioButton>();
        ToggleGroup toggleGroup = new ToggleGroup();
        for (int i = 0; i < choices.size(); ++i) {
            T value = choices.get(i);
            RadioButton button = new RadioButton(value.toString());
            this.buttonsByValue.put(value, (ButtonBase)button);
            JavaFXUtil.addChangeListener(button.selectedProperty(), sel -> {
                if (sel.booleanValue()) {
                    this.selected.set(value);
                }
            });
            button.setToggleGroup(toggleGroup);
            JavaFXUtil.addStyleClass((Styleable)button, "radio-check-border");
            button.maxWidthProperty().bind((ObservableValue)button.prefWidthProperty());
            button.getStyleClass().addAll((Object[])new String[]{"toggle-button", i == 0 ? "left-pill" : (i == choices.size() - 1 ? "right-pill" : "center-pill")});
            buttons.add(button);
        }
        this.hBox = new HBox(buttons.toArray(new Node[0]));
        this.hBox.setAlignment(Pos.BASELINE_LEFT);
    }

    public HBox getButtons() {
        return this.hBox;
    }

    public ReadOnlyObjectProperty<T> selectedProperty() {
        return this.selected;
    }

    public void select(T item) {
        this.buttonsByValue.get(item).fire();
    }
}

