/*
 * Decompiled with CFR 0.152.
 */
package bluej.utility.javafx;

import bluej.utility.javafx.FXPlatformSupplier;
import bluej.utility.javafx.HangingFlowPane;
import bluej.utility.javafx.JavaFXUtil;
import java.util.ArrayList;
import java.util.List;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Region;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public class GrowableList<T extends Node> {
    private final FXPlatformSupplier<T> newNodeFactory;
    private final List<T> items = new ArrayList<T>();
    private final ObservableList<Node> inclButtons = FXCollections.observableArrayList();

    public GrowableList(FXPlatformSupplier<T> newNodeFactory) {
        this.newNodeFactory = newNodeFactory;
        this.inclButtons.setAll((Object[])new Node[]{this.makePlusButton()});
        this.addNewItem(0);
    }

    private Node makeCrossButton() {
        Button button = JavaFXUtil.withStyleClass(new Button(), "growable-remove");
        button.setGraphic((Node)JavaFXUtil.withStyleClass(new Region(), "growable-remove-graphic"));
        button.setOnAction(e -> {
            int index = this.inclButtons.indexOf((Object)button);
            this.removeItem((index - 2) / 3);
        });
        button.addEventFilter(MouseEvent.MOUSE_ENTERED, e -> this.setRemoveHighlight(button, true));
        button.addEventFilter(MouseEvent.MOUSE_EXITED, e -> this.setRemoveHighlight(button, button.isFocused()));
        JavaFXUtil.addFocusListener((Node)button, focus -> this.setRemoveHighlight(button, (boolean)focus));
        HangingFlowPane.setBreakBefore((Node)button, false);
        return button;
    }

    private void setRemoveHighlight(Button button, boolean on) {
        int index = this.inclButtons.indexOf((Object)button);
        if (index != -1) {
            JavaFXUtil.setPseudoclass("bj-growable-remove-highlight", on, (Node)this.inclButtons.get(index - 1));
        }
    }

    private void removeItem(int index) {
        this.items.remove(index);
        this.inclButtons.remove(index * 3 + 3);
        this.inclButtons.remove(index * 3 + 2);
        this.inclButtons.remove(index * 3 + 1);
    }

    private Node makePlusButton() {
        Button button = JavaFXUtil.withStyleClass(new Button(), "growable-add");
        button.setGraphic((Node)JavaFXUtil.withStyleClass(new Region(), "growable-add-graphic"));
        button.setOnAction(e -> {
            int index = this.inclButtons.indexOf((Object)button);
            this.addNewItem(index / 3);
        });
        HangingFlowPane.setBreakBefore((Node)button, true);
        HangingFlowPane.setMargin((Node)button, new Insets(0.0, 0.0, 0.0, 8.0));
        return button;
    }

    private void addNewItem(int itemIndex) {
        Node newItem = (Node)this.newNodeFactory.get();
        HangingFlowPane.setBreakBefore(newItem, false);
        this.items.add(itemIndex, newItem);
        this.inclButtons.add(itemIndex * 3 + 1, (Object)newItem);
        this.inclButtons.add(itemIndex * 3 + 2, (Object)this.makeCrossButton());
        this.inclButtons.add(itemIndex * 3 + 3, (Object)this.makePlusButton());
    }

    public T getItem(int index) {
        return (T)((Node)this.items.get(index));
    }

    public ObservableList<? extends Node> getNodes() {
        return this.inclButtons;
    }

    public int size() {
        return this.items.size();
    }
}

