/*
 * Decompiled with CFR 0.152.
 */
package bluej.utility;

import bluej.Config;
import bluej.prefmgr.PrefMgr;
import bluej.utility.javafx.JavaFXUtil;
import bluej.utility.javafx.dialog.DialogPaneAnimateError;
import java.io.File;
import java.nio.file.InvalidPathException;
import java.nio.file.Paths;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.StringBinding;
import javafx.beans.value.ObservableValue;
import javafx.css.Styleable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import javafx.scene.control.Label;
import javafx.scene.control.OverrunStyle;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.VBox;
import javafx.stage.DirectoryChooser;
import javafx.stage.Modality;
import javafx.stage.Window;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
class ProjectLocationDialog {
    private final Dialog<File> dialog;
    private final TextField nameField;
    private final TextField parentField;
    private final Label compoundPath;
    private final Label errorLabel = new Label();
    private final DialogPaneAnimateError dialogPane;
    private boolean dialogHasBeenEdited = false;

    public ProjectLocationDialog(Window owner, String title) {
        this.dialog = new Dialog();
        this.dialog.initOwner(owner);
        this.dialog.initModality(Modality.WINDOW_MODAL);
        this.dialog.setTitle(title);
        this.dialogPane = new DialogPaneAnimateError(this.errorLabel, () -> this.updateOKButton(true));
        this.dialog.setDialogPane((DialogPane)this.dialogPane);
        Config.addDialogStylesheets(this.dialog.getDialogPane());
        this.dialog.getDialogPane().getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        JavaFXUtil.addStyleClass((Styleable)this.errorLabel, "dialog-error-label");
        GridPane gridPane = new GridPane();
        JavaFXUtil.addStyleClass((Styleable)gridPane, "proj-grid");
        gridPane.add((Node)this.makeLabel(Config.getString("newProject.name")), 0, 0);
        gridPane.add((Node)this.makeLabel(Config.getString("newProject.parent")), 0, 1);
        gridPane.add((Node)this.makeLabel(Config.getString("newProject.path")), 0, 2);
        this.nameField = new TextField("");
        gridPane.add((Node)this.nameField, 1, 0);
        JavaFXUtil.addChangeListenerPlatform(this.nameField.textProperty(), s -> {
            this.dialogHasBeenEdited = true;
        });
        this.parentField = new TextField(PrefMgr.getProjectDirectory().getAbsolutePath());
        JavaFXUtil.addChangeListenerPlatform(this.parentField.textProperty(), s -> {
            this.dialogHasBeenEdited = true;
        });
        gridPane.add((Node)this.parentField, 1, 1);
        Button chooseParent = new Button(Config.getString("newProject.parent.choose"));
        chooseParent.setOnAction(e -> {
            DirectoryChooser newChooser = new DirectoryChooser();
            newChooser.setTitle(title);
            newChooser.setInitialDirectory(new File(this.parentField.getText()));
            File chosen = newChooser.showDialog(this.dialogPane.getScene().getWindow());
            if (chosen != null) {
                this.parentField.setText(chosen.getAbsolutePath());
            }
        });
        chooseParent.setMinWidth(Double.NEGATIVE_INFINITY);
        gridPane.add((Node)chooseParent, 2, 1);
        this.compoundPath = new Label();
        this.compoundPath.setMinWidth(250.0);
        this.compoundPath.setTextOverrun(OverrunStyle.CENTER_ELLIPSIS);
        JavaFXUtil.addStyleClass((Styleable)this.compoundPath, "compound-path");
        this.compoundPath.textProperty().bind((ObservableValue)new StringBinding(){
            {
                super.bind(new Observable[]{ProjectLocationDialog.this.parentField.textProperty()});
            }

            protected String computeValue() {
                return new File(ProjectLocationDialog.this.parentField.getText(), ProjectLocationDialog.this.nameField.getText()).getAbsolutePath();
            }
        });
        JavaFXUtil.addChangeListenerPlatform(this.compoundPath.textProperty(), x -> this.updateOKButton(false));
        gridPane.add((Node)this.compoundPath, 1, 2);
        VBox content = new VBox(new Node[]{gridPane, this.errorLabel});
        JavaFXUtil.addStyleClass((Styleable)content, "new-project-dialog");
        this.dialogPane.setContent((Node)content);
        this.dialog.setResultConverter(button -> {
            if (button == ButtonType.OK) {
                return new File(this.compoundPath.getText());
            }
            return null;
        });
        this.dialog.setResizable(true);
        this.updateOKButton(false);
    }

    private Label makeLabel(String string) {
        Label label = new Label(string);
        label.setMinWidth(Double.NEGATIVE_INFINITY);
        return label;
    }

    public File showAndWait() {
        return this.dialog.showAndWait().orElse(null);
    }

    private void updateOKButton(boolean force) {
        boolean enable = false;
        try {
            if (!Paths.get(this.parentField.getText(), new String[0]).toFile().exists()) {
                this.showError(Config.getString("newProject.error.parentNotExist"), false);
            } else if (this.dialogHasBeenEdited || force) {
                if (this.nameField.getText().isEmpty()) {
                    this.showError(Config.getString("newProject.error.nameEmpty"), true);
                } else {
                    File compound = Paths.get(this.compoundPath.getText(), new String[0]).toFile();
                    if (compound.exists()) {
                        this.showError(Config.getString("newProject.error.compoundExist"), false);
                    } else {
                        this.hideError();
                        enable = true;
                    }
                }
            } else {
                this.hideError();
                enable = true;
            }
        }
        catch (InvalidPathException e2) {
            this.showError(Config.getString("newProject.error.pathInvalid"), true);
        }
        this.setOKEnabled(enable);
        this.dialog.setOnShown(e -> Platform.runLater(() -> ((TextField)this.nameField).requestFocus()));
    }

    private void hideError() {
        this.errorLabel.setText("");
        JavaFXUtil.setPseudoclass("bj-dialog-error", false, new Node[]{this.nameField});
        JavaFXUtil.setPseudoclass("bj-dialog-error", false, new Node[]{this.parentField});
    }

    private void showError(String error, boolean problemIsName) {
        this.errorLabel.setText(error);
        JavaFXUtil.setPseudoclass("bj-dialog-error", problemIsName, new Node[]{this.nameField});
        JavaFXUtil.setPseudoclass("bj-dialog-error", !problemIsName, new Node[]{this.parentField});
    }

    private void setOKEnabled(boolean okEnabled) {
        this.dialogPane.getOKButton().setDisable(!okEnabled);
    }
}

