/*
 * Decompiled with CFR 0.152.
 */
package bluej.utility;

import bluej.Config;
import bluej.utility.BlueJFileReader;
import bluej.utility.Debug;
import bluej.utility.Utility;
import bluej.utility.javafx.SwingNodeDialog;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.StringSelection;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.TextInputDialog;
import javafx.stage.Modality;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.Swing)
public class DialogManager {
    private static final String DLG_FILE_NAME = "dialogues";
    private static final String GREENFOOT_DLG_FILE_NAME = "greenfoot/dialogues";

    public static void showMessage(Component parent, String msgID) {
        String message = DialogManager.getMessage(msgID, new String[0]);
        if (message != null) {
            JOptionPane.showMessageDialog(parent, message, Config.getApplicationName() + ":  " + Config.getString("dialogmgr.message"), 1);
        }
    }

    @OnThread(value=Tag.FXPlatform)
    public static void showMessageFX(javafx.stage.Window parent, String msgID) {
        DialogManager.showMessageFX(parent, msgID, new String[0]);
    }

    @OnThread(value=Tag.FXPlatform)
    public static void showMessageFX(javafx.stage.Window parent, String msgID, String[] subs) {
        String message = DialogManager.getMessage(msgID, new String[0]);
        if (message != null) {
            for (String sub : subs) {
                message = message.replace("$", sub);
            }
            Alert alert = new Alert(Alert.AlertType.INFORMATION, "", new ButtonType[]{ButtonType.OK});
            alert.setHeaderText(message);
            alert.setTitle(Config.getApplicationName() + ":  " + Config.getString("dialogmgr.message"));
            alert.initOwner(parent);
            alert.initModality(Modality.WINDOW_MODAL);
            alert.showAndWait();
        }
    }

    @OnThread(value=Tag.FXPlatform)
    public static void showMessageWithTextFX(javafx.stage.Window parent, String msgID, String text) {
        String message = DialogManager.getMessage(msgID, new String[0]);
        if (message != null) {
            Alert alert = new Alert(Alert.AlertType.INFORMATION, text, new ButtonType[]{ButtonType.OK});
            alert.setHeaderText(message);
            alert.setTitle(Config.getApplicationName() + ":  " + Config.getString("dialogmgr.message"));
            alert.initOwner(parent);
            alert.initModality(Modality.WINDOW_MODAL);
            alert.showAndWait();
        }
    }

    @OnThread(value=Tag.FXPlatform)
    public static void showMessageWithPrefixTextFX(javafx.stage.Window parent, String msgID, String text, String innerText) {
        String message = DialogManager.getMessage(msgID, new String[0]);
        String messageDialog = Utility.mergeStrings(message, innerText);
        if (message != null) {
            Alert alert = new Alert(Alert.AlertType.INFORMATION, "", new ButtonType[]{ButtonType.OK});
            alert.setHeaderText("");
            alert.setTitle(Config.getApplicationName() + ":  " + Config.getString("dialogmgr.message"));
            alert.initOwner(parent);
            alert.initModality(Modality.WINDOW_MODAL);
            alert.setContentText(messageDialog);
            alert.showAndWait();
        }
    }

    public static void showText(Component parent, String text) {
        JOptionPane.showMessageDialog(parent, text);
    }

    @OnThread(value=Tag.FXPlatform)
    public static void showTextWithCopyButtonFX(javafx.stage.Window parent, String text, String title) {
        Alert alert = new Alert(Alert.AlertType.INFORMATION, text, new ButtonType[]{ButtonType.OK, ButtonType.APPLY});
        ((Button)alert.getDialogPane().lookupButton(ButtonType.APPLY)).setText(Config.getString("editor.copy-to-clipboardLabel"));
        alert.setTitle(title);
        alert.initOwner(parent);
        alert.initModality(Modality.WINDOW_MODAL);
        if (alert.showAndWait().orElse(ButtonType.OK) == ButtonType.APPLY) {
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(text), null);
        }
    }

    @OnThread(value=Tag.FXPlatform)
    public static void showTextFX(javafx.stage.Window parent, String text) {
        Alert alert = new Alert(Alert.AlertType.INFORMATION, text, new ButtonType[]{ButtonType.OK});
        alert.initOwner(parent);
        alert.initModality(Modality.WINDOW_MODAL);
        alert.showAndWait();
    }

    public static void showError(Component parent, String msgID) {
        String message = DialogManager.getMessage(msgID, new String[0]);
        if (message != null) {
            DialogManager.showErrorText(parent, message);
        }
    }

    @OnThread(value=Tag.FXPlatform)
    public static void showErrorFX(javafx.stage.Window parent, String msgID) {
        String message = DialogManager.getMessage(msgID, new String[0]);
        if (message != null) {
            DialogManager.showErrorTextFX(parent, message);
        }
    }

    public static void showErrorText(Component parent, String message) {
        JOptionPane.showMessageDialog(parent, message, Config.getApplicationName() + ":  " + Config.getString("dialogmgr.error"), 0);
    }

    @OnThread(value=Tag.FXPlatform)
    public static void showErrorTextFX(javafx.stage.Window parent, String message) {
        Alert alert = new Alert(Alert.AlertType.ERROR, message, new ButtonType[]{ButtonType.OK});
        alert.setTitle(Config.getApplicationName() + ":  " + Config.getString("dialogmgr.error"));
        alert.initOwner(parent);
        alert.initModality(Modality.WINDOW_MODAL);
        alert.showAndWait();
    }

    @OnThread(value=Tag.FXPlatform)
    public static void showErrorWithTextFX(javafx.stage.Window parent, String msgID, String text) {
        String message = DialogManager.getMessage(msgID, new String[0]);
        if (message != null) {
            DialogManager.showErrorTextFX(parent, message + "\n" + text);
        }
    }

    @OnThread(value=Tag.FXPlatform)
    public static int askQuestionFX(javafx.stage.Window parent, String msgID) {
        MessageAndButtons messageAndButtons = new MessageAndButtons(DialogManager.getMessage(msgID, new String[0]));
        if (messageAndButtons.getMessage() != null) {
            ArrayList<ButtonType> buttons = new ArrayList<ButtonType>();
            for (int i = 0; i < messageAndButtons.getOptions().size(); ++i) {
                buttons.add(new ButtonType(messageAndButtons.getOptions().get(i), i == messageAndButtons.getOptions().size() - 1 ? ButtonBar.ButtonData.NO : ButtonBar.ButtonData.YES));
            }
            Alert alert = new Alert(Alert.AlertType.CONFIRMATION, messageAndButtons.getMessage(), buttons.toArray(new ButtonType[0]));
            alert.initOwner(parent);
            alert.initModality(Modality.WINDOW_MODAL);
            alert.setTitle(Config.getApplicationName() + ":  " + Config.getString("dialogmgr.question"));
            return alert.showAndWait().map(buttons::indexOf).orElse(buttons.size() - 1);
        }
        return 0;
    }

    @OnThread(value=Tag.FXPlatform)
    public static int askQuestionFX(javafx.stage.Window parent, String msgID, String[] subs) {
        String message = DialogManager.getMessage(msgID, new String[0]);
        if (message != null) {
            int button3Index = message.lastIndexOf("\n");
            int button2Index = message.lastIndexOf("\n", button3Index - 1);
            int button1Index = message.lastIndexOf("\n", button2Index - 1);
            String button3 = message.substring(button3Index + 1);
            String button2 = message.substring(button2Index + 1, button3Index);
            String button1 = message.substring(button1Index + 1, button2Index);
            message = message.substring(0, button1Index);
            message = Utility.mergeStrings(message, subs);
            ArrayList<ButtonType> buttons = new ArrayList<ButtonType>();
            boolean hasThirdButton = "null".equals(button3);
            buttons.add(new ButtonType(button1, hasThirdButton ? ButtonBar.ButtonData.CANCEL_CLOSE : ButtonBar.ButtonData.NO));
            buttons.add(new ButtonType(button2, hasThirdButton ? ButtonBar.ButtonData.NO : ButtonBar.ButtonData.YES));
            if (hasThirdButton) {
                buttons.add(new ButtonType(button3, ButtonBar.ButtonData.YES));
            }
            Alert alert = new Alert(Alert.AlertType.CONFIRMATION, message, buttons.toArray(new ButtonType[0]));
            alert.initOwner(parent);
            alert.initModality(Modality.WINDOW_MODAL);
            alert.setTitle(Config.getApplicationName() + ":  " + Config.getString("dialogmgr.question"));
            return alert.showAndWait().map(buttons::indexOf).orElse(buttons.size() - 1);
        }
        return 0;
    }

    @OnThread(value=Tag.FXPlatform)
    public static String askStringFX(javafx.stage.Window parent, String msgID) {
        String response = "";
        String message = DialogManager.getMessage(msgID, new String[0]);
        if (message != null) {
            int defaultTextIndex = message.lastIndexOf("\n");
            int titleIndex = message.lastIndexOf("\n", defaultTextIndex - 1);
            String defaultText = message.substring(defaultTextIndex + 1);
            String title = message.substring(titleIndex + 1, defaultTextIndex);
            message = message.substring(0, titleIndex);
            if ("null".equals(defaultText)) {
                defaultText = null;
            }
            TextInputDialog dialog = new TextInputDialog(defaultText);
            dialog.initModality(Modality.WINDOW_MODAL);
            dialog.initOwner(parent);
            dialog.setTitle(title);
            dialog.setHeaderText(message);
            return dialog.showAndWait().orElse(null);
        }
        return response;
    }

    @OnThread(value=Tag.FXPlatform)
    public static String askStringFX(javafx.stage.Window parent, String msgID, String defaultText) {
        String response = "";
        String message = DialogManager.getMessage(msgID, new String[0]);
        if (message != null) {
            int defaultTextIndex = message.lastIndexOf("\n");
            int titleIndex = message.lastIndexOf("\n", defaultTextIndex - 1);
            String title = message.substring(titleIndex + 1, defaultTextIndex);
            message = message.substring(0, titleIndex);
            TextInputDialog dialog = new TextInputDialog(defaultText);
            dialog.initModality(Modality.WINDOW_MODAL);
            dialog.initOwner(parent);
            dialog.setTitle(title);
            dialog.setHeaderText(message);
            return dialog.showAndWait().orElse(null);
        }
        return response;
    }

    @OnThread(value=Tag.Any)
    public static String getMessage(String msgID, String ... subs) {
        File filename;
        String message = null;
        if (Config.isGreenfoot() && (message = BlueJFileReader.readHelpText(filename = Config.getLanguageFile(GREENFOOT_DLG_FILE_NAME), msgID, true)) == null) {
            filename = Config.getDefaultLanguageFile(GREENFOOT_DLG_FILE_NAME);
            message = BlueJFileReader.readHelpText(filename, msgID, true);
        }
        if (message == null) {
            filename = Config.getLanguageFile(DLG_FILE_NAME);
            message = BlueJFileReader.readHelpText(filename, msgID, true);
        }
        if (message == null && !Config.language.equals("english")) {
            filename = Config.getDefaultLanguageFile(DLG_FILE_NAME);
            message = BlueJFileReader.readHelpText(filename, msgID, true);
        }
        if (message == null) {
            message = "BlueJ configuration problem:\ntext not found for message ID\n" + msgID;
            Debug.message(message);
        } else {
            for (String sub : subs) {
                message = message.replace("$", sub);
            }
        }
        return message;
    }

    public static void centreDialog(JDialog dialog) {
        DialogManager.centreWindow(dialog, (Window)dialog.getParent());
    }

    public static void centreDialog(SwingNodeDialog dialog) {
    }

    public static void centreWindow(Window child, Window parent) {
        child.setLocationRelativeTo(parent);
    }

    public static void addOKCancelButtons(JPanel panel, JButton okButton, JButton cancelButton) {
        if (Config.isMacOS()) {
            panel.add(cancelButton);
            panel.add(okButton);
        } else {
            panel.add(okButton);
            panel.add(cancelButton);
        }
    }

    private static class MessageAndButtons {
        private final String message;
        private final List<String> options;

        public MessageAndButtons(String message) {
            if (message == null) {
                this.message = null;
                this.options = null;
                return;
            }
            int button3Index = message.lastIndexOf("\n");
            int button2Index = message.lastIndexOf("\n", button3Index - 1);
            int button1Index = message.lastIndexOf("\n", button2Index - 1);
            String button3 = message.substring(button3Index + 1);
            String button2 = message.substring(button2Index + 1, button3Index);
            String button1 = message.substring(button1Index + 1, button2Index);
            this.message = message.substring(0, button1Index);
            this.options = "null".equals(button3) ? Arrays.asList(button1, button2) : Arrays.asList(button1, button2, button3);
        }

        public String getMessage() {
            return this.message;
        }

        public List<String> getOptions() {
            return this.options;
        }
    }
}

