/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.slots;

import bluej.stride.slots.SuggestionList;
import bluej.utility.javafx.FXPlatformConsumer;
import bluej.utility.javafx.JavaFXUtil;
import bluej.utility.javafx.ScalableHeightLabel;
import javafx.animation.FadeTransition;
import javafx.beans.binding.DoubleExpression;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.css.Styleable;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.util.Duration;

class SuggestionCell
extends ListCell<SuggestionList.SuggestionListItem>
implements ChangeListener<Object> {
    private final Label special = new Label();
    private final Label type = new Label();
    private final Label prefix;
    private final Label matching;
    private final Label next;
    private final Label suffix;
    private final Label fixedPostSuffix;
    private final Label buttonHint;
    private boolean showingHint;
    private final BorderPane pane;
    private final HBox hbox;

    public SuggestionCell(DoubleExpression typeWidth, FXPlatformConsumer<SuggestionList.SuggestionListItem> clickListener) {
        this.type.minWidthProperty().bind((ObservableValue)typeWidth);
        this.type.maxWidthProperty().bind((ObservableValue)typeWidth);
        this.prefix = new Label();
        this.matching = new Label();
        this.next = new Label();
        this.suffix = new Label();
        this.fixedPostSuffix = new Label();
        JavaFXUtil.addStyleClass((Styleable)this, "suggestion-cell");
        JavaFXUtil.addStyleClass((Styleable)this.type, "suggestion-type");
        JavaFXUtil.addStyleClass((Styleable)this.prefix, "suggestion-prefix");
        JavaFXUtil.addStyleClass((Styleable)this.matching, "suggestion-matching");
        JavaFXUtil.addStyleClass((Styleable)this.next, "suggestion-next");
        JavaFXUtil.addStyleClass((Styleable)this.suffix, "suggestion-suffix");
        this.prefix.setMinWidth(Double.NEGATIVE_INFINITY);
        this.matching.setMinWidth(Double.NEGATIVE_INFINITY);
        this.next.setMinWidth(Double.NEGATIVE_INFINITY);
        this.suffix.setMinWidth(0.0);
        this.fixedPostSuffix.setMinWidth(0.0);
        this.buttonHint = new ScalableHeightLabel("\u21b5", false);
        JavaFXUtil.addStyleClass((Styleable)this.buttonHint, "suggestion-button-hint");
        this.buttonHint.setMinWidth(Double.NEGATIVE_INFINITY);
        this.buttonHint.setOpacity(0.0);
        this.showingHint = false;
        this.special.setMaxWidth(9999.0);
        this.special.setText("Related:");
        JavaFXUtil.addStyleClass((Styleable)this.special, "suggestion-similar-heading");
        this.hbox = new HBox();
        this.hbox.getChildren().addAll((Object[])new Node[]{this.type, this.prefix, this.matching, this.next, this.suffix, this.fixedPostSuffix});
        this.hbox.setSpacing(0.0);
        this.pane = new BorderPane();
        this.pane.setCenter((Node)this.hbox);
        this.pane.setRight((Node)this.buttonHint);
        JavaFXUtil.addStyleClass((Styleable)this.pane, "suggestion");
        this.pane.setOnMouseClicked(e -> clickListener.accept((SuggestionList.SuggestionListItem)this.itemProperty().get()));
        this.itemProperty().addListener((_obs, oldItem, item) -> {
            if (oldItem != null) {
                oldItem.eligibleAt.removeListener((ChangeListener)this);
                oldItem.eligibleLength.removeListener((ChangeListener)this);
                oldItem.eligibleCanTab.removeListener((ChangeListener)this);
                oldItem.highlighted.removeListener((ChangeListener)this);
            }
            this.update((SuggestionList.SuggestionListItem)item);
            if (item != null) {
                item.eligibleAt.addListener((ChangeListener)this);
                item.eligibleLength.addListener((ChangeListener)this);
                item.eligibleCanTab.addListener((ChangeListener)this);
                item.highlighted.addListener((ChangeListener)this);
            }
        });
        this.setGraphic((Node)this.pane);
    }

    private void update(SuggestionList.SuggestionListItem item) {
        if (item != null && item.index == -1) {
            this.pane.setCenter((Node)this.special);
            this.pane.setRight(null);
        } else {
            this.pane.setCenter((Node)this.hbox);
            this.pane.setRight((Node)this.buttonHint);
        }
        if (item != null && item.index != -1) {
            this.update(item.getDetails().choice, item.getDetails().suffix, item.getDetails().type, item.typeMatch, item.direct, item.eligibleAt.get(), item.eligibleLength.get(), item.eligibleCanTab.get(), item.highlighted.get());
        } else {
            this.update("", "", "", false, true, 0, 0, false, false);
        }
    }

    private void update(String text, String unmatchableSuffix, String type, boolean typeMatch, boolean direct, int at, int len, boolean canTab, boolean highlighted) {
        this.type.setText(type);
        JavaFXUtil.setPseudoclass("bj-match", typeMatch, new Node[]{this.type});
        if (text.length() >= 1) {
            this.next.setText(text.substring(0, 1));
            this.suffix.setText(text.substring(1));
        } else {
            this.next.setText("");
            this.suffix.setText("");
        }
        this.fixedPostSuffix.setText(unmatchableSuffix);
        JavaFXUtil.setPseudoclass("bj-suggestion-similar", !direct, new Node[]{this.pane});
        JavaFXUtil.setPseudoclass("bj-suggestion-highlight", highlighted, new Node[]{this.pane});
        if (canTab) {
            this.setHintShowing(true, true);
        } else {
            this.setHintShowing(false, true);
        }
        this.prefix.setText(text.substring(0, at));
        int end = Math.min(at + len, text.length());
        this.matching.setText(text.substring(at, end));
        String rest = text.substring(end);
        if (rest.length() >= 1) {
            this.next.setText(rest.substring(0, 1));
            this.suffix.setText(rest.substring(1));
        } else {
            this.next.setText("");
            this.suffix.setText("");
        }
    }

    public void changed(ObservableValue<?> observable, Object oldValue, Object newValue) {
        this.update((SuggestionList.SuggestionListItem)this.itemProperty().get());
    }

    private void setHintShowing(boolean shouldShow, boolean immediate) {
        if (this.showingHint != shouldShow) {
            double targetOpacity;
            this.showingHint = shouldShow;
            double d = targetOpacity = shouldShow ? 1.0 : 0.0;
            if (immediate) {
                this.buttonHint.setOpacity(targetOpacity);
            } else {
                FadeTransition ft = new FadeTransition(Duration.millis((double)200.0), (Node)this.buttonHint);
                ft.setToValue(targetOpacity);
                ft.play();
            }
        }
    }
}

