/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.slots;

import bluej.Config;
import bluej.collect.StrideEditReason;
import bluej.editor.stride.CodeOverlayPane;
import bluej.editor.stride.FrameCatalogue;
import bluej.stride.framedjava.ast.JavaFragment;
import bluej.stride.framedjava.ast.SlotFragment;
import bluej.stride.framedjava.ast.StructuredSlotFragment;
import bluej.stride.framedjava.ast.links.PossibleLink;
import bluej.stride.framedjava.elements.CodeElement;
import bluej.stride.framedjava.errors.CodeError;
import bluej.stride.framedjava.errors.ErrorAndFixDisplay;
import bluej.stride.framedjava.frames.CodeFrame;
import bluej.stride.framedjava.slots.BracketedStructured;
import bluej.stride.framedjava.slots.CaretPos;
import bluej.stride.framedjava.slots.InfixStructured;
import bluej.stride.framedjava.slots.Operator;
import bluej.stride.framedjava.slots.StructuredCompletionCalculator;
import bluej.stride.framedjava.slots.StructuredSlotField;
import bluej.stride.framedjava.slots.TextOverlayPosition;
import bluej.stride.framedjava.slots.UnderlineContainer;
import bluej.stride.generic.ExtensionDescription;
import bluej.stride.generic.Frame;
import bluej.stride.generic.FrameContentRow;
import bluej.stride.generic.InteractionManager;
import bluej.stride.slots.EditableSlot;
import bluej.stride.slots.Focus;
import bluej.stride.slots.FocusParent;
import bluej.stride.slots.HeaderItem;
import bluej.stride.slots.LinkedIdentifier;
import bluej.stride.slots.SlotLabel;
import bluej.stride.slots.SuggestionList;
import bluej.utility.Debug;
import bluej.utility.Utility;
import bluej.utility.javafx.ErrorUnderlineCanvas;
import bluej.utility.javafx.FXBiConsumer;
import bluej.utility.javafx.FXConsumer;
import bluej.utility.javafx.FXFunction;
import bluej.utility.javafx.FXPlatformConsumer;
import bluej.utility.javafx.FXPlatformFunction;
import bluej.utility.javafx.FXRunnable;
import bluej.utility.javafx.JavaFXUtil;
import bluej.utility.javafx.SharedTransition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.binding.DoubleExpression;
import javafx.beans.binding.StringExpression;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.Styleable;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.input.Clipboard;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Duration;
import threadchecker.OnThread;
import threadchecker.Tag;

public abstract class StructuredSlot<SLOT_FRAGMENT extends StructuredSlotFragment, INFIX extends InfixStructured<?, INFIX>, COMPLETION_CALCULATOR extends StructuredCompletionCalculator>
implements EditableSlot,
ErrorAndFixDisplay.ErrorFixListener,
SuggestionList.SuggestionListListener {
    private final ErrorUnderlineCanvas overlay;
    private final Frame parentFrame;
    protected final CodeFrame<?> parentCodeFrame;
    private final FrameContentRow row;
    private final @OnThread(value=Tag.FXPlatform) List<CodeError> allErrors = new ArrayList<CodeError>();
    private final @OnThread(value=Tag.FXPlatform) List<CodeError> shownErrors = new ArrayList<CodeError>();
    private ErrorAndFixDisplay errorAndFixDisplay;
    private CodeError hoverErrorCurrentlyShown;
    private SLOT_FRAGMENT slotElement;
    protected final INFIX topLevel;
    protected final InteractionManager editor;
    private final List<UnderlineContainer.Underline> underlines = new ArrayList<UnderlineContainer.Underline>();
    protected final COMPLETION_CALCULATOR completionCalculator;
    private SuggestionList suggestionDisplay;
    private Region suggestionNode;
    private boolean currentlyCompleting = false;
    private List<InteractionManager.FileCompletion> fileCompletions;
    private Map<KeyCode, Runnable> fileCompletionShortcuts;
    private StringExpression targetType;
    private boolean beenModified = false;
    protected final StringProperty textMirror = new SimpleStringProperty("");
    private List<TextOverlayPosition> selectionDrawPositions;
    private final List<FXRunnable> lostFocusActions = new ArrayList<FXRunnable>();
    private CaretPos suggestionLocation;
    private StructuredSlotField suggestionField;
    private final SimpleBooleanProperty fakeCaretShowing = new SimpleBooleanProperty(false);
    private final List<FrameCatalogue.Hint> hints;
    private final ObservableList<String> recentValues = FXCollections.observableArrayList();
    private CaretPos mostRecentPos;
    private String valueOnGain;
    private boolean editable = true;
    private final BooleanProperty focusedProperty = new SimpleBooleanProperty(false);
    private final BooleanBinding effectivelyFocusedProperty;
    private final List<ModificationToken> modificationTokens = new ArrayList<ModificationToken>();
    protected final List<FXRunnable> afterModify = new ArrayList<FXRunnable>();

    public StructuredSlot(InteractionManager editor, Frame parentFrame, CodeFrame<?> parentCodeFrame, FrameContentRow row, String stylePrefix, COMPLETION_CALCULATOR completionCalculator, List<FrameCatalogue.Hint> hints) {
        this.editor = editor;
        this.parentFrame = parentFrame;
        this.parentCodeFrame = parentCodeFrame;
        this.row = row;
        this.completionCalculator = completionCalculator;
        this.hints = hints;
        this.topLevel = this.newInfix(editor, new ModificationToken());
        this.effectivelyFocusedProperty = this.focusedProperty.or((ObservableBooleanValue)this.fakeCaretShowing);
        JavaFXUtil.addChangeListener(this.textMirror, t -> {
            if (!editor.isLoading()) {
                this.modified();
            } else {
                parentFrame.trackBlank();
            }
        });
        this.overlay = row.getOverlay();
        this.overlay.addExtraRedraw(gc -> {
            gc.save();
            if (this.selectionDrawPositions != null && !this.selectionDrawPositions.isEmpty()) {
                gc.setFill(editor.getHighlightColor());
                for (TextOverlayPosition.Line l : TextOverlayPosition.groupIntoLines(this.selectionDrawPositions)) {
                    l.transform(this.overlay::sceneToLocal);
                    gc.fillRect(l.startX + 1.0, l.topY, l.endX - l.startX, l.bottomY - l.topY);
                }
            }
            if (this.fakeCaretShowing.get()) {
                gc.setStroke((Paint)Color.BLACK);
                double x = this.overlay.sceneToLocal(((InfixStructured)this.topLevel).calculateOverlayPos(this.suggestionLocation).getSceneX(), 0.0).getX();
                gc.strokeLine(x, 0.0, x, this.suggestionField.heightProperty().get());
            }
            gc.restore();
        });
        JavaFXUtil.addChangeListener(this.fakeCaretShowing, b -> JavaFXUtil.runNowOrLater(() -> this.overlay.redraw()));
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void flagErrorsAsOld() {
        this.allErrors.forEach(CodeError::flagAsOld);
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void removeOldErrors() {
        this.allErrors.removeIf(CodeError::isFlaggedAsOld);
        this.recalculateShownErrors();
    }

    @OnThread(value=Tag.FXPlatform)
    private void recalculateShownErrors() {
        this.shownErrors.clear();
        List<CodeError> sortedErrors = this.allErrors.stream().sorted((a, b) -> CodeError.compareErrors(a, b)).collect(Collectors.toList());
        sortedErrors.forEach(e -> {
            if (this.shownErrors.stream().allMatch(shown -> !shown.overlaps((CodeError)e))) {
                this.shownErrors.add((CodeError)e);
                e.setShowingIndicator(true);
            } else {
                e.setShowingIndicator(false);
            }
        });
        this.clearErrorMarkers();
        this.shownErrors.forEach(e -> this.drawErrorMarker(e.getStartPosition(), e.getEndPosition(), e.isJavaPos(), b -> this.showErrorHover(b != false ? e : null), e.visibleProperty()));
        CaretPos curPos = ((InfixStructured)this.topLevel).getCurrentPos();
        if (curPos != null) {
            JavaFXUtil.runNowOrLater(() -> this.showErrorAtCaret(curPos));
        }
    }

    @OnThread(value=Tag.FXPlatform)
    private void showErrorHover(CodeError error) {
        if (this.errorAndFixDisplay != null) {
            if (error != null && this.errorAndFixDisplay.getError().equals(error)) {
                this.hoverErrorCurrentlyShown = error;
                return;
            }
            CaretPos caretPos = ((InfixStructured)this.topLevel).getCurrentPos();
            if (caretPos != null) {
                int caretPosition = ((InfixStructured)this.topLevel).caretPosToStringPos(caretPos, true);
                Optional<CodeError> errorAtCaret = this.shownErrors.stream().filter(e -> e.getStartPosition() <= caretPosition && caretPosition <= e.getEndPosition()).findFirst();
                if (error == null && errorAtCaret.isPresent() && errorAtCaret.get().equals(this.errorAndFixDisplay.getError())) {
                    this.hoverErrorCurrentlyShown = null;
                    return;
                }
            }
            this.errorAndFixDisplay.hide();
            this.errorAndFixDisplay = null;
        }
        if (error != null && error.visibleProperty().get()) {
            this.hoverErrorCurrentlyShown = error;
            this.errorAndFixDisplay = new ErrorAndFixDisplay(this.editor, error, this);
            this.errorAndFixDisplay.showBelow((Region)error.getRelevantNode(), Duration.ZERO);
        }
    }

    @OnThread(value=Tag.FXPlatform)
    private void showErrorAtCaret(CaretPos curPos) {
        if (curPos == null) {
            if (this.errorAndFixDisplay != null) {
                this.errorAndFixDisplay.hide();
                this.errorAndFixDisplay = null;
            }
            return;
        }
        int caretPosition = ((InfixStructured)this.topLevel).caretPosToStringPos(curPos, true);
        Optional<CodeError> errorAtCaret = this.shownErrors.stream().filter(e -> e.getStartPosition() <= caretPosition && caretPosition <= e.getEndPosition()).findFirst();
        if (errorAtCaret.isPresent() && this.errorAndFixDisplay != null && this.errorAndFixDisplay.getError().equals(errorAtCaret.get())) {
            return;
        }
        if (this.errorAndFixDisplay != null) {
            this.errorAndFixDisplay.hide();
            this.errorAndFixDisplay = null;
        }
        if (errorAtCaret.isPresent() && errorAtCaret.get().visibleProperty().get()) {
            this.errorAndFixDisplay = new ErrorAndFixDisplay(this.editor, errorAtCaret.get(), this);
            this.errorAndFixDisplay.showBelow(((InfixStructured)this.topLevel).getNodeForPos(curPos));
        }
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void addError(CodeError err) {
        this.allErrors.add(err);
        err.bindFresh((ObservableBooleanValue)this.getFreshExtra(err).or(this.getParentFrame().freshProperty()), this.editor);
        this.recalculateShownErrors();
    }

    protected BooleanExpression getFreshExtra(CodeError err) {
        return new ReadOnlyBooleanWrapper(false);
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void fixedError(CodeError err) {
        this.allErrors.remove(err);
        this.recalculateShownErrors();
    }

    @OnThread(value=Tag.FXPlatform)
    public void drawErrorMarker(int startPos, int endPos, boolean javaPos, FXPlatformConsumer<Boolean> onHover, ObservableBooleanValue visible) {
        if (startPos == 0 && endPos == 0 || this.getText().length() == 0) {
            this.overlay.addErrorMarker(this, 0, Integer.MAX_VALUE, false, onHover, visible);
        } else {
            this.overlay.addErrorMarker(this, startPos, endPos, javaPos, onHover, visible);
        }
    }

    protected abstract SLOT_FRAGMENT makeSlotFragment(String var1, String var2);

    public SLOT_FRAGMENT getSlotElement() {
        if (this.slotElement == null || this.beenModified) {
            this.slotElement = this.makeSlotFragment(this.getText(), this.getJavaCode());
            this.beenModified = false;
        }
        return this.slotElement;
    }

    @OnThread(value=Tag.FXPlatform)
    public void clearErrorMarkers() {
        this.overlay.clearErrorMarkers(this);
    }

    public void setSimplePromptText(String t) {
        FXRunnable action = () -> ((InfixStructured)this.topLevel).withContent((fields, ops) -> {
            if (ops.isEmpty() && fields.size() == 1 && fields.get(0) instanceof StructuredSlotField) {
                ((StructuredSlotField)fields.get(0)).setPromptText(t);
            } else if (fields.size() > 0) {
                ((StructuredSlotField)fields.get(0)).setPromptText("");
            }
        });
        this.afterModify.add(action);
        action.run();
    }

    public void setMethodCallPromptText(String t) {
        FXRunnable action = () -> ((InfixStructured)this.topLevel).withContent((fields, ops) -> {
            if (ops.size() == 0 || fields.size() == 0) {
                return;
            }
            for (int i = 0; i < fields.size() - 1; ++i) {
                if (!(fields.get(i) instanceof StructuredSlotField)) continue;
                StructuredSlotField f = (StructuredSlotField)fields.get(i);
                if (ops.get(i) != null || !(fields.get(i + 1) instanceof BracketedStructured) || i != 0 && (ops.get(i - 1) == null || !((Operator)ops.get(i - 1)).get().equals("."))) continue;
                f.setPromptText(t);
            }
        });
        this.afterModify.add(action);
        action.run();
    }

    public void onTextPropertyChange(FXConsumer<String> listener) {
        JavaFXUtil.addChangeListener(this.textMirror, listener);
    }

    public void onTextPropertyChangeOld(FXBiConsumer<String, String> listener) {
        this.textMirror.addListener((a, oldVal, newVal) -> listener.accept((String)oldVal, (String)newVal));
    }

    public String getText() {
        return ((InfixStructured)this.topLevel).getCopyText(null, null);
    }

    @Override
    public boolean isFocused() {
        return ((InfixStructured)this.topLevel).isFocused();
    }

    @Override
    public int getFocusInfo() {
        CaretPos pos = ((InfixStructured)this.topLevel).getCurrentPos();
        if (pos == null) {
            pos = this.mostRecentPos;
        }
        if (pos == null) {
            return 0;
        }
        return ((InfixStructured)this.topLevel).caretPosToStringPos(pos, false);
    }

    @Override
    public Node recallFocus(int info) {
        return ((InfixStructured)this.topLevel).positionCaret(((InfixStructured)this.topLevel).stringPosToCaretPos(info, false));
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public Stream<CodeError> getCurrentErrors() {
        return this.shownErrors.stream();
    }

    public void setText(String text) {
        this.modification(token -> {
            ((InfixStructured)this.topLevel).blank((ModificationToken)token);
            if (!"".equals(text)) {
                ((InfixStructured)this.topLevel).insert(((InfixStructured)this.topLevel).getFirstField(), 0, text);
            }
        });
    }

    @Override
    public void focusAndPositionAtError(CodeError err) {
        this.requestFocus();
        ((InfixStructured)this.topLevel).positionCaret(this.javaPosToCaretPos(err.getStartPosition()));
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void addUnderline(UnderlineContainer.Underline u) {
        this.underlines.add(u);
        this.drawUnderlines();
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void removeAllUnderlines() {
        this.underlines.clear();
        this.drawUnderlines();
    }

    @OnThread(value=Tag.FXPlatform)
    private void drawUnderlines() {
        this.overlay.clearUnderlines();
        this.underlines.forEach(u -> this.overlay.addUnderline(this, u.getStartPosition(), u.getEndPosition(), u.getOnClick()));
    }

    @Override
    public void cleanup() {
        if (this.suggestionDisplay != null) {
            this.hideSuggestionDisplay();
        }
        if (this.errorAndFixDisplay != null) {
            ErrorAndFixDisplay errorAndFixDisplayToHide = this.errorAndFixDisplay;
            JavaFXUtil.runNowOrLater(() -> errorAndFixDisplayToHide.hide());
            this.errorAndFixDisplay = null;
        }
        JavaFXUtil.runNowOrLater(() -> {
            this.shownErrors.clear();
            this.clearErrorMarkers();
            this.overlay.clearUnderlines();
        });
    }

    public void replace(int startPosInSlot, int endPosInSlot, boolean javaPos, String s) {
        if (javaPos) {
            startPosInSlot = ((InfixStructured)this.topLevel).caretPosToStringPos(this.javaPosToCaretPos(startPosInSlot), false);
            endPosInSlot = ((InfixStructured)this.topLevel).caretPosToStringPos(this.javaPosToCaretPos(endPosInSlot), false);
        }
        String prev = this.getText();
        String updated = prev.substring(0, startPosInSlot) + s + prev.substring(endPosInSlot);
        this.setText(updated);
    }

    @Override
    public void requestFocus(Focus on) {
        ((InfixStructured)this.topLevel).requestFocus();
        if (on == Focus.LEFT) {
            ((InfixStructured)this.topLevel).home(null);
        } else if (on == Focus.RIGHT) {
            ((InfixStructured)this.topLevel).end();
        } else if (on == Focus.SELECT_ALL) {
            ((InfixStructured)this.topLevel).selectAll(null);
        }
    }

    public boolean isEmpty() {
        return ((InfixStructured)this.topLevel).isEmpty();
    }

    protected void modified() {
        this.beenModified = true;
        this.editor.modifiedFrame(this.parentFrame, false);
        JavaFXUtil.runNowOrLater(() -> this.editor.afterRegenerateAndReparse(null));
    }

    private double overlayToSceneX(double overlayX) {
        return this.overlay.localToScene(overlayX, 0.0).getX();
    }

    private double overlayToSceneY(double overlayY) {
        return this.overlay.localToScene(0.0, overlayY).getX();
    }

    double sceneToOverlayX(double sceneX) {
        return this.overlay.sceneToLocal(sceneX, 0.0).getX();
    }

    double sceneToOverlayY(double sceneY) {
        return this.overlay.sceneToLocal(0.0, sceneY).getY();
    }

    void clearSelection(boolean invalidateErrors) {
        this.selectionDrawPositions = null;
        JavaFXUtil.runNowOrLater(() -> {
            if (invalidateErrors) {
                this.clearErrorMarkers();
            }
            this.overlay.redraw();
        });
    }

    void drawSelection(List<TextOverlayPosition> positions) {
        this.selectionDrawPositions = positions;
        JavaFXUtil.runNowOrLater(this.overlay::redraw);
    }

    public void bindTargetType(StringExpression targetTypeBinding) {
        this.targetType = targetTypeBinding;
    }

    public void setTargetType(String targetType) {
        this.targetType = new SimpleStringProperty(targetType);
    }

    public static Label makeBracket(String content, boolean opening, InfixStructured parent) {
        Label l = new Label(content);
        JavaFXUtil.addStyleClass((Styleable)l, "expression-bracket", opening ? "expression-bracket-opening" : "expression-bracket-closing");
        l.setOnMousePressed(e -> {
            if (parent != null) {
                parent.moveTo(e.getSceneX(), e.getSceneY(), true);
            }
            e.consume();
        });
        l.setOnMouseMoved(e -> {
            if (e.isShortcutDown()) {
                parent.getSlot().getOverlay().hoverAtPos(-1);
            }
        });
        l.setOnMouseReleased(Event::consume);
        l.setOnMouseClicked(Event::consume);
        l.setOnMouseDragged(Event::consume);
        l.setOnDragDetected(Event::consume);
        return l;
    }

    public static SlotLabel makeBracketSlot(String content, boolean opening, InfixStructured parent) {
        SlotLabel l = new SlotLabel(content, new String[0]);
        JavaFXUtil.addStyleClass(l, "expression-bracket", opening ? "expression-bracket-opening" : "expression-bracket-closing");
        l.setOnMousePressed((EventHandler<? super MouseEvent>)((EventHandler)e -> {
            if (parent != null) {
                parent.moveTo(e.getSceneX(), e.getSceneY(), true);
            }
            e.consume();
        }));
        l.setOnMouseReleased((EventHandler<? super MouseEvent>)((EventHandler)Event::consume));
        l.setOnMouseClicked((EventHandler<? super MouseEvent>)((EventHandler)Event::consume));
        l.setOnMouseDragged((EventHandler<? super MouseEvent>)((EventHandler)Event::consume));
        l.setOnDragDetected((EventHandler<? super MouseEvent>)((EventHandler)Event::consume));
        return l;
    }

    void hideSuggestionDisplay() {
        if (this.suggestionDisplay != null) {
            this.suggestionDisplay = null;
        }
        this.fileCompletions = null;
    }

    @OnThread(value=Tag.FXPlatform)
    void showSuggestionDisplay(StructuredSlotField field, int caretPosition, boolean stringLiteral) {
        if (this.suggestionDisplay != null) {
            this.hideSuggestionDisplay();
        }
        this.suggestionField = field;
        this.suggestionNode = (Region)field.getComponents().get(0);
        FXPlatformConsumer<SuggestionList> withSuggList = suggList -> {
            this.suggestionDisplay = suggList;
            this.updateSuggestions(true);
            this.suggestionDisplay.highlightFirstEligible();
            this.suggestionDisplay.show((Node)this.suggestionNode, (DoubleExpression)new ReadOnlyDoubleWrapper(0.0), field.heightProperty());
            this.fakeCaretShowing.set(true);
        };
        this.suggestionLocation = ((InfixStructured)this.topLevel).getCurrentPos();
        if (Config.isGreenfoot() && stringLiteral) {
            this.fileCompletions = this.editor.getAvailableFilenames();
            Function<InteractionManager.FileCompletion, SuggestionList.SuggestionDetails> func = f -> new SuggestionList.SuggestionDetailsWithCustomDoc(f.getFile().getName(), null, f.getType(), SuggestionList.SuggestionShown.COMMON, () -> this.makeFileCompletionPreview((InteractionManager.FileCompletion)f));
            withSuggList.accept(new SuggestionList(this.editor, Utility.mapList(this.fileCompletions, func), null, SuggestionList.SuggestionShown.RARE, null, this));
        } else {
            this.currentlyCompleting = true;
            this.editor.afterRegenerateAndReparse(() -> {
                int stringPos = ((InfixStructured)this.topLevel).caretPosToStringPos(((InfixStructured)this.topLevel).getCurrentPos(), true);
                JavaFragment.PosInSourceDoc posInFile = this.getSlotElement().getPosInSourceDoc(stringPos);
                this.completionCalculator.withCalculatedSuggestionList(posInFile, this.asExpressionSlot(), (CodeElement)this.parentCodeFrame.getCode(), this, this.targetType == null ? null : (String)this.targetType.get(), field == ((InfixStructured)this.topLevel).getFirstField(), withSuggList);
                this.editor.recordCodeCompletionStarted((SlotFragment)this.getSlotElement(), stringPos, field.getText().substring(0, caretPosition));
            });
        }
    }

    private Pane makeFileCompletionPreview(InteractionManager.FileCompletion fc) {
        BorderPane javadocDisplay = new BorderPane(fc.getPreview(300.0, 250.0));
        JavaFXUtil.addStyleClass((Styleable)javadocDisplay, "suggestion-file-preview");
        CodeOverlayPane.setDropShadow((Node)javadocDisplay);
        this.fileCompletionShortcuts = fc.getShortcuts();
        return javadocDisplay;
    }

    private String getCurSuggestionWord() {
        if (this.suggestionLocation == null) {
            return null;
        }
        return ((InfixStructured)this.topLevel).getCopyText(StructuredSlot.replaceLastWithZero(this.suggestionLocation), this.suggestionLocation);
    }

    private static CaretPos replaceLastWithZero(CaretPos p) {
        if (p.subPos == null) {
            return new CaretPos(0, null);
        }
        return new CaretPos(p.index, StructuredSlot.replaceLastWithZero(p.subPos));
    }

    @OnThread(value=Tag.FXPlatform)
    private void updateSuggestions(boolean initialState) {
        if (this.suggestionDisplay != null) {
            String prefix = this.getCurSuggestionWord();
            if (prefix == null) {
                this.hideSuggestionDisplay();
            } else {
                this.suggestionDisplay.calculateEligible(prefix, true, initialState);
                this.suggestionDisplay.updateVisual(prefix, false);
            }
        }
    }

    @OnThread(value=Tag.FXPlatform)
    private void executeSuggestion(int selected, ModificationToken token) {
        char opening;
        List<String> params;
        String name;
        if (this.fileCompletions != null && selected != -1) {
            InteractionManager.FileCompletion fc = this.fileCompletions.get(selected);
            name = fc.getFile().getName();
            params = null;
            opening = '\u0000';
        } else {
            name = this.completionCalculator.getName(selected);
            params = this.completionCalculator.getParams(selected);
            opening = this.completionCalculator.getOpening(selected);
        }
        ((InfixStructured)this.topLevel).insertSuggestion(this.suggestionLocation, name, opening, params, token);
        this.modified();
        String completion = name + (params == null ? "" : "(" + params.stream().collect(Collectors.joining(",")) + ")");
        this.editor.recordCodeCompletionEnded((SlotFragment)this.getSlotElement(), ((InfixStructured)this.topLevel).caretPosToStringPos(this.suggestionLocation, false), this.getCurSuggestionWord(), completion);
    }

    void up() {
        if (this.errorAndFixDisplay != null && this.errorAndFixDisplay.hasFixes() && this.errorAndFixDisplay.isShowing()) {
            this.errorAndFixDisplay.up();
        } else {
            List<TextOverlayPosition> overlayPositions = ((InfixStructured)this.topLevel).getAllStartEndPositionsBetween(null, null).collect(Collectors.toList());
            TextOverlayPosition cur = ((InfixStructured)this.topLevel).calculateOverlayPos(((InfixStructured)this.topLevel).getCurrentPos());
            LinkedList<TextOverlayPosition.Line> lines = TextOverlayPosition.groupIntoLines(overlayPositions);
            int curLine = -1;
            for (int i = 0; i < lines.size(); ++i) {
                if (!(((TextOverlayPosition.Line)lines.get((int)i)).topY <= cur.getSceneTopY()) || !(((TextOverlayPosition.Line)lines.get((int)i)).bottomY >= cur.getSceneBottomY())) continue;
                curLine = i;
                break;
            }
            if (curLine > 0) {
                double nearestDist = 9999.0;
                StructuredSlotField nearest = null;
                for (int i = 0; i < ((TextOverlayPosition.Line)lines.get((int)(curLine - 1))).positions.size(); ++i) {
                    TextOverlayPosition p = ((TextOverlayPosition.Line)lines.get((int)(curLine - 1))).positions.get(i);
                    double dist = Math.abs(p.getSceneX() - cur.getSceneX());
                    if (!(dist < nearestDist) || p.getSource() == null) continue;
                    nearestDist = dist;
                    nearest = p.getSource();
                }
                if (nearest != null) {
                    nearest.focusAtPos(nearest.getNearest(cur.getSceneX(), cur.getSceneTopY(), false, false).getPos());
                    return;
                }
            }
            this.row.focusUp(this, false);
        }
    }

    void down() {
        if (this.errorAndFixDisplay != null && this.errorAndFixDisplay.hasFixes() && this.errorAndFixDisplay.isShowing()) {
            this.errorAndFixDisplay.down();
        } else {
            List<TextOverlayPosition> overlayPositions = ((InfixStructured)this.topLevel).getAllStartEndPositionsBetween(null, null).collect(Collectors.toList());
            TextOverlayPosition cur = ((InfixStructured)this.topLevel).calculateOverlayPos(((InfixStructured)this.topLevel).getCurrentPos());
            LinkedList<TextOverlayPosition.Line> lines = TextOverlayPosition.groupIntoLines(overlayPositions);
            int curLine = -1;
            for (int i = 0; i < lines.size(); ++i) {
                if (!(((TextOverlayPosition.Line)lines.get((int)i)).topY <= cur.getSceneTopY()) || !(((TextOverlayPosition.Line)lines.get((int)i)).bottomY >= cur.getSceneBottomY())) continue;
                curLine = i;
                break;
            }
            if (curLine < lines.size() - 1) {
                double nearestDist = 9999.0;
                StructuredSlotField nearest = null;
                for (int i = 0; i < ((TextOverlayPosition.Line)lines.get((int)(curLine + 1))).positions.size(); ++i) {
                    TextOverlayPosition p = ((TextOverlayPosition.Line)lines.get((int)(curLine + 1))).positions.get(i);
                    double dist = Math.abs(p.getSceneX() - cur.getSceneX());
                    if (!(dist < nearestDist) || p.getSource() == null) continue;
                    nearestDist = dist;
                    nearest = p.getSource();
                }
                if (nearest != null) {
                    nearest.focusAtPos(nearest.getNearest(cur.getSceneX(), cur.getSceneBottomY(), false, false).getPos());
                    return;
                }
            }
            this.row.focusDown(this);
        }
    }

    @OnThread(value=Tag.FXPlatform)
    void enter() {
        if (this.errorAndFixDisplay != null && this.errorAndFixDisplay.hasFixes()) {
            this.errorAndFixDisplay.executeSelected();
        } else {
            this.row.focusEnter(this);
        }
    }

    public String getJavaCode() {
        if (((InfixStructured)this.topLevel).isCurlyLiteral()) {
            return this.getCurlyLiteralPrefix() + ((InfixStructured)this.topLevel).getJavaCode();
        }
        return ((InfixStructured)this.topLevel).getJavaCode();
    }

    @OnThread(value=Tag.FXPlatform)
    public void caretMoved() {
        CaretPos pos = ((InfixStructured)this.topLevel).getCurrentPos();
        this.showErrorAtCaret(pos);
        ((InfixStructured)this.topLevel).showHighlightedBrackets(null, pos);
        if (pos != null) {
            this.mostRecentPos = pos;
        }
    }

    @OnThread(value=Tag.FXPlatform)
    public void escape() {
        if (this.errorAndFixDisplay != null) {
            this.errorAndFixDisplay.hide();
        } else {
            this.row.escape(this);
        }
    }

    public ObservableList<Node> getComponents() {
        return ((InfixStructured)this.topLevel).getComponents();
    }

    @Override
    public TextOverlayPosition getOverlayLocation(int stringCaretPos, boolean javaPos) {
        CaretPos p;
        if (stringCaretPos == Integer.MAX_VALUE) {
            return ((InfixStructured)this.topLevel).calculateOverlayEnd();
        }
        if (stringCaretPos < 0) {
            p = ((InfixStructured)this.topLevel).getStartPos();
        } else {
            CaretPos caretPos = p = javaPos ? this.javaPosToCaretPos(stringCaretPos) : ((InfixStructured)this.topLevel).stringPosToCaretPos(stringCaretPos, false);
            if (p == null) {
                p = ((InfixStructured)this.topLevel).getEndPos();
            }
        }
        return ((InfixStructured)this.topLevel).calculateOverlayPos(p);
    }

    @Override
    public List<TextOverlayPosition.Line> getAllLines(int start, int end, boolean javaPos) {
        CaretPos startPos = ((InfixStructured)this.topLevel).stringPosToCaretPos(start, javaPos);
        CaretPos endPos = end == Integer.MAX_VALUE ? null : ((InfixStructured)this.topLevel).stringPosToCaretPos(end, javaPos);
        return TextOverlayPosition.groupIntoLines(((InfixStructured)this.topLevel).getAllStartEndPositionsBetween(startPos, endPos).collect(Collectors.toList()));
    }

    CaretPos javaPosToCaretPos(int pos) {
        if (((InfixStructured)this.topLevel).isCurlyLiteral()) {
            pos -= this.getCurlyLiteralPrefix().length();
        }
        return ((InfixStructured)this.topLevel).stringPosToCaretPos(Math.max(0, pos), true);
    }

    public InfixStructured getTopLevel() {
        return this.topLevel;
    }

    FocusParent<HeaderItem> getSlotParent() {
        return this.row;
    }

    @OnThread(value=Tag.FXPlatform)
    public boolean backspaceAtStart() {
        return this.row.backspaceAtStart(this);
    }

    public void addClosingChar(char c) {
        ((InfixStructured)this.topLevel).addClosingChar(c);
    }

    public boolean checkFilePreviewShortcut(KeyCode code) {
        if (this.fileCompletionShortcuts != null && this.fileCompletionShortcuts.containsKey(code)) {
            this.fileCompletionShortcuts.get(code).run();
            return true;
        }
        return false;
    }

    public boolean isShowingSuggestions() {
        return this.suggestionDisplay != null && this.suggestionDisplay.isShowing() && !this.suggestionDisplay.isInMiddleOfHiding();
    }

    @Override
    public abstract List<? extends PossibleLink> findLinks();

    @Override
    public void lostFocus() {
        if (this.focusedProperty.get()) {
            this.recentValues.removeAll((Object[])new String[]{this.getText()});
            this.recentValues.removeAll((Object[])new String[]{this.valueOnGain});
            this.recentValues.add(0, (Object)this.valueOnGain);
            while (this.recentValues.size() > 3) {
                this.recentValues.remove(3);
            }
            this.editor.endRecordingState(this);
            ((InfixStructured)this.topLevel).getAllExpressions().forEach(InfixStructured::deselect);
            this.notifyLostFocusExcept(null);
            this.lostFocusActions.forEach(FXRunnable::run);
        }
        this.focusedProperty.set(false);
    }

    void notifyGainFocus(StructuredSlotField focus) {
        this.notifyLostFocusExcept(focus);
        if (!this.focusedProperty.get()) {
            this.valueOnGain = this.getText();
            this.editor.beginRecordingState(this);
        }
        this.focusedProperty.set(true);
    }

    private void notifyLostFocusExcept(StructuredSlotField except) {
        ((InfixStructured)this.topLevel).getAllExpressions().forEach(e -> e.notifyLostFocus(except));
    }

    public void onLostFocus(FXRunnable action) {
        this.lostFocusActions.add(action);
    }

    public void addFocusListener(Frame frame) {
        this.onLostFocus(frame::checkForEmptySlot);
    }

    ErrorUnderlineCanvas getOverlay() {
        return this.overlay;
    }

    @Override
    public Frame getParentFrame() {
        return this.parentFrame;
    }

    public List<PlainVarReference> findPlainVarReferences(String name) {
        return ((InfixStructured)this.topLevel).findPlainVarUse(name);
    }

    public String getCurlyLiteralPrefix() {
        return "";
    }

    @Override
    public void setView(Frame.View oldView, Frame.View newView, SharedTransition animate) {
        ((InfixStructured)this.topLevel).setView(oldView, newView, animate, Optional.empty());
    }

    public boolean isConstantRange() {
        return ((InfixStructured)this.topLevel).checkRangeExpression() == InfixStructured.RangeType.RANGE_CONSTANT;
    }

    @Override
    public Map<EditableSlot.TopLevelMenu, EditableSlot.MenuItems> getMenuItems(boolean contextMenu) {
        HashMap<EditableSlot.TopLevelMenu, EditableSlot.MenuItems> itemMap = new HashMap<EditableSlot.TopLevelMenu, EditableSlot.MenuItems>();
        Menu recentMenu = new Menu(Config.getString("frame.slot.recent"));
        recentMenu.setDisable(true);
        this.recentValues.addListener(c -> {
            recentMenu.getItems().clear();
            if (this.recentValues.isEmpty()) {
                recentMenu.setDisable(true);
            } else {
                recentMenu.setDisable(false);
                this.recentValues.forEach(v -> {
                    MenuItem item = new MenuItem(v);
                    item.setOnAction(e -> {
                        this.editor.recordEdits(StrideEditReason.FLUSH);
                        this.setText((String)v);
                        this.modified();
                        this.editor.recordEdits(StrideEditReason.UNDO_LOCAL);
                    });
                    recentMenu.getItems().add((Object)item);
                });
            }
        });
        ObservableList originalItems = FXCollections.observableArrayList();
        final FXConsumer<ObservableList> setToOriginal = l -> {
            if (contextMenu) {
                l.setAll((Object[])new EditableSlot.SortedMenuItem[]{EditableSlot.MenuItemOrder.RECENT_VALUES.item((MenuItem)recentMenu)});
            } else {
                l.clear();
            }
        };
        setToOriginal.accept(originalItems);
        itemMap.put(EditableSlot.TopLevelMenu.EDIT, new EditableSlot.MenuItems(originalItems){

            @Override
            @OnThread(value=Tag.FXPlatform)
            public void onShowing() {
                Stream<InfixStructured<?, ?>> allExpressions = StructuredSlot.this.getTopLevel().getAllExpressions();
                InfixStructured exp = allExpressions.filter(i -> i.isFocused()).findFirst().orElse(null);
                if (exp == null) {
                    setToOriginal.accept(this.items);
                } else {
                    MenuItem cut = JavaFXUtil.makeMenuItem(Config.getString("frame.slot.cut"), exp::cut, (KeyCombination)new KeyCodeCombination(KeyCode.X, new KeyCombination.Modifier[]{KeyCodeCombination.SHORTCUT_DOWN}));
                    MenuItem copy = JavaFXUtil.makeMenuItem(Config.getString("frame.slot.copy"), exp::copy, (KeyCombination)new KeyCodeCombination(KeyCode.C, new KeyCombination.Modifier[]{KeyCodeCombination.SHORTCUT_DOWN}));
                    MenuItem paste = JavaFXUtil.makeMenuItem(Config.getString("frame.slot.paste"), exp::paste, (KeyCombination)new KeyCodeCombination(KeyCode.V, new KeyCombination.Modifier[]{KeyCodeCombination.SHORTCUT_DOWN}));
                    boolean inSelection = exp.isInSelection();
                    cut.setDisable(!inSelection);
                    copy.setDisable(!inSelection);
                    paste.setDisable(!Clipboard.getSystemClipboard().hasString());
                    setToOriginal.accept(this.items);
                    this.items.addAll((Object[])new EditableSlot.SortedMenuItem[]{EditableSlot.MenuItemOrder.CUT.item(cut), EditableSlot.MenuItemOrder.COPY.item(copy), EditableSlot.MenuItemOrder.PASTE.item(paste)});
                }
                if (StructuredSlot.this.hoverErrorCurrentlyShown != null) {
                    StructuredSlot.this.errorAndFixDisplay.hide();
                }
            }
        });
        if (contextMenu) {
            final EditableSlot.SortedMenuItem scanningItem = EditableSlot.MenuItemOrder.GOTO_DEFINITION.item(new MenuItem("Scanning..."));
            scanningItem.getItem().setDisable(true);
            itemMap.put(EditableSlot.TopLevelMenu.VIEW, new EditableSlot.MenuItems(FXCollections.observableArrayList()){

                private void removeScanning() {
                    if (this.items.size() == 1 && this.items.get(0) == scanningItem) {
                        this.items.clear();
                    }
                }

                @Override
                @OnThread(value=Tag.FXPlatform)
                public void onShowing() {
                    this.items.setAll((Object[])new EditableSlot.SortedMenuItem[]{scanningItem});
                    CaretPos caretPos = StructuredSlot.this.getTopLevel().getCurrentPos();
                    Debug.message("Scanning position: " + caretPos);
                    FXPlatformConsumer<Optional<LinkedIdentifier>> withLink = optLink -> {
                        this.removeScanning();
                        optLink.ifPresent(defLink -> this.items.add((Object)EditableSlot.MenuItemOrder.GOTO_DEFINITION.item(JavaFXUtil.makeMenuItem("Go to definition of \"" + defLink.getName() + "\"", defLink.getOnClick(), null))));
                    };
                    StructuredSlot.this.withLinksAtPos(caretPos, withLink);
                    JavaFXUtil.runAfter(Duration.millis((double)1000.0), this::removeScanning);
                }

                @Override
                public void onHidden() {
                    this.items.clear();
                }
            });
        }
        return itemMap;
    }

    @OnThread(value=Tag.FXPlatform)
    void withLinksAtPos(CaretPos caretPos, FXPlatformConsumer<Optional<LinkedIdentifier>> withLink) {
        List<PossibleLink> possibleLinks = this.findLinks();
        possibleLinks.removeIf(possLink -> {
            CaretPos endCaretPos;
            CaretPos startCaretPos = this.javaPosToCaretPos(possLink.getStartPosition());
            return !CaretPos.between(startCaretPos, endCaretPos = this.javaPosToCaretPos(possLink.getEndPosition()), caretPos);
        });
        possibleLinks.forEach(possLink -> this.editor.searchLink((PossibleLink)possLink, withLink));
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public SuggestionList.SuggestionListListener.Response suggestionListKeyPressed(KeyEvent event, int highlighted) {
        switch (event.getCode()) {
            case ENTER: {
                if (highlighted != -1) {
                    this.modificationPlatform(token -> this.executeSuggestion(highlighted, (ModificationToken)token));
                    return SuggestionList.SuggestionListListener.Response.DISMISS;
                }
            }
            case ESCAPE: {
                return SuggestionList.SuggestionListListener.Response.DISMISS;
            }
            case BACK_SPACE: {
                CaretPos updatedLocation = this.modificationReturnPlatform(token -> ((InfixStructured)this.topLevel).deletePreviousAtPos(this.suggestionLocation, (ModificationToken)token));
                if (updatedLocation == null || !updatedLocation.init().equals(this.suggestionLocation.init())) {
                    JavaFXUtil.runAfterCurrent(() -> ((InfixStructured)this.topLevel).positionCaret(updatedLocation));
                    return SuggestionList.SuggestionListListener.Response.DISMISS;
                }
                this.suggestionLocation = updatedLocation;
                this.overlay.redraw();
                this.updateSuggestions(false);
                return SuggestionList.SuggestionListListener.Response.CONTINUE;
            }
            case TAB: {
                if (event.isShiftDown()) {
                    this.row.focusLeft(this);
                } else {
                    this.row.focusRight(this);
                    this.completeIfPossible(highlighted);
                }
                return SuggestionList.SuggestionListListener.Response.DISMISS;
            }
        }
        return SuggestionList.SuggestionListListener.Response.CONTINUE;
    }

    @OnThread(value=Tag.FXPlatform)
    private void completeIfPossible(int highlighted) {
        if (highlighted != -1) {
            this.modificationPlatform(token -> this.executeSuggestion(highlighted, (ModificationToken)token));
        } else if (this.suggestionDisplay.eligibleCount() == 1 && this.getText().length() > 0) {
            this.modificationPlatform(token -> this.executeSuggestion(this.suggestionDisplay.getFirstEligible(), (ModificationToken)token));
        }
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public SuggestionList.SuggestionListListener.Response suggestionListKeyTyped(KeyEvent event, int highlighted) {
        return this.modificationReturnPlatform(token -> {
            CaretPos updatedLocation = null;
            if ("\b".equals(event.getCharacter())) {
                return SuggestionList.SuggestionListListener.Response.CONTINUE;
            }
            updatedLocation = ((InfixStructured)this.topLevel).insertAtPos(this.suggestionLocation, event.getCharacter(), (ModificationToken)token);
            if (!updatedLocation.init().equals(this.suggestionLocation.init())) {
                return SuggestionList.SuggestionListListener.Response.DISMISS;
            }
            this.suggestionLocation = updatedLocation;
            this.overlay.redraw();
            this.updateSuggestions(true);
            return SuggestionList.SuggestionListListener.Response.CONTINUE;
        });
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void suggestionListChoiceClicked(int highlighted) {
        this.modificationPlatform(token -> this.executeSuggestion(highlighted, (ModificationToken)token));
    }

    @Override
    public void hidden() {
        this.fakeCaretShowing.set(false);
    }

    boolean suggestingFor(CaretPos fieldPos) {
        return fieldPos != null && this.suggestionLocation != null && fieldPos.equals(this.suggestionLocation.init()) && this.suggestionDisplay != null && this.suggestionDisplay.isShowing();
    }

    public boolean deleteAtEnd() {
        if (this.row != null) {
            return this.row.deleteAtEnd(this);
        }
        return false;
    }

    public void setSplitText(String beforeCursor, String afterCursor) {
        this.modification(token -> {
            ((InfixStructured)this.topLevel).blank((ModificationToken)token);
            CaretPos p = ((InfixStructured)this.topLevel).insert_(((InfixStructured)this.topLevel).getFirstField(), 0, beforeCursor, false, (ModificationToken)token);
            ((InfixStructured)this.topLevel).insertAtPos(p, afterCursor, (ModificationToken)token);
            token.after(() -> ((InfixStructured)this.topLevel).positionCaret(p));
        });
    }

    public boolean isCurrentlyCompleting() {
        return this.currentlyCompleting;
    }

    List<ExtensionDescription> getExtensions() {
        return this.row.getExtensions();
    }

    @OnThread(value=Tag.FXPlatform)
    void notifyModifiedPress(KeyCode c) {
        this.row.notifyModifiedPress(c);
    }

    void focusNext() {
        this.row.focusRight(this);
    }

    public abstract boolean canCollapse();

    public SplitInfo trySplitOnEquals() {
        return ((InfixStructured)this.topLevel).trySplitOn("=");
    }

    public final List<FrameCatalogue.Hint> getHints() {
        return this.hints;
    }

    @Override
    public boolean isAlmostBlank() {
        return ((InfixStructured)this.topLevel).isAlmostBlank();
    }

    @Override
    public boolean isEditable() {
        return this.editable;
    }

    @Override
    public void setEditable(boolean editable) {
        this.editable = editable;
        ((InfixStructured)this.topLevel).setEditable(editable);
    }

    @Override
    public ObservableBooleanValue effectivelyFocusedProperty() {
        return this.effectivelyFocusedProperty;
    }

    @Override
    public int calculateEffort() {
        return ((InfixStructured)this.topLevel).calculateEffort();
    }

    protected abstract INFIX newInfix(InteractionManager var1, ModificationToken var2);

    @OnThread(value=Tag.FX)
    <T> T modificationReturn(FXFunction<ModificationToken, T> modificationAction) {
        ModificationToken token = new ModificationToken();
        this.modificationTokens.add(token);
        T ret = modificationAction.apply(token);
        if (this.modificationTokens.get(this.modificationTokens.size() - 1) != token) {
            throw new IllegalStateException("Modifications did not nest");
        }
        this.modificationTokens.remove(token);
        if (this.modificationTokens.isEmpty()) {
            this.textMirror.set((Object)((InfixStructured)this.topLevel).calculateText());
            token.runAfters();
            this.afterModify.forEach(FXRunnable::run);
        } else {
            this.modificationTokens.get(0).afters.addAll(token.afters);
        }
        return ret;
    }

    @OnThread(value=Tag.FXPlatform)
    <T> T modificationReturnPlatform(FXPlatformFunction<ModificationToken, T> modificationAction) {
        return (T)this.modificationReturn(modificationAction::apply);
    }

    void modification(FXConsumer<ModificationToken> modificationAction) {
        this.modificationReturn(t -> {
            modificationAction.accept((ModificationToken)t);
            return 0;
        });
    }

    @OnThread(value=Tag.FXPlatform)
    void modificationPlatform(FXPlatformConsumer<ModificationToken> modificationAction) {
        this.modificationReturnPlatform(t -> {
            modificationAction.accept((ModificationToken)t);
            return 0;
        });
    }

    static <T> T testingModification(FXFunction<ModificationToken, T> modificationAction) {
        return modificationAction.apply(new ModificationToken());
    }

    void afterCurrentModification(FXRunnable action) {
        if (this.modificationTokens.isEmpty()) {
            action.run();
        } else {
            this.modificationTokens.get(0).after(action);
        }
    }

    public static class ModificationToken {
        private List<FXRunnable> afters = new ArrayList<FXRunnable>();

        private ModificationToken() {
        }

        public void check() {
        }

        public void after(FXRunnable action) {
            this.afters.add(action);
        }

        private void runAfters() {
            this.afters.forEach(FXRunnable::run);
        }
    }

    public static class PlainVarReference {
        public final FXConsumer<String> rename;
        public final Region refNode;

        PlainVarReference(FXConsumer<String> rename, Region refNode) {
            this.rename = rename;
            this.refNode = refNode;
        }
    }

    public static class SplitInfo {
        public final String lhs;
        public final String rhs;

        public SplitInfo(String lhs, String rhs) {
            this.lhs = lhs;
            this.rhs = rhs;
        }
    }
}

