/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.slots;

import bluej.stride.framedjava.slots.CaretPos;
import bluej.stride.framedjava.slots.InfixStructured;
import bluej.stride.framedjava.slots.PosAndDist;
import bluej.stride.framedjava.slots.StructuredSlot;
import bluej.stride.framedjava.slots.StructuredSlotComponent;
import bluej.stride.framedjava.slots.StructuredSlotField;
import bluej.stride.framedjava.slots.TextOverlayPosition;
import bluej.stride.generic.Frame;
import bluej.stride.generic.InteractionManager;
import bluej.utility.Utility;
import bluej.utility.javafx.HangingFlowPane;
import bluej.utility.javafx.JavaFXUtil;
import bluej.utility.javafx.SharedTransition;
import java.util.List;
import java.util.stream.Stream;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.Styleable;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.Region;

class StringLiteralExpression
implements StructuredSlotComponent {
    private final StructuredSlotField field;
    private final ObservableList<Node> components = FXCollections.observableArrayList();
    private final Label openingQuote;
    private final Label closingQuote;
    private final String quote;
    private final String openingSmartQuote;
    private final String closingSmartQuote;

    public StringLiteralExpression(char quoteChar, StructuredSlotField f, InfixStructured parent) {
        this.field = f;
        this.quote = "" + quoteChar;
        this.openingSmartQuote = quoteChar == '\"' ? "\u201c" : "\u2018";
        this.closingSmartQuote = quoteChar == '\"' ? "\u201d" : "\u2019";
        this.openingQuote = StructuredSlot.makeBracket(this.openingSmartQuote, true, parent);
        this.closingQuote = StructuredSlot.makeBracket(this.closingSmartQuote, false, parent);
        this.components.add((Object)this.openingQuote);
        this.components.addAll(this.field.getComponents());
        this.components.add((Object)this.closingQuote);
        for (int i = 1; i < this.components.size(); ++i) {
            HangingFlowPane.setBreakBefore((Node)this.components.get(i), false);
        }
        JavaFXUtil.addStyleClass((Styleable)this.openingQuote, "expression-string-literal-quote");
        JavaFXUtil.addStyleClass((Styleable)this.closingQuote, "expression-string-literal-quote");
    }

    @Override
    public void focusAtStart() {
        this.field.focusAtStart();
    }

    @Override
    public void focusAtEnd() {
        this.field.focusAtEnd();
    }

    @Override
    public Node focusAtPos(CaretPos caretPos) {
        return this.field.focusAtPos(caretPos);
    }

    @Override
    public TextOverlayPosition calculateOverlayPos(CaretPos pos) {
        return this.field.calculateOverlayPos(pos);
    }

    @Override
    public PosAndDist getNearest(double sceneX, double sceneY, boolean allowDescend, boolean anchorInItem) {
        if (allowDescend || anchorInItem) {
            return this.field.getNearest(sceneX, sceneY, allowDescend, anchorInItem);
        }
        return new PosAndDist();
    }

    @Override
    public CaretPos getSelectIntoPos(boolean atEnd) {
        return null;
    }

    @Override
    public CaretPos getStartPos() {
        return this.field.getStartPos();
    }

    @Override
    public CaretPos getEndPos() {
        return this.field.getEndPos();
    }

    @Override
    public String getCopyText(CaretPos from, CaretPos to) {
        StringBuilder b = new StringBuilder();
        if (from == null) {
            b.append(this.quote);
        }
        b.append(this.field.getCopyText(from, to));
        if (to == null) {
            b.append(this.quote);
        }
        return b.toString();
    }

    @Override
    public String getJavaCode() {
        StringBuilder b = new StringBuilder();
        b.append(this.quote);
        b.append(this.field.getText());
        b.append(this.quote);
        return b.toString();
    }

    @Override
    public CaretPos getCurrentPos() {
        return this.field.getCurrentPos();
    }

    public ObservableList<Node> getComponents() {
        return this.components;
    }

    @Override
    public List<InfixStructured.CaretPosMap> mapCaretPosStringPos(InfixStructured.IntCounter cur, boolean javaString) {
        ++cur.counter;
        List<InfixStructured.CaretPosMap> r = this.field.mapCaretPosStringPos(cur, false);
        ++cur.counter;
        return r;
    }

    @Override
    public Region getNodeForPos(CaretPos subPos) {
        return this.field.getNodeForPos(subPos);
    }

    StructuredSlotField getField() {
        return this.field;
    }

    @Override
    public String testingGetState(CaretPos pos) {
        if (pos == null) {
            return this.quote + this.field.getText() + this.quote;
        }
        return this.quote + this.field.getText().substring(0, pos.index) + "$" + this.field.getText().substring(pos.index) + this.quote;
    }

    @Override
    public boolean isFocused() {
        return this.field.isFocused();
    }

    @Override
    public void insertSuggestion(CaretPos p, String name, char opening, List<String> params, StructuredSlot.ModificationToken token) {
        if (params != null) {
            throw new IllegalArgumentException();
        }
        this.getField().setText(name, token);
        this.getField().focusAtPos(new CaretPos(name.length(), null));
    }

    @Override
    public Stream<TextOverlayPosition> getAllStartEndPositionsBetween(CaretPos start, CaretPos end) {
        return this.field.getAllStartEndPositionsBetween(start, end);
    }

    @Override
    public Stream<InfixStructured<?, ?>> getAllExpressions() {
        return Stream.empty();
    }

    @Override
    public String getText() {
        return this.quote + this.field.getText() + this.quote;
    }

    @Override
    public void setView(Frame.View oldView, Frame.View newView, SharedTransition animate) {
        this.field.setView(oldView, newView, animate);
        JavaFXUtil.setPseudoclass("bj-java-preview", newView == Frame.View.JAVA_PREVIEW, new Node[]{this.openingQuote, this.closingQuote});
        this.openingQuote.setText(newView == Frame.View.JAVA_PREVIEW ? this.quote : this.openingSmartQuote);
        this.closingQuote.setText(newView == Frame.View.JAVA_PREVIEW ? this.quote : this.closingSmartQuote);
    }

    @Override
    public boolean isAlmostBlank() {
        return this.field.isAlmostBlank();
    }

    @Override
    public void notifyLostFocus(StructuredSlotField except) {
        if (this.field != except) {
            this.field.notifyLostFocus(except);
        }
    }

    @Override
    public void setEditable(boolean editable) {
        this.field.setEditable(editable);
    }

    @Override
    public boolean isNumericLiteral() {
        return false;
    }

    @Override
    public int calculateEffort() {
        return this.field.calculateEffort();
    }

    @Override
    public Stream<Node> makeDisplayClone(InteractionManager editor) {
        return Utility.concat(Stream.of(JavaFXUtil.cloneLabel(this.openingQuote, (ObservableValue<String>)editor.getFontSizeCSS())), this.field.makeDisplayClone(editor), Stream.of(JavaFXUtil.cloneLabel(this.closingQuote, (ObservableValue<String>)editor.getFontSizeCSS())));
    }

    String getQuote() {
        return this.quote;
    }
}

