/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.frames;

import bluej.editor.stride.FrameCatalogue;
import bluej.parser.AssistContent;
import bluej.stride.framedjava.ast.JavaFragment;
import bluej.stride.framedjava.ast.links.PossibleLink;
import bluej.stride.framedjava.ast.links.PossibleTypeLink;
import bluej.stride.framedjava.elements.CodeElement;
import bluej.stride.framedjava.elements.ImportElement;
import bluej.stride.framedjava.errors.CodeError;
import bluej.stride.framedjava.frames.CodeFrame;
import bluej.stride.generic.Frame;
import bluej.stride.generic.FrameFactory;
import bluej.stride.generic.InteractionManager;
import bluej.stride.generic.RecallableFocus;
import bluej.stride.generic.SingleLineFrame;
import bluej.stride.slots.CompletionCalculator;
import bluej.stride.slots.HeaderItem;
import bluej.stride.slots.SlotTraversalChars;
import bluej.stride.slots.SuggestionList;
import bluej.stride.slots.TextSlot;
import bluej.utility.Utility;
import bluej.utility.javafx.FXPlatformConsumer;
import bluej.utility.javafx.JavaFXUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.beans.binding.StringExpression;
import javafx.scene.control.TextField;
import javafx.util.Pair;
import threadchecker.OnThread;
import threadchecker.Tag;

public class ImportFrame
extends SingleLineFrame
implements CodeFrame<ImportElement> {
    private static final String IMPORT_STYLE_PREFIX = "import-";
    private static final List<FrameCatalogue.Hint> HINTS = Arrays.asList(new FrameCatalogue.Hint("greenfoot.*", "Greenfoot classes"), new FrameCatalogue.Hint("java.util.*", "Java utility classes"));
    private TextSlot<ImportElement.ImportFragment> importField;
    private ImportElement element;

    private ImportFrame(final InteractionManager editor) {
        super(editor, "import ", IMPORT_STYLE_PREFIX);
        CompletionCalculator calc = new CompletionCalculator(){
            private List<Pair<SuggestionList.SuggestionShown, String>> imports;

            @Override
            public void withCalculatedSuggestionList(JavaFragment.PosInSourceDoc pos, CodeElement codeEl, SuggestionList.SuggestionListListener clickListener, FXPlatformConsumer<SuggestionList> handler) {
                this.imports = editor.getImportSuggestions().entrySet().stream().flatMap(e -> ((Collection)e.getValue()).stream().filter(ac -> ac.getPackage() == null || ac.getPackage().equals("") || ac.getAccessPermission() == AssistContent.Access.PUBLIC).flatMap(ac -> ac.getPackage() == null || ac.getPackage().equals("") ? Stream.of(ac.getName()) : Stream.of(ac.getPackage() + "." + (ac.getDeclaringClass() == null ? "" : ac.getDeclaringClass() + ".") + ac.getName(), ac.getPackage() + ".*")).sorted().distinct().map(v -> new Pair(e.getKey(), v))).collect(Collectors.toList());
                SuggestionList suggestionDisplay = new SuggestionList(editor, Utility.mapList(this.imports, imp -> new SuggestionList.SuggestionDetails((String)imp.getValue(), null, null, (SuggestionList.SuggestionShown)((Object)((Object)imp.getKey())))), null, SuggestionList.SuggestionShown.COMMON, null, clickListener);
                JavaFXUtil.runNowOrLater(() -> handler.accept(suggestionDisplay));
            }

            @Override
            public boolean execute(TextField field, int highlighted, int startOfCurWord) {
                if (highlighted >= 0) {
                    field.setText((String)this.imports.get(highlighted).getValue());
                    return true;
                }
                return false;
            }
        };
        this.importField = new TextSlot<ImportElement.ImportFragment>(editor, (Frame)this, (CodeFrame)this, this.getHeaderRow(), calc, "import-slot-", HINTS){

            @Override
            protected ImportElement.ImportFragment createFragment(String content) {
                return new ImportElement.ImportFragment(content, this);
            }

            @Override
            public void valueChangedLostFocus(String oldValue, String newValue) {
            }

            @Override
            @OnThread(value=Tag.FXPlatform)
            public void addError(CodeError err) {
                this.editor.ensureImportsVisible();
                super.addError(err);
            }

            @Override
            public List<? extends PossibleLink> findLinks() {
                if (!this.getText().endsWith(".*")) {
                    return Collections.singletonList(new PossibleTypeLink(this.getText(), 0, this.getText().length(), this));
                }
                return Collections.emptyList();
            }

            @Override
            public int getStartOfCurWord() {
                return 0;
            }
        };
        this.importField.setPromptText("package or class");
        this.importField.addValueListener(new SlotTraversalChars(new char[0]){

            @Override
            @OnThread(value=Tag.FXPlatform)
            public void backSpacePressedAtStart(HeaderItem slot) {
                ImportFrame.this.backspaceAtStart(ImportFrame.this.getHeaderRow(), slot);
            }
        });
        this.setHeaderRow(this.importField, this.previewSemi);
    }

    public ImportFrame(InteractionManager editor, ImportElement element, boolean enabled) {
        this(editor);
        this.element = element;
        this.importField.setText(element.getImport());
        this.frameEnabledProperty.set(enabled);
    }

    public ImportFrame(InteractionManager editor, String src) {
        this(editor);
        this.importField.setText(src);
        this.element = new ImportElement(src, this.importField, this.frameEnabledProperty.get());
    }

    public static FrameFactory<ImportFrame> getFactory() {
        return new FrameFactory<ImportFrame>(){

            @Override
            public ImportFrame createBlock(InteractionManager editor) {
                return new ImportFrame(editor);
            }

            @Override
            public Class<ImportFrame> getBlockClass() {
                return ImportFrame.class;
            }
        };
    }

    public String getImport() {
        return this.importField.getText();
    }

    @Override
    public void regenerateCode() {
        this.element = new ImportElement(this.importField.getText(), this.importField, this.frameEnabledProperty.get());
    }

    @Override
    public ImportElement getCode() {
        return this.element;
    }

    public RecallableFocus getFocusable() {
        return this.importField;
    }

    public StringExpression importProperty() {
        return this.importField.textProperty();
    }
}

