/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.frames;

import bluej.stride.framedjava.ast.ExpressionSlotFragment;
import bluej.stride.framedjava.ast.FilledExpressionSlotFragment;
import bluej.stride.framedjava.ast.HighlightedBreakpoint;
import bluej.stride.framedjava.ast.NameDefSlotFragment;
import bluej.stride.framedjava.ast.TypeSlotFragment;
import bluej.stride.framedjava.canvases.JavaCanvas;
import bluej.stride.framedjava.elements.CodeElement;
import bluej.stride.framedjava.elements.ForeachElement;
import bluej.stride.framedjava.frames.BreakFrame;
import bluej.stride.framedjava.frames.CodeFrame;
import bluej.stride.framedjava.frames.DebugInfo;
import bluej.stride.framedjava.frames.DebuggableParentFrame;
import bluej.stride.framedjava.slots.EachExpressionSlot;
import bluej.stride.framedjava.slots.TypeSlot;
import bluej.stride.generic.ExtensionDescription;
import bluej.stride.generic.Frame;
import bluej.stride.generic.FrameCanvas;
import bluej.stride.generic.FrameContentItem;
import bluej.stride.generic.FrameCursor;
import bluej.stride.generic.FrameFactory;
import bluej.stride.generic.InteractionManager;
import bluej.stride.generic.SingleCanvasFrame;
import bluej.stride.operations.FrameOperation;
import bluej.stride.operations.PullUpContentsOperation;
import bluej.stride.slots.HeaderItem;
import bluej.stride.slots.SlotLabel;
import bluej.stride.slots.SlotTraversalChars;
import bluej.stride.slots.VariableNameDefTextSlot;
import bluej.utility.Utility;
import bluej.utility.javafx.FXConsumer;
import bluej.utility.javafx.JavaFXUtil;
import bluej.utility.javafx.SharedTransition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import threadchecker.OnThread;
import threadchecker.Tag;

public class ForeachFrame
extends SingleCanvasFrame
implements CodeFrame<ForeachElement>,
DebuggableParentFrame {
    private final TypeSlot type;
    private final VariableNameDefTextSlot var;
    private final EachExpressionSlot collection;
    private ForeachElement element;
    private final SlotLabel inLabel;

    private ForeachFrame(InteractionManager editor) {
        super(editor, "for each", "foreach-");
        this.type = new TypeSlot(editor, this, this, this.getHeaderRow(), TypeSlot.Role.DECLARATION, "foreach-type-");
        this.type.setSimplePromptText("item type");
        this.type.addClosingChar(' ');
        this.var = new VariableNameDefTextSlot(editor, this, this.getHeaderRow(), "foreach-var-");
        this.var.setPromptText("item name");
        this.var.addValueListener(SlotTraversalChars.IDENTIFIER);
        this.collection = new EachExpressionSlot(editor, (Frame)this, this, this.getHeaderRow(), this.type, this.var, "foreach-collection-");
        this.collection.setSimplePromptText("collection");
        this.inLabel = new SlotLabel(" in ", new String[0]);
        this.setHeaderRow(new SlotLabel("(", new String[0]), this.type, this.var, this.inLabel, this.collection, new SlotLabel(")", new String[0]));
        FXConsumer<String> updateTriple = s -> this.updateSidebarCurried("for each ").accept(this.type.getText() + " " + this.var.getText() + " : " + this.collection.getText());
        this.type.onTextPropertyChange(updateTriple);
        JavaFXUtil.addChangeListener(this.var.textProperty(), updateTriple);
        this.collection.onTextPropertyChange(updateTriple);
    }

    public ForeachFrame(InteractionManager editor, TypeSlotFragment type, NameDefSlotFragment var, ExpressionSlotFragment collection, boolean enabled) {
        this(editor);
        this.type.setText(type);
        this.var.setText(var);
        this.collection.setText(collection);
        this.frameEnabledProperty.set(enabled);
    }

    public ForeachFrame(InteractionManager editor, List<Frame> contents) {
        this(editor);
        this.getCanvas().getFirstCursor().insertFramesAfter(contents);
    }

    @Override
    public List<FrameOperation> getContextOperations() {
        List<FrameOperation> r = super.getContextOperations();
        r.add(new PullUpContentsOperation(this.getEditor()));
        return r;
    }

    public static FrameFactory<ForeachFrame> getFactory() {
        return new FrameFactory<ForeachFrame>(){

            @Override
            public ForeachFrame createBlock(InteractionManager editor) {
                return new ForeachFrame(editor);
            }

            @Override
            public ForeachFrame createBlock(InteractionManager editor, List<Frame> contents) {
                return new ForeachFrame(editor, contents);
            }

            @Override
            public Class<ForeachFrame> getBlockClass() {
                return ForeachFrame.class;
            }
        };
    }

    @Override
    public FrameCanvas createCanvas(InteractionManager editor, String stylePrefix) {
        return new JavaCanvas(editor, this, stylePrefix, false);
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public HighlightedBreakpoint showDebugAtEnd(DebugInfo debug) {
        return ((JavaCanvas)this.getCanvas()).showDebugBefore(null, debug);
    }

    @Override
    public void regenerateCode() {
        ArrayList<CodeElement> contents = new ArrayList<CodeElement>();
        for (CodeFrame f : this.canvas.getBlocksSubtype(CodeFrame.class)) {
            f.regenerateCode();
            contents.add((CodeElement)f.getCode());
        }
        this.element = new ForeachElement(this, (TypeSlotFragment)this.type.getSlotElement(), (NameDefSlotFragment)this.var.getSlotElement(), (FilledExpressionSlotFragment)this.collection.getSlotElement(), contents, this.frameEnabledProperty.get());
    }

    @Override
    public ForeachElement getCode() {
        return this.element;
    }

    @Override
    public List<ExtensionDescription> getAvailableExtensions(FrameCanvas canvas, FrameCursor cursorInCanvas) {
        return Utility.concat(super.getAvailableExtensions(canvas, cursorInCanvas), Arrays.asList(new ExtensionDescription('\b', "Remove loop, keep contents", () -> new PullUpContentsOperation(this.getEditor()).activate(this), false, ExtensionDescription.ExtensionSource.INSIDE_FIRST, new ExtensionDescription.ExtensionSource[0])));
    }

    @Override
    public List<String> getDeclaredVariablesWithin(FrameCanvas c) {
        if (c != this.getCanvas()) {
            throw new IllegalArgumentException("Canvas does not exist in this frame");
        }
        String name = this.var.getText();
        if (name.isEmpty()) {
            return Collections.emptyList();
        }
        return Arrays.asList(name);
    }

    @Override
    public BreakFrame.BreakEncloser asBreakEncloser() {
        return BreakFrame.BreakEncloser.FOREACH;
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void setView(Frame.View oldView, Frame.View newView, SharedTransition animateProgress) {
        super.setView(oldView, newView, animateProgress);
        String caption = newView == Frame.View.JAVA_PREVIEW ? "for" : "for each";
        this.headerCaptionLabel.setText(caption);
        this.inLabel.setText(newView == Frame.View.JAVA_PREVIEW ? (this.collection.isConstantRange() ? " = " : " : ") : " in ");
        if (this.isFrameEnabled() && (oldView == Frame.View.JAVA_PREVIEW || newView == Frame.View.JAVA_PREVIEW)) {
            this.canvas.previewCurly(newView == Frame.View.JAVA_PREVIEW, this.header.getLeftFirstItem() + this.tweakCurlyX(), this.tweakOpeningCurlyY(), animateProgress);
        }
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public boolean backspaceAtStart(FrameContentItem srcRow, HeaderItem src) {
        if (src == this.type && this.type.isAlmostBlank()) {
            new PullUpContentsOperation(this.getEditor()).activate(this.getFrame());
            return true;
        }
        return super.backspaceAtStart(srcRow, src);
    }
}

