/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.frames;

import bluej.stride.framedjava.elements.BreakElement;
import bluej.stride.framedjava.frames.CodeFrame;
import bluej.stride.framedjava.frames.DebuggableFrame;
import bluej.stride.generic.DefaultFrameFactory;
import bluej.stride.generic.Frame;
import bluej.stride.generic.FrameCanvas;
import bluej.stride.generic.FrameFactory;
import bluej.stride.generic.InteractionManager;
import bluej.stride.generic.SingleLineFrame;
import bluej.utility.javafx.JavaFXUtil;
import bluej.utility.javafx.SharedTransition;
import javafx.beans.binding.DoubleExpression;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.css.Styleable;
import javafx.scene.Node;
import javafx.scene.layout.VBox;
import javafx.scene.shape.Rectangle;
import threadchecker.OnThread;
import threadchecker.Tag;

public class BreakFrame
extends SingleLineFrame
implements CodeFrame<BreakElement>,
DebuggableFrame {
    private SimpleDoubleProperty xOffset;
    private SimpleDoubleProperty yOffset;
    private BreakElement element;
    private Rectangle rectangle;
    private FrameCanvas outer;
    private VBox overlay;
    private boolean normalView = true;

    private BreakFrame(InteractionManager editor) {
        super(editor, "break", "break-");
        this.setHeaderRow(this.previewSemi);
    }

    public BreakFrame(InteractionManager editor, boolean enabled) {
        this(editor);
        this.frameEnabledProperty.set(enabled);
    }

    @Override
    public void updateAppearance(FrameCanvas c) {
        super.updateAppearance(c);
        if (!this.normalView || !this.isFrameEnabled()) {
            JavaFXUtil.runNowOrLater(() -> this.setOverlay(false, null, null));
            return;
        }
        for (BreakEncloser e : BreakEncloser.values()) {
            JavaFXUtil.setPseudoclass(e.getPseudoClass(), false, this.getNode());
        }
        while (c != null && c.getParent() != null && c.getParent().getFrame() != null && c.getParent().getFrame() instanceof CodeFrame) {
            CodeFrame cf = (CodeFrame)((Object)c.getParent().getFrame());
            if (cf.asBreakEncloser() != null) {
                JavaFXUtil.setPseudoclass(cf.asBreakEncloser().getPseudoClass(), true, this.getNode());
                FrameCanvas cFinal = c;
                JavaFXUtil.runNowOrLater(() -> this.setOverlay(true, cFinal, cf.asBreakEncloser().getPseudoClass()));
                return;
            }
            c = c.getParent().getFrame().getParentCanvas();
        }
        JavaFXUtil.runNowOrLater(() -> this.setOverlay(false, null, null));
    }

    public static FrameFactory<BreakFrame> getFactory() {
        return new DefaultFrameFactory<BreakFrame>(BreakFrame.class, BreakFrame::new);
    }

    @Override
    public BreakElement getCode() {
        return this.element;
    }

    @Override
    public void regenerateCode() {
        this.element = new BreakElement(this, this.frameEnabledProperty.get());
    }

    private void adjustOverlayBounds() {
        if (this.outer == null || this.rectangle == null || this.overlay == null) {
            return;
        }
        double ourX = this.getNode().localToScene(0.0, 0.0).getX();
        double theirX = this.outer.getContentSceneBounds().getMinX();
        double width = ourX - theirX;
        this.rectangle.setWidth(width + 1.0);
        this.rectangle.setHeight(Math.ceil(this.getRegion().getHeight() / 4.0));
        this.xOffset.set(-width);
        this.yOffset.set(this.getRegion().getHeight() * 3.0 / 8.0);
    }

    @OnThread(value=Tag.FXPlatform)
    private void setOverlay(boolean on, FrameCanvas outer, String pseudo) {
        if (on && this.overlay == null) {
            this.outer = outer;
            this.rectangle = new Rectangle();
            this.overlay = new VBox(new Node[]{this.rectangle});
            JavaFXUtil.addStyleClass((Styleable)this.overlay, "break-frame-overlay");
            JavaFXUtil.addStyleClass((Styleable)this.rectangle, "break-frame-overlay-rect");
            JavaFXUtil.setPseudoclass(pseudo, true, new Node[]{this.overlay, this.rectangle});
            this.xOffset = new SimpleDoubleProperty(0.0);
            this.yOffset = new SimpleDoubleProperty(0.0);
            JavaFXUtil.onceInScene(this.getNode(), () -> {
                this.getEditor().getCodeOverlayPane().addOverlay((Node)this.overlay, this.getNode(), (DoubleExpression)this.xOffset, (DoubleExpression)this.yOffset);
                this.adjustOverlayBounds();
            });
            JavaFXUtil.addChangeListener(this.getNode().localToSceneTransformProperty(), t -> this.adjustOverlayBounds());
            JavaFXUtil.addChangeListener(this.getNode().boundsInLocalProperty(), b -> this.adjustOverlayBounds());
        } else if (!on && this.overlay != null) {
            this.getEditor().getCodeOverlayPane().removeOverlay((Node)this.overlay);
            this.overlay = null;
            this.rectangle = null;
            this.outer = null;
        }
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void setView(Frame.View oldView, Frame.View newView, SharedTransition animation) {
        super.setView(oldView, newView, animation);
        this.normalView = newView == Frame.View.NORMAL;
        this.updateAppearance(this.getParentCanvas());
    }

    @Override
    protected void saveAsRecent() {
    }

    @Override
    protected void cleanupFrame() {
        JavaFXUtil.runNowOrLater(() -> this.setOverlay(false, null, null));
    }

    public static enum BreakEncloser {
        WHILE,
        FOREACH,
        SWITCH;


        public String getPseudoClass() {
            switch (this) {
                case WHILE: {
                    return "bj-break-while";
                }
                case FOREACH: {
                    return "bj-break-foreach";
                }
                case SWITCH: {
                    return "bj-break-switch";
                }
            }
            return null;
        }
    }
}

