/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.errors;

import bluej.stride.framedjava.ast.SlotFragment;
import bluej.stride.framedjava.errors.Correction;
import bluej.stride.framedjava.errors.DirectSlotError;
import bluej.stride.framedjava.errors.FixSuggestion;
import bluej.stride.generic.AssistContentThreadSafe;
import bluej.stride.generic.InteractionManager;
import bluej.utility.javafx.FXPlatformConsumer;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import threadchecker.OnThread;
import threadchecker.Tag;

public class UnknownTypeError
extends DirectSlotError {
    private final String typeName;
    private final InteractionManager editor;
    private final List<FixSuggestion> corrections = new ArrayList<FixSuggestion>();

    @OnThread(value=Tag.Any)
    public UnknownTypeError(SlotFragment slotFragment, String typeName, FXPlatformConsumer<String> replace, InteractionManager editor, Stream<AssistContentThreadSafe> possibleCorrections, Stream<AssistContentThreadSafe> possibleImports) {
        super(slotFragment);
        this.typeName = typeName;
        this.editor = editor;
        this.corrections.addAll(Correction.winnowAndCreateCorrections(typeName, possibleCorrections.map(TypeCorrectionInfo::new), replace));
        this.corrections.addAll(possibleImports.filter(ac -> ac.getPackage() != null && ac.getName().equals(typeName)).flatMap(ac -> Stream.of(new ImportSingleFix((AssistContentThreadSafe)ac), new ImportPackageFix((AssistContentThreadSafe)ac))).collect(Collectors.toList()));
    }

    @Override
    @OnThread(value=Tag.Any)
    public String getMessage() {
        return "Unknown type: " + this.typeName;
    }

    @Override
    public List<? extends FixSuggestion> getFixSuggestions() {
        return this.corrections;
    }

    @Override
    public boolean isJavaPos() {
        return true;
    }

    private class ImportPackageFix
    extends FixSuggestion {
        private final AssistContentThreadSafe classInfo;

        @OnThread(value=Tag.Any)
        public ImportPackageFix(AssistContentThreadSafe ac) {
            this.classInfo = ac;
        }

        @Override
        public String getDescription() {
            return "Import package " + this.classInfo.getPackage() + " (for " + this.classInfo.getName() + " class)";
        }

        @Override
        public void execute() {
            UnknownTypeError.this.editor.addImport(this.classInfo.getPackage() + ".*");
        }
    }

    private class ImportSingleFix
    extends FixSuggestion {
        private final AssistContentThreadSafe classInfo;

        @OnThread(value=Tag.Any)
        public ImportSingleFix(AssistContentThreadSafe ac) {
            this.classInfo = ac;
        }

        @Override
        public String getDescription() {
            return "Import class " + this.classInfo.getPackage() + "." + this.classInfo.getName();
        }

        @Override
        public void execute() {
            UnknownTypeError.this.editor.addImport(this.classInfo.getPackage() + "." + this.classInfo.getName());
        }
    }

    @OnThread(value=Tag.Any)
    private static class TypeCorrectionInfo
    implements Correction.CorrectionInfo {
        private AssistContentThreadSafe ac;

        public TypeCorrectionInfo(AssistContentThreadSafe ac) {
            this.ac = ac;
        }

        @Override
        public String getCorrection() {
            return this.ac.getName();
        }

        @Override
        public String getDisplay() {
            String pkg = this.ac.getPackage();
            if (pkg == null) {
                return this.ac.getName();
            }
            return this.ac.getName() + " (" + this.ac.getPackage() + " package)";
        }
    }
}

